/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzjk;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgt
extends zzmx
implements zzai {
    private final Map<String, @Nullable Map<String, String>> zzc = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Set<String>> zzd = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zze = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zzg = new ArrayMap();
    private final Map<String, @Nullable zzfi.zzd> zzh = new ArrayMap();
    private final Map<String, @Nullable Map<String, Integer>> zzi;
    @VisibleForTesting
    final LruCache<String, zzb> zza;
    final zzv zzb;
    private final Map<String, @Nullable String> zzj = new ArrayMap();
    private final Map<String, @Nullable String> zzk = new ArrayMap();
    private final Map<String, @Nullable String> zzl = new ArrayMap();

    @WorkerThread
    final int zzb(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, Integer> map = this.zzi.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zza(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Unable to parse timezone offset. appId", zzfw.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    static /* synthetic */ zzb zza(zzgt zzgt2, String string) {
        String string2 = string;
        zzgt zzgt3 = zzgt2;
        zzgt3.zzal();
        Preconditions.checkNotEmpty((String)string2);
        if (!zzgt3.zzl(string2)) {
            return null;
        }
        if (zzgt3.zzh.containsKey(string2) && zzgt3.zzh.get(string2) != null) {
            zzgt3.zza(string2, zzgt3.zzh.get(string2));
        } else {
            zzgt3.zzv(string2);
        }
        return (zzb)zzgt3.zza.snapshot().get(string2);
    }

    @WorkerThread
    final zzim zza(String string, zzin.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfi.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return zzim.zza;
        }
        for (zzfi.zza.zza zza4 : zza3.zzf()) {
            if (zzgt.zza(zza4.zzc()) != zza2) continue;
            switch (zza4.zzb()) {
                case zzc: {
                    return zzim.zzc;
                }
                case zzb: {
                    return zzim.zzd;
                }
            }
            return zzim.zza;
        }
        return zzim.zza;
    }

    @WorkerThread
    final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzin.zza zzb(String string, zzin.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfi.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return null;
        }
        for (zzfi.zza.zzc zzc2 : zza3.zze()) {
            zzin.zza zza4 = zzgt.zza(zzc2.zzc());
            if (zza2 != zza4) continue;
            return zzgt.zza(zzc2.zzb());
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzin.zza zza(zzfi.zza.zze zze2) {
        switch (zze2) {
            case zzb: {
                return zzin.zza.zza;
            }
            case zzc: {
                return zzin.zza.zzb;
            }
            case zzd: {
                return zzin.zza.zzc;
            }
            case zze: {
                return zzin.zza.zzd;
            }
        }
        return null;
    }

    @WorkerThread
    final @Nullable zzfi.zza zzb(String string) {
        this.zzt();
        this.zzv(string);
        zzfi.zzd zzd2 = this.zzc(string);
        if (zzd2 == null || !zzd2.zzp()) {
            return null;
        }
        return zzd2.zzd();
    }

    @WorkerThread
    protected final @Nullable zzfi.zzd zzc(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        this.zzv(string);
        return this.zzh.get(string);
    }

    @WorkerThread
    private final zzfi.zzd zza(String string, byte @Nullable [] byArray) {
        zzfi.zzd zzd2;
        if (byArray == null) {
            return zzfi.zzd.zzg();
        }
        try {
            zzd2 = (zzfi.zzd)((zzjk)zznl.zza(zzfi.zzd.zze(), byArray).zzai());
            this.zzj().zzp().zza("Parsed config. version, gmp_app_id", (Object)(zzd2.zzs() ? Long.valueOf(zzd2.zzc()) : null), (Object)(zzd2.zzq() ? zzd2.zzi() : null));
        }
        catch (zzjs zzjs2) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzfw.zza((String)string), (Object)zzjs2);
            return zzfi.zzd.zzg();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzfw.zza((String)string), (Object)runtimeException);
            return zzfi.zzd.zzg();
        }
        return zzd2;
    }

    @WorkerThread
    public final @Nullable String zza(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, String> map = this.zzc.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @WorkerThread
    protected final @Nullable String zzd(String string) {
        this.zzt();
        return this.zzl.get(string);
    }

    @WorkerThread
    protected final @Nullable String zze(String string) {
        this.zzt();
        return this.zzk.get(string);
    }

    @WorkerThread
    final @Nullable String zzf(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzj.get(string);
    }

    static /* bridge */ /* synthetic */ Map zza(zzgt zzgt2) {
        return zzgt2.zzc;
    }

    private static Map<String, String> zza(zzfi.zzd zzd2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzd2 != null) {
            for (zzfi.zzg zzg2 : zzd2.zzn()) {
                arrayMap.put(zzg2.zzb(), zzg2.zzc());
            }
        }
        return arrayMap;
    }

    @WorkerThread
    final @Nullable Set<String> zzg(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string);
    }

    @WorkerThread
    final SortedSet<String> zzh(String string) {
        this.zzt();
        this.zzv(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        zzfi.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return treeSet;
        }
        for (zzfi.zza.zzf zzf2 : zza2.zzc()) {
            treeSet.add(zzf2.zzb());
        }
        return treeSet;
    }

    zzgt(zznc zznc2) {
        super(zznc2);
        this.zzi = new ArrayMap();
        this.zza = new zzgz(this, 20);
        this.zzb = new zzgy(this);
    }

    @WorkerThread
    protected final void zzi(String string) {
        this.zzt();
        this.zzk.put(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void zza(String string, zzfi.zzd.zza zza2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (zzfi.zzb zzkv2 : zza2.zze()) {
                hashSet.add(zzkv2.zzb());
            }
            for (int i = 0; i < zza2.zza(); ++i) {
                void var8_13;
                zzfi.zzc.zza zza3 = (zzfi.zzc.zza)zza2.zza(i).zzcc();
                if (zza3.zzb().isEmpty()) {
                    this.zzj().zzu().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zzb();
                String string3 = zziq.zzb((String)zza3.zzb());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zzfi.zzc.zza zza4 = zza3.zza(string3);
                    zza2.zza(i, zza4);
                }
                if (var8_13.zze() && var8_13.zzc()) {
                    arrayMap.put(string2, true);
                }
                if (var8_13.zzf() && var8_13.zzd()) {
                    arrayMap2.put(var8_13.zzb(), true);
                }
                if (!var8_13.zzg()) continue;
                if (var8_13.zza() < 2 || var8_13.zza() > 65535) {
                    this.zzj().zzu().zza("Invalid sampling rate. Event name, sample rate", (Object)var8_13.zzb(), (Object)var8_13.zza());
                    continue;
                }
                arrayMap3.put(var8_13.zzb(), var8_13.zza());
            }
        }
        this.zzd.put(string, hashSet);
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzg.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzi.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    private final void zzv(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzh.get(string) == null) {
            zzan zzan2 = ((zzmy)this).zzh().zzf(string);
            if (zzan2 == null) {
                this.zzc.put(string, null);
                this.zze.put(string, null);
                this.zzd.put(string, null);
                this.zzg.put(string, null);
                this.zzh.put(string, null);
                this.zzj.put(string, null);
                this.zzk.put(string, null);
                this.zzl.put(string, null);
                this.zzi.put(string, null);
                return;
            }
            byte[] byArray = zzan2.zza;
            zzfi.zzd.zza zza2 = (zzfi.zzd.zza)this.zza(string, byArray).zzcc();
            this.zza(string, zza2);
            this.zzc.put(string, zzgt.zza((zzfi.zzd)((zzjk)zza2.zzai())));
            this.zzh.put(string, (zzfi.zzd)((zzjk)zza2.zzai()));
            this.zza(string, (zzfi.zzd)((zzjk)zza2.zzai()));
            this.zzj.put(string, zza2.zzc());
            this.zzk.put(string, zzan2.zzb);
            this.zzl.put(string, zzan2.zzc);
        }
    }

    @WorkerThread
    private final void zza(String string, zzfi.zzd zzd2) {
        if (zzd2.zza() == 0) {
            this.zza.remove((Object)string);
            return;
        }
        this.zzj().zzp().zza("EES programs found", (Object)zzd2.zza());
        zzft.zzc zzc2 = zzd2.zzm().get(0);
        try {
            zzb zzb2 = new zzb();
            String string2 = string;
            zzgt zzgt2 = this;
            zzb2.zza("internal.remoteConfig", new zzgu(zzgt2, string2));
            string2 = string;
            zzgt2 = this;
            zzb2.zza("internal.appMetadata", new zzgx(zzgt2, string2));
            zzgt2 = this;
            zzb2.zza("internal.logger", new zzgw(zzgt2));
            zzb2.zza(zzc2);
            this.zza.put((Object)string, (Object)zzb2);
            this.zzj().zzp().zza("EES program loaded for appId, activities", (Object)string, (Object)zzc2.zza().zza());
            for (zzft.zzb zzb3 : zzc2.zza().zzd()) {
                this.zzj().zzp().zza("EES program activity", (Object)zzb3.zzb());
            }
            return;
        }
        catch (zzc zzc3) {
            this.zzj().zzg().zza("Failed to load EES program. appId", (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zzj(String string) {
        this.zzt();
        this.zzh.remove(string);
    }

    @WorkerThread
    final boolean zzk(String string) {
        this.zzt();
        zzfi.zzd zzd2 = this.zzc(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zzo();
    }

    public final boolean zzl(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzfi.zzd zzd2 = this.zzh.get(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zza() != 0;
    }

    final boolean zzm(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    @WorkerThread
    final boolean zzc(String string, zzin.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfi.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return false;
        }
        for (zzfi.zza.zza zza4 : zza3.zzd()) {
            if (zza2 != zzgt.zza(zza4.zzc())) continue;
            return zza4.zzb() == zzfi.zza.zzd.zzb;
        }
        return false;
    }

    @WorkerThread
    final boolean zzn(String string) {
        this.zzt();
        this.zzv(string);
        zzfi.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return true;
        }
        return !zza2.zzh() || zza2.zzg();
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzg.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzd(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if (this.zzm(string) && zznp.zzg((String)string2)) {
            return true;
        }
        if (this.zzo(string) && zznp.zzh((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzo(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    protected final boolean zza(String string, byte @Nullable [] byArray, @Nullable String string2, @Nullable String string3) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        zzfi.zzd.zza zza2 = (zzfi.zzd.zza)this.zza(string, byArray).zzcc();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zza(string, (zzfi.zzd)((zzjk)zza2.zzai()));
        this.zzh.put(string, (zzfi.zzd)((zzjk)zza2.zzai()));
        this.zzj.put(string, zza2.zzc());
        this.zzk.put(string, string2);
        this.zzl.put(string, string3);
        this.zzc.put(string, zzgt.zza((zzfi.zzd)((zzjk)zza2.zzai())));
        ((zzmy)this).zzh().zza(string, new ArrayList<zzff.zza>(zza2.zzd()));
        try {
            zza2.zzb();
            byArray = ((zzfi.zzd)((zzjk)zza2.zzai())).zzbz();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzfw.zza((String)string), (Object)runtimeException);
        }
        String string4 = string3;
        String string5 = string2;
        byte[] byArray2 = byArray;
        String string6 = string;
        zzal zzal2 = ((zzmy)this).zzh();
        Preconditions.checkNotEmpty((String)string6);
        zzal2.zzt();
        zzal2.zzal();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        contentValues.put("config_last_modified_time", string5);
        contentValues.put("e_tag", string4);
        try {
            if ((long)zzal2.e_().update("apps", contentValues, "app_id = ?", new String[]{string6}) == 0L) {
                zzal2.zzj().zzg().zza("Failed to update remote config (got 0). appId", zzfw.zza((String)string6));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error storing remote config. appId", zzfw.zza((String)string6), (Object)sQLiteException);
        }
        this.zzh.put(string, (zzfi.zzd)((zzjk)zza2.zzai()));
        return true;
    }

    @WorkerThread
    final boolean zzp(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("app_instance_id");
    }

    @WorkerThread
    final boolean zzq(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("device_model") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzr(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("enhanced_user_id");
    }

    @WorkerThread
    final boolean zzs(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("google_signals");
    }

    @WorkerThread
    final boolean zzt(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("os_version") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzu(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("user_id");
    }
}

