/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zznl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class zzz {
    String zza;
    int zzb;
    Boolean zzc;
    Boolean zzd;
    Long zze;
    Long zzf;

    abstract int zza();

    @VisibleForTesting
    private static @Nullable Boolean zza(BigDecimal bigDecimal, zzff.zzd zzd2, double d) {
        block25: {
            BigDecimal bigDecimal2;
            zzff.zzd.zza zza2;
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            double d2;
            block24: {
                block23: {
                    Preconditions.checkNotNull((Object)((Object)zzd2));
                    if (!zzd2.zzh() || zzd2.zza() == zzff.zzd.zza.zza) {
                        return null;
                    }
                    if (zzd2.zza() == zzff.zzd.zza.zze ? !zzd2.zzl() || !zzd2.zzk() : !zzd2.zzi()) {
                        return null;
                    }
                    zzff.zzd.zza zza3 = zzd2.zza();
                    BigDecimal bigDecimal6 = null;
                    BigDecimal bigDecimal7 = null;
                    BigDecimal bigDecimal8 = null;
                    if (zzd2.zza() == zzff.zzd.zza.zze) {
                        if (!zznl.zzb(zzd2.zzf()) || !zznl.zzb(zzd2.zze())) {
                            return null;
                        }
                        try {
                            bigDecimal7 = new BigDecimal(zzd2.zzf());
                            bigDecimal8 = new BigDecimal(zzd2.zze());
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    }
                    if (!zznl.zzb(zzd2.zzd())) {
                        return null;
                    }
                    try {
                        bigDecimal6 = new BigDecimal(zzd2.zzd());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    d2 = d;
                    bigDecimal5 = bigDecimal8;
                    bigDecimal4 = bigDecimal7;
                    bigDecimal3 = bigDecimal6;
                    zza2 = zza3;
                    bigDecimal2 = bigDecimal;
                    if (zza2 != zzff.zzd.zza.zze) break block23;
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    break block24;
                }
                if (bigDecimal3 == null) break block25;
            }
            switch (zza2) {
                case zzb: {
                    if (bigDecimal3 == null) break;
                    return bigDecimal2.compareTo(bigDecimal3) < 0;
                }
                case zzc: {
                    if (bigDecimal3 == null) break;
                    return bigDecimal2.compareTo(bigDecimal3) > 0;
                }
                case zzd: {
                    if (bigDecimal3 == null) break;
                    if (d2 != 0.0) {
                        return bigDecimal2.compareTo(bigDecimal3.subtract(new BigDecimal(d2).multiply(new BigDecimal(2)))) > 0 && bigDecimal2.compareTo(bigDecimal3.add(new BigDecimal(d2).multiply(new BigDecimal(2)))) < 0;
                    }
                    return bigDecimal2.compareTo(bigDecimal3) == 0;
                }
                case zze: {
                    if (bigDecimal4 == null) {
                        return null;
                    }
                    return bigDecimal2.compareTo(bigDecimal4) >= 0 && bigDecimal2.compareTo(bigDecimal5) <= 0;
                }
            }
        }
        return null;
    }

    @VisibleForTesting
    static @Nullable Boolean zza(String string, zzff.zzf zzf2, @Nullable zzfw zzfw2) {
        List<String> list;
        Preconditions.checkNotNull((Object)((Object)zzf2));
        if (string == null) {
            return null;
        }
        if (!zzf2.zzj() || zzf2.zzb() == zzff.zzf.zza.zza) {
            return null;
        }
        if (zzf2.zzb() == zzff.zzf.zza.zzg ? zzf2.zza() == 0 : !zzf2.zzi()) {
            return null;
        }
        zzff.zzf.zza zza2 = zzf2.zzb();
        boolean bl = zzf2.zzg();
        String string2 = bl || zza2 == zzff.zzf.zza.zzb || zza2 == zzff.zzf.zza.zzg ? zzf2.zze() : zzf2.zze().toUpperCase(Locale.ENGLISH);
        if (zzf2.zza() == 0) {
            list = null;
        } else {
            boolean bl2 = bl;
            List<String> list2 = zzf2.zzf();
            if (bl2) {
                list = list2;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                for (String string3 : list2) {
                    arrayList.add(string3.toUpperCase(Locale.ENGLISH));
                }
                list = Collections.unmodifiableList(arrayList);
            }
        }
        List<String> list3 = list;
        String string4 = null;
        if (zza2 == zzff.zzf.zza.zzb) {
            string4 = string2;
        }
        return zzz.zza(string, zza2, bl, string2, list3, string4, zzfw2);
    }

    private static @Nullable Boolean zza(String string, zzff.zzf.zza zza2, boolean bl, String string2, @Nullable List<String> list, @Nullable String string3, @Nullable zzfw zzfw2) {
        if (string == null) {
            return null;
        }
        if (zza2 == zzff.zzf.zza.zzg ? list == null || list.isEmpty() : string2 == null) {
            return null;
        }
        string = bl || zza2 == zzff.zzf.zza.zzb ? string : string.toUpperCase(Locale.ENGLISH);
        switch (zza2) {
            case zzb: {
                if (string3 == null) {
                    return null;
                }
                int n = bl ? 0 : 66;
                try {
                    return Pattern.compile(string3, n).matcher(string).matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (zzfw2 != null) {
                        zzfw2.zzu().zza("Invalid regular expression in REGEXP audience filter. expression", (Object)string3);
                    }
                    return null;
                }
            }
            case zzc: {
                return string.startsWith(string2);
            }
            case zzd: {
                return string.endsWith(string2);
            }
            case zze: {
                return string.contains(string2);
            }
            case zzf: {
                return string.equals(string2);
            }
            case zzg: {
                if (list == null) {
                    return null;
                }
                return list.contains(string);
            }
        }
        return null;
    }

    static @Nullable Boolean zza(double d, zzff.zzd zzd2) {
        try {
            return zzz.zza(new BigDecimal(d), zzd2, Math.ulp(d));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static @Nullable Boolean zza(long l, zzff.zzd zzd2) {
        try {
            return zzz.zza(new BigDecimal(l), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static @Nullable Boolean zza(String string, zzff.zzd zzd2) {
        if (!zznl.zzb(string)) {
            return null;
        }
        try {
            return zzz.zza(new BigDecimal(string), zzd2, 0.0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @VisibleForTesting
    static @Nullable Boolean zza(@Nullable Boolean bl, boolean bl2) {
        if (bl == null) {
            return null;
        }
        return bl != bl2;
    }

    zzz(String string, int n) {
        this.zza = string;
        this.zzb = n;
    }

    abstract boolean zzb();

    abstract boolean zzc();
}

