/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzg;
import com.google.android.gms.internal.measurement.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzas
implements zzaq,
Iterable<zzaq> {
    private final String zza;

    public final int hashCode() {
        return this.zza.hashCode();
    }

    @Override
    public final zzaq zza(String string, zzh zzh2, List<zzaq> list) {
        String string2 = string;
        if ("charAt".equals(string2) || "concat".equals(string2) || "hasOwnProperty".equals(string2) || "indexOf".equals(string2) || "lastIndexOf".equals(string2) || "match".equals(string2) || "replace".equals(string2) || "search".equals(string2) || "slice".equals(string2) || "split".equals(string2) || "substring".equals(string2) || "toLowerCase".equals(string2) || "toLocaleLowerCase".equals(string2) || "toString".equals(string2) || "toUpperCase".equals(string2) || "toLocaleUpperCase".equals(string2) || "trim".equals(string2)) {
            List<zzaq> list2 = list;
            zzh zzh3 = zzh2;
            zzas zzas2 = this;
            switch (string) {
                case "charAt": {
                    List<zzaq> list3 = list2;
                    zzh zzh4 = zzh3;
                    zzas zzas3 = zzas2;
                    zzg.zzc("charAt", 1, list3);
                    int n = 0;
                    if (!list3.isEmpty()) {
                        n = (int)zzg.zza(zzh4.zza(list3.get(0)).zze());
                    }
                    String string3 = zzas3.zza;
                    if (n < 0 || n >= string3.length()) {
                        return zzaq.zzj;
                    }
                    return new zzas(String.valueOf(string3.charAt(n)));
                }
                case "concat": {
                    List<zzaq> list4 = list2;
                    zzh zzh5 = zzh3;
                    zzas zzas4 = zzas2;
                    if (list4.isEmpty()) {
                        return zzas4;
                    }
                    StringBuilder stringBuilder = new StringBuilder(zzas4.zza);
                    for (int i = 0; i < list4.size(); ++i) {
                        stringBuilder.append(zzh5.zza(list4.get(i)).zzf());
                    }
                    return new zzas(stringBuilder.toString());
                }
                case "hasOwnProperty": {
                    int n;
                    List<zzaq> list5 = list2;
                    zzh zzh6 = zzh3;
                    zzas zzas5 = zzas2;
                    zzg.zza("hasOwnProperty", 1, list5);
                    String string4 = zzas5.zza;
                    zzaq zzaq2 = zzh6.zza(list5.get(0));
                    if ("length".equals(zzaq2.zzf())) {
                        return zzag.zzh;
                    }
                    double d = zzaq2.zze();
                    if (d == Math.floor(d) && (n = (int)d) >= 0 && n < string4.length()) {
                        return zzag.zzh;
                    }
                    return zzag.zzi;
                }
                case "indexOf": {
                    List<zzaq> list6 = list2;
                    zzh zzh7 = zzh3;
                    zzas zzas6 = zzas2;
                    zzg.zzc("indexOf", 2, list6);
                    String string5 = zzas6.zza;
                    String string6 = list6.size() <= 0 ? zzaq.zzc.zzf() : zzh7.zza(list6.get(0)).zzf();
                    double d = zzg.zza(list6.size() < 2 ? 0.0 : zzh7.zza(list6.get(1)).zze());
                    return new zzai(Double.valueOf(string5.indexOf(string6, (int)d)));
                }
                case "lastIndexOf": {
                    List<zzaq> list7 = list2;
                    zzh zzh8 = zzh3;
                    zzas zzas7 = zzas2;
                    zzg.zzc("lastIndexOf", 2, list7);
                    String string7 = zzas7.zza;
                    String string8 = list7.size() <= 0 ? zzaq.zzc.zzf() : zzh8.zza(list7.get(0)).zzf();
                    double d = list7.size() < 2 ? Double.NaN : zzh8.zza(list7.get(1)).zze();
                    d = Double.isNaN(d) ? Double.POSITIVE_INFINITY : zzg.zza(d);
                    return new zzai(Double.valueOf(string7.lastIndexOf(string8, (int)d)));
                }
                case "match": {
                    List<zzaq> list8 = list2;
                    zzh zzh9 = zzh3;
                    zzas zzas8 = zzas2;
                    zzg.zzc("match", 1, list8);
                    String string9 = zzas8.zza;
                    Matcher matcher = Pattern.compile(list8.size() <= 0 ? "" : zzh9.zza(list8.get(0)).zzf()).matcher(string9);
                    if (matcher.find()) {
                        return new zzaf(new zzas(matcher.group()));
                    }
                    return zzaq.zzd;
                }
                case "replace": {
                    String string10;
                    int n;
                    List<zzaq> list9 = list2;
                    zzh zzh10 = zzh3;
                    zzas zzas9 = zzas2;
                    zzg.zzc("replace", 2, list9);
                    String string11 = zzaq.zzc.zzf();
                    zzaq zzaq3 = zzaq.zzc;
                    if (!list9.isEmpty()) {
                        string11 = zzh10.zza(list9.get(0)).zzf();
                        if (list9.size() > 1) {
                            zzaq3 = zzh10.zza(list9.get(1));
                        }
                    }
                    if ((n = (string10 = zzas9.zza).indexOf(string11)) < 0) {
                        return zzas9;
                    }
                    if (zzaq3 instanceof zzal) {
                        zzaq3 = ((zzal)zzaq3).zza(zzh10, Arrays.asList(new zzas(string11), new zzai(Double.valueOf(n)), zzas9));
                    }
                    String string12 = string10.substring(n + string11.length());
                    String string13 = zzaq3.zzf();
                    String string14 = string10.substring(0, n);
                    return new zzas(string14 + string13 + string12);
                }
                case "search": {
                    List<zzaq> list10 = list2;
                    zzh zzh11 = zzh3;
                    zzas zzas10 = zzas2;
                    zzg.zzc("search", 1, list10);
                    String string15 = !list10.isEmpty() ? zzh11.zza(list10.get(0)).zzf() : zzaq.zzc.zzf();
                    String string16 = zzas10.zza;
                    Matcher matcher = Pattern.compile(string15).matcher(string16);
                    if (matcher.find()) {
                        return new zzai(Double.valueOf(matcher.start()));
                    }
                    return new zzai(-1.0);
                }
                case "slice": {
                    double d;
                    double d2;
                    List<zzaq> list11 = list2;
                    zzh zzh12 = zzh3;
                    zzas zzas11 = zzas2;
                    zzg.zzc("slice", 2, list11);
                    String string17 = zzas11.zza;
                    double d3 = zzg.zza(!list11.isEmpty() ? zzh12.zza(list11.get(0)).zze() : 0.0);
                    int n = (int)(d2 < 0.0 ? Math.max((double)string17.length() + d3, 0.0) : Math.min(d3, (double)string17.length()));
                    double d4 = zzg.zza(list11.size() > 1 ? zzh12.zza(list11.get(1)).zze() : (double)string17.length());
                    int n2 = (int)(d < 0.0 ? Math.max((double)string17.length() + d4, 0.0) : Math.min(d4, (double)string17.length()));
                    n2 = n + Math.max(0, n2 - n);
                    return new zzas(string17.substring(n, n2));
                }
                case "split": {
                    List<zzaq> list12 = list2;
                    zzh zzh13 = zzh3;
                    zzas zzas12 = zzas2;
                    zzg.zzc("split", 2, list12);
                    String string18 = zzas12.zza;
                    if (string18.length() == 0) {
                        return new zzaf(zzas12);
                    }
                    ArrayList<zzaq> arrayList = new ArrayList<zzaq>();
                    if (list12.isEmpty()) {
                        arrayList.add(zzas12);
                    } else {
                        String string19 = zzh13.zza(list12.get(0)).zzf();
                        long l = Integer.MAX_VALUE;
                        if (list12.size() > 1) {
                            l = zzg.zzc(zzh13.zza(list12.get(1)).zze());
                        }
                        if (l == 0L) {
                            return new zzaf();
                        }
                        String[] stringArray = string18.split(Pattern.quote(string19), (int)l + 1);
                        int n = 0;
                        int n3 = stringArray.length;
                        if (string19.isEmpty() && stringArray.length > 0) {
                            if (stringArray[0].isEmpty()) {
                                n = 1;
                            }
                            if (stringArray[stringArray.length - 1].isEmpty()) {
                                n3 = stringArray.length - 1;
                            }
                        }
                        if ((long)stringArray.length > l) {
                            --n3;
                        }
                        for (int i = n; i < n3; ++i) {
                            arrayList.add(new zzas(stringArray[i]));
                        }
                    }
                    return new zzaf(arrayList);
                }
                case "substring": {
                    List<zzaq> list13 = list2;
                    zzh zzh14 = zzh3;
                    zzas zzas13 = zzas2;
                    zzg.zzc("substring", 2, list13);
                    String string20 = zzas13.zza;
                    int n = !list13.isEmpty() ? (int)zzg.zza(zzh14.zza(list13.get(0)).zze()) : 0;
                    int n4 = list13.size() > 1 ? (int)zzg.zza(zzh14.zza(list13.get(1)).zze()) : string20.length();
                    n = Math.min(Math.max(n, 0), string20.length());
                    n4 = Math.min(Math.max(n4, 0), string20.length());
                    return new zzas(string20.substring(Math.min(n, n4), Math.max(n, n4)));
                }
                case "toLocaleUpperCase": {
                    List<zzaq> list14 = list2;
                    zzas zzas14 = zzas2;
                    zzg.zza("toLocaleUpperCase", 0, list14);
                    String string21 = zzas14.zza;
                    return new zzas(string21.toUpperCase());
                }
                case "toLocaleLowerCase": {
                    List<zzaq> list15 = list2;
                    zzas zzas15 = zzas2;
                    zzg.zza("toLocaleLowerCase", 0, list15);
                    String string22 = zzas15.zza;
                    return new zzas(string22.toLowerCase());
                }
                case "toLowerCase": {
                    List<zzaq> list16 = list2;
                    zzas zzas16 = zzas2;
                    zzg.zza("toLowerCase", 0, list16);
                    String string23 = zzas16.zza;
                    return new zzas(string23.toLowerCase(Locale.ENGLISH));
                }
                case "toString": {
                    List<zzaq> list17 = list2;
                    zzas zzas17 = zzas2;
                    zzg.zza("toString", 0, list17);
                    return zzas17;
                }
                case "toUpperCase": {
                    List<zzaq> list18 = list2;
                    zzas zzas18 = zzas2;
                    zzg.zza("toUpperCase", 0, list18);
                    String string24 = zzas18.zza;
                    return new zzas(string24.toUpperCase(Locale.ENGLISH));
                }
                case "trim": {
                    List<zzaq> list19 = list2;
                    zzas zzas19 = zzas2;
                    zzg.zza("toUpperCase", 0, list19);
                    String string25 = zzas19.zza;
                    return new zzas(string25.trim());
                }
            }
            throw new IllegalArgumentException("Command not supported");
        }
        throw new IllegalArgumentException(String.format("%s is not a String function", string));
    }

    @Override
    public final zzaq zzc() {
        return new zzas(this.zza);
    }

    @Override
    public final Boolean zzd() {
        return !this.zza.isEmpty();
    }

    @Override
    public final Double zze() {
        if (this.zza.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.valueOf(this.zza);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    static /* bridge */ /* synthetic */ String zza(zzas zzas2) {
        return zzas2.zza;
    }

    @Override
    public final String zzf() {
        return this.zza;
    }

    public final String toString() {
        String string = this.zza;
        return "\"" + string + "\"";
    }

    @Override
    public final @Nullable Iterator<zzaq> zzh() {
        return new zzav(this);
    }

    @Override
    public final Iterator<zzaq> iterator() {
        return new zzau(this);
    }

    public zzas(@Nullable String string) {
        if (string == null) {
            throw new IllegalArgumentException("StringValue cannot be null.");
        }
        this.zza = string;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzas)) {
            return false;
        }
        zzas zzas2 = (zzas)object;
        return this.zza.equals(zzas2.zza);
    }
}

