/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zznw;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgr
extends zznr {
    public zzgr(zznv zznv2) {
        super(zznv2);
    }

    @WorkerThread
    public final void zza(String string, URL uRL, byte[] byArray, @Nullable Map<String, String> map, zzgu zzgu2) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)uRL);
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkNotNull((Object)zzgu2);
        this.zzl().zza((Runnable)new zzgw(this, string, uRL, byArray, map, zzgu2));
    }

    @WorkerThread
    public final void zza(String string, zznw zznw2, zzfy.zzj zzj2, zzgu zzgu2) {
        this.zzt();
        this.zzal();
        try {
            URL uRL = new URI(zznw2.zzb()).toURL();
            ((zzns)this).g_();
            byte[] byArray = zzj2.zzca();
            this.zzl().zza((Runnable)new zzgw(this, string, uRL, byArray, zznw2.zzc(), zzgu2));
            return;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
            this.zzj().zzg().zza("Failed to parse URL. Not uploading MeasurementBatch. appId", zzgo.zza((String)string), (Object)zznw2.zzb());
            return;
        }
    }

    public final boolean zzu() {
        this.zzal();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zza().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            if (connectivityManager != null) {
                networkInfo = connectivityManager.getActiveNetworkInfo();
            }
        }
        catch (SecurityException securityException) {}
        return networkInfo != null && networkInfo.isConnected();
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    static /* bridge */ /* synthetic */ byte[] zza(zzgr zzgr2, HttpURLConnection httpURLConnection) {
        return zzgr.zza(httpURLConnection);
    }

    @WorkerThread
    private static byte[] zza(HttpURLConnection httpURLConnection) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }
}

