/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzon;
import com.google.android.gms.measurement.internal.zzoo;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzic
extends zzge {
    private final zznv zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzaj zza(zzo zzo2) {
        this.zzb(zzo2, false);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Future future = this.zza.zzl().zzb((Callable)new zziv(this, zzo2));
        try {
            return (zzaj)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zza.zzj().zzg().zza("Failed to get consent. appId", zzgo.zza((String)zzo2.zza), (Object)exception);
            return new zzaj(null);
        }
    }

    @VisibleForTesting
    final zzbf zzb(zzbf zzbf2, zzo zzo2) {
        String string;
        zzbf zzbf3 = zzbf2;
        if (!"_cmp".equals(zzbf3.zza) || zzbf3.zzb == null || zzbf3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbf3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzo().zza("Event has been filtered ", (Object)zzbf2.toString());
            return new zzbf("_cmpx", zzbf2.zzb, zzbf2.zzc, zzbf2.zzd);
        }
        return zzbf2;
    }

    static /* bridge */ /* synthetic */ zznv zza(zzic zzic2) {
        return zzic2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzo zzo2) {
        this.zzb(zzo2, false);
        return this.zza.zzb(zzo2);
    }

    @BinderThread
    public final List<zzno> zza(zzo zzo2, Bundle bundle) {
        this.zzb(zzo2, false);
        Preconditions.checkNotNull((Object)zzo2.zza);
        Future future = this.zza.zzl().zza((Callable)new zziy(this, zzo2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzgo.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzon> zza(zzo zzo2, boolean bl) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zzjb(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzon> arrayList = new ArrayList<zzon>(list.size());
            for (zzop zzop2 : list) {
                if (!bl && zzos.zzg((String)zzop2.zzc)) continue;
                arrayList.add(new zzon(zzop2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzgo.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzae> zza(@Nullable String string, @Nullable String string2, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzir(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzae> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zziq(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzon> zza(@Nullable String string, @Nullable String string2, boolean bl, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzip(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzon> arrayList = new ArrayList<zzon>(list.size());
            for (zzop zzop2 : list) {
                if (!bl && zzos.zzg((String)zzop2.zzc)) continue;
                arrayList.add(new zzon(zzop2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzgo.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzon> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzio(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzon> arrayList = new ArrayList<zzon>(list.size());
            for (zzop zzop2 : list) {
                if (!bl && zzos.zzg((String)zzop2.zzc)) continue;
                arrayList.add(new zzon(zzop2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzgo.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzic(zznv zznv2) {
        this(zznv2, null);
    }

    private zzic(zznv zznv2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zznv2);
        this.zza = zznv2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zzb(new zzil(this, zzo2));
    }

    @BinderThread
    public final void zzd(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zzb(new zzii(this, zzo2));
    }

    @BinderThread
    private final void zzb(zzo zzo2, boolean bl) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza.zzq().zza(zzo2.zzb, zzo2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzic zzic2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzic2 = this;
                    if (!bl2) break block9;
                    if (zzic2.zzb == null) {
                        zzic2.zzb = "com.google.android.gms".equals(zzic2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzic2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzic2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzic2.zzb.booleanValue()) break block10;
                }
                if (zzic2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzic2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzic2.zzc = string2;
                }
                if (!string2.equals(zzic2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzgo.zza((String)string));
            throw securityException;
        }
    }

    final void zzc(zzbf zzbf2, zzo zzo2) {
        if (!this.zza.zzi().zzk(zzo2.zza)) {
            this.zzd(zzbf2, zzo2);
            return;
        }
        this.zza.zzj().zzp().zza("EES config found for", (Object)zzo2.zza);
        String string = zzo2.zza;
        zznr zznr2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzhl)zznr2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzp().zza("EES not loaded for", (Object)zzo2.zza);
            this.zzd(zzbf2, zzo2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbf2;
            zznr2 = this.zza.zzp();
            Bundle bundle = ((zzbf)string).zzb.zzb();
            Map<String, Object> map = ((zzoo)zznr2).zza(bundle, true);
            String string2 = zzji.zza((String)((zzbf)string).zza);
            if (string2 == null) {
                string2 = ((zzbf)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbf)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzo2.zzb, (Object)zzbf2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzp().zza("EES was not applied to event", (Object)zzbf2.zza);
            this.zzd(zzbf2, zzo2);
            return;
        }
        if (zzb2.zzd()) {
            this.zza.zzj().zzp().zza("EES edited event", (Object)zzbf2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzo2);
        } else {
            this.zzd(zzbf2, zzo2);
        }
        if (zzb2.zzc()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzp().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzo2);
            }
        }
    }

    final /* synthetic */ void zza(Bundle bundle, String string) {
        boolean bl = this.zza.zze().zza(zzbh.zzde);
        boolean bl2 = this.zza.zze().zza(zzbh.zzdg);
        if (bundle.isEmpty() && bl && bl2) {
            this.zza.zzf().zzp(string);
            return;
        }
        this.zza.zzf().zzb(string, bundle);
        if (bl2 && this.zza.zzf().zzt(string)) {
            this.zza.zzf().zza(string, bundle);
        }
    }

    final /* synthetic */ void zzb(Bundle bundle, String string) {
        if (bundle.isEmpty()) {
            this.zza.zzf().zzp(string);
            return;
        }
        this.zza.zzf().zzb(string, bundle);
        this.zza.zzf().zza(string, bundle);
    }

    final /* synthetic */ void zzj(zzo zzo2) {
        this.zza.zzr();
        this.zza.zzf(zzo2);
    }

    final /* synthetic */ void zzk(zzo zzo2) {
        this.zza.zzr();
        this.zza.zzg(zzo2);
    }

    @BinderThread
    public final void zza(zzbf zzbf2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbf2);
        this.zzb(zzo2, false);
        this.zzb(new zziu(this, zzbf2, zzo2));
    }

    @BinderThread
    public final void zza(zzbf zzbf2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbf2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzb(new zzix(this, zzbf2, string));
    }

    private final void zzd(zzbf zzbf2, zzo zzo2) {
        this.zza.zzr();
        this.zza.zza(zzbf2, zzo2);
    }

    @BinderThread
    public final void zze(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zzb(new zzit(this, zzo2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzc(runnable);
    }

    @VisibleForTesting
    private final void zzb(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        this.zzb(zzo2, false);
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zza = zzo2.zza;
        this.zzb(new zzin(this, zzae3, zzo2));
    }

    @BinderThread
    public final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        this.zza(zzae2.zza, true);
        zzae zzae3 = new zzae(zzae2);
        this.zzb(new zzim(this, zzae3));
    }

    @BinderThread
    public final void zzf(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        this.zza(new zzis(this, zzo2));
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zzb(new zzik(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzo zzo2) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        String string2 = string;
        Bundle bundle2 = bundle;
        zzic zzic2 = this;
        this.zzb(new zzig(zzic2, bundle2, string2));
    }

    @BinderThread
    public final void zzb(Bundle bundle, zzo zzo2) {
        if (com.google.android.gms.internal.measurement.zznr.zza() && this.zza.zze().zza(zzbh.zzdg)) {
            this.zzb(zzo2, false);
            String string = zzo2.zza;
            Preconditions.checkNotNull((Object)string);
            String string2 = string;
            Bundle bundle2 = bundle;
            zzic zzic2 = this;
            this.zzb(new zzie(zzic2, bundle2, string2));
        }
    }

    @BinderThread
    public final void zzg(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzo zzo3 = zzo2;
        zzic zzic2 = this;
        this.zza(new zzih(zzic2, zzo3));
    }

    @BinderThread
    public final void zzh(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zzb(new zzij(this, zzo2));
    }

    @BinderThread
    public final void zzi(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzo zzo3 = zzo2;
        zzic zzic2 = this;
        this.zza(new zzif(zzic2, zzo3));
    }

    @BinderThread
    public final void zza(zzon zzon2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzon2);
        this.zzb(zzo2, false);
        this.zzb(new zziz(this, zzon2, zzo2));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbf zzbf2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbf2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbf2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zziw(this, zzbf2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzgo.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbf2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzgo.zza((String)string), (Object)this.zza.zzg().zza(zzbf2.zza), (Object)exception);
            return null;
        }
    }
}

