/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzle;
import com.google.android.gms.internal.measurement.zzov;
import com.google.android.gms.internal.measurement.zzow;
import com.google.android.gms.internal.measurement.zzpb;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.internal.measurement.zzpu;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzmw;
import com.google.android.gms.measurement.internal.zznm;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznu;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zznz;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzob;
import com.google.android.gms.measurement.internal.zzoc;
import com.google.android.gms.measurement.internal.zzod;
import com.google.android.gms.measurement.internal.zzoe;
import com.google.android.gms.measurement.internal.zzof;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzoi;
import com.google.android.gms.measurement.internal.zzoj;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzon;
import com.google.android.gms.measurement.internal.zzoo;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzor;
import com.google.android.gms.measurement.internal.zzos;
import com.google.android.gms.measurement.internal.zzt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zznv
implements zzjc {
    private static volatile @Nullable zznv zza;
    private zzhl zzb;
    private zzgr zzc;
    private zzal zzd;
    private zzgy zze;
    private zznq zzf;
    private zzt zzg;
    private final zzoo zzh;
    private zzli zzi;
    private zzmw zzj;
    private final zznu zzk;
    private @MonotonicNonNull zzhf zzl;
    private final zzhy zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzje> zzac;
    private final Map<String, zzax> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzlk zzaf;
    private @Nullable String zzag;
    private final zzor zzah = new zzof(this);

    private final int zza(String string, zzah zzah2) {
        zzjh zzjh2;
        if (this.zzb.zzb(string) == null) {
            zzah2.zza(zzje.zza.zzd, zzak.zzi);
            return 1;
        }
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 != null && com.google.android.gms.measurement.internal.zzf.zza((String)zzg2.zzak()).zza() == zzjh.zzb && (zzjh2 = this.zzb.zza(string, zzje.zza.zzd)) != zzjh.zza) {
            zzah2.zza(zzje.zza.zzd, zzak.zzh);
            if (zzjh2 == zzjh.zzd) {
                return 0;
            }
            return 1;
        }
        zzah2.zza(zzje.zza.zzd, zzak.zzb);
        if (this.zzb.zzc(string, zzje.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzmw zzmw2 = this.zzj;
        zzmw2.zzal();
        zzmw2.zzt();
        long l2 = zzmw2.zzf.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzmw2.zzq().zzv().nextInt(86400000);
            zzmw2.zzf.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        this.zzl().zzt();
        this.zzs();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzje zzje2 = this.zzb(string);
        bundle.putAll(zzje2.zzb());
        zzax zzax2 = this.zza(string, this.zzd(string), zzje2, new zzah());
        bundle.putAll(zzax2.zzb());
        zzop zzop2 = this.zzf().zze(string, "_npa");
        int n = zzop2 != null ? (zzop2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzah());
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zznv this) {
        return ((zzhy)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzg zza(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzo2.zzu.isEmpty()) {
            this.zzae.put(zzo2.zza, new zzb(this, zzo2.zzu, null));
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        boolean bl = false;
        zzje zzje2 = this.zzb(zzo2.zza).zza(zzje.zzb((String)zzo2.zzt));
        String string = zzje2.zzg() ? this.zzj.zza(zzo2.zza, zzo2.zzn) : "";
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzm, zzo2.zza);
            if (zzje2.zzh()) {
                zzg2.zzb(this.zza(zzje2));
            }
            if (zzje2.zzg()) {
                zzg2.zzh(string);
            }
        } else if (zzje2.zzg() && string != null && !string.equals(zzg2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzg2.zzaj());
            zzg2.zzh(string);
            if (zzo2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzo2.zza, (zzje)zzje2).first) && !bl2) {
                if (com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcy) && !zzje2.zzh()) {
                    bl = true;
                } else {
                    zzg2.zzb(this.zza(zzje2));
                }
                if (this.zzf().zze(zzo2.zza, "_id") != null && this.zzf().zze(zzo2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zzop zzop2 = new zzop(zzo2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zzop2);
                }
            } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzje2.zzh()) {
                zzg2.zzb(this.zza(zzje2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzje2.zzh()) {
            zzg2.zzb(this.zza(zzje2));
        }
        zzg2.zzf(zzo2.zzb);
        zzg2.zza(zzo2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzk)) {
            zzg2.zze(zzo2.zzk);
        }
        if (zzo2.zze != 0L) {
            zzg2.zzn(zzo2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzc)) {
            zzg2.zzd(zzo2.zzc);
        }
        zzg2.zzb(zzo2.zzj);
        if (zzo2.zzd != null) {
            zzg2.zzc(zzo2.zzd);
        }
        zzg2.zzk(zzo2.zzf);
        zzg2.zzb(zzo2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzg)) {
            zzg2.zzg(zzo2.zzg);
        }
        zzg2.zza(zzo2.zzn);
        zzg2.zza(zzo2.zzq);
        zzg2.zzl(zzo2.zzr);
        zzg2.zzj(zzo2.zzv);
        if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbh.zzbv)) {
            zzg2.zza(zzo2.zzs);
        } else if (com.google.android.gms.internal.measurement.zzny.zza() && this.zze().zza(zzbh.zzbu)) {
            zzg2.zza((List<String>)null);
        }
        if (zzpu.zza() && this.zze().zza(zzbh.zzbx)) {
            this.zzq();
            if (zzos.zzf((String)zzg2.zzac())) {
                zzg2.zzc(zzo2.zzw);
                if (this.zze().zza(zzbh.zzby)) {
                    zzg2.zzk(zzo2.zzac);
                }
            }
        }
        if (zzpn.zza() && this.zze().zza(zzbh.zzch)) {
            zzg2.zza(zzo2.zzaa);
        }
        zzg2.zzt(zzo2.zzx);
        zzg2.zzi(zzo2.zzad);
        if (com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcy)) {
            if (zzg2.zzas() || bl) {
                this.zzf().zza(zzg2, bl, false);
            }
        } else if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
        return zzg2;
    }

    @WorkerThread
    private final @Nullable zzo zzc(String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzgo.zza((String)string));
            return null;
        }
        return new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzf(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
    }

    public final zzt zzc() {
        return (zzt)zznv.zza(this.zzg);
    }

    public final zzab zzd() {
        return this.zzm.zzd();
    }

    public final zzag zze(@UnknownInitialization zznv this) {
        return ((zzhy)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzal zzf(@UnknownInitialization zznv this) {
        return (zzal)zznv.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzax zza(String string, zzax zzax2, zzje zzje2, zzah zzah2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzax2.zzc() == zzjh.zzc) {
                n2 = zzax2.zza();
                zzah2.zza(zzje.zza.zzc, n2);
            } else {
                n2 = 90;
                zzah2.zza(zzje.zza.zzc, zzak.zzi);
            }
            return new zzax(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzjh zzjh2 = zzax2.zzc();
        if (zzjh2 == zzjh.zzd || zzjh2 == zzjh.zzc) {
            n = zzax2.zza();
            zzah2.zza(zzje.zza.zzc, n);
        } else {
            zzje.zza zza2;
            zzje.zza zza3;
            n = 90;
            zzah zzah3 = zzah2;
            zzje zzje3 = zzje2;
            zzjh zzjh3 = zzjh2;
            String string2 = string;
            zznv zznv2 = this;
            if (zzjh3 == zzjh.zzb && (zza3 = zznv2.zzb.zza(string2, zzje.zza.zzc)) != zzjh.zza) {
                zzah3.zza(zzje.zza.zzc, zzak.zzh);
                zza2 = zza3;
            } else {
                boolean bl;
                zza3 = zznv2.zzb.zzb(string2, zzje.zza.zzc);
                zzjh zzjh4 = zzje3.zzc();
                boolean bl2 = bl = zzjh4 == zzjh.zzd || zzjh4 == zzjh.zzc;
                if (zza3 == zzje.zza.zza && bl) {
                    zzah3.zza(zzje.zza.zzc, zzak.zzc);
                    zza2 = zzjh4;
                } else {
                    zzah3.zza(zzje.zza.zzc, zzak.zzb);
                    zza2 = zznv2.zzb.zzc(string2, zzje.zza.zzc) ? zzjh.zzd : zzjh.zzc;
                }
            }
            zzjh2 = zza2;
        }
        boolean bl = this.zzb.zzm(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzjh2 == zzjh.zzc || sortedSet.isEmpty()) {
            return new zzax(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzax(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzax zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        zzax zzax2 = this.zzad.get(string);
        if (zzax2 == null) {
            zzax2 = this.zzf().zzg(string);
            this.zzad.put(string, zzax2);
        }
        return zzax2;
    }

    public final zzgh zzg() {
        return this.zzm.zzk();
    }

    public final zzgo zzj(@UnknownInitialization zznv this) {
        return ((zzhy)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzgr zzh() {
        return (zzgr)zznv.zza(this.zzc);
    }

    private final zzgy zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzhl zzi() {
        return (zzhl)zznv.zza(this.zzb);
    }

    public final zzhv zzl(@UnknownInitialization zznv this) {
        return ((zzhy)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhy zza(zznv zznv2) {
        return zznv2.zzm;
    }

    final zzhy zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzje zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzje zzje2 = this.zzac.get(string);
        if (zzje2 == null) {
            zzje2 = this.zzf().zzi(string);
            if (zzje2 == null) {
                zzje2 = zzje.zza;
            }
            this.zza(string, zzje2);
        }
        return zzje2;
    }

    public final zzli zzm() {
        return (zzli)zznv.zza(this.zzi);
    }

    public final zzmw zzn() {
        return this.zzj;
    }

    private final zznq zzz() {
        return (zznq)zznv.zza(this.zzf);
    }

    private static zznr zza(@Nullable zznr zznr2) {
        if (zznr2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zznr2.zzan()) {
            String string = String.valueOf(((Object)((Object)zznr2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zznr2;
    }

    public final zznu zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zznv zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zznv> clazz = zznv.class;
        synchronized (zznv.class) {
            if (zza != null) return zza;
            zzok zzok2 = (zzok)Preconditions.checkNotNull((Object)new zzok(context));
            zza = new zznv(zzok2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzoo zzp() {
        return (zzoo)zznv.zza(this.zzh);
    }

    public final zzos zzq(@UnknownInitialization zznv this) {
        return ((zzhy)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzg zzg2) {
        try {
            if (zzg2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionCode;
                if (zzg2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionName;
                String string2 = zzg2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private static @Nullable Boolean zzh(zzo zzo2) {
        Boolean bl = zzo2.zzq;
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzad)) {
            zzjh zzjh2 = com.google.android.gms.measurement.internal.zzf.zza((String)zzo2.zzad).zza();
            switch (zzjh2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzje zzje2) {
        if (zzje2.zzh()) {
            zznv zznv2 = this;
            byte[] byArray = new byte[16];
            zznv2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzo zzo2) {
        Future future = this.zzl().zza((Callable)new zzog(this, zzo2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzgo.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    private static @Nullable String zza(@Nullable Map<String, List<String>> map, String string) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            if (entry.getValue().isEmpty()) {
                return null;
            }
            return entry.getValue().get(0);
        }
        return null;
    }

    static /* synthetic */ void zza(zznv zznv2, zzok zzok2) {
        zznv zznv3 = zznv2;
        zznv3.zzl().zzt();
        zznv zznv4 = zznv3;
        zznv3.zzl = new zzhf(zznv4);
        zznv4 = zznv3;
        zzal zzal2 = new zzal(zznv4);
        zzal2.zzam();
        zznv3.zzd = zzal2;
        zznv3.zze().zza((zzai)Preconditions.checkNotNull((Object)((Object)zznv3.zzb)));
        zznv4 = zznv3;
        zzmw zzmw2 = new zzmw(zznv4);
        zzmw2.zzam();
        zznv3.zzj = zzmw2;
        zznv4 = zznv3;
        zzt zzt2 = new zzt(zznv4);
        zzt2.zzam();
        zznv3.zzg = zzt2;
        zznv4 = zznv3;
        zzli zzli2 = new zzli(zznv4);
        zzli2.zzam();
        zznv3.zzi = zzli2;
        zznv4 = zznv3;
        zznq zznq2 = new zznq(zznv4);
        zznq2.zzam();
        zznv3.zzf = zznq2;
        zznv4 = zznv3;
        zznv3.zze = new zzgy(zznv4);
        if (zznv3.zzs != zznv3.zzt) {
            zznv3.zzj().zzg().zza("Not all upload components initialized", (Object)zznv3.zzs, (Object)zznv3.zzt);
        }
        zznv3.zzn = true;
    }

    private zznv(zzok zzok2) {
        this(zzok2, null);
    }

    private zznv(zzok zzok2, @Nullable zzhy zzhy2) {
        Preconditions.checkNotNull((Object)zzok2);
        this.zzm = zzhy2 = zzhy.zza((Context)zzok2.zza, null, null);
        this.zzab = -1L;
        zznv zznv2 = this;
        this.zzk = new zznu(zznv2);
        zznv2 = this;
        zzoo zzoo2 = new zzoo(zznv2);
        zzoo2.zzam();
        this.zzh = zzoo2;
        zznv2 = this;
        zzgr zzgr2 = new zzgr(zznv2);
        zzgr2.zzam();
        this.zzc = zzgr2;
        zznv2 = this;
        zzhl zzhl2 = new zzhl(zznv2);
        zzhl2.zzam();
        this.zzb = zzhl2;
        this.zzac = new HashMap<String, zzje>();
        this.zzad = new HashMap<String, zzax>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zznx(this, zzok2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzae()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zznv zznv2 = this;
        zznv2.zzl().zzt();
        if (n4 > n3) {
            zznv2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zznv2.zza(n3, zznv2.zzy)) {
            zznv2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zznv2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfy.zzk.zza zza2) {
        int n;
        int n2;
        String string2;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzp(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzs(string) && !TextUtils.isEmpty((CharSequence)(string2 = zza2.zzy())) && (n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
            zza2.zzo(string2);
        }
        if (this.zzi().zzt(string) && (n = zzoo.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzr(string)) {
            zza2.zzk();
        }
        if (this.zzi().zzo(string)) {
            zza2.zzh();
            if (!com.google.android.gms.internal.measurement.zznm.zza() || !this.zze().zza(zzbh.zzcy) || this.zzb(string).zzh()) {
                zzb zzb2 = this.zzae.get(string);
                if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbh.zzaw) < this.zzb().elapsedRealtime()) {
                    zzb2 = new zzb(this, null);
                    this.zzae.put(string, zzb2);
                }
                zza2.zzk(zzb2.zza);
            }
        }
        if (this.zzi().zzq(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzah()) && TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zzb((String)Preconditions.checkNotNull((Object)zzg2.zzac()), 204, null, null, null);
            return;
        }
        if (zzpb.zza() && this.zze().zza(zzbh.zzcf)) {
            String string = (String)Preconditions.checkNotNull((Object)zzg2.zzac());
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string);
            zzfr.zzd zzd2 = this.zzi().zzc(string);
            ArrayMap arrayMap = null;
            String string2 = this.zzi().zze(string);
            if (zzd2 != null) {
                String string3;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string2);
                }
                if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzi().zzd(string)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string3);
                }
            }
            this.zzu = true;
            zznv zznv2 = this;
            zzny zzny2 = new zzny(zznv2);
            ArrayMap arrayMap2 = arrayMap;
            zzg zzg3 = zzg2;
            zzgr zzgr2 = this.zzh();
            zzgr2.zzt();
            zzgr2.zzal();
            Preconditions.checkNotNull((Object)zzg3);
            Preconditions.checkNotNull((Object)zzny2);
            String string4 = ((zzns)zzgr2).zzo().zza(zzg3);
            try {
                URL uRL = new URI(string4).toURL();
                zzgr2.zzl().zza((Runnable)new zzgw(zzgr2, zzg3.zzac(), uRL, null, (Map)arrayMap2, zzny2));
                return;
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                zzgr2.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgo.zza((String)zzg3.zzac()), (Object)string4);
                return;
            }
        }
        String string = this.zzk.zza(zzg2);
        try {
            String string5 = (String)Preconditions.checkNotNull((Object)zzg2.zzac());
            URL uRL = new URL(string);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string5);
            zzfr.zzd zzd3 = this.zzi().zzc(string5);
            ArrayMap arrayMap = null;
            String string6 = this.zzi().zze(string5);
            if (zzd3 != null) {
                String string7;
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string6);
                }
                if (!TextUtils.isEmpty((CharSequence)(string7 = this.zzi().zzd(string5)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string7);
                }
            }
            this.zzu = true;
            zzod zzod2 = new zzod(this);
            ArrayMap arrayMap3 = arrayMap;
            URL uRL2 = uRL;
            String string8 = string5;
            zzgr zzgr3 = this.zzh();
            zzgr3.zzt();
            zzgr3.zzal();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzod2);
            zzgr3.zzl().zza((Runnable)new zzgw(zzgr3, string8, uRL2, null, (Map)arrayMap3, zzod2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgo.zza((String)zzg2.zzac()), (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zza(zzg zzg2, zzfy.zzk.zza zza2) {
        Object object7;
        this.zzl().zzt();
        this.zzs();
        zzah zzah2 = com.google.android.gms.measurement.internal.zzah.zza(zza2.zzv());
        Object object2 = zzah2;
        Object object3 = zzg2.zzac();
        Object object4 = this;
        ((zznv)object4).zzl().zzt();
        ((zznv)object4).zzs();
        Object object5 = ((zznv)object4).zzb((String)object3);
        switch (object5.zzc()) {
            case zzb: {
                ((zzah)object2).zza(zzje.zza.zza, zzak.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                ((zzah)object2).zza(zzje.zza.zza, object5.zza());
                break;
            }
            default: {
                ((zzah)object2).zza(zzje.zza.zza, zzak.zzi);
            }
        }
        switch (object5.zzd()) {
            case zzb: {
                ((zzah)object2).zza(zzje.zza.zzb, zzak.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                ((zzah)object2).zza(zzje.zza.zzb, object5.zza());
                break;
            }
            default: {
                ((zzah)object2).zza(zzje.zza.zzb, zzak.zzi);
            }
        }
        object5 = zzah2;
        object2 = zza2;
        object3 = zzg2.zzac();
        object4 = this;
        ((zznv)object4).zzl().zzt();
        ((zznv)object4).zzs();
        Object object6 = ((zznv)object4).zza((String)object3, ((zznv)object4).zzd((String)object3), ((zznv)object4).zzb((String)object3), (zzah)object5);
        ((zzfy.zzk.zza)((Object)object2)).zzb((Boolean)Preconditions.checkNotNull((Object)object6.zzd()));
        if (!TextUtils.isEmpty((CharSequence)object6.zze())) {
            ((zzfy.zzk.zza)((Object)object2)).zzh(object6.zze());
        }
        object5 = zzah2;
        object2 = zza2;
        object3 = zzg2;
        object4 = this;
        ((zznv)object4).zzl().zzt();
        ((zznv)object4).zzs();
        object6 = null;
        for (Object object7 : ((zzfy.zzk.zza)((Object)object2)).zzab()) {
            if (!"_npa".equals(object7.zzg())) continue;
            object6 = object7;
            break;
        }
        if (object6 != null) {
            if (((zzah)object5).zza(zzje.zza.zzd) == zzak.zza) {
                zzop zzop2 = ((zznv)object4).zzf().zze(((zzg)object3).zzac(), "_npa");
                if (zzop2 != null) {
                    if ("tcf".equals(zzop2.zzb)) {
                        ((zzah)object5).zza(zzje.zza.zzd, zzak.zzg);
                    } else if ("app".equals(zzop2.zzb)) {
                        ((zzah)object5).zza(zzje.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object5).zza(zzje.zza.zzd, zzak.zzd);
                    }
                } else {
                    object7 = ((zzg)object3).zzx();
                    if (object7 == null || object7 == Boolean.TRUE && ((zzfy.zzo)((Object)object6)).zzc() != 1L || object7 == Boolean.FALSE && ((zzfy.zzo)((Object)object6)).zzc() != 0L) {
                        ((zzah)object5).zza(zzje.zza.zzd, zzak.zzf);
                    } else {
                        ((zzah)object5).zza(zzje.zza.zzd, zzak.zzd);
                    }
                }
            }
        } else {
            int n = ((zznv)object4).zza(((zzg)object3).zzac(), (zzah)object5);
            ((zzfy.zzk.zza)((Object)object2)).zza((zzfy.zzo)((zzjt)zzfy.zzo.zze().zza("_npa").zzb(((zznv)object4).zzb().currentTimeMillis()).zza(n).zzai()));
            ((zznv)object4).zzj().zzp().zza("Setting user property", (Object)"non_personalized_ads(_npa)", (Object)n);
        }
        zza2.zzf(zzah2.toString());
        boolean bl = this.zzb.zzm(zzg2.zzac());
        object4 = zza2;
        object5 = ((zzfy.zzk.zza)((Object)object4)).zzaa();
        for (int i = 0; i < object5.size(); ++i) {
            if (!"_tcf".equals(((zzfy.zzf)((Object)object5.get(i))).zzg())) continue;
            zzfy.zzf.zza zza3 = (zzfy.zzf.zza)((zzfy.zzf)((Object)object5.get(i))).zzcd();
            object7 = zza3.zzf();
            for (int j = 0; j < object7.size(); ++j) {
                if (!"_tcfd".equals(((zzfy.zzh)((Object)object7.get(j))).zzg())) continue;
                String string = zznm.zza((String)((zzfy.zzh)((Object)object7.get(j))).zzh(), (boolean)bl);
                zza3.zza(j, zzfy.zzh.zze().zza("_tcfd").zzb(string));
                break;
            }
            ((zzfy.zzk.zza)((Object)object4)).zza(i, zza3);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzfy.zzf.zza zza2, int n, String string) {
        List<zzfy.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfy.zzh zzh2 = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_err").zza(n).zzai());
        zzfy.zzh zzh3 = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_ev").zzb(string).zzai());
        zza2.zza(zzh2).zza(zzh3);
    }

    @WorkerThread
    final void zza(zzbf zzbf2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzo2.zza;
        long l = zzbf2.zzd;
        zzgs zzgs2 = zzgs.zza((zzbf)zzbf2);
        String string2 = string;
        zzjc zzjc2 = this;
        zzjc2.zzl().zzt();
        zzos.zza(zzjc2.zzaf == null || zzjc2.zzag == null || !zzjc2.zzag.equals(string2) ? null : zzjc2.zzaf, (Bundle)zzgs2.zzc, (boolean)false);
        zzbf2 = zzgs2.zza();
        this.zzp();
        if (!zzoo.zza(zzbf2, zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if (zzo2.zzs != null) {
            if (zzo2.zzs.contains(zzbf2.zza)) {
                Bundle bundle = zzbf2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbf2 = new zzbf(zzbf2.zza, new zzbe(bundle), zzbf2.zzc, zzbf2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbf2.zza, (Object)zzbf2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzae zzae2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzjc2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjc2.zzt();
            zzjc2.zzal();
            if (l2 < 0L) {
                zzjc2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzgo.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzjc2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzae)object22).zza, (Object)this.zzm.zzk().zzc(((zzae)object22).zzc.zza), ((zzae)object22).zzc.zza());
                if (((zzae)object22).zzg != null) {
                    this.zzc(new zzbf(((zzae)object22).zzg, l), zzo2);
                }
                this.zzf().zza(string, ((zzae)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzjc2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjc2.zzt();
            zzjc2.zzal();
            if (l2 < 0L) {
                zzjc2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzgo.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzjc2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzae)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzae)object).zza, (Object)this.zzm.zzk().zzc(((zzae)object).zzc.zza), ((zzae)object).zzc.zza());
                this.zzf().zzh(string, ((zzae)object).zzc.zza);
                if (((zzae)object).zzk != null) {
                    object22.add(((zzae)object).zzk);
                }
                this.zzf().zza(string, ((zzae)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbf)e;
                this.zzc(new zzbf((zzbf)object, l), zzo2);
            }
            long l3 = l;
            String string4 = zzbf2.zza;
            string2 = string;
            zzjc2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzjc2.zzt();
            zzjc2.zzal();
            if (l3 < 0L) {
                zzjc2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzgo.zza((String)string2), (Object)zzjc2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzjc2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzae2 = (zzae)iterator.next();
                if (zzae2 == null) continue;
                zzon zzon2 = zzae2.zzc;
                zzop zzop2 = new zzop((String)Preconditions.checkNotNull((Object)zzae2.zza), zzae2.zzb, zzon2.zza, l, Preconditions.checkNotNull((Object)zzon2.zza()));
                if (this.zzf().zza(zzop2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zzop2.zzc), zzop2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzgo.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zzop2.zzc), zzop2.zze);
                }
                if (zzae2.zzi != null) {
                    object.add(zzae2.zzi);
                }
                zzae2.zzc = new zzon(zzop2);
                zzae2.zze = true;
                this.zzf().zza(zzae2);
            }
            this.zzc(zzbf2, zzo2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzae2 = (zzbf)e;
                this.zzc(new zzbf((zzbf)zzae2, l), zzo2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbf zzbf2, String string) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzbf2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzgo.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzgo.zza((String)string));
            return;
        }
        zzo zzo2 = new zzo(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), zzg2.zzd(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzf(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak());
        this.zzb(zzbf2, zzo2);
    }

    @WorkerThread
    private final void zzb(zzbf zzbf2, zzo zzo2) {
        String string;
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzgs zzgs2 = zzgs.zza((zzbf)zzbf2);
        this.zzq().zza(zzgs2.zzc, this.zzf().zzd(zzo2.zza));
        this.zzq().zza(zzgs2, this.zze().zzb(zzo2.zza));
        zzbf2 = zzgs2.zza();
        zzo zzo3 = zzo2;
        zzbf zzbf3 = zzbf2;
        zznv zznv2 = this;
        if ("_cmp".equals(zzbf3.zza) && "referrer API v2".equals(zzbf3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbf3.zzb.zzd("gclid")))) {
            zzon zzon2 = new zzon("_lgclid", zzbf3.zzd, (Object)string, "auto");
            zznv2.zza(zzon2, zzo3);
        }
        this.zza(zzbf2, zzo2);
    }

    @VisibleForTesting
    private final void zza(zzfy.zzk.zza zza2, long l, boolean bl) {
        zzop zzop2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzop2 = (zzop2 = this.zzf().zze(zza2.zzt(), string)) == null || zzop2.zze == null ? new zzop(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zzop(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zzop2.zze + l));
        zzfy.zzo zzo2 = (zzfy.zzo)((zzjt)zzfy.zzo.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zzop2.zze).zzai());
        boolean bl2 = false;
        int n = zzoo.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzo2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzo2);
        }
        if (l > 0L) {
            this.zzf().zza(zzop2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zzop2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        this.zzb(string, n, throwable, byArray, map);
    }

    @WorkerThread
    private final void zzab() {
        this.zzl().zzt();
        for (String string : this.zzr) {
            if (!zzpn.zza() || !this.zze().zze(string, zzbh.zzch)) continue;
            this.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)string);
            Intent intent = new Intent();
            intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            intent.setPackage(string);
            this.zzm.zza().sendBroadcast(intent);
        }
        this.zzr.clear();
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzg zzg2 = this.zzf().zze(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzgo.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    String string3;
                    String string4;
                    if (zzpb.zza() && this.zze().zza(zzbh.zzcf)) {
                        string4 = zznv.zza(map, "Last-Modified");
                        string3 = zznv.zza(map, "ETag");
                    } else {
                        List<String> list = map != null ? map.get("Last-Modified") : null;
                        string4 = list != null && !list.isEmpty() ? list.get(0) : null;
                        List<String> list2 = map != null ? map.get("ETag") : null;
                        string3 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    }
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string4, string2)) {
                        return;
                    }
                    zzg2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzad()) {
                        this.zzw();
                    } else if (this.zze().zza(zzbh.zzcb) && this.zzh().zzu() && this.zzf().zzs(zzg2.zzac())) {
                        this.zze(zzg2.zzac());
                    } else {
                        this.zzac();
                    }
                } else {
                    zzg2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zze.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzac();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzac();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string, List<Pair<zzfy.zzj, zznw>> list) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list2 = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (!bl || (n == 200 || n == 204) && throwable == null) {
                this.zzj().zzp().zza("Network upload successful with code", (Object)n);
                try {
                    if (bl) {
                        this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zze.zza(0L);
                    this.zzac();
                    if (bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        if (this.zze().zza(zzbh.zzcb)) {
                            for (Pair l : list) {
                                zzfy.zzj zzj2 = (zzfy.zzj)((Object)l.first);
                                zznw zznw2 = (zznw)l.second;
                                this.zzf().zza(string, zzj2, zznw2.zzb(), zznw2.zzc(), zznw2.zza());
                            }
                        }
                        for (Long l : list2) {
                            try {
                                long l2 = l;
                                zzal zzal2 = this.zzf();
                                zzal2.zzt();
                                zzal2.zzal();
                                SQLiteDatabase sQLiteDatabase = zzal2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzal2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzad()) {
                        this.zzw();
                    } else if (this.zze().zza(zzbh.zzcb) && this.zzh().zzu() && this.zzf().zzs(string)) {
                        this.zze(string);
                    } else {
                        this.zzab = -1L;
                        this.zzac();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                if (zzpb.zza() && this.zze().zza(zzbh.zzcf)) {
                    String string2 = new String(byArray, StandardCharsets.UTF_8);
                    String string3 = string2.substring(0, Math.min(32, string2.length()));
                    this.zzj().zzv().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable, (Object)string3);
                } else {
                    this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                }
                this.zzj.zze.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list2);
                this.zzac();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(@NonNull String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable zzoj zzoj2) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if ((n == 200 || n == 204) && throwable == null) {
                if (zzoj2 != null) {
                    Long l = zzoj2.zza();
                    zzal zzal2 = this.zzf();
                    zzal2.zzt();
                    zzal2.zzal();
                    Preconditions.checkNotNull((Object)l);
                    if (!zzpu.zza() || zzal2.zze().zza(zzbh.zzcb)) {
                        SQLiteDatabase sQLiteDatabase = zzal2.e_();
                        String[] stringArray = new String[]{String.valueOf(l)};
                        try {
                            if (sQLiteDatabase.delete("upload_queue", "rowid=?", stringArray) != 1) {
                                zzal2.zzj().zzu().zza("Deleted fewer rows from upload_queue than expected");
                            }
                        }
                        catch (SQLiteException sQLiteException) {
                            zzal2.zzj().zzg().zza("Failed to delete a MeasurementBatch in a upload_queue table", (Object)sQLiteException);
                            throw sQLiteException;
                        }
                    }
                }
                this.zzj().zzp().zza("Successfully uploaded batch from upload queue. appId, status", (Object)string, (Object)n);
                if (this.zze().zza(zzbh.zzcb) && this.zzh().zzu() && this.zzf().zzs(string)) {
                    this.zze(string);
                } else {
                    this.zzac();
                }
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = string2.substring(0, Math.min(32, string2.length()));
                this.zzj().zzv().zza("Network upload failed. Will retry later. appId, status, error", (Object)string, (Object)n, throwable == null ? string3 : throwable);
                if (zzoj2 != null) {
                    this.zzf().zza((Long)zzoj2.zza());
                }
                this.zzac();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzb(zzg zzg2, zzfy.zzk.zza zza2) {
        this.zzl().zzt();
        this.zzs();
        zzfy.zza.zza zza3 = zzfy.zza.zzc();
        byte[] byArray = zzg2.zzav();
        if (byArray != null) {
            try {
                zza3 = zzoo.zza(zza3, byArray);
            }
            catch (zzkb zzkb2) {
                this.zzj().zzu().zza("Failed to parse locally stored ad campaign info. appId", zzgo.zza((String)zzg2.zzac()));
            }
        }
        for (zzfy.zzf zzf2 : zza2.zzaa()) {
            if (!zzf2.zzg().equals("_cmp")) continue;
            zzfy.zzf zzf3 = zzf2;
            zzfy.zza.zza zza4 = zza3;
            zznv zznv2 = this;
            String string = (String)zzoo.zza(zzf3, "gclid", (Object)"");
            String string2 = (String)zzoo.zza(zzf3, "gbraid", (Object)"");
            String string3 = (String)zzoo.zza(zzf3, "gad_source", (Object)"");
            if (string.isEmpty() && string2.isEmpty()) continue;
            long l = (Long)zzoo.zza(zzf3, "click_timestamp", (Object)0L);
            if (l <= 0L) {
                l = zzf3.zzd();
            }
            if ("referrer API v2".equals(zzoo.zzb(zzf3, "_cis"))) {
                if (!(l > zza4.zzb())) continue;
                if (string.isEmpty()) {
                    zza4.zzh();
                } else {
                    zza4.zzf(string);
                }
                if (string2.isEmpty()) {
                    zza4.zzg();
                } else {
                    zza4.zze(string2);
                }
                if (string3.isEmpty()) {
                    zza4.zzf();
                } else {
                    zza4.zzd(string3);
                }
                zza4.zzb(l);
                continue;
            }
            if (!(l > zza4.zza())) continue;
            if (string.isEmpty()) {
                zza4.zze();
            } else {
                zza4.zzc(string);
            }
            if (string2.isEmpty()) {
                zza4.zzd();
            } else {
                zza4.zzb(string2);
            }
            if (string3.isEmpty()) {
                zza4.zzc();
            } else {
                zza4.zza(string3);
            }
            zza4.zza(l);
        }
        if (!((zzfy.zza)((zzjt)zza3.zzai())).equals((Object)zzfy.zza.zze())) {
            zza2.zza((zzfy.zza)((zzjt)zza3.zzai()));
        }
        zzg2.zza(((zzfy.zza)((zzjt)zza3.zzai())).zzca());
        if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!this.zze().zza(zzbh.zzdc)) {
            return;
        }
        if (this.zze().zza(zzbh.zzbj)) {
            long l;
            long l2 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbh.zzau);
            this.zze();
            long l3 = l2 - com.google.android.gms.measurement.internal.zzag.zzg();
            for (int i = 0; i < n && this.zza(null, l = l3); ++i) {
            }
        } else {
            this.zze();
            long l = com.google.android.gms.measurement.internal.zzag.zzh();
            int n = 0;
            while ((long)n < l && this.zza(zzo2.zza, 0L)) {
                ++n;
            }
        }
        if (this.zze().zza(zzbh.zzbk)) {
            this.zzab();
        }
    }

    @WorkerThread
    final void zzd(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zznv.zzi(zzo2)) {
            return;
        }
        zzg zzg2 = this.zzf().zze(zzo2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzah()) && !TextUtils.isEmpty((CharSequence)zzo2.zzb)) {
            zzg2.zzd(0L);
            this.zzf().zza(zzg2, false, false);
            this.zzi().zzj(zzo2.zza);
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        long l = zzo2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzt();
        int n = zzo2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzgo.zza((String)zzo2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzal zzal2;
            String string2;
            zzon zzon2;
            zzop zzop2 = this.zzf().zze(zzo2.zza, "_npa");
            Boolean bl = zznv.zzh(zzo2);
            if (zzop2 == null || "auto".equals(zzop2.zzb)) {
                if (bl != null) {
                    zzon2 = new zzon("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zzop2 == null || !zzop2.zze.equals(zzon2.zzc)) {
                        this.zza(zzon2, zzo2);
                    }
                } else if (zzop2 != null) {
                    this.zza("_npa", zzo2);
                }
            }
            long l2 = l;
            zzo zzo3 = zzo2;
            zznv zznv2 = this;
            Object object3 = zznv2.zzf().zze((String)Preconditions.checkNotNull((Object)zzo3.zza));
            if (object3 != null) {
                zznv2.zzq();
                if (zzos.zza((String)zzo3.zzb, (String)((zzg)object3).zzah(), (String)zzo3.zzp, (String)((zzg)object3).zzaa())) {
                    zznv2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzgo.zza((String)((zzg)object3).zzac()));
                    string2 = ((zzg)object3).zzac();
                    zzal2 = zznv2.zzf();
                    zzal2.zzal();
                    zzal2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzal2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzal2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzal2.zzj().zzg().zza("Error deleting application data. appId, error", zzgo.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzg)object3).zze() != Integer.MIN_VALUE && ((zzg)object3).zze() != zzo3.zzj;
                string = ((zzg)object3).zzaf();
                if (bl2 | (((zzg)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzo3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbf("_au", new zzbe(bundle), "auto", l2);
                    zznv2.zza((zzbf)object, zzo3);
                }
            }
            this.zza(zzo2);
            zzon2 = null;
            if (n == 0) {
                zzon2 = this.zzf().zzd(zzo2.zza, "_f");
            } else if (n == 1) {
                zzon2 = this.zzf().zzd(zzo2.zza, "_v");
            }
            if (zzon2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzon zzon3 = new zzon("_fot", l, (Object)l3, "auto");
                    this.zza(zzon3, zzo2);
                    zzo3 = zzo2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    String string3 = zzo3.zza;
                    zzhf zzhf2 = (zzhf)Preconditions.checkNotNull((Object)zznv2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzhf2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzhf2.zza.zzl().zzt();
                        if (!zzhf2.zza()) {
                            zzhf2.zza.zzj().zzo().zza("Install Referrer Reporter is not available");
                        } else {
                            zzhi zzhi2 = new zzhi(zzhf2, string3);
                            object3 = zzhf2;
                            ((zzhf)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzhf)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzhf)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzal2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzal2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzal2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzal2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzhf)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzhf)object3).zza.zza(), intent, (ServiceConnection)zzhi2, 1);
                                                ((zzhf)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzhf)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzhf)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzhf)object3).zza.zzj().zzo().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzo3 = zzo2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    zznv2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
                    object2 = string4;
                    zzal zzal3 = zznv2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzal3.zzt();
                    zzal3.zzal();
                    long l5 = zzal3.zzb((String)object2, "first_open_count");
                    if (zznv2.zzm.zza().getPackageManager() == null) {
                        zznv2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzgo.zza((String)string4));
                    } else {
                        zzal2 = null;
                        try {
                            zzal2 = Wrappers.packageManager((Context)zznv2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznv2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzgo.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzal2 != null && ((PackageInfo)zzal2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzal2).firstInstallTime != ((PackageInfo)zzal2).lastUpdateTime) {
                                if (zznv2.zze().zza(zzbh.zzbs)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zzon("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zznv2.zza((zzon)sQLiteDatabase, zzo3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zznv2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zznv2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzgo.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzal2 = new zzbf("_f", new zzbe((Bundle)object3), "auto", l4);
                    zznv2.zzb((zzbf)zzal2, zzo3);
                } else if (n == 1) {
                    zzon zzon4 = new zzon("_fvt", l, (Object)l3, "auto");
                    this.zza(zzon4, zzo2);
                    l2 = l;
                    zzo3 = zzo2;
                    zznv2 = this;
                    zznv2.zzl().zzt();
                    zznv2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbf zzbf2 = new zzbf("_v", new zzbe((Bundle)object3), "auto", l2);
                    zznv2.zzb(zzbf2, zzo3);
                }
            } else if (zzo2.zzi) {
                l2 = l;
                zzo3 = zzo2;
                zznv2 = this;
                object3 = new Bundle();
                zzbf zzbf3 = new zzbf("_cd", new zzbe((Bundle)object3), "auto", l2);
                zznv2.zzb(zzbf3, zzo3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zza(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            String string = (String)Preconditions.checkNotNull((Object)zzae2.zza);
            zzae zzae3 = this.zzf().zzc(string, zzae2.zzc.zza);
            if (zzae3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
                this.zzf().zza(string, zzae2.zzc.zza);
                if (zzae3.zze) {
                    this.zzf().zzh(string, zzae2.zzc.zza);
                }
                if (zzae2.zzk != null) {
                    Bundle bundle = null;
                    if (zzae2.zzk.zzb != null) {
                        bundle = zzae2.zzk.zzb.zzb();
                    }
                    zzbf zzbf2 = this.zzq().zza(string, ((zzbf)Preconditions.checkNotNull((Object)zzae2.zzk)).zza, bundle, zzae3.zzb, zzae2.zzk.zzd, true, true);
                    this.zzc((zzbf)Preconditions.checkNotNull((Object)zzbf2), zzo2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzgo.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfy.zzf.zza zza2, @NonNull String string) {
        List<zzfy.zzh> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        Boolean bl = zznv.zzh(zzo2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzon zzon2 = new zzon("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zzon2, zzo2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zze(zzo zzo2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzo2.zza);
        zzal zzal2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzal2.zzt();
        zzal2.zzal();
        try {
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray) + sQLiteDatabase.delete("upload_queue", "app_id=?", stringArray);
            if (n > 0) {
                zzal2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzgo.zza((String)string), (Object)sQLiteException);
        }
        if (zzo2.zzh) {
            this.zzd(zzo2);
        }
    }

    @WorkerThread
    final void zzf(zzo zzo2) {
        boolean bl;
        zzjh zzjh2;
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzax zzax2 = zzax.zza((String)zzo2.zzz);
        this.zzj().zzp().zza("Setting DMA consent for package", (Object)zzo2.zza, (Object)zzax2);
        zzax zzax3 = zzax2;
        String string = zzo2.zza;
        zznv zznv2 = this;
        zznv2.zzl().zzt();
        zznv2.zzs();
        zzjh zzjh3 = zzax.zza((Bundle)zznv2.zza(string), (int)100).zzc();
        zznv2.zzad.put(string, zzax3);
        zznv2.zzf().zza(string, zzax3);
        zzjh zzjh4 = zzjh2 = zzax.zza((Bundle)zznv2.zza(string), (int)100).zzc();
        zzjh zzjh5 = zzjh3;
        String string2 = string;
        zznv zznv3 = zznv2;
        zznv3.zzl().zzt();
        zznv3.zzs();
        boolean bl2 = zzjh5 == zzjh.zzc && zzjh4 == zzjh.zzd;
        boolean bl3 = bl = zzjh5 == zzjh.zzd && zzjh4 == zzjh.zzc;
        boolean bl4 = zznv3.zze().zza(zzbh.zzcq) ? bl2 || bl : bl2;
        if (bl4) {
            zznv3.zzj().zzp().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zznv3.zzf().zza((long)zznv3.zzx(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zznv3.zze().zzb(string2, zzbh.zzay)) {
                bundle.putLong("_r", 1L);
                zzaq zzaq2 = zznv3.zzf().zza(zznv3.zzx(), string2, false, false, false, false, false, true, false);
                zznv3.zzj().zzp().zza("_dcu realtime event count", (Object)string2, (Object)zzaq2.zzf);
            }
            zznv3.zzah.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzlk zzlk2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzlk2 != null) {
            this.zzag = string;
            this.zzaf = zzlk2;
        }
    }

    @WorkerThread
    final void zzg(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)zzo2.zza);
        int n = zzo2.zzy;
        zzje zzje2 = zzje.zza((String)zzo2.zzt, (int)n);
        zzje zzje3 = this.zzb(zzo2.zza);
        this.zzj().zzp().zza("Setting storage consent for package", (Object)zzo2.zza, (Object)zzje2);
        this.zza(zzo2.zza, zzje2);
        if (!(com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcy) || !zzje2.zzc(zzje3))) {
            this.zze(zzo2);
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        zzal zzal2 = this.zzf();
        zzal2.zzt();
        zzal2.zzal();
        if (zzal2.zzaa() && (Long)zzbh.zzbh.zza(null) != 0L) {
            String[] stringArray;
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            int n = sQLiteDatabase.delete("trigger_uris", "abs(timestamp_millis - ?) > cast(? as integer)", stringArray = new String[]{String.valueOf(zzal2.zzb().currentTimeMillis()), String.valueOf(zzbh.zzbh.zza(null))});
            if (n > 0) {
                zzal2.zzj().zzp().zza("Deleted stale trigger uris. rowsDeleted", (Object)n);
            }
        }
        if (this.zzj.zzd.zza() == 0L) {
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzac();
    }

    @WorkerThread
    final void zzb(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zzb(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zzb(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzb);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzae zzae4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzc.zza);
            if (zzae4 != null && !zzae4.zzb.equals(zzae3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), (Object)zzae3.zzb, (Object)zzae4.zzb);
            }
            if (zzae4 != null && zzae4.zze) {
                zzae3.zzb = zzae4.zzb;
                zzae3.zzd = zzae4.zzd;
                zzae3.zzh = zzae4.zzh;
                zzae3.zzf = zzae4.zzf;
                zzae3.zzi = zzae4.zzi;
                zzae3.zze = zzae4.zze;
                zzae3.zzc = new zzon(zzae3.zzc.zza, zzae4.zzc.zzb, zzae3.zzc.zza(), zzae4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzae3.zzf)) {
                zzae3.zzc = new zzon(zzae3.zzc.zza, zzae3.zzd, zzae3.zzc.zza(), zzae3.zzc.zze);
                zzae3.zze = true;
                bl = true;
            }
            if (zzae3.zze) {
                zzon zzon2 = zzae3.zzc;
                zzop zzop2 = new zzop((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzb, zzon2.zza, zzon2.zzb, Preconditions.checkNotNull((Object)zzon2.zza()));
                if (this.zzf().zza(zzop2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zzop2.zzc), zzop2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzgo.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zzop2.zzc), zzop2.zze);
                }
                if (bl && zzae3.zzi != null) {
                    zzbf zzbf2 = new zzbf(zzae3.zzi, zzae3.zzd);
                    this.zzc(zzbf2, zzo2);
                }
            }
            if (this.zzf().zza(zzae3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzgo.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    private final void zzac() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzad()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zznv zznv2 = this;
            long l5 = zznv2.zzb().currentTimeMillis();
            zznv2.zze();
            long l6 = Math.max(0L, (Long)zzbh.zzab.zza(null));
            boolean bl = zznv2.zzf().zzz() || zznv2.zzf().zzy();
            if (bl) {
                String string = zznv2.zze().zzo();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zznv2.zze();
                    l4 = Math.max(0L, (Long)zzbh.zzw.zza(null));
                } else {
                    zznv2.zze();
                    l4 = Math.max(0L, (Long)zzbh.zzv.zza(null));
                }
            } else {
                zznv2.zze();
                l4 = Math.max(0L, (Long)zzbh.zzu.zza(null));
            }
            long l7 = zznv2.zzj.zzd.zza();
            long l8 = zznv2.zzj.zze.zza();
            long l9 = zznv2.zzf().c_();
            long l10 = zznv2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zznv2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zznv2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbh.zzad.zza(null)))) break;
                        long l15 = 1L << n;
                        zznv2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbh.zzac.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzc.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbh.zzs.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbh.zzx.zza(null));
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, zzje zzje2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzje2);
        this.zzf().zzb(string, zzje2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzg zzg2 = this.zzf().zze(string);
        if (zzg2 != null) {
            zzg2.zzd(bl);
            zzg2.zza(l);
            zzg2.zzb(l2);
            if (zzg2.zzas()) {
                this.zzf().zza(zzg2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zzon zzon2, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zznv.zzi(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        int n = this.zzq().zzb(zzon2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzon2.zza;
            this.zze();
            String string2 = zzos.zza((String)string, (int)24, (boolean)true);
            int n2 = zzon2.zza != null ? zzon2.zza.length() : 0;
            this.zzq();
            zzos.zza((zzor)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzon2.zza, zzon2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzon2.zza;
            this.zze();
            String string3 = zzos.zza((String)string, (int)24, (boolean)true);
            Object object = zzon2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzos.zza((zzor)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzon2.zza, zzon2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzon2.zza)) {
            zzbb zzbb2;
            zzo zzo3 = zzo2;
            String string = zzon2.zze;
            long l = zzon2.zzb;
            zznv zznv2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
            long l2 = 0L;
            zzop zzop2 = zznv2.zzf().zze(string4, "_sno");
            if (zzop2 != null && zzop2.zze instanceof Long) {
                l2 = (Long)zzop2.zze;
            } else {
                if (zzop2 != null) {
                    zznv2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zzop2.zze);
                }
                if ((zzbb2 = zznv2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbb2.zzc;
                    zznv2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbb2 = new zzon("_sno", l, (Object)(++l2), string);
            zznv2.zza((zzon)zzbb2, zzo3);
        }
        zzop zzop3 = new zzop((String)Preconditions.checkNotNull((Object)zzo2.zza), (String)Preconditions.checkNotNull((Object)zzon2.zze), zzon2.zza, zzon2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zzop3.zzc), object);
        this.zzf().zzp();
        try {
            zzop zzop4;
            if ("_id".equals(zzop3.zzc) && (zzop4 = this.zzf().zze(zzo2.zza, "_id")) != null && !zzop3.zze.equals(zzop4.zze)) {
                this.zzf().zzh(zzo2.zza, "_lair");
            }
            this.zza(zzo2);
            boolean bl = this.zzf().zza(zzop3);
            if ("_sid".equals(zzon2.zza)) {
                long l = this.zzp().zza(zzo2.zzv);
                zzg zzg2 = this.zzf().zze(zzo2.zza);
                if (zzg2 != null) {
                    zzg2.zzs(l);
                    if (zzg2.zzas()) {
                        this.zzf().zza(zzg2, false, false);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zzop3.zzc), zzop3.zze);
                this.zzq();
                zzos.zza((zzor)this.zzah, (String)zzo2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzac();
                return;
            }
            zznv zznv2 = this;
            zznv2.zzl().zzt();
            if (zznv2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzac();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbh.zzau);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzag.zzg();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzpn.zza()) {
                this.zzab();
            }
            if ((l = this.zzj.zzd.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbh.zzg);
                Object object = string;
                zznv2 = this.zze();
                int n3 = Math.max(0, zznv2.zzb((String)object, zzbh.zzh));
                List<Pair<zzfy.zzk, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    zzle zzle2;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    Object object9;
                    Object object10;
                    if (this.zzb(string).zzg()) {
                        object10 = null;
                        Iterator<Pair<zzfy.zzk, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfy.zzk zzk2 = (zzfy.zzk)((Object)iterator.next().first);
                            if (zzk2.zzan().isEmpty()) continue;
                            object10 = zzk2.zzan();
                            break;
                        }
                        if (object10 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object9 = (zzfy.zzk)((Object)list.get((int)i).first);
                                if (((zzfy.zzk)((Object)object9)).zzan().isEmpty() || ((zzfy.zzk)((Object)object9)).zzan().equals(object10)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object10 = zzfy.zzj.zzb();
                    int n4 = list.size();
                    object9 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzj(string) && this.zzb(string).zzg();
                    boolean bl3 = this.zzb(string).zzg();
                    boolean bl4 = this.zzb(string).zzh();
                    boolean bl5 = zzpo.zza() && this.zze().zze(string, zzbh.zzbw);
                    zznw zznw2 = this.zzk.zza(string);
                    for (int i = 0; i < n4; ++i) {
                        object8 = (zzfy.zzk.zza)((zzfy.zzk)((Object)list.get((int)i).first)).zzcd();
                        object9.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfy.zzk.zza)((Object)object8)).zzl(106000L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfy.zzk.zza)((Object)object8)).zzk();
                        }
                        if (!bl3) {
                            ((zzfy.zzk.zza)((Object)object8)).zzq();
                            ((zzfy.zzk.zza)((Object)object8)).zzn();
                        }
                        if (!bl4) {
                            ((zzfy.zzk.zza)((Object)object8)).zzh();
                        }
                        this.zza(string, (zzfy.zzk.zza)((Object)object8));
                        if (!bl5) {
                            ((zzfy.zzk.zza)((Object)object8)).zzr();
                        }
                        if (com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcz) && !bl4) {
                            ((zzfy.zzk.zza)((Object)object8)).zzi();
                        }
                        object = object8;
                        zznv2 = this;
                        object7 = ((zzfy.zzk.zza)((Object)object)).zzz();
                        boolean bl6 = false;
                        if (TextUtils.isEmpty((CharSequence)object7) || ((String)object7).equals("00000000-0000-0000-0000-000000000000")) {
                            object6 = new ArrayList<zzfy.zzf>(((zzfy.zzk.zza)((Object)object)).zzaa());
                            boolean bl7 = false;
                            object5 = object6.iterator();
                            object4 = null;
                            Long l5 = null;
                            while (object5.hasNext()) {
                                zzle2 = (zzfy.zzf)((Object)object5.next());
                                if ("_fx".equals(zzle2.zzg())) {
                                    bl6 = true;
                                    object5.remove();
                                    bl7 = true;
                                    continue;
                                }
                                if (!"_f".equals(zzle2.zzg())) continue;
                                bl6 = true;
                                if (!zznv2.zze().zza(zzbh.zzcw)) continue;
                                zznv2.zzp();
                                zzfy.zzh zzh2 = zzoo.zza((zzfy.zzf)zzle2, "_pfo");
                                if (zzh2 != null) {
                                    object4 = zzh2.zzd();
                                }
                                zznv2.zzp();
                                zzfy.zzh zzh3 = zzoo.zza((zzfy.zzf)zzle2, "_uwa");
                                if (zzh3 == null) continue;
                                l5 = zzh3.zzd();
                            }
                            if (bl7) {
                                ((zzfy.zzk.zza)((Object)object)).zzl();
                                ((zzfy.zzk.zza)((Object)object)).zzb((Iterable<? extends zzfy.zzf>)object6);
                            }
                            if (bl6) {
                                zznv2.zza(((zzfy.zzk.zza)((Object)object)).zzt(), true, (Long)object4, l5);
                            }
                        }
                        if (((zzfy.zzk.zza)((Object)object8)).zzc() == 0) continue;
                        if (this.zze().zze(string, zzbh.zzbm)) {
                            object3 = ((zzfy.zzk)((zzjt)object8.zzai())).zzca();
                            ((zzfy.zzk.zza)((Object)object8)).zza(this.zzp().zza((byte[])object3));
                        }
                        ((zzfy.zzj.zza)((Object)object10)).zza((zzfy.zzk.zza)((Object)object8));
                    }
                    if (((zzfy.zzj.zza)((Object)object10)).zza() == 0) {
                        this.zza((List<Long>)object9);
                        this.zza(false, 204, null, null, string, Collections.emptyList());
                        return;
                    }
                    zzfy.zzj zzj2 = (zzfy.zzj)((zzjt)object10.zzai());
                    object8 = new ArrayList();
                    if (this.zze().zza(zzbh.zzbx)) {
                        this.zzq();
                        if (zzos.zzf((String)string) && zznw2.zza() == zznt.zzc) {
                            String object112;
                            boolean bl6;
                            block59: {
                                object7 = ((zzfy.zzj)((zzjt)object10.zzai())).zzf().iterator();
                                while (object7.hasNext()) {
                                    if (!object7.next().zzbh()) continue;
                                    bl6 = true;
                                    break block59;
                                }
                                bl6 = false;
                            }
                            Object object12 = object3 = bl6 ? UUID.randomUUID().toString() : null;
                            object7 = (zzfy.zzj)((zzjt)object10.zzai());
                            object = string;
                            zznv2 = this;
                            zznv2.zzl().zzt();
                            zznv2.zzs();
                            object6 = zzfy.zzj.zza((zzfy.zzj)((Object)object7));
                            if (!TextUtils.isEmpty((CharSequence)object12)) {
                                ((zzfy.zzj.zza)((Object)object6)).zza((String)object12);
                            }
                            if (!TextUtils.isEmpty((CharSequence)(object112 = zznv2.zzi().zzf((String)object)))) {
                                ((zzfy.zzj.zza)((Object)object6)).zzb(object112);
                            }
                            object5 = new ArrayList();
                            object4 = ((zzfy.zzj)((Object)object7)).zzf().iterator();
                            while (object4.hasNext()) {
                                zzle2 = zzfy.zzk.zza(object4.next());
                                zzle2.zzk();
                                object5.add((zzfy.zzk)((zzjt)zzle2.zzai()));
                            }
                            ((zzfy.zzj.zza)((Object)object6)).zzb();
                            ((zzfy.zzj.zza)((Object)object6)).zza((Iterable<? extends zzfy.zzk>)object5);
                            if (zznv2.zze().zza(zzbh.zzcc)) {
                                zznv2.zzj().zzp().zza("Processed MeasurementBatch for sGTM with sgtmJoinId: ", (Object)(TextUtils.isEmpty((CharSequence)object12) ? "null" : ((zzfy.zzj.zza)((Object)object6)).zzc()));
                            } else {
                                zznv2.zzj().zzp().zza("Processed MeasurementBatch for sGTM.");
                            }
                            zzj2 = (zzfy.zzj)((zzjt)object6.zzai());
                            if (!TextUtils.isEmpty((CharSequence)object3) && this.zze().zza(zzbh.zzcc)) {
                                zznw zznw3;
                                object7 = object3;
                                object = (zzfy.zzj)((zzjt)object10.zzai());
                                zznv2 = this;
                                zznv2.zzl().zzt();
                                zznv2.zzs();
                                object12 = zzfy.zzj.zzb();
                                zznv2.zzj().zzp().zza("Processing Google Signal, sgtmJoinId:", object7);
                                ((zzfy.zzj.zza)((Object)object12)).zza((String)object7);
                                for (zzfy.zzk zzk2 : ((zzfy.zzj)((Object)object)).zzf()) {
                                    ((zzfy.zzj.zza)((Object)object12)).zza(zzfy.zzk.zzw().zzj(zzk2.zzah()).zzg(zzk2.zzd()));
                                }
                                object2 = (Object)((zzfy.zzj)((zzjt)object12.zzai()));
                                object = string;
                                object7 = ((zzns)this.zzk).zzm().zzf((String)object);
                                if (!TextUtils.isEmpty((CharSequence)object7)) {
                                    object12 = Uri.parse((String)((String)zzbh.zzr.zza(null)));
                                    object6 = object12.buildUpon();
                                    object5 = object12.getAuthority();
                                    Object object11 = object7;
                                    object6.authority((String)object11 + "." + (String)object5);
                                    zznw3 = new zznw(object6.build().toString(), zznt.zzb);
                                } else {
                                    zznw3 = new zznw((String)zzbh.zzr.zza(null), zznt.zzb);
                                }
                                object8.add(Pair.create((Object)object2, (Object)zznw3));
                            }
                        }
                    }
                    object3 = null;
                    if (this.zzj().zza(2)) {
                        object3 = this.zzp().zza(zzj2);
                    }
                    this.zzp();
                    object2 = zzj2.zzca();
                    if (zzpb.zza() && this.zze().zza(zzbh.zzcf)) {
                        this.zza((List<Long>)object9);
                        this.zzj.zze.zza(l3);
                        String string2 = "?";
                        if (n4 > 0) {
                            string2 = ((zzfy.zzj.zza)((Object)object10)).zza(0).zzz();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", (Object)string2, (Object)((byte[])object2).length, object3);
                        this.zzv = true;
                        this.zzh().zza(string, zznw2, zzj2, new zznz(this, string, (List)object8));
                    } else {
                        try {
                            this.zza((List<Long>)object9);
                            this.zzj.zze.zza(l3);
                            String string3 = "?";
                            if (n4 > 0) {
                                string3 = ((zzfy.zzj.zza)((Object)object10)).zza(0).zzz();
                            }
                            this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", (Object)string3, (Object)((byte[])object2).length, object3);
                            this.zzv = true;
                            this.zzh().zza(string, new URL(zznw2.zzb()), (byte[])object2, zznw2.zzc(), new zzoc(this, string, (List)object8));
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzgo.zza((String)string), (Object)zznw2.zzb());
                        }
                    }
                }
            } else {
                zzg zzg2;
                this.zzab = -1L;
                zzal zzal2 = this.zzf();
                this.zze();
                String string4 = zzal2.zza(l3 - com.google.android.gms.measurement.internal.zzag.zzg());
                if (!TextUtils.isEmpty((CharSequence)string4) && (zzg2 = this.zzf().zze(string4)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @WorkerThread
    private final void zze(String string) {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            Object object = this.zzm.zzr().zzab();
            if (object == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (((Boolean)object).booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzac();
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzac();
                return;
            }
            if (!this.zzf().zzs(string)) {
                this.zzj().zzp().zza("Upload queue has no batches for appId", (Object)string);
                return;
            }
            object = this.zzf().zzj(string);
            if (object == null) {
                return;
            }
            zzfy.zzj zzj2 = ((zzoj)object).zzc();
            if (zzj2 == null) {
                return;
            }
            String string2 = this.zzp().zza(zzj2);
            byte[] byArray = zzj2.zzca();
            this.zzj().zzp().zza("Uploading data from upload queue. appId, uncompressed size, data", (Object)string, (Object)byArray.length, (Object)string2);
            if (zzpb.zza() && this.zze().zza(zzbh.zzcf)) {
                this.zzv = true;
                this.zzh().zza(string, ((zzoj)object).zzb(), zzj2, new zzob(this, string, (zzoj)object));
            } else {
                try {
                    this.zzv = true;
                    this.zzh().zza(string, new URL(((zzoj)object).zzd()), byArray, ((zzoj)object).zze(), new zzoe(this, string, (zzoj)object));
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzj().zzg().zza("Failed to parse URL. Not uploading MeasurementBatch. appId", zzgo.zza((String)string), (Object)((zzoj)object).zzd());
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzfy.zzh.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzos.zzg((String)zza2.zzf()) || zzos.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzos.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzos.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbf var1_1, zzo var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzoo.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzgo.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzl(var5_4) != false || this.zzi().zzn(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzos.zza((zzor)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zze(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbh.zzaa.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzgs.zza((zzbf)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = this.zze().zza(var5_4, zzbh.zzas, 10, 35);
        for (String var10_12 : new TreeSet<E>(var6_6.zzc.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzc.getParcelableArray(var10_12), var7_8);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzow.zza()) {
            this.zze().zza(zzbh.zzcd);
        }
        this.zzf().zzp();
        try {
            block77: {
                block78: {
                    block80: {
                        block84: {
                            block83: {
                                block81: {
                                    block82: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block80;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block81;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block82;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block83;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzgo.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block84;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbh.zzag) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzal();
                                    try {
                                        var45_33 = var41_32.zze().zza(zzbh.zzdl) != false ? "and name like '!_ltv!_%' escape '!'" : "and name like '_ltv_%' ";
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? " + var45_33 + "order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_34) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzgo.zza((String)var42_31), (Object)var44_34);
                                    }
                                    var33_29 = new zzop(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_35 = (Long)var33_29.zze;
                                    var33_29 = new zzop(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_35 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zzop)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzgo.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzos.zza((zzor)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_39 = zzos.zzh((String)var1_1.zza);
                    var12_40 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_41 = 1L + zzos.zza((zzbe)var1_1.zzb);
                    var15_42 = this.zzf().zza(this.zzx(), var5_4, var13_41, true, var11_39, false, var12_40, false, false, false);
                    v2 = var15_42.zzb;
                    this.zze();
                    var16_43 = v2 - com.google.android.gms.measurement.internal.zzag.zzh();
                    if (var16_43 > 0L) {
                        if (var16_43 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_42.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_39) {
                        v3 = var15_42.zza;
                        this.zze();
                        var16_43 = v3 - (long)((Integer)zzbh.zzm.zza(null)).intValue();
                        if (var16_43 > 0L) {
                            if (var16_43 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_42.zza);
                            }
                            this.zzq();
                            zzos.zza((zzor)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_40) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbh.zzl);
                        var16_43 = var15_42.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_43 > 0L) {
                            if (var16_43 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_42.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_44 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_44, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_44, "_dbg", (Object)1L);
                        this.zzq().zza(var18_44, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_45 /* !! */  = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_45 /* !! */ .zze instanceof Long) {
                        this.zzq().zza(var18_44, "_sno", var19_45 /* !! */ .zze);
                    }
                    if (this.zze().zza(zzbh.zzdj) && Objects.equals(var1_1.zzc, "am") && Objects.equals(var1_1.zza, "_ai") && (var19_45 /* !! */  = var18_44.get("value")) != null && var19_45 /* !! */  instanceof String) {
                        try {
                            var20_47 = Double.parseDouble((String)var19_45 /* !! */ );
                            var18_44.remove("value");
                            var18_44.putDouble("value", var20_47);
                        }
                        catch (NumberFormatException v4) {}
                    }
                    if ((var19_46 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzgo.zza((String)var5_4), (Object)var19_46);
                    }
                    var21_48 = new zzbc(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_44);
                    var22_49 = this.zzf().zzd(var5_4, var21_48.zzb);
                    if (var22_49 == null) {
                        if (this.zzf().zzc(var5_4) >= (long)this.zze().zza(var5_4) && var11_39) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzgo.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_48.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzos.zza((zzor)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_50 = new zzbb(var5_4, var21_48.zzb, 0L, 0L, var21_48.zzd, 0L, null, null, null, null);
                    } else {
                        var21_48 = var21_48.zza(this.zzm, var22_49.zzf);
                        var23_50 = var22_49.zza(var21_48.zzd);
                    }
                    this.zzf().zza(var23_50);
                    var27_17 = var2_2;
                    var26_18 = var21_48;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfy.zzk.zzw().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzv)) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzje.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zze());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzpn.zza() && var25_19.zze().zze(var27_17.zza, zzbh.zzch)) {
                        var25_19.zzq();
                        if (zzos.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzg() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_51 = var30_25;
                                var40_53 /* !! */  = zzfy.zzc.zza();
                                var40_53 /* !! */ .zzc((var37_51 & 1L) != 0L);
                                var40_53 /* !! */ .zze((var37_51 & 2L) != 0L);
                                var40_53 /* !! */ .zzf((var37_51 & 4L) != 0L);
                                var40_53 /* !! */ .zzg((var37_51 & 8L) != 0L);
                                var40_53 /* !! */ .zzb((var37_51 & 16L) != 0L);
                                var40_53 /* !! */ .zza((var37_51 & 32L) != 0L);
                                var40_53 /* !! */ .zzd((var37_51 & 64L) != 0L);
                                var28_14.zza((zzfy.zzc)((zzjt)var40_53 /* !! */ .zzai()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_54 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzje.zzb((String)var27_17.zzt))).zzg() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_54)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (!var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zze(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_36 = new Bundle();
                            if (var25_19.zze().zza(zzbh.zzcw)) {
                                var35_55 = var33_29.zzy();
                                if (var35_55 != null) {
                                    var34_36.putLong("_pfo", Math.max(0L, var35_55.longValue()));
                                }
                                if ((var36_27 = var33_29.zzz()) != null) {
                                    var34_36.putLong("_uwa", var36_27.longValue());
                                }
                            } else if (var25_19.zze().zza(zzbh.zzcv)) {
                                var35_56 = var25_19.zzf().zzb(var27_17.zza) - 1L;
                                var34_36.putLong("_pfo", Math.max(0L, var35_56));
                            }
                            var34_36.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_36);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v5 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v5.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzc()).zzs(var25_19.zzm.zzg().zzg());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zze(var27_17.zza)) == null) {
                        var32_24 = new zzg(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_54));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_54.zzg()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzg)var42_31, false, false);
                    }
                    if (var31_54.zzh() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzl(var27_17.zza);
                    for (var34_37 = 0; var34_37 < var33_29.size(); ++var34_37) {
                        var35_55 = zzfy.zzo.zze().zza(((zzop)var33_29.get((int)var34_37)).zzc).zzb(((zzop)var33_29.get((int)var34_37)).zzd);
                        var25_19.zzp().zza((zzfy.zzo.zza)var35_55, ((zzop)var33_29.get((int)var34_37)).zze);
                        var28_14.zza((zzfy.zzo.zza)var35_55);
                        if (!"_sid".equals(((zzop)var33_29.get((int)var34_37)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_38 = var25_19.zzf().zza((zzfy.zzk)((zzjt)var28_14.zzai()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzgo.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block77;
                    }
                    v6 = var25_19.zzf();
                    var38_57 = var26_18;
                    var37_52 = var25_19;
                    if (var38_57.zzf == null) ** GOTO lbl-1000
                    for (zzfy.zzc.zza var40_53 : var38_57.zzf) {
                        if (!"_r".equals((Object)var40_53 /* !! */ )) continue;
                        v7 = true;
                        break block78;
                    }
                    var39_59 = var37_52.zzi().zzc(var38_57.zza, var38_57.zzb);
                    var40_53 /* !! */  = var37_52.zzf().zza(var37_52.zzx(), var38_57.zza, false, false, false, false, false, false, false);
                    if (var39_59 && var40_53 /* !! */ .zze < (long)var37_52.zze().zzc(var38_57.zza)) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                }
                if (v6.zza((zzbc)var26_18, var34_38, v7)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzac();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzi(zzo zzo2) {
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zza(@Nullable String var1_1, long var2_2) {
        this.zzf().zzp();
        try {
            block173: {
                block177: {
                    block176: {
                        block171: {
                            var4_3 = new zza(null);
                            var34_4 = var4_3;
                            var32_6 = this.zzab;
                            var30_12 = var2_2;
                            var29_19 = var1_1;
                            var28_20 = this.zzf();
                            Preconditions.checkNotNull((Object)var34_4);
                            var28_20.zzt();
                            var28_20.zzal();
                            var35_21 = null;
                            try {
                                var36_27 /* !! */  = var28_20.e_();
                                if (TextUtils.isEmpty((CharSequence)var29_19)) {
                                    var38_33 = var32_6 != -1L ? new String[]{String.valueOf(var32_6), String.valueOf(var30_12)} : new String[]{String.valueOf(var30_12)};
                                    var47_35 = var32_6 != -1L ? "rowid <= ? and " : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var47_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block171;
                                    var29_19 = var35_21.getString(0);
                                    var37_36 = var35_21.getString(1);
                                    var35_21.close();
                                } else {
                                    var38_33 = var32_6 != -1L ? new String[]{var29_19, String.valueOf(var32_6)} : new String[]{var29_19};
                                    var47_35 = var32_6 != -1L ? " and rowid <= ?" : "";
                                    var35_21 = var36_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var47_35 + " order by rowid limit 1;", (String[])var38_33);
                                    if (!var35_21.moveToFirst()) break block171;
                                    var37_36 = var35_21.getString(0);
                                    var35_21.close();
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var29_19, var37_36}, null, null, "rowid", "2");
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzgo.zza((String)var29_19));
                                    break block171;
                                }
                                var38_33 = var35_21.getBlob(0);
                                try {
                                    var39_37 /* !! */  = (zzfy.zzk)((zzjt)zzoo.zza(zzfy.zzk.zzw(), (byte[])var38_33).zzai());
                                }
                                catch (IOException var40_38) {
                                    var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzgo.zza((String)var29_19), (Object)var40_38);
                                    if (var35_21 != null) {
                                        var35_21.close();
                                    }
                                    break block171;
                                }
                                if (var35_21.moveToNext()) {
                                    var28_20.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzgo.zza((String)var29_19));
                                }
                                var35_21.close();
                                var34_4.zza(var39_37 /* !! */ );
                                if (var32_6 != -1L) {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                                    var41_41 = new String[]{var29_19, var37_36, String.valueOf(var32_6)};
                                } else {
                                    var40_39 = "app_id = ? and metadata_fingerprint = ?";
                                    var41_41 = new String[]{var29_19, var37_36};
                                }
                                var35_21 = var36_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var40_39, var41_41, null, null, "rowid", null);
                                if (!var35_21.moveToFirst()) {
                                    var28_20.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzgo.zza((String)var29_19));
                                    break block171;
                                }
                                do {
                                    var42_42 = var35_21.getLong(0);
                                    var38_33 = var35_21.getBlob(3);
                                    try {
                                        var44_44 = zzoo.zza(zzfy.zzf.zze(), (byte[])var38_33);
                                    }
                                    catch (IOException var45_46) {
                                        var28_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzgo.zza((String)var29_19), (Object)var45_46);
                                        continue;
                                    }
                                    var44_44.zza(var35_21.getString(1)).zzb(var35_21.getLong(2));
                                    if (!var34_4.zza(var42_42, (zzfy.zzf)((zzjt)var44_44.zzai()))) break;
                                } while (var35_21.moveToNext());
                            }
                            catch (SQLiteException var36_28) {
                                var28_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzgo.zza((String)var29_19), (Object)var36_28);
                            }
                            finally {
                                if (var35_21 != null) {
                                    var35_21.close();
                                }
                            }
                        }
                        var28_20 = var4_3;
                        if (var28_20.zzc == null || var28_20.zzc.isEmpty() != false) break block173;
                        var5_49 = false;
                        var6_50 = ((zzfy.zzk.zza)var4_3.zza.zzcd()).zzl();
                        var7_51 = 0;
                        var8_52 = 0L;
                        var10_53 = null;
                        var11_54 = -1;
                        var12_55 = null;
                        var13_56 = -1;
                        for (var14_57 = 0; var14_57 < var4_3.zzc.size(); ++var14_57) {
                            block175: {
                                block174: {
                                    var15_58 = var5_49;
                                    var16_61 = (zzfy.zzf.zza)var4_3.zzc.get(var14_57).zzcd();
                                    if (this.zzi().zzd(var4_3.zza.zzz(), var16_61.zze())) {
                                        this.zzj().zzu().zza("Dropping blocked raw event. appId", zzgo.zza((String)var4_3.zza.zzz()), (Object)this.zzm.zzk().zza(var16_61.zze()));
                                        if (this.zzi().zzl(var4_3.zza.zzz()) != false || this.zzi().zzn(var4_3.zza.zzz()) != false || "_err".equals(var16_61.zze())) continue;
                                        this.zzq();
                                        zzos.zza((zzor)this.zzah, (String)var4_3.zza.zzz(), (int)11, (String)"_ev", (String)var16_61.zze(), (int)0);
                                        continue;
                                    }
                                    if (var16_61.zze().equals(zzji.zza((String)"_ai"))) {
                                        var16_61.zza("_ai");
                                        this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                        if (this.zzj().zza(5)) {
                                            for (var17_64 = 0; var17_64 < var16_61.zza(); ++var17_64) {
                                                if (!"ad_platform".equals(var16_61.zzb(var17_64).zzg()) || var16_61.zzb(var17_64).zzh().isEmpty() || !"admob".equalsIgnoreCase(var16_61.zzb(var17_64).zzh())) continue;
                                                this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                            }
                                        }
                                    }
                                    if ((var17_64 = this.zzi().zzc(var4_3.zza.zzz(), var16_61.zze())) != 0) break block174;
                                    this.zzp();
                                    var28_20 = var16_61.zze();
                                    Preconditions.checkNotEmpty((String)var28_20);
                                    var30_13 = var28_20;
                                    var31_97 = -1;
                                    switch (var30_13.hashCode()) {
                                        case 95027: {
                                            if (!var30_13.equals("_ui")) break;
                                            var31_97 = 0;
                                        }
                                    }
                                    switch (var31_97) {
                                        case 0: {
                                            v0 = true;
                                            break;
                                        }
                                        default: {
                                            v0 = false;
                                        }
                                    }
                                    if (!v0) break block175;
                                }
                                var18_70 = false;
                                var19_76 = 0;
                                for (var20_80 = 0; var20_80 < var16_61.zza(); ++var20_80) {
                                    if ("_c".equals(var16_61.zzb(var20_80).zzg())) {
                                        var21_84 /* !! */  = (zzfy.zzh)((zzjt)((zzfy.zzh.zza)var16_61.zzb(var20_80).zzcd()).zza(1L).zzai());
                                        var18_70 = true;
                                        var16_61.zza(var20_80, var21_84 /* !! */ );
                                        continue;
                                    }
                                    if (!"_r".equals(var16_61.zzb(var20_80).zzg())) continue;
                                    var21_84 /* !! */  = (zzfy.zzh)((zzjt)((zzfy.zzh.zza)var16_61.zzb(var20_80).zzcd()).zza(1L).zzai());
                                    var19_76 = 1;
                                    var16_61.zza(var20_80, var21_84 /* !! */ );
                                }
                                if (!var18_70 && var17_64 != 0) {
                                    this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfy.zzh.zze().zza("_c").zza(1L));
                                }
                                if (var19_76 == 0) {
                                    this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var16_61.zze()));
                                    var16_61.zza(zzfy.zzh.zze().zza("_r").zza(1L));
                                }
                                var5_49 = true;
                                if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzz())) {
                                    zznv.zza((zzfy.zzf.zza)var16_61, "_r");
                                    var5_49 = var15_58;
                                }
                                if (zzos.zzh((String)var16_61.zze()) && var17_64 != 0 && this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzz(), zzbh.zzn)) {
                                    this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzgo.zza((String)var4_3.zza.zzz()));
                                    var22_87 = false;
                                    var23_90 /* !! */  = null;
                                    var24_91 = -1;
                                    for (var25_94 = 0; var25_94 < var16_61.zza(); ++var25_94) {
                                        var26_96 = var16_61.zzb(var25_94);
                                        if ("_c".equals(var26_96.zzg())) {
                                            var23_90 /* !! */  = (zzfy.zzh.zza)var26_96.zzcd();
                                            var24_91 = var25_94;
                                            continue;
                                        }
                                        if (!"_err".equals(var26_96.zzg())) continue;
                                        var22_87 = true;
                                    }
                                    if (var22_87 && var23_90 /* !! */  != null) {
                                        var16_61.zza(var24_91);
                                    } else if (var23_90 /* !! */  != null) {
                                        var25_95 = (zzfy.zzh)((zzjt)((zzfy.zzh.zza)((zzjt.zzb)var23_90 /* !! */ .clone())).zza("_err").zza(10L).zzai());
                                        var16_61.zza(var24_91, var25_95);
                                    } else {
                                        this.zzj().zzg().zza("Did not find conversion parameter. appId", zzgo.zza((String)var4_3.zza.zzz()));
                                    }
                                }
                            }
                            if (var17_64 != 0) {
                                var29_19 = var16_61;
                                var28_20 = this;
                                var30_13 = new ArrayList<zzfy.zzh>(var29_19.zzf());
                                var31_97 = -1;
                                var32_7 = -1;
                                for (var33_102 = 0; var33_102 < var30_13.size(); ++var33_102) {
                                    if ("value".equals(((zzfy.zzh)var30_13.get(var33_102)).zzg())) {
                                        var31_97 = var33_102;
                                        continue;
                                    }
                                    if (!"currency".equals(((zzfy.zzh)var30_13.get(var33_102)).zzg())) continue;
                                    var32_7 = var33_102;
                                }
                                if (var31_97 != -1) {
                                    if (!((zzfy.zzh)var30_13.get(var31_97)).zzl() && !((zzfy.zzh)var30_13.get(var31_97)).zzj()) {
                                        var28_20.zzj().zzv().zza("Value must be specified with a numeric type.");
                                        var29_19.zza(var31_97);
                                        zznv.zza((zzfy.zzf.zza)var29_19, "_c");
                                        zznv.zza((zzfy.zzf.zza)var29_19, 18, "value");
                                    } else {
                                        var33_102 = 0;
                                        if (var32_7 == -1) {
                                            var33_102 = 1;
                                        } else {
                                            var34_4 = ((zzfy.zzh)var30_13.get(var32_7)).zzh();
                                            if (var34_4.length() != 3) {
                                                var33_102 = 1;
                                            } else {
                                                for (var35_22 = 0; var35_22 < var34_4.length(); var35_22 += Character.charCount(var36_29)) {
                                                    var36_29 = var34_4.codePointAt(var35_22);
                                                    if (Character.isLetter(var36_29)) continue;
                                                    var33_102 = 1;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var33_102 != 0) {
                                            var28_20.zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                            var29_19.zza(var31_97);
                                            zznv.zza((zzfy.zzf.zza)var29_19, "_c");
                                            zznv.zza((zzfy.zzf.zza)var29_19, 19, "currency");
                                        }
                                    }
                                }
                            }
                            if ("_e".equals(var16_61.zze())) {
                                this.zzp();
                                if (zzoo.zza((zzfy.zzf)((zzjt)var16_61.zzai()), "_fr") == null) {
                                    if (var12_55 != null && Math.abs(var12_55.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_71 = (zzfy.zzf.zza)((zzjt.zzb)var12_55.clone());
                                        if (this.zza((zzfy.zzf.zza)var16_61, var18_71)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var13_56, var18_71);
                                        } else {
                                            var10_53 = var16_61;
                                            var11_54 = var7_51;
                                        }
                                    } else {
                                        var10_53 = var16_61;
                                        var11_54 = var7_51;
                                    }
                                }
                            } else if ("_vs".equals(var16_61.zze())) {
                                this.zzp();
                                if (zzoo.zza((zzfy.zzf)((zzjt)var16_61.zzai()), "_et") == null) {
                                    if (var10_53 != null && Math.abs(var10_53.zzc() - var16_61.zzc()) <= 1000L) {
                                        var18_72 = (zzfy.zzf.zza)((zzjt.zzb)var10_53.clone());
                                        if (this.zza(var18_72, (zzfy.zzf.zza)var16_61)) {
                                            var10_53 = null;
                                            var12_55 = null;
                                            var6_50.zza(var11_54, var18_72);
                                        } else {
                                            var12_55 = var16_61;
                                            var13_56 = var7_51;
                                        }
                                    } else {
                                        var12_55 = var16_61;
                                        var13_56 = var7_51;
                                    }
                                }
                            }
                            if (var16_61.zza() != 0) {
                                this.zzp();
                                var18_73 = zzoo.zza(var16_61.zzf());
                                for (var19_76 = 0; var19_76 < var16_61.zza(); ++var19_76) {
                                    var20_81 = var16_61.zzb(var19_76);
                                    if (var20_81.zzg().equals("items") && !var20_81.zzi().isEmpty()) {
                                        var32_8 = var18_73;
                                        var31_98 = var4_3.zza.zzz();
                                        var30_14 = var16_61;
                                        var29_19 = var20_81;
                                        var28_20 = this;
                                        var33_103 = var29_19.zzi();
                                        var34_4 = new Bundle[var33_103.size()];
                                        for (var35_23 = 0; var35_23 < var33_103.size(); ++var35_23) {
                                            var36_30 = var33_103.get(var35_23);
                                            var28_20.zzp();
                                            var37_36 = zzoo.zza(var36_30.zzi());
                                            for (zzfy.zzk var39_37 : var36_30.zzi()) {
                                                super.zza(var30_14.zze(), (zzfy.zzh.zza)var39_37 /* !! */ .zzcd(), (Bundle)var37_36, var31_98);
                                            }
                                            var34_4[var35_23] = var37_36;
                                        }
                                        var32_8.putParcelableArray("items", (Parcelable[])var34_4);
                                        continue;
                                    }
                                    if (var20_81.zzg().equals("items")) continue;
                                    this.zza(var16_61.zze(), (zzfy.zzh.zza)var20_81.zzcd(), var18_73, var4_3.zza.zzz());
                                }
                                var30_14 = var16_61;
                                var29_19 = var18_73;
                                var28_20 = this;
                                var30_14.zzd();
                                var34_4 = var29_19;
                                var33_104 = var28_20.zzp();
                                var35_24 = new ArrayList<zzfy.zzh>();
                                for (String var37_36 : var34_4.keySet()) {
                                    var38_33 = zzfy.zzh.zze().zza(var37_36);
                                    var39_37 /* !! */  = var34_4.get(var37_36);
                                    if (var39_37 /* !! */  == null) continue;
                                    var33_104.zza((zzfy.zzh.zza)var38_33, (Object)var39_37 /* !! */ );
                                    var35_24.add((zzfy.zzh)((zzjt)var38_33.zzai()));
                                }
                                var51_106 = var35_24;
                                var52_107 = var51_106.size();
                                for (var53_108 = 0; var53_108 < var52_107; ++var53_108) {
                                    v1 = var51_106.get(var53_108);
                                    var32_9 = (zzfy.zzh)v1;
                                    var30_14.zza(var32_9);
                                }
                            }
                            var4_3.zzc.set(var14_57, (zzfy.zzf)((zzjt)var16_61.zzai()));
                            ++var7_51;
                            var6_50.zza((zzfy.zzf.zza)var16_61);
                        }
                        for (var14_57 = 0; var14_57 < var7_51; ++var14_57) {
                            var15_59 = var6_50.zza(var14_57);
                            if ("_e".equals(var15_59.zzg())) {
                                this.zzp();
                                if (zzoo.zza(var15_59, "_fr") != null) {
                                    var6_50.zzb(var14_57);
                                    --var7_51;
                                    --var14_57;
                                    continue;
                                }
                            }
                            this.zzp();
                            var16_61 = zzoo.zza(var15_59, "_et");
                            if (var16_61 == null || (var17_66 = var16_61.zzl() != false ? Long.valueOf(var16_61.zzd()) : null) == null || var17_66 <= 0L) continue;
                            var8_52 += var17_66.longValue();
                        }
                        this.zza(var6_50, var8_52, false);
                        var14_57 = 0;
                        for (zzle var16_61 : var6_50.zzaa()) {
                            if (!"_s".equals(var16_61.zzg())) continue;
                            var14_57 = 1;
                            break;
                        }
                        if (var14_57 != 0) {
                            this.zzf().zzh(var6_50.zzt(), "_se");
                        }
                        if (zzoo.zza(var6_50, "_sid") >= 0) {
                            this.zza(var6_50, var8_52, true);
                        } else {
                            var16_62 = zzoo.zza(var6_50, "_se");
                            if (var16_62 >= 0) {
                                var6_50.zzc(var16_62);
                                this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzgo.zza((String)var4_3.zza.zzz()));
                            }
                        }
                        var30_15 = var6_50;
                        var29_19 = var4_3.zza.zzz();
                        var28_20 = this;
                        var28_20.zzl().zzt();
                        var28_20.zzs();
                        var31_99 /* !! */  = var28_20.zzf().zze((String)var29_19);
                        if (var31_99 /* !! */  == null) {
                            var28_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzgo.zza((String)var29_19));
                        } else {
                            var28_20.zza(var31_99 /* !! */ , var30_15);
                        }
                        if (zzov.zza() && this.zze().zza(zzbh.zzcu)) {
                            var30_15 = var6_50;
                            var29_19 = var4_3.zza.zzz();
                            var28_20 = this;
                            var28_20.zzl().zzt();
                            var28_20.zzs();
                            var31_99 /* !! */  = var28_20.zzf().zze((String)var29_19);
                            if (var31_99 /* !! */  == null) {
                                var28_20.zzj().zzu().zza("Cannot populate ad_campaign_info without appInfo. appId", zzgo.zza((String)var29_19));
                            } else {
                                var28_20.zzb(var31_99 /* !! */ , var30_15);
                            }
                        }
                        var28_20 = var6_50;
                        var28_20.zzi(0x7FFFFFFFFFFFFFFFL).zze(-9223372036854775808L);
                        for (var30_16 = 0; var30_16 < var28_20.zzc(); ++var30_16) {
                            var31_99 /* !! */  = var28_20.zza(var30_16);
                            if (var31_99 /* !! */ .zzd() < var28_20.zzf()) {
                                var28_20.zzi(var31_99 /* !! */ .zzd());
                            }
                            if (var31_99 /* !! */ .zzd() <= var28_20.zze()) continue;
                            var28_20.zze(var31_99 /* !! */ .zzd());
                        }
                        var6_50.zzs();
                        var16_63 = zzje.zza;
                        if (com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcy)) {
                            var16_63 = this.zzb(var4_3.zza.zzz()).zza(zzje.zzb((String)var4_3.zza.zzae()));
                            var17_67 = this.zzf().zzh(var4_3.zza.zzz());
                            this.zzf().zza(var4_3.zza.zzz(), var16_63);
                            if (!var16_63.zzh() && var17_67.zzh()) {
                                this.zzf().zzq(var4_3.zza.zzz());
                            } else if (var16_63.zzh() && !var17_67.zzh()) {
                                this.zzf().zzr(var4_3.zza.zzz());
                            }
                            var29_19 = var16_63;
                            var28_20 = var6_50;
                            if (!var29_19.zzg()) {
                                var28_20.zzq();
                                var28_20.zzn();
                                var28_20.zzk();
                            }
                            if (!var29_19.zzh()) {
                                var28_20.zzh();
                                var28_20.zzr();
                            }
                        }
                        if (zzpn.zza() && this.zze().zze(var4_3.zza.zzz(), zzbh.zzch)) {
                            this.zzq();
                            ** if (!zzos.zzd((String)var4_3.zza.zzz()) || !this.zzb((String)var4_3.zza.zzz()).zzg() || !var4_3.zza.zzat()) goto lbl463
                            for (var17_68 = 0; var17_68 < var6_50.zzc(); ++var17_68) {
                                var18_74 = (zzfy.zzf.zza)var6_50.zza(var17_68).zzcd();
                                var19_76 = 0;
                                for (zzfy.zzh var21_84 : var18_74.zzf()) {
                                    if (!"_c".equals(var21_84 /* !! */ .zzg())) continue;
                                    var19_76 = 1;
                                    break;
                                }
                                if (var19_76 == 0) continue;
                                if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzz(), zzbh.zzax)) {
                                    var20_83 = this.zze().zzb(var4_3.zza.zzz(), zzbh.zzbi);
                                    if (var20_83 > 0) {
                                        if (this.zzf().zza((long)this.zzx(), (String)var4_3.zza.zzz(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzg > (long)var20_83) {
                                            var22_89 /* !! */  = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_tnr").zza(1L).zzai());
                                            var18_74.zza(var22_89 /* !! */ );
                                        } else {
                                            var22_89 /* !! */  = null;
                                            if (this.zze().zze(var4_3.zza.zzz(), zzbh.zzcj)) {
                                                var22_89 /* !! */  = this.zzq().zzp();
                                                var23_90 /* !! */  = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_tu").zzb((String)var22_89 /* !! */ ).zzai());
                                                var18_74.zza((zzfy.zzh)var23_90 /* !! */ );
                                            }
                                            var23_90 /* !! */  = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_tr").zza(1L).zzai());
                                            var18_74.zza((zzfy.zzh)var23_90 /* !! */ );
                                            var24_93 = this.zzp().zza(var4_3.zza.zzz(), var6_50, var18_74, (String)var22_89 /* !! */ );
                                            if (var24_93 != null) {
                                                this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzz(), (Object)var24_93.zza);
                                                this.zzf().zza(var4_3.zza.zzz(), var24_93);
                                                this.zzr.add(var4_3.zza.zzz());
                                            }
                                        }
                                    } else {
                                        var21_84 /* !! */  = null;
                                        if (this.zze().zze(var4_3.zza.zzz(), zzbh.zzcj)) {
                                            var21_84 /* !! */  = this.zzq().zzp();
                                            var22_89 /* !! */  = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_tu").zzb((String)var21_84 /* !! */ ).zzai());
                                            var18_74.zza(var22_89 /* !! */ );
                                        }
                                        var22_89 /* !! */  = (zzfy.zzh)((zzjt)zzfy.zzh.zze().zza("_tr").zza(1L).zzai());
                                        var18_74.zza(var22_89 /* !! */ );
                                        var23_90 /* !! */  = this.zzp().zza(var4_3.zza.zzz(), var6_50, var18_74, (String)var21_84 /* !! */ );
                                        if (var23_90 /* !! */  != null) {
                                            this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzz(), (Object)var23_90 /* !! */ .zza);
                                            this.zzf().zza(var4_3.zza.zzz(), (zzno)var23_90 /* !! */ );
                                            this.zzr.add(var4_3.zza.zzz());
                                        }
                                    }
                                }
                                var6_50.zza(var17_68, (zzfy.zzf)((zzjt)var18_74.zzai()));
lbl-1000:
                                // 2 sources

                                {
                                    continue;
                                }
                            }
                        }
lbl463:
                        // 4 sources

                        if (com.google.android.gms.internal.measurement.zznm.zza() && this.zze().zza(zzbh.zzcy)) {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze(), var16_63.zzh() == false));
                        } else {
                            var6_50.zzi().zza(this.zzc().zza(var6_50.zzt(), var6_50.zzaa(), var6_50.zzab(), var6_50.zzf(), var6_50.zze()));
                        }
                        if (this.zze().zzk(var4_3.zza.zzz())) {
                            var30_17 = var4_3;
                            var29_19 = var6_50;
                            var28_20 = this;
                            var31_99 /* !! */  = new HashMap<K, V>();
                            var32_10 = new ArrayList<zzfy.zzf>();
                            var33_105 = var28_20.zzq().zzv();
                            for (var34_5 = 0; var34_5 < var29_19.zzc(); ++var34_5) {
                                block172: {
                                    var35_25 = (zzfy.zzf.zza)var29_19.zza(var34_5).zzcd();
                                    if (var35_25.zze().equals("_ep")) {
                                        var28_20.zzp();
                                        var36_27 /* !! */  = (String)zzoo.zzb((zzfy.zzf)((zzjt)var35_25.zzai()), "_en");
                                        var37_36 = (zzbb)var31_99 /* !! */ .get(var36_27 /* !! */ );
                                        if (var37_36 == null && (var37_36 = var28_20.zzf().zzd(var30_17.zza.zzz(), (String)Preconditions.checkNotNull((Object)var36_27 /* !! */ ))) != null) {
                                            var31_99 /* !! */ .put(var36_27 /* !! */ , var37_36);
                                        }
                                        if (var37_36 != null && var37_36.zzi == null) {
                                            if (var37_36.zzj != null && var37_36.zzj > 1L) {
                                                var28_20.zzp();
                                                zzoo.zza(var35_25, "_sr", (Object)var37_36.zzj);
                                            }
                                            if (var37_36.zzk != null && var37_36.zzk.booleanValue()) {
                                                var28_20.zzp();
                                                zzoo.zza(var35_25, "_efs", (Object)1L);
                                            }
                                            var32_10.add((zzfy.zzf)((zzjt)var35_25.zzai()));
                                        }
                                        var29_19.zza(var34_5, var35_25);
                                        continue;
                                    }
                                    var36_32 = var28_20.zzi().zza(var30_17.zza.zzz());
                                    var28_20.zzq();
                                    var38_34 = zzos.zza((long)var35_25.zzc(), (long)var36_32);
                                    var40_40 = 1;
                                    var48_110 = 1L;
                                    var47_35 = "_dbg";
                                    var46_48 = (zzfy.zzf)((zzjt)var35_25.zzai());
                                    if (TextUtils.isEmpty((CharSequence)var47_35) || var48_110 == null) {
                                        v2 = false;
                                    } else {
                                        for (zzfy.zzh var50_112 : var46_48.zzh()) {
                                            if (!var47_35.equals(var50_112.zzg())) continue;
                                            v2 = var48_110 instanceof Long != false && var48_110.equals(var50_112.zzd()) != false || var48_110 instanceof String != false && var48_110.equals(var50_112.zzh()) != false || var48_110 instanceof Double && var48_110.equals(var50_112.zza());
                                            break block172;
                                        }
                                        v2 = false;
                                    }
                                }
                                if (!v2) {
                                    var40_40 = var28_20.zzi().zzb(var30_17.zza.zzz(), var35_25.zze());
                                }
                                if (var40_40 <= 0) {
                                    var28_20.zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)var35_25.zze(), (Object)var40_40);
                                    var32_10.add((zzfy.zzf)((zzjt)var35_25.zzai()));
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                var41_41 = (String[])var31_99 /* !! */ .get(var35_25.zze());
                                if (var41_41 == null && (var41_41 = var28_20.zzf().zzd(var30_17.zza.zzz(), var35_25.zze())) == null) {
                                    var28_20.zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var30_17.zza.zzz(), (Object)var35_25.zze());
                                    var41_41 = new zzbb(var30_17.zza.zzz(), var35_25.zze(), 1L, 1L, 1L, var35_25.zzc(), 0L, null, null, null, null);
                                }
                                var28_20.zzp();
                                var42_43 = (Long)zzoo.zzb((zzfy.zzf)((zzjt)var35_25.zzai()), "_eid");
                                var43_109 = var42_43 != null;
                                if (var40_40 == 1) {
                                    var32_10.add((zzfy.zzf)((zzjt)var35_25.zzai()));
                                    if (var43_109.booleanValue() && (var41_41.zzi != null || var41_41.zzj != null || var41_41.zzk != null)) {
                                        var41_41 = var41_41.zza(null, null, null);
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41);
                                    }
                                    var29_19.zza(var34_5, var35_25);
                                    continue;
                                }
                                if (var33_105.nextInt(var40_40) == 0) {
                                    var28_20.zzp();
                                    zzoo.zza(var35_25, "_sr", (Object)var40_40);
                                    var32_10.add((zzfy.zzf)((zzjt)var35_25.zzai()));
                                    if (var43_109.booleanValue()) {
                                        var41_41 = var41_41.zza(null, Long.valueOf(var40_40), null);
                                    }
                                    var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                } else {
                                    if (var41_41.zzh != null) {
                                        var44_45 = var41_41.zzh;
                                    } else {
                                        var28_20.zzq();
                                        var44_45 = zzos.zza((long)var35_25.zzb(), (long)var36_32);
                                    }
                                    if (var44_45 != var38_34) {
                                        var28_20.zzp();
                                        zzoo.zza(var35_25, "_efs", (Object)1L);
                                        var28_20.zzp();
                                        zzoo.zza(var35_25, "_sr", (Object)var40_40);
                                        var32_10.add((zzfy.zzf)((zzjt)var35_25.zzai()));
                                        if (var43_109.booleanValue()) {
                                            var41_41 = var41_41.zza(null, Long.valueOf(var40_40), Boolean.valueOf(true));
                                        }
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var35_25.zzc(), var38_34));
                                    } else if (var43_109.booleanValue()) {
                                        var31_99 /* !! */ .put(var35_25.zze(), var41_41.zza(var42_43, null, null));
                                    }
                                }
                                var29_19.zza(var34_5, var35_25);
                            }
                            if (var32_10.size() < var29_19.zzc()) {
                                var29_19.zzl().zzb(var32_10);
                            }
                            for (Map.Entry var35_26 : var31_99 /* !! */ .entrySet()) {
                                var28_20.zzf().zza((zzbb)var35_26.getValue());
                            }
                        }
                        var17_69 = var4_3.zza.zzz();
                        var18_75 = this.zzf().zze(var17_69);
                        if (var18_75 != null) break block176;
                        this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzgo.zza((String)var4_3.zza.zzz()));
                        break block177;
                    }
                    if (var6_50.zzc() <= 0) break block177;
                    var19_77 = var18_75.zzs();
                    if (var19_77 != 0L) {
                        var6_50.zzg(var19_77);
                    } else {
                        var6_50.zzo();
                    }
                    var21_85 = var18_75.zzu();
                    if (var21_85 == 0L) {
                        var21_85 = var19_77;
                    }
                    if (var21_85 != 0L) {
                        var6_50.zzh(var21_85);
                    } else {
                        var6_50.zzp();
                    }
                    if (!zzpu.zza() || !this.zze().zza(zzbh.zzbx)) ** GOTO lbl-1000
                    this.zzq();
                    if (zzos.zzf((String)var18_75.zzac())) {
                        var18_75.zza((long)var6_50.zzc());
                        var6_50.zzg((int)var18_75.zzr());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var18_75.zzap();
                    }
                    var6_50.zzf((int)var18_75.zzt());
                    var18_75.zzr(var6_50.zzf());
                    var18_75.zzp(var6_50.zze());
                    var23_90 /* !! */  = var18_75.zzab();
                    if (var23_90 /* !! */  != null) {
                        var6_50.zzn((String)var23_90 /* !! */ );
                    } else {
                        var6_50.zzm();
                    }
                    this.zzf().zza(var18_75, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var19_79 = this.zzi().zzc(var4_3.zza.zzz());
                    if (var19_79 == null || !var19_79.zzr()) {
                        if (var4_3.zza.zzaj().isEmpty()) {
                            var6_50.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzgo.zza((String)var4_3.zza.zzz()));
                        }
                    } else {
                        var6_50.zzb(var19_79.zzc());
                    }
                    this.zzf().zza((zzfy.zzk)((zzjt)var6_50.zzai()), var5_49);
                }
                var29_19 = var4_3.zzb;
                var28_20 = this.zzf();
                Preconditions.checkNotNull((Object)var29_19);
                var28_20.zzt();
                var28_20.zzal();
                var30_18 = new StringBuilder("rowid in (");
                for (var31_100 = 0; var31_100 < var29_19.size(); ++var31_100) {
                    if (var31_100 != 0) {
                        var30_18.append(",");
                    }
                    var30_18.append((Long)var29_19.get(var31_100));
                }
                var30_18.append(")");
                var32_11 = var28_20.e_().delete("raw_events", var30_18.toString(), null);
                if (var32_11 != var29_19.size()) {
                    var28_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var32_11, (Object)var29_19.size());
                }
                var29_19 = var17_69;
                var28_20 = this.zzf();
                var30_18 = var28_20.e_();
                try {
                    var30_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var29_19, var29_19});
                }
                catch (SQLiteException var31_101) {
                    var28_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzgo.zza((String)var29_19), (Object)var31_101);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzad() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzae() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzcf.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfy.zzf.zza zza2, zzfy.zzf.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfy.zzh zzh2 = zzoo.zza((zzfy.zzf)((zzjt)zza2.zzai()), "_sc");
        String string = zzh2 == null ? null : zzh2.zzh();
        this.zzp();
        zzfy.zzh zzh3 = zzoo.zza((zzfy.zzf)((zzjt)zza3.zzai()), "_pc");
        String string2 = zzh3 == null ? null : zzh3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfy.zzf.zza zza4 = zza3;
            zzfy.zzf.zza zza5 = zza2;
            zznv zznv2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zznv2.zzp();
            zzfy.zzh zzh4 = zzoo.zza((zzfy.zzf)((zzjt)zza5.zzai()), "_et");
            if (zzh4 != null && zzh4.zzl() && zzh4.zzd() > 0L) {
                long l = zzh4.zzd();
                zznv2.zzp();
                zzh4 = zzoo.zza((zzfy.zzf)((zzjt)zza4.zzai()), "_et");
                if (zzh4 != null && zzh4.zzd() > 0L) {
                    l += zzh4.zzd();
                }
                zznv2.zzp();
                zzoo.zza(zza4, "_et", (Object)l);
                zznv2.zzp();
                zzoo.zza(zza5, "_fr", (Object)1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zznv zznv2) {
            this(zznv2, zznv2.zzq().zzp());
        }

        /* synthetic */ zzb(zznv zznv2, zzoi zzoi2) {
            this(zznv2);
        }

        private zzb(zznv zznv2, String string) {
            this.zza = string;
            this.zzb = zznv2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zznv zznv2, String string, zzoi zzoi2) {
            this(zznv2, string);
        }
    }

    private final class zza
    implements zzas {
        zzfy.zzk zza;
        List<Long> zzb;
        List<zzfy.zzf> zzc;
        private long zzd;

        private static long zza(zzfy.zzf zzf2) {
            return zzf2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zzoi zzoi2) {
            this();
        }

        @Override
        public final void zza(zzfy.zzk zzk2) {
            Preconditions.checkNotNull((Object)((Object)zzk2));
            this.zza = zzk2;
        }

        @Override
        public final boolean zza(long l, zzfy.zzf zzf2) {
            Preconditions.checkNotNull((Object)((Object)zzf2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfy.zzf>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zznv$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zznv$zza.zza(zzf2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzf2.zzcb();
            zznv.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbh.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzf2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zznv.this.zze();
            return n < Math.max(1, (Integer)zzbh.zzj.zza(null));
        }
    }
}

