/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzlo;
import com.google.android.gms.internal.measurement.zzoy;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzoh;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzou;
import com.google.android.gms.measurement.internal.zzph;
import com.google.android.gms.measurement.internal.zzpi;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpm;
import com.google.android.gms.measurement.internal.zzpn;
import com.google.android.gms.measurement.internal.zzpo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class zzar
extends zzot {
    private static final String[] zzb = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    static final String[] zza = new String[]{"associated_row_id", "ALTER TABLE upload_queue ADD COLUMN associated_row_id INTEGER;"};
    private static final String[] zzc = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzd = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;", "config_last_modified_time", "ALTER TABLE apps ADD COLUMN config_last_modified_time TEXT;", "e_tag", "ALTER TABLE apps ADD COLUMN e_tag TEXT;", "session_stitching_token", "ALTER TABLE apps ADD COLUMN session_stitching_token TEXT;", "sgtm_upload_enabled", "ALTER TABLE apps ADD COLUMN sgtm_upload_enabled INTEGER;", "target_os_version", "ALTER TABLE apps ADD COLUMN target_os_version INTEGER;", "session_stitching_token_hash", "ALTER TABLE apps ADD COLUMN session_stitching_token_hash INTEGER;", "ad_services_version", "ALTER TABLE apps ADD COLUMN ad_services_version INTEGER;", "unmatched_first_open_without_ad_id", "ALTER TABLE apps ADD COLUMN unmatched_first_open_without_ad_id INTEGER;", "npa_metadata_value", "ALTER TABLE apps ADD COLUMN npa_metadata_value INTEGER;", "attribution_eligibility_status", "ALTER TABLE apps ADD COLUMN attribution_eligibility_status INTEGER;", "sgtm_preview_key", "ALTER TABLE apps ADD COLUMN sgtm_preview_key TEXT;", "dma_consent_state", "ALTER TABLE apps ADD COLUMN dma_consent_state INTEGER;", "daily_realtime_dcu_count", "ALTER TABLE apps ADD COLUMN daily_realtime_dcu_count INTEGER;", "bundle_delivery_index", "ALTER TABLE apps ADD COLUMN bundle_delivery_index INTEGER;", "serialized_npa_metadata", "ALTER TABLE apps ADD COLUMN serialized_npa_metadata TEXT;", "unmatched_pfo", "ALTER TABLE apps ADD COLUMN unmatched_pfo INTEGER;", "unmatched_uwa", "ALTER TABLE apps ADD COLUMN unmatched_uwa INTEGER;", "ad_campaign_info", "ALTER TABLE apps ADD COLUMN ad_campaign_info BLOB;", "daily_registered_triggers_count", "ALTER TABLE apps ADD COLUMN daily_registered_triggers_count INTEGER;", "client_upload_eligibility", "ALTER TABLE apps ADD COLUMN client_upload_eligibility INTEGER;"};
    private static final String[] zze = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzf = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzh = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzi = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzj = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private static final String[] zzk = new String[]{"consent_source", "ALTER TABLE consent_settings ADD COLUMN consent_source INTEGER;", "dma_consent_settings", "ALTER TABLE consent_settings ADD COLUMN dma_consent_settings TEXT;", "storage_consent_at_bundling", "ALTER TABLE consent_settings ADD COLUMN storage_consent_at_bundling TEXT;"};
    private static final String[] zzl = new String[]{"idempotent", "CREATE INDEX IF NOT EXISTS trigger_uris_index ON trigger_uris (app_id);"};
    private final zzaz zzm;
    private final zzoh zzn = new zzoh(this.zzb());

    private final int zzr(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        try {
            int n = this.zze().zzb(string, zzbn.zzv);
            if (n <= 0) {
                return 0;
            }
            return this.f_().delete("upload_queue", "rowid in (SELECT rowid FROM upload_queue WHERE app_id=? ORDER BY rowid DESC LIMIT -1 OFFSET ?)", new String[]{string, String.valueOf(n)});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting over the limit queued batches. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final int zza(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        try {
            return this.f_().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting conditional property", zzgo.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    static /* bridge */ /* synthetic */ long zza(zzar zzar2, String string, String[] stringArray, long l) {
        return zzar2.zza(string, stringArray, -1L);
    }

    public final long zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        try {
            SQLiteDatabase sQLiteDatabase = this.f_();
            int n = this.zze().zzb(string, zzbn.zzp);
            n = Math.min(1000000, n);
            String string2 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting over the limit events. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    public final long c_() {
        try (Cursor cursor = null;){
            cursor = this.f_().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final long zza(zzgf.zzk zzk2) throws IOException {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzk2);
        Preconditions.checkNotEmpty((String)zzk2.zzab());
        byte[] byArray = zzk2.zzce();
        long l = this.h_().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzk2.zzab());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.f_().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event metadata. appId", zzgo.zza((String)zzk2.zzab()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    @WorkerThread
    public final long zza(String string, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull zzgf.zzj zzj2, @NonNull String string2, @NonNull Map<String, String> map, zzlu zzlu2, @Nullable Long l) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzj2);
        Preconditions.checkNotEmpty((String)string);
        if (!this.zze().zza(zzbn.zzch)) {
            return -1L;
        }
        Object object = string;
        Object object2 = this;
        object2.zzv();
        object2.zzam();
        if (object2.zzab()) {
            long l2 = object2.zzo().zzb.zza();
            long l3 = object2.zzb().elapsedRealtime();
            if (Math.abs(l3 - l2) > zzai.zzo()) {
                int n;
                object2.zzo().zzb.zza(l3);
                zzar zzar2 = object2;
                zzar2.zzv();
                zzar2.zzam();
                if (zzar2.zzab() && (n = zzar2.f_().delete("upload_queue", zzar2.zzap(), new String[0])) > 0) {
                    zzar2.zzj().zzq().zza("Deleted stale MeasurementBatch rows from upload_queue. rowsDeleted", (Object)n);
                }
                if (object2.zze().zza(zzbn.zzcj)) {
                    object2.zzr((String)object);
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> contentValues2 : map.entrySet()) {
            String string3 = contentValues2.getValue();
            String string4 = contentValues2.getKey();
            arrayList.add(string4 + "=" + string3);
        }
        Object object3 = zzj2.zzce();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("measurement_batch", (byte[])object3);
        contentValues.put("upload_uri", string2);
        object = arrayList;
        object2 = "\r\n";
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList2 = (ArrayList)object;
        int n = arrayList2.size();
        int n2 = 0;
        if (n > 0) {
            ++n2;
            stringBuilder.append((CharSequence)arrayList2.get(0));
            while (n2 < n) {
                stringBuilder.append((CharSequence)object2);
                Object e = arrayList2.get(n2);
                ++n2;
                stringBuilder.append((CharSequence)e);
            }
        }
        contentValues.put("upload_headers", stringBuilder.toString());
        contentValues.put("upload_type", Integer.valueOf(zzlu2.zza()));
        contentValues.put("creation_timestamp", Long.valueOf(this.zzb().currentTimeMillis()));
        contentValues.put("retry_count", Integer.valueOf(0));
        if (l != null) {
            contentValues.put("associated_row_id", l);
        }
        try {
            long l2 = this.f_().insert("upload_queue", null, contentValues);
            if (l2 == -1L) {
                this.zzj().zzg().zza("Failed to insert MeasurementBatch (got -1) to upload_queue. appId", (Object)string);
            }
            return l2;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing MeasurementBatch to upload_queue. appId", (Object)string, (Object)sQLiteException);
            return -1L;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzb(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.f_();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            String string3 = string2;
            l = this.zza("select " + string3 + " from app2 where app_id=?", new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzj().zzg().zza("Failed to insert column (got -1). appId", zzgo.zza((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzj().zzg().zza("Failed to update column (got 0). appId", zzgo.zza((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error inserting column. appId", zzgo.zza((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long d_() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public final long e_() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    @WorkerThread
    private final long zzb(String string, String @Nullable [] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzj().zzg().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String @Nullable [] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.f_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase f_() {
        this.zzv();
        try {
            return this.zzm.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzr().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final @Nullable Bundle zzc(String string) {
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            zzgf.zzf zzf2;
            cursor = this.f_().rawQuery("select parameters from default_event_params where app_id=?", new String[]{string});
            if (!cursor.moveToFirst()) {
                this.zzj().zzq().zza("Default event parameters not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            try {
                zzf2 = (zzgf.zzf)((zzkg)zzpj.zza(zzgf.zzf.zze(), byArray).zzaj());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to retrieve default event parameters. appId", zzgo.zza((String)string), (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            this.h_();
            Bundle bundle = zzpj.zza(zzf2.zzh());
            return bundle;
        }
        return null;
    }

    public final @Nullable Pair<// Could not load outer class - annotation placement on inner may be incorrect
    zzgf.zzf, Long> zza(String string, Long l) {
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            zzgf.zzf zzf2;
            cursor = this.f_().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzq().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzf2 = (zzgf.zzf)((zzkg)zzpj.zza(zzgf.zzf.zze(), byArray).zzaj());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to merge main event. appId, eventId", zzgo.zza((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)zzf2, (Object)l2);
            return pair;
        }
        return null;
    }

    @WorkerThread
    public final @Nullable zzh zzd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events", "ga_app_id", "session_stitching_token", "sgtm_upload_enabled", "target_os_version", "session_stitching_token_hash", "ad_services_version", "unmatched_first_open_without_ad_id", "npa_metadata_value", "attribution_eligibility_status", "sgtm_preview_key", "dma_consent_state", "daily_realtime_dcu_count", "bundle_delivery_index", "serialized_npa_metadata", "unmatched_pfo", "unmatched_uwa", "ad_campaign_info", "client_upload_eligibility"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzh zzh2 = new zzh(this.zzg.zzk(), string);
            if (this.zzg.zzb(string).zza(zzjj.zza.zzb)) {
                zzh2.zzb(cursor.getString(0));
            }
            zzh2.zzf(cursor.getString(1));
            if (this.zzg.zzb(string).zza(zzjj.zza.zza)) {
                zzh2.zzh(cursor.getString(2));
            }
            zzh2.zzq(cursor.getLong(3));
            zzh2.zzr(cursor.getLong(4));
            zzh2.zzp(cursor.getLong(5));
            zzh2.zzd(cursor.getString(6));
            zzh2.zzc(cursor.getString(7));
            zzh2.zzn(cursor.getLong(8));
            zzh2.zzk(cursor.getLong(9));
            zzh2.zzb(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzh2.zzj(cursor.getLong(11));
            zzh2.zzh(cursor.getLong(12));
            zzh2.zzg(cursor.getLong(13));
            zzh2.zze(cursor.getLong(14));
            zzh2.zzd(cursor.getLong(15));
            zzh2.zzm(cursor.getLong(16));
            zzh2.zzb(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzh2.zze(cursor.getString(18));
            zzh2.zzf(cursor.getLong(19));
            zzh2.zzi(cursor.getLong(20));
            zzh2.zzg(cursor.getString(21));
            zzh2.zza(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzh2.zza(cursor.getString(24));
            zzh2.zzl(cursor.isNull(25) ? 0L : cursor.getLong(25));
            if (!cursor.isNull(26)) {
                zzh2.zza(Arrays.asList(cursor.getString(26).split(",", -1)));
            }
            if (this.zzg.zzb(string).zza(zzjj.zza.zzb)) {
                zzh2.zzj(cursor.getString(28));
            }
            zzh2.zzc(!cursor.isNull(29) && cursor.getInt(29) != 0);
            zzh2.zzo(cursor.getLong(39));
            zzh2.zzk(cursor.getString(36));
            zzh2.zzt(cursor.getLong(30));
            zzh2.zzs(cursor.getLong(31));
            if (zzoy.zza() && this.zze().zze(string, zzbn.zzcp)) {
                zzh2.zza(cursor.getInt(32));
                zzh2.zzc(cursor.getLong(35));
            }
            zzh2.zzd(!cursor.isNull(33) && cursor.getInt(33) != 0);
            zzh2.zza(cursor.isNull(34) ? null : Boolean.valueOf(cursor.getInt(34) != 0));
            zzh2.zzd(cursor.getInt(37));
            zzh2.zzc(cursor.getInt(38));
            zzh2.zzi(cursor.isNull(40) ? "" : (String)Preconditions.checkNotNull((Object)cursor.getString(40)));
            if (!cursor.isNull(41)) {
                zzh2.zza((Long)cursor.getLong(41));
            }
            if (!cursor.isNull(42)) {
                zzh2.zzb((Long)cursor.getLong(42));
            }
            zzh2.zza(cursor.getBlob(43));
            if (this.zze().zze(string, zzbn.zzcj) && !cursor.isNull(44)) {
                zzh2.zzb(cursor.getInt(44));
            }
            zzh2.zzao();
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app, expected one. appId", zzgo.zza((String)string));
            }
            zzh zzh3 = zzh2;
            return zzh3;
        }
    }

    @WorkerThread
    public final @Nullable zzag zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            if (string3 == null) {
                string3 = "";
            }
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzbl zzbl2 = (zzbl)this.h_().zza(cursor.getBlob(5), zzbl.CREATOR);
            long l2 = cursor.getLong(6);
            zzbl zzbl3 = (zzbl)this.h_().zza(cursor.getBlob(7), zzbl.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzbl zzbl4 = (zzbl)this.h_().zza(cursor.getBlob(10), zzbl.CREATOR);
            zzpm zzpm2 = new zzpm(string2, l3, object, string3);
            zzag zzag2 = new zzag(string, string3, zzpm2, l2, bl, string4, zzbl2, l, zzbl3, l4, zzbl4);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for conditional property, expected one", zzgo.zza((String)string), (Object)this.zzi().zzc(string2));
            }
            zzag zzag3 = zzag2;
            return zzag3;
        }
    }

    @WorkerThread
    public final @Nullable zzat zze(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().query("apps", new String[]{"remote_config", "config_last_modified_time", "e_tag"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            String string2 = cursor.getString(1);
            String string3 = cursor.getString(2);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app config, expected one. appId", zzgo.zza((String)string));
            }
            if (byArray == null) {
                return null;
            }
            zzat zzat2 = new zzat(byArray, string2, string3);
            return zzat2;
        }
    }

    @WorkerThread
    public final zzas zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return this.zza(l, string, 1L, false, false, bl3, false, bl5, bl6, bl7);
    }

    @WorkerThread
    public final zzas zza(long l, String string, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        String[] stringArray = new String[]{string};
        zzas zzas2 = new zzas();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.f_();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count", "daily_realtime_dcu_count", "daily_registered_triggers_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzj().zzr().zza("Not updating daily counts, app is not known. appId", zzgo.zza((String)string));
                zzas zzas3 = zzas2;
                return zzas3;
            }
            if (cursor.getLong(0) == l) {
                zzas2.zzb = cursor.getLong(1);
                zzas2.zza = cursor.getLong(2);
                zzas2.zzc = cursor.getLong(3);
                zzas2.zzd = cursor.getLong(4);
                zzas2.zze = cursor.getLong(5);
                zzas2.zzf = cursor.getLong(6);
                zzas2.zzg = cursor.getLong(7);
            }
            if (bl) {
                zzas2.zzb += l2;
            }
            if (bl2) {
                zzas2.zza += l2;
            }
            if (bl3) {
                zzas2.zzc += l2;
            }
            if (bl4) {
                zzas2.zzd += l2;
            }
            if (bl5) {
                zzas2.zze += l2;
            }
            if (bl6) {
                zzas2.zzf += l2;
            }
            if (bl7) {
                zzas2.zzg += l2;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzas2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzas2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzas2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzas2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzas2.zze));
            contentValues.put("daily_realtime_dcu_count", Long.valueOf(zzas2.zzf));
            contentValues.put("daily_registered_triggers_count", Long.valueOf(zzas2.zzg));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzas zzas4 = zzas2;
            return zzas4;
        }
    }

    public final zzbd zzf(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzv();
        this.zzam();
        return zzbd.zza((String)this.zza("select dma_consent_settings from consent_settings where app_id=? limit 1;", new String[]{string}, ""));
    }

    @WorkerThread
    public final @Nullable zzbh zzd(String string, String string2) {
        return this.zzc("events", string, string2);
    }

    @WorkerThread
    private final @Nullable zzbh zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotEmpty((String)string3);
        this.zzv();
        this.zzam();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling", "current_session_count"));
        try (Cursor cursor = null;){
            cursor = this.f_().query(string, arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            long l8 = cursor.isNull(8) ? 0L : cursor.getLong(8);
            zzbh zzbh2 = new zzbh(string2, string3, l, l2, l8, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for event aggregates, expected one. appId", zzgo.zza((String)string2));
            }
            zzbh zzbh3 = zzbh2;
            return zzbh3;
        }
    }

    static /* synthetic */ zzjj zza(Cursor cursor) {
        String string = cursor.getString(0);
        int n = cursor.getInt(1);
        return zzjj.zza((String)string, (int)n);
    }

    public final zzjj zzg(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzv();
        this.zzam();
        return zzjj.zzb((String)this.zza("select storage_consent_at_bundling from consent_settings where app_id=? limit 1;", new String[]{string}, ""));
    }

    public final zzjj zzh(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzv();
        this.zzam();
        zzjj zzjj2 = (zzjj)this.zza("select consent_state, consent_source from consent_settings where app_id=? limit 1;", new String[]{string}, new zzaq());
        if (zzjj2 == null) {
            return zzjj.zza;
        }
        return zzjj2;
    }

    static /* bridge */ /* synthetic */ zzoh zza(zzar zzar2) {
        return zzar2.zzn;
    }

    private final @Nullable zzpi zza(String string, long l, byte[] byArray, @Nullable String string2, @Nullable String string3, int n, int n2, long l2, long l3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzj().zzc().zza("Upload uri is null or empty. Destination is unknown. Dropping batch. ");
            return null;
        }
        try {
            HashMap<String, String> hashMap;
            zzlu zzlu2;
            zzlu zzlu3;
            zzgf.zzj.zzb zzb2;
            block9: {
                zzb2 = zzpj.zza(zzgf.zzj.zzb(), byArray);
                int n3 = n;
                for (zzlu zzlu4 : zzlu.values()) {
                    if (zzlu4.zza() != n3) continue;
                    zzlu3 = zzlu4;
                    break block9;
                }
                zzlu3 = zzlu2 = zzlu.zzf;
            }
            if (zzlu3 != zzlu.zzb && zzlu2 != zzlu.zze && n2 > 0) {
                hashMap = new ArrayList();
                Iterator iterator = zzb2.zzd().iterator();
                while (iterator.hasNext()) {
                    zzgf.zzk.zza zza2 = (zzgf.zzk.zza)((zzgf.zzk)iterator.next()).zzch();
                    zza2.zzi(n2);
                    hashMap.add((zzgf.zzk)((zzkg)zza2.zzaj()));
                }
                zzb2.zzb();
                zzb2.zza(hashMap);
            }
            hashMap = new HashMap();
            if (string3 != null) {
                for (String string4 : string3.split("\r\n")) {
                    if (string4.isEmpty()) break;
                    String[] stringArray = string4.split("=", 2);
                    if (stringArray.length != 2) {
                        this.zzj().zzg().zza("Invalid upload header: ", (Object)string4);
                        break;
                    }
                    String string5 = stringArray[0];
                    String string6 = stringArray[1];
                    hashMap.put(string5, string6);
                }
            }
            return new zzph().zzc(l).zza((zzgf.zzj)((zzkg)zzb2.zzaj())).zza(string2).zza(hashMap).zza(zzlu2).zzb(l2).zza(l3).zza();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to queued MeasurementBatch from upload_queue. appId", (Object)string, (Object)iOException);
            return null;
        }
    }

    @WorkerThread
    public final @Nullable zzpi zzi(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        if (!this.zze().zza(zzbn.zzch)) {
            return null;
        }
        if (this.zze().zza(zzbn.zzcj)) {
            List<zzpi> list = this.zza(string, zzop.zza((zzlu[])new zzlu[]{zzlu.zzb}), 1);
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        try (Cursor cursor = null;){
            String string2 = this.zzap();
            cursor = this.f_().query("upload_queue", new String[]{"rowId", "app_id", "measurement_batch", "upload_uri", "upload_headers", "upload_type", "retry_count", "creation_timestamp", "associated_row_id"}, "app_id=? AND NOT " + string2, new String[]{string}, null, null, "creation_timestamp ASC", "1");
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzpi zzpi2 = this.zza(string, cursor.getLong(0), cursor.getBlob(2), cursor.getString(3), cursor.getString(4), cursor.getInt(5), cursor.getInt(6), cursor.getLong(7), cursor.getLong(8));
            return zzpi2;
        }
    }

    @WorkerThread
    public final @Nullable zzpi zza(long l) {
        if (!this.zze().zza(zzbn.zzcj)) {
            return null;
        }
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().query("upload_queue", new String[]{"rowId", "app_id", "measurement_batch", "upload_uri", "upload_headers", "upload_type", "retry_count", "creation_timestamp", "associated_row_id"}, "rowId=?", new String[]{String.valueOf(l)}, null, null, null, "1");
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzpi zzpi2 = this.zza((String)Preconditions.checkNotNull((Object)cursor.getString(1)), l, cursor.getBlob(2), cursor.getString(3), cursor.getString(4), cursor.getInt(5), cursor.getInt(6), cursor.getLong(7), cursor.getLong(8));
            return zzpi2;
        }
    }

    @WorkerThread
    public final @Nullable zzpo zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            if (object == null) {
                return null;
            }
            String string3 = cursor.getString(2);
            zzpo zzpo2 = new zzpo(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for user property, expected one. appId", zzgo.zza((String)string));
            }
            zzpo zzpo3 = zzpo2;
            return zzpo3;
        }
    }

    @WorkerThread
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzgf.zzk zzb(String string, long l) {
        zzgf.zzk zzk2 = null;
        try (Cursor cursor = null;){
            cursor = this.f_().query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string, Long.toString(l)}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzj().zzg().zza("Raw event metadata record is missing. appId", zzgo.zza((String)string));
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            try {
                zzk2 = (zzgf.zzk)((zzkg)zzpj.zza(zzgf.zzk.zzx(), byArray).zzaj());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzgo.zza((String)string), (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            if (cursor.moveToNext()) {
                this.zzj().zzr().zza("Get multiple raw event metadata records, expected one. appId", zzgo.zza((String)string));
            }
            cursor.close();
        }
        return zzk2;
    }

    @VisibleForTesting
    @WorkerThread
    private final @Nullable Object zza(Cursor cursor, int n) {
        int n2 = cursor.getType(n);
        switch (n2) {
            case 0: {
                this.zzj().zzg().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzj().zzg().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzj().zzg().zza("Loaded invalid unknown value type, ignoring it", (Object)n2);
        return null;
    }

    @WorkerThread
    private final <T> @Nullable T zza(String string, String[] stringArray, zzaw<T> zzaw2) {
        try (Cursor cursor = null;){
            cursor = this.f_().rawQuery(string, stringArray);
            if (!cursor.moveToFirst()) {
                this.zzj().zzq().zza("No data found");
                return null;
            }
            T t = zzaw2.zza(cursor);
            return t;
        }
        return null;
    }

    private final String zzap() {
        String string;
        long l = this.zzb().currentTimeMillis();
        String string2 = String.format(Locale.US, "(upload_type = %d AND ABS(creation_timestamp - %d) > %d)", zzlu.zzb.zza(), l, (long)((Long)zzbn.zzan.zza(null)));
        String string3 = string = String.format(Locale.US, "(upload_type != %d AND ABS(creation_timestamp - %d) > %d)", zzlu.zzb.zza(), l, zzai.zzm());
        String string4 = string2;
        return "(" + string4 + " OR " + string3 + ")";
    }

    public final @Nullable String zzb(long l) {
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            cursor = this.f_().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzq().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final @Nullable String g_() {
        SQLiteDatabase sQLiteDatabase = this.f_();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @WorkerThread
    private final String zza(String string, String[] stringArray, String string2) {
        String string3;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.f_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    String string4 = cursor.getString(0);
                    return string4;
                }
                string3 = string2;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return string3;
    }

    private static String zzb(List<Integer> list) {
        if (list.isEmpty()) {
            return "";
        }
        return String.format(" AND (upload_type IN (%s))", TextUtils.join((CharSequence)", ", list));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    public final List<Pair<zzgf.zzk, Long>> zza(String var1_1, int var2_2, int var3_3) {
        this.zzv();
        this.zzam();
        Preconditions.checkArgument((boolean)(var2_2 > 0));
        Preconditions.checkArgument((boolean)(var3_3 > 0));
        Preconditions.checkNotEmpty((String)var1_1);
        var4_4 = null;
        try {
            var4_4 = this.f_().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{var1_1}, null, null, "rowid", String.valueOf(var2_2));
            if (!var4_4.moveToFirst()) {
                var6_5 = Collections.emptyList();
                return var6_5;
            }
            var6_6 = new ArrayList<Pair<zzgf.zzk, Long>>();
            var7_8 = 0;
            do {
                block18: {
                    var8_9 = var4_4.getLong(0);
                    try {
                        var11_12 /* !! */  = var4_4.getBlob(1);
                        var10_11 = this.h_().zzc(var11_12 /* !! */ );
                    }
                    catch (IOException var11_13) {
                        this.zzj().zzg().zza("Failed to unzip queued bundle. appId", zzgo.zza((String)var1_1), (Object)var11_13);
                        continue;
                    }
                    if (!var6_6.isEmpty() && var7_8 + var10_11.length > var3_3) break;
                    try {
                        var11_12 /* !! */  = (byte[])zzpj.zza(zzgf.zzk.zzx(), var10_11);
                    }
                    catch (IOException var12_14) {
                        this.zzj().zzg().zza("Failed to merge queued bundle. appId", zzgo.zza((String)var1_1), (Object)var12_14);
                        continue;
                    }
                    if (var6_6.isEmpty()) break block18;
                    var15_16 = (zzgf.zzk)((zzkg)var11_12 /* !! */ .zzaj());
                    var14_15 = (zzgf.zzk)((Pair)var6_6.get((int)0)).first;
                    if (!var14_15.zzag().equals(var15_16.zzag()) || !var14_15.zzaf().equals(var15_16.zzaf()) || var14_15.zzaw() != var15_16.zzaw() || !var14_15.zzah().equals(var15_16.zzah())) ** GOTO lbl-1000
                    var16_17 = -1L;
                    for (zzgf.zzp var19_20 : var14_15.zzau()) {
                        if (!"_npa".equals(var19_20.zzg())) continue;
                        var16_17 = var19_20.zzc();
                        break;
                    }
                    var18_18 = -1L;
                    for (zzgf.zzp var21_22 : var15_16.zzau()) {
                        if (!"_npa".equals(var21_22.zzg())) continue;
                        var18_18 = var21_22.zzc();
                        break;
                    }
                    if (var16_17 == var18_18) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) break;
                }
                if (!var4_4.isNull(2)) {
                    var11_12 /* !! */ .zzi(var4_4.getInt(2));
                }
                var7_8 += var10_11.length;
                var6_6.add((Pair<zzgf.zzk, Long>)Pair.create((Object)((zzgf.zzk)((zzkg)var11_12 /* !! */ .zzaj())), (Object)var8_9));
            } while (var4_4.moveToNext() && var7_8 <= var3_3);
            var8_10 = var6_6;
            return var8_10;
        }
        catch (SQLiteException var5_23) {
            this.zzj().zzg().zza("Error querying bundles. appId", zzgo.zza((String)var1_1), (Object)var5_23);
            var6_7 = Collections.emptyList();
            return var6_7;
        }
        finally {
            if (var4_4 != null) {
                var4_4.close();
            }
        }
    }

    @WorkerThread
    public final List<zzag> zza(String string, @Nullable String string2, @Nullable String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            String string4 = string3;
            arrayList.add(string4 + "*");
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzag> zza(String string, String[] stringArray) {
        this.zzv();
        this.zzam();
        ArrayList<zzag> arrayList = new ArrayList<zzag>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.f_().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzag> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzbl zzbl2 = (zzbl)this.h_().zza(cursor.getBlob(7), zzbl.CREATOR);
                long l2 = cursor.getLong(8);
                zzbl zzbl3 = (zzbl)this.h_().zza(cursor.getBlob(9), zzbl.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzbl zzbl4 = (zzbl)this.h_().zza(cursor.getBlob(12), zzbl.CREATOR);
                zzpm zzpm2 = new zzpm(string3, l3, object2, string2);
                zzag zzag2 = new zzag((String)object, string2, zzpm2, l2, bl, string4, zzbl2, l, zzbl3, l4, zzbl4);
                arrayList.add(zzag2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    public final List<zzog> zzj(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        ArrayList<zzog> arrayList = new ArrayList<zzog>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.f_().query("trigger_uris", new String[]{"trigger_uri", "timestamp_millis", "source"}, "app_id=?", new String[]{string}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                ArrayList<zzog> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if ((object = cursor.getString(0)) == null) {
                    object = "";
                }
                long l = cursor.getLong(1);
                int n = cursor.getInt(2);
                zzog zzog2 = new zzog((String)object, l, n);
                arrayList.add(zzog2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzpi> zza(String string, zzop zzop2, int n) {
        if (!this.zze().zza(zzbn.zzcj)) {
            return Collections.emptyList();
        }
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        try (Cursor cursor = null;){
            Object object;
            String string2 = this.zzap();
            String string3 = zzar.zzb(zzop2.zza);
            cursor = this.f_().query("upload_queue", new String[]{"rowId", "app_id", "measurement_batch", "upload_uri", "upload_headers", "upload_type", "retry_count", "creation_timestamp", "associated_row_id"}, "app_id=?" + string3 + " AND NOT " + string2, new String[]{string}, null, null, "creation_timestamp ASC", n > 0 ? String.valueOf(n) : null);
            ArrayList<zzpi> arrayList = new ArrayList<zzpi>();
            while (cursor.moveToNext()) {
                object = this.zza(string, cursor.getLong(0), cursor.getBlob(2), cursor.getString(3), cursor.getString(4), cursor.getInt(5), cursor.getInt(6), cursor.getLong(7), cursor.getLong(8));
                if (object == null) continue;
                arrayList.add((zzpi)object);
            }
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzpo> zzk(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        ArrayList<zzpo> arrayList = new ArrayList<zzpo>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.f_().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzpo> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzj().zzg().zza("Read invalid user property value, ignoring it. appId", zzgo.zza((String)string));
                    continue;
                }
                zzpo zzpo2 = new zzpo(string, string2, (String)object, l, object2);
                arrayList.add(zzpo2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzpo> zzb(String string, @Nullable String string2, @Nullable String string3) {
        Object object;
        Preconditions.checkNotEmpty((String)string);
        this.zzv();
        this.zzam();
        ArrayList<zzpo> arrayList = new ArrayList<zzpo>();
        try (Cursor cursor = null;){
            Object object2;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            object = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                ((StringBuilder)object).append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string4 = string3;
                arrayList2.add(string4 + "*");
                ((StringBuilder)object).append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.f_().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, ((StringBuilder)object).toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzpo> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object2 = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object3 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object3 == null) {
                    this.zzj().zzg().zza("(2)Read invalid user property value, ignoring it", zzgo.zza((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzpo zzpo2 = new zzpo(string, string2, (String)object2, l, object3);
                arrayList.add(zzpo2);
            } while (cursor.moveToNext());
            object2 = arrayList;
            return object2;
        }
    }

    final Map<Integer, zzgf.zzm> zzl(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, zzgf.zzm> map = Collections.emptyMap();
                return map;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzgf.zzm zzm2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzm2 = (zzgf.zzm)((zzkg)zzpj.zza(zzgf.zzm.zze(), byArray).zzaj());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter results. appId, audienceId, error", zzgo.zza((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzm2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    final Map<Integer, List<zzfw.zzb>> zzm(String string) {
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfw.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfw.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzfw.zzb)((zzkg)zzpj.zza(zzfw.zzb.zzc(), byArray).zzaj());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzgo.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!zzb2.zzk()) continue;
                int n = cursor.getInt(0);
                ArrayList<zzfw.zzb> arrayList = (ArrayList<zzfw.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfw.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzfw.zzb>> zzf(String string, String string2) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfw.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfw.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzfw.zzb)((zzkg)zzpj.zza(zzfw.zzb.zzc(), byArray).zzaj());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzgo.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfw.zzb> arrayList = (ArrayList<zzfw.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfw.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzfw.zze>> zzg(String string, String string2) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfw.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfw.zze zze2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zze2 = (zzfw.zze)((zzkg)zzpj.zza(zzfw.zze.zzc(), byArray).zzaj());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter", zzgo.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfw.zze> arrayList = (ArrayList<zzfw.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfw.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzn(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.f_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    zzar(zzou zzou2) {
        super(zzou2);
        String string = "google_app_measurement.db";
        this.zzm = new zzaz(this, this.zza(), string);
    }

    public final void zza(String string, @Nullable Long l, @Nullable String string2, Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        this.zzv();
        this.zzam();
        zzax zzax2 = this.zze().zza(zzbn.zzcz) && l != null ? new zzax(this, string, l) : new zzax(this, string);
        List<zzav> list = zzax2.zza();
        while (!list.isEmpty()) {
            for (zzav zzav2 : list) {
                zzgf.zzk zzk2;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzk2 = this.zzb(string, zzav2.zzb);
                    boolean bl = false;
                    if (zzk2 != null) {
                        Iterator iterator = zzk2.zzau().iterator();
                        while (iterator.hasNext()) {
                            if (!((zzgf.zzp)iterator.next()).zzg().equals(string2)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue;
                }
                zzgf.zzf zzf2 = zzav2.zzd;
                zzpj zzpj2 = this.h_();
                Bundle bundle2 = new Bundle();
                for (zzgf.zzh zzh2 : zzf2.zzh()) {
                    if (zzh2.zzj()) {
                        bundle2.putDouble(zzh2.zzg(), zzh2.zza());
                        continue;
                    }
                    if (zzh2.zzk()) {
                        bundle2.putFloat(zzh2.zzg(), zzh2.zzb());
                        continue;
                    }
                    if (zzh2.zzl()) {
                        bundle2.putLong(zzh2.zzg(), zzh2.zzd());
                        continue;
                    }
                    if (zzh2.zzn()) {
                        bundle2.putString(zzh2.zzg(), zzh2.zzh());
                        continue;
                    }
                    if (!zzh2.zzi().isEmpty()) {
                        bundle2.putParcelableArray(zzh2.zzg(), (Parcelable[])zzpj.zzb(zzh2.zzi()));
                        continue;
                    }
                    zzpj2.zzj().zzg().zza("Unexpected parameter type for parameter", (Object)zzh2);
                }
                String string3 = bundle2.getString("_o");
                bundle2.remove("_o");
                zzk2 = new zzgs(zzf2.zzg(), (String)(string3 == null ? "" : string3), bundle2, zzf2.zzd());
                this.zzs().zza(zzk2.zzc, bundle);
                zzbe zzbe2 = new zzbe(this.zzu, zzk2.zzb, string, zzav2.zzd.zzg(), zzav2.zzd.zzd(), zzav2.zzd.zzc(), zzk2.zzc);
                this.zza(zzav2.zza, zzbe2, zzav2.zzb, zzav2.zzc);
            }
            list = zzax2.zza();
        }
    }

    @WorkerThread
    public final void zzq() {
        this.zzam();
        this.f_().beginTransaction();
    }

    private final void zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        try {
            this.f_().delete(string, "app_id=?", new String[]{string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting snapshot. appId", zzgo.zza((String)string2), (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzo(String string) {
        String string2 = string;
        this.zzj("events_snapshot", string2);
        List<String> list = Collections.singletonList("name");
        Cursor cursor = null;
        try {
            cursor = this.f_().query("events", list.toArray(new String[0]), "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return;
            }
            do {
                zzbh zzbh2;
                String string3;
                if ((string3 = cursor.getString(0)) == null || (zzbh2 = this.zzd(string, string3)) == null) continue;
                string2 = zzbh2;
                this.zza("events_snapshot", (zzbh)string2);
            } while (cursor.moveToNext());
            if (cursor == null) return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error creating snapshot. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return;
        }
        finally {
            if (cursor == null) return;
            cursor.close();
        }
        cursor.close();
        return;
    }

    @WorkerThread
    public final void zza(Long l) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)l);
        if (!this.zze().zza(zzbn.zzch)) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.f_();
        String[] stringArray = new String[]{String.valueOf(l)};
        try {
            if (sQLiteDatabase.delete("upload_queue", "rowid=?", stringArray) != 1) {
                this.zzj().zzr().zza("Deleted fewer rows from upload_queue than expected");
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Failed to delete a MeasurementBatch in a upload_queue table", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final void zzr() {
        this.zzam();
        this.f_().endTransaction();
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzab()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = "(" + string + ")";
        if (this.zzb("SELECT COUNT(1) FROM queue WHERE rowid IN " + (string = string2) + " AND retry_count =  2147483647 LIMIT 1", (String[])null) > 0L) {
            this.zzj().zzr().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            string = string2;
            this.f_().execSQL("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN " + string + " AND (retry_count IS NULL OR retry_count < 2147483647)");
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zzb(Long l) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)l);
        if (!this.zze().zza(zzbn.zzch)) {
            return;
        }
        if (!this.zzab()) {
            return;
        }
        Long l2 = l;
        if (this.zzb("SELECT COUNT(1) FROM upload_queue WHERE rowid = " + l2 + " AND retry_count =  2147483647 LIMIT 1", (String[])null) > 0L) {
            this.zzj().zzr().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            l2 = l;
            this.f_().execSQL("UPDATE upload_queue SET retry_count = retry_count + 1 WHERE rowid = " + l2 + " AND retry_count < 2147483647");
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzv();
        this.zzam();
        if (!this.zzab()) {
            return;
        }
        long l = this.zzo().zza.zza();
        long l2 = this.zzb().elapsedRealtime();
        if (Math.abs(l2 - l) > zzai.zzo()) {
            this.zzo().zza.zza(l2);
            zzar zzar2 = this;
            zzar2.zzv();
            zzar2.zzam();
            if (zzar2.zzab()) {
                SQLiteDatabase sQLiteDatabase = zzar2.f_();
                String[] stringArray = new String[]{String.valueOf(zzar2.zzb().currentTimeMillis()), String.valueOf(zzai.zzm())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzar2.zzj().zzq().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzv();
        this.zzam();
        try {
            this.f_().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting user property. appId", zzgo.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzp(String string) {
        Cursor cursor;
        boolean bl;
        boolean bl2;
        String string2;
        zzbh zzbh2;
        zzbh zzbh3;
        block19: {
            block20: {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("name", "lifetime_count"));
                zzbh3 = this.zzd(string, "_f");
                zzbh2 = this.zzd(string, "_v");
                string2 = string;
                this.zzj("events", string2);
                bl2 = false;
                bl = false;
                cursor = null;
                try {
                    cursor = this.f_().query("events_snapshot", arrayList.toArray(new String[0]), "app_id=?", new String[]{string}, null, null, null);
                    if (!cursor.moveToFirst()) {
                        if (cursor == null) break block19;
                        break block20;
                    }
                    do {
                        String string3;
                        zzbh zzbh4;
                        String string4 = cursor.getString(0);
                        if (cursor.getLong(1) >= 1L) {
                            if ("_f".equals(string4)) {
                                bl2 = true;
                            } else if ("_v".equals(string4)) {
                                bl = true;
                            }
                        }
                        if (string4 == null || (zzbh4 = this.zzc("events_snapshot", string2 = string, string3 = string4)) == null) continue;
                        string2 = zzbh4;
                        this.zza("events", (zzbh)string2);
                    } while (cursor.moveToNext());
                    return;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Error querying snapshot. appId", zzgo.zza((String)string), (Object)sQLiteException);
                    return;
                }
            }
            cursor.close();
        }
        if (zzbh3 != null) {
            string2 = zzbh3;
            this.zza("events", (zzbh)string2);
        } else if (zzbh2 != null) {
            string2 = zzbh2;
            this.zza("events", (zzbh)string2);
        }
        string2 = string;
        this.zzj("events_snapshot", string2);
        return;
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (!bl2 && zzbh3 != null) {
                string2 = zzbh3;
                this.zza("events", (zzbh)string2);
            } else if (!bl && zzbh2 != null) {
                string2 = zzbh2;
                this.zza("events", (zzbh)string2);
            }
            string2 = string;
            this.zzj("events_snapshot", string2);
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    final void zza(String string, List<zzfw.zza> list) {
        Preconditions.checkNotNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            zzlo zzlo2;
            int n;
            zzfw.zza.zza zza2 = (zzfw.zza.zza)list.get(i).zzch();
            if (zza2.zza() != 0) {
                for (n = 0; n < zza2.zza(); ++n) {
                    zzlo2 = (zzfw.zzb.zza)zza2.zza(n).zzch();
                    object = (zzfw.zzb.zza)((zzkg.zza)zzlo2.clone());
                    boolean bl = false;
                    String string2 = zzjp.zzb((String)zzlo2.zzb());
                    if (string2 != null) {
                        ((zzfw.zzb.zza)((Object)object)).zza(string2);
                        bl = true;
                    }
                    for (int j = 0; j < zzlo2.zza(); ++j) {
                        zzfw.zzc zzc2 = zzlo2.zza(j);
                        String string3 = zzjo.zza((String)zzc2.zze());
                        if (string3 == null) continue;
                        zzfw.zzc zzc3 = (zzfw.zzc)((zzkg)((zzfw.zzc.zza)zzc2.zzch()).zza(string3).zzaj());
                        ((zzfw.zzb.zza)((Object)object)).zza(j, zzc3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zza2 = zza2.zza(n, (zzfw.zzb.zza)((Object)object));
                    list.set(i, (zzfw.zza)((zzkg)zza2.zzaj()));
                }
            }
            if (zza2.zzb() == 0) continue;
            for (n = 0; n < zza2.zzb(); ++n) {
                zzlo2 = zza2.zzb(n);
                object = zzjr.zza((String)zzlo2.zze());
                if (object == null) continue;
                zza2 = zza2.zza(n, ((zzfw.zze.zza)zzlo2.zzch()).zza((String)object));
                list.set(i, (zzfw.zza)((zzkg)zza2.zzaj()));
            }
        }
        List<zzfw.zza> list2 = list;
        String string4 = string;
        zzar zzar2 = this;
        zzar2.zzam();
        zzar2.zzv();
        Preconditions.checkNotEmpty((String)string4);
        Preconditions.checkNotNull(list2);
        SQLiteDatabase sQLiteDatabase = zzar2.f_();
        sQLiteDatabase.beginTransaction();
        try {
            String string5 = string4;
            zzar zzar3 = zzar2;
            zzar3.zzam();
            zzar3.zzv();
            Preconditions.checkNotEmpty((String)string5);
            Object object = zzar3.f_();
            object.delete("property_filters", "app_id=?", new String[]{string5});
            object.delete("event_filters", "app_id=?", new String[]{string5});
            Object object2 = list2.iterator();
            block7: while (object2.hasNext()) {
                Object object3;
                object = object3 = object2.next();
                string5 = string4;
                zzar3 = zzar2;
                zzar3.zzam();
                zzar3.zzv();
                Preconditions.checkNotEmpty((String)string5);
                Preconditions.checkNotNull((Object)object);
                if (!((zzfw.zza)((Object)object)).zzg()) {
                    zzar3.zzj().zzr().zza("Audience with no ID. appId", zzgo.zza((String)string5));
                    continue;
                }
                int n = ((zzfw.zza)((Object)object)).zza();
                Iterator<zzkg> iterator = ((zzfw.zza)((Object)object)).zze().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().zzl()) continue;
                    zzar3.zzj().zzr().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzgo.zza((String)string5), (Object)n);
                    continue block7;
                }
                iterator = ((zzfw.zza)((Object)object)).zzf().iterator();
                while (iterator.hasNext()) {
                    if (((zzfw.zze)iterator.next()).zzi()) continue;
                    zzar3.zzj().zzr().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzgo.zza((String)string5), (Object)n);
                    continue block7;
                }
                boolean bl = true;
                for (zzfw.zzb zzb2 : ((zzfw.zza)((Object)object)).zze()) {
                    if (zzar3.zza(string5, n, zzb2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (zzfw.zze zze2 : ((zzfw.zza)((Object)object)).zzf()) {
                        if (zzar3.zza(string5, n, zze2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n2 = n;
                String string2 = string5;
                zzar zzar4 = zzar3;
                zzar4.zzam();
                zzar4.zzv();
                Preconditions.checkNotEmpty((String)string2);
                SQLiteDatabase sQLiteDatabase2 = zzar4.f_();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
            }
            object2 = new ArrayList();
            for (zzfw.zza zza2 : list2) {
                object2.add(zza2.zzg() ? Integer.valueOf(zza2.zza()) : null);
            }
            zzar2.zzb(string4, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    public final void zzx() {
        this.zzam();
        this.f_().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zza(zzh zzh2, boolean bl, boolean bl2) {
        List<String> list;
        Preconditions.checkNotNull((Object)zzh2);
        this.zzv();
        this.zzam();
        String string = zzh2.zzac();
        Preconditions.checkNotNull((Object)string);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        if (bl) {
            contentValues.put("app_instance_id", null);
        } else if (this.zzg.zzb(string).zza(zzjj.zza.zzb)) {
            contentValues.put("app_instance_id", zzh2.zzad());
        }
        contentValues.put("gmp_app_id", zzh2.zzah());
        if (this.zzg.zzb(string).zza(zzjj.zza.zza)) {
            contentValues.put("resettable_device_id_hash", zzh2.zzaj());
        }
        contentValues.put("last_bundle_index", Long.valueOf(zzh2.zzt()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzh2.zzu()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzh2.zzs()));
        contentValues.put("app_version", zzh2.zzaf());
        contentValues.put("app_store", zzh2.zzae());
        contentValues.put("gmp_version", Long.valueOf(zzh2.zzq()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzh2.zzn()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzh2.zzar()));
        contentValues.put("day", Long.valueOf(zzh2.zzm()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzh2.zzk()));
        contentValues.put("daily_events_count", Long.valueOf(zzh2.zzj()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzh2.zzh()));
        contentValues.put("config_fetched_time", Long.valueOf(zzh2.zzg()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzh2.zzp()));
        contentValues.put("app_version_int", Long.valueOf(zzh2.zze()));
        contentValues.put("firebase_instance_id", zzh2.zzag());
        contentValues.put("daily_error_events_count", Long.valueOf(zzh2.zzi()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzh2.zzl()));
        contentValues.put("health_monitor_sample", zzh2.zzai());
        contentValues.put("android_id", Long.valueOf(0L));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzh2.zzaq()));
        contentValues.put("admob_app_id", zzh2.zzaa());
        contentValues.put("dynamite_version", Long.valueOf(zzh2.zzo()));
        if (this.zzg.zzb(string).zza(zzjj.zza.zzb)) {
            contentValues.put("session_stitching_token", zzh2.zzal());
        }
        contentValues.put("sgtm_upload_enabled", Boolean.valueOf(zzh2.zzat()));
        contentValues.put("target_os_version", Long.valueOf(zzh2.zzw()));
        contentValues.put("session_stitching_token_hash", Long.valueOf(zzh2.zzv()));
        if (zzoy.zza() && this.zze().zze(string, zzbn.zzcp)) {
            contentValues.put("ad_services_version", Integer.valueOf(zzh2.zza()));
            contentValues.put("attribution_eligibility_status", Long.valueOf(zzh2.zzf()));
        }
        contentValues.put("unmatched_first_open_without_ad_id", Boolean.valueOf(zzh2.zzau()));
        contentValues.put("npa_metadata_value", zzh2.zzx());
        contentValues.put("bundle_delivery_index", Long.valueOf(zzh2.zzr()));
        contentValues.put("sgtm_preview_key", zzh2.zzam());
        contentValues.put("dma_consent_state", Integer.valueOf(zzh2.zzd()));
        contentValues.put("daily_realtime_dcu_count", Integer.valueOf(zzh2.zzc()));
        contentValues.put("serialized_npa_metadata", zzh2.zzak());
        if (this.zze().zze(string, zzbn.zzcj)) {
            contentValues.put("client_upload_eligibility", Integer.valueOf(zzh2.zzb()));
        }
        if ((list = zzh2.zzan()) != null) {
            if (list.isEmpty()) {
                this.zzj().zzr().zza("Safelisted events should not be an empty list. appId", (Object)string);
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", list));
            }
        }
        if (com.google.android.gms.internal.measurement.zzog.zza() && this.zze().zza(zzbn.zzce) && !contentValues.containsKey("safelisted_events")) {
            contentValues.put("safelisted_events", null);
        }
        contentValues.put("unmatched_pfo", zzh2.zzy());
        contentValues.put("unmatched_uwa", zzh2.zzz());
        contentValues.put("ad_campaign_info", zzh2.zzav());
        try {
            SQLiteDatabase sQLiteDatabase = this.f_();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update app (got -1). appId", zzgo.zza((String)string));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing app. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzbd zzbd2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzbd2);
        this.zzv();
        this.zzam();
        if (this.zzh(string) == zzjj.zza) {
            this.zzb(string, zzjj.zza);
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("dma_consent_settings", zzbd2.zzf());
        this.zza("consent_settings", "app_id", contentValues);
    }

    @WorkerThread
    public final void zza(zzbh zzbh2) {
        this.zza("events", zzbh2);
    }

    @WorkerThread
    private final void zza(String string, zzbh zzbh2) {
        Preconditions.checkNotNull((Object)zzbh2);
        this.zzv();
        this.zzam();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzbh2.zza);
        contentValues.put("name", zzbh2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzbh2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzbh2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzbh2.zzf));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzbh2.zzg));
        contentValues.put("last_bundled_day", zzbh2.zzh);
        contentValues.put("last_sampled_complex_event_id", zzbh2.zzi);
        contentValues.put("last_sampling_rate", zzbh2.zzj);
        contentValues.put("current_session_count", Long.valueOf(zzbh2.zze));
        Long l = null;
        if (zzbh2.zzk != null && zzbh2.zzk.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.f_().insertWithOnConflict(string, null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update event aggregates (got -1). appId", zzgo.zza((String)zzbh2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event aggregates. appId", zzgo.zza((String)zzbh2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    private final void zza(String string, String string2, ContentValues contentValues) {
        try {
            SQLiteDatabase sQLiteDatabase = this.f_();
            String string3 = contentValues.getAsString(string2);
            if (string3 == null) {
                this.zzj().zzm().zza("Value of the primary key is not set.", zzgo.zza((String)string2));
                return;
            }
            String string4 = string2;
            if ((long)sQLiteDatabase.update(string, contentValues, string4 + " = ?", new String[]{string3}) == 0L && sQLiteDatabase.insertWithOnConflict(string, null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update table (got -1). key", zzgo.zza((String)string), zzgo.zza((String)string2));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing into table. key", zzgo.zza((String)string), zzgo.zza((String)string2), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzjj zzjj2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzjj2);
        this.zzv();
        this.zzam();
        this.zzb(string, this.zzh(string));
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("storage_consent_at_bundling", zzjj2.zzf());
        this.zza("consent_settings", "app_id", contentValues);
    }

    public final void zzb(String string, zzjj zzjj2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzjj2);
        this.zzv();
        this.zzam();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("consent_state", zzjj2.zzf());
        contentValues.put("consent_source", Integer.valueOf(zzjj2.zza()));
        this.zza("consent_settings", "app_id", contentValues);
    }

    private final boolean zzb(String string, List<@Nullable Integer> list) {
        String string2;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzam();
        this.zzv();
        SQLiteDatabase sQLiteDatabase = this.f_();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error querying filters. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        int n = this.zze().zzb(string, zzbn.zzap);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Integer n3 = list.get(i);
            if (n3 == null) {
                return false;
            }
            arrayList.add(Integer.toString(n3));
        }
        String string3 = TextUtils.join((CharSequence)",", arrayList);
        string3 = string2 = "(" + string3 + ")";
        return sQLiteDatabase.delete("audience_filter_values", "audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in " + string3 + " order by rowid desc limit -1 offset ?)", new String[]{string, Integer.toString(n2)}) > 0;
    }

    @WorkerThread
    public final boolean zzq(String string) {
        if (!this.zze().zza(zzbn.zzch)) {
            return false;
        }
        if (this.zze().zza(zzbn.zzcj)) {
            zzlu[] zzluArray = new zzlu[]{zzlu.zzb};
            String string2 = string;
            zzar zzar2 = this;
            zzlu[] zzluArray2 = zzluArray;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
            zzlu[] zzluArray3 = zzluArray2;
            for (int i = 0; i <= 0; ++i) {
                zzlu zzlu2 = zzluArray3[0];
                arrayList.add(zzlu2.zza());
            }
            String string3 = zzar2.zzap();
            String string4 = zzar.zzb(arrayList);
            return zzar2.zzb("SELECT COUNT(1) > 0 FROM upload_queue WHERE app_id=?" + string4 + " AND NOT " + string3, new String[]{string2}) != 0L;
        }
        String string5 = this.zzap();
        return this.zzb("SELECT COUNT(1) > 0 FROM upload_queue WHERE app_id=? AND NOT " + string5, new String[]{string}) != 0L;
    }

    public final boolean zzi(String string, String string2) {
        return this.zzb("select count(1) from raw_events where app_id = ? and name = ?", new String[]{string, string2}) > 0L;
    }

    public final boolean zzy() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzz() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    public final boolean zzaa() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final boolean zza(zzgf.zzk zzk2, boolean bl) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzk2);
        Preconditions.checkNotEmpty((String)zzk2.zzab());
        Preconditions.checkState((boolean)zzk2.zzbm());
        this.zzw();
        long l = this.zzb().currentTimeMillis();
        if (zzk2.zzn() < l - zzai.zzm() || zzk2.zzn() > l + zzai.zzm()) {
            this.zzj().zzr().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzgo.zza((String)zzk2.zzab()), (Object)l, (Object)zzk2.zzn());
        }
        byte[] byArray = zzk2.zzce();
        try {
            byArray = this.h_().zzb(byArray);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Data loss. Failed to serialize bundle. appId", zzgo.zza((String)zzk2.zzab()), (Object)iOException);
            return false;
        }
        this.zzj().zzq().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzk2.zzab());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzk2.zzn()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzk2.zzbt()) {
            contentValues.put("retry_count", Integer.valueOf(zzk2.zzg()));
        }
        try {
            if (this.f_().insert("queue", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert bundle (got -1). appId", zzgo.zza((String)zzk2.zzab()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing bundle. appId", zzgo.zza((String)zzk2.zzab()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfw.zzb zzb2) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzb2));
        if (zzb2.zzf().isEmpty()) {
            this.zzj().zzr().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzgo.zza((String)string), (Object)n, (Object)String.valueOf(zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null));
            return false;
        }
        byte[] byArray = zzb2.zzce();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null);
        contentValues.put("event_name", zzb2.zzf());
        contentValues.put("session_scoped", zzb2.zzm() ? Boolean.valueOf(zzb2.zzj()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.f_().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert event filter (got -1). appId", zzgo.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event filter. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfw.zze zze2) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zze2));
        if (zze2.zze().isEmpty()) {
            this.zzj().zzr().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzgo.zza((String)string), (Object)n, (Object)String.valueOf(zze2.zzi() ? Integer.valueOf(zze2.zza()) : null));
            return false;
        }
        byte[] byArray = zze2.zzce();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzi() ? Integer.valueOf(zze2.zza()) : null);
        contentValues.put("property_name", zze2.zze());
        contentValues.put("session_scoped", zze2.zzj() ? Boolean.valueOf(zze2.zzh()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.f_().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert property filter (got -1). appId", zzgo.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing property filter. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzbe zzbe2, long l, boolean bl) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzbe2);
        Preconditions.checkNotEmpty((String)zzbe2.zza);
        byte[] byArray = this.h_().zza(zzbe2).zzce();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzbe2.zza);
        contentValues.put("name", zzbe2.zzb);
        contentValues.put("timestamp", Long.valueOf(zzbe2.zzd));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", byArray);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.f_().insert("raw_events", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert raw event (got -1). appId", zzgo.zza((String)zzbe2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event. appId", zzgo.zza((String)zzbe2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(String string, zzog zzog2) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzog2);
        Preconditions.checkNotEmpty((String)string);
        long l = this.zzb().currentTimeMillis();
        if (zzog2.zzb < l - (Long)zzbn.zzbp.zza(null) || zzog2.zzb > l + (Long)zzbn.zzbp.zza(null)) {
            this.zzj().zzr().zza("Storing trigger URI outside of the max retention time span. appId, now, timestamp", zzgo.zza((String)string), (Object)l, (Object)zzog2.zzb);
        }
        this.zzj().zzq().zza("Saving trigger URI");
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("trigger_uri", zzog2.zza);
        contentValues.put("source", Integer.valueOf(zzog2.zzc));
        contentValues.put("timestamp_millis", Long.valueOf(zzog2.zzb));
        try {
            if (this.f_().insert("trigger_uris", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert trigger URI (got -1). appId", zzgo.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing trigger URI. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected final boolean zzab() {
        return this.zza().getDatabasePath("google_app_measurement.db").exists();
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    public final boolean zza(String string, Long l, long l2, zzgf.zzf zzf2) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzf2);
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zzf2.zzce();
        this.zzj().zzq().zza("Saving complex main event, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.f_().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert complex main event (got -1). appId", zzgo.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing complex main event. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final boolean zza(String string, long l) {
        if (!this.zze().zza(zzbn.zzcz) && this.zzb().currentTimeMillis() > l + 15000L) {
            return false;
        }
        try {
            if (this.zza("select count(*) from raw_events where app_id=? and timestamp >= ? and name not like '!_%' escape '!' limit 1;", new String[]{string, String.valueOf(l)}, 0L) > 0L) {
                return false;
            }
            return this.zza("select count(*) from raw_events where app_id=? and timestamp >= ? and name like '!_%' escape '!' limit 1;", new String[]{string, String.valueOf(l)}, 0L) > 0L;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error checking backfill conditions", (Object)sQLiteException);
            return false;
        }
    }

    @WorkerThread
    public final boolean zza(zzag zzag2) {
        Preconditions.checkNotNull((Object)zzag2);
        this.zzv();
        this.zzam();
        String string = zzag2.zza;
        Preconditions.checkNotNull((Object)string);
        if (this.zze(string, zzag2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{string}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("origin", zzag2.zzb);
        contentValues.put("name", zzag2.zzc.zza);
        zzar.zza(contentValues, "value", Preconditions.checkNotNull((Object)zzag2.zzc.zza()));
        contentValues.put("active", Boolean.valueOf(zzag2.zze));
        contentValues.put("trigger_event_name", zzag2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzag2.zzh));
        this.zzs();
        contentValues.put("timed_out_event", zzpn.zza((Parcelable)zzag2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzag2.zzd));
        this.zzs();
        contentValues.put("triggered_event", zzpn.zza((Parcelable)zzag2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzag2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzag2.zzj));
        this.zzs();
        contentValues.put("expired_event", zzpn.zza((Parcelable)zzag2.zzk));
        try {
            if (this.f_().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update conditional user property (got -1)", zzgo.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing conditional user property", zzgo.zza((String)string), (Object)sQLiteException);
        }
        return true;
    }

    final boolean zza(String string, Bundle bundle) {
        this.zzv();
        this.zzam();
        zzbe zzbe2 = new zzbe(this.zzu, "", string, "dep", 0L, 0L, bundle);
        byte[] byArray = this.h_().zza(zzbe2).zzce();
        this.zzj().zzq().zza("Saving default event parameters, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("parameters", byArray);
        try {
            if (this.f_().insertWithOnConflict("default_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert default event parameters (got -1). appId", zzgo.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing default event parameters. appId", zzgo.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zza(long l, zzbe zzbe2, long l2, boolean bl) {
        this.zzv();
        this.zzam();
        Preconditions.checkNotNull((Object)zzbe2);
        Preconditions.checkNotEmpty((String)zzbe2.zza);
        byte[] byArray = this.h_().zza(zzbe2).zzce();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzbe2.zza);
        contentValues.put("name", zzbe2.zzb);
        contentValues.put("timestamp", Long.valueOf(zzbe2.zzd));
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("data", byArray);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            long l3 = this.f_().update("raw_events", contentValues, "rowid = ?", new String[]{String.valueOf(l)});
            if (l3 != 1L) {
                this.zzj().zzg().zza("Failed to update raw event. appId, updatedRows", zzgo.zza((String)zzbe2.zza), (Object)l3);
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error updating raw event. appId", zzgo.zza((String)zzbe2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(zzpo zzpo2) {
        Preconditions.checkNotNull((Object)zzpo2);
        this.zzv();
        this.zzam();
        if (this.zze(zzpo2.zza, zzpo2.zzc) == null && (zzpn.zzg((String)zzpo2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzpo2.zza}) >= (long)this.zze().zza(zzpo2.zza, zzbn.zzaq, 25, 100) : !"_npa".equals(zzpo2.zzc) && this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzpo2.zza, zzpo2.zzb}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzpo2.zza);
        contentValues.put("origin", zzpo2.zzb);
        contentValues.put("name", zzpo2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzpo2.zzd));
        zzar.zza(contentValues, "value", zzpo2.zze);
        try {
            if (this.f_().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update user property (got -1). appId", zzgo.zza((String)zzpo2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing user property. appId", zzgo.zza((String)zzpo2.zza), (Object)sQLiteException);
        }
        return true;
    }

    static /* bridge */ /* synthetic */ String[] zzac() {
        return zzj;
    }

    static /* bridge */ /* synthetic */ String[] zzad() {
        return zzd;
    }

    static /* bridge */ /* synthetic */ String[] zzae() {
        return zzk;
    }

    static /* bridge */ /* synthetic */ String[] zzaf() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ String[] zzag() {
        return zzh;
    }

    static /* bridge */ /* synthetic */ String[] zzah() {
        return zzi;
    }

    static /* bridge */ /* synthetic */ String[] zzai() {
        return zzf;
    }

    static /* bridge */ /* synthetic */ String[] zzaj() {
        return zze;
    }

    static /* bridge */ /* synthetic */ String[] zzak() {
        return zzl;
    }

    static /* bridge */ /* synthetic */ String[] zzal() {
        return zzc;
    }
}

