/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgr;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzr;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzou;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhm
extends zzot
implements zzak {
    private final Map<String, @Nullable Map<String, String>> zzb = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Set<String>> zzc = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zzd = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zze = new ArrayMap();
    private final Map<String, @Nullable zzgc.zzd> zzf = new ArrayMap();
    private final Map<String, @Nullable Map<String, Integer>> zzh;
    @VisibleForTesting
    final LruCache<String, zzb> zza;
    private final zzv zzi;
    private final Map<String, @Nullable String> zzj = new ArrayMap();
    private final Map<String, @Nullable String> zzk = new ArrayMap();
    private final Map<String, @Nullable String> zzl = new ArrayMap();

    @WorkerThread
    final int zzb(String string, String string2) {
        this.zzv();
        this.zzu(string);
        Map<String, Integer> map = this.zzh.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zza(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzr().zza("Unable to parse timezone offset. appId", zzgo.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    static /* synthetic */ zzb zza(zzhm zzhm2, String string) {
        String string2 = string;
        zzhm zzhm3 = zzhm2;
        zzhm3.zzam();
        Preconditions.checkNotEmpty((String)string2);
        if (!zzhm3.zzk(string2)) {
            return null;
        }
        if (zzhm3.zzf.containsKey(string2) && zzhm3.zzf.get(string2) != null) {
            zzhm3.zza(string2, zzhm3.zzf.get(string2));
        } else {
            zzhm3.zzu(string2);
        }
        return (zzb)zzhm3.zza.snapshot().get(string2);
    }

    public static /* synthetic */ zzal zza(zzhm zzhm2) {
        zzhm zzhm3 = zzhm2;
        return new zzr(zzhm3.zzi);
    }

    @WorkerThread
    final zzjm zza(String string, zzjj.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzgc.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return zzjm.zza;
        }
        for (zzgc.zza.zzb zzb2 : zza3.zzf()) {
            if (zzhm.zza(zzb2.zzc()) != zza2) continue;
            switch (zzb2.zzb()) {
                case zzc: {
                    return zzjm.zzc;
                }
                case zzb: {
                    return zzjm.zzd;
                }
            }
            return zzjm.zza;
        }
        return zzjm.zza;
    }

    @WorkerThread
    final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzjj.zza zzb(String string, zzjj.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzgc.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return null;
        }
        for (zzgc.zza.zzc zzc2 : zza3.zze()) {
            zzjj.zza zza4 = zzhm.zza(zzc2.zzc());
            if (zza2 != zza4) continue;
            return zzhm.zza(zzc2.zzb());
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzjj.zza zza(zzgc.zza.zze zze2) {
        switch (zze2) {
            case zzb: {
                return zzjj.zza.zza;
            }
            case zzc: {
                return zzjj.zza.zzb;
            }
            case zzd: {
                return zzjj.zza.zzc;
            }
            case zze: {
                return zzjj.zza.zzd;
            }
        }
        return null;
    }

    @WorkerThread
    final @Nullable zzgc.zza zzb(String string) {
        this.zzv();
        this.zzu(string);
        zzgc.zzd zzd2 = this.zzc(string);
        if (zzd2 == null || !zzd2.zzo()) {
            return null;
        }
        return zzd2.zzd();
    }

    @WorkerThread
    protected final @Nullable zzgc.zzd zzc(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        this.zzu(string);
        return this.zzf.get(string);
    }

    @WorkerThread
    private final zzgc.zzd zza(String string, byte @Nullable [] byArray) {
        zzgc.zzd zzd2;
        if (byArray == null) {
            return zzgc.zzd.zzg();
        }
        try {
            zzd2 = (zzgc.zzd)((zzkg)zzpj.zza(zzgc.zzd.zze(), byArray).zzaj());
            this.zzj().zzq().zza("Parsed config. version, gmp_app_id", (Object)(zzd2.zzr() ? Long.valueOf(zzd2.zzc()) : null), (Object)(zzd2.zzp() ? zzd2.zzi() : null));
        }
        catch (zzkp zzkp2) {
            this.zzj().zzr().zza("Unable to merge remote config. appId", zzgo.zza((String)string), (Object)zzkp2);
            return zzgc.zzd.zzg();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzr().zza("Unable to merge remote config. appId", zzgo.zza((String)string), (Object)runtimeException);
            return zzgc.zzd.zzg();
        }
        return zzd2;
    }

    @WorkerThread
    public final @Nullable String zza(String string, String string2) {
        this.zzv();
        this.zzu(string);
        Map<String, String> map = this.zzb.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @WorkerThread
    protected final @Nullable String zzd(String string) {
        this.zzv();
        return this.zzl.get(string);
    }

    @WorkerThread
    protected final @Nullable String zze(String string) {
        this.zzv();
        return this.zzk.get(string);
    }

    @WorkerThread
    final @Nullable String zzf(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzj.get(string);
    }

    static /* bridge */ /* synthetic */ Map zzb(zzhm zzhm2) {
        return zzhm2.zzb;
    }

    private static Map<String, String> zza(zzgc.zzd zzd2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzd2 != null) {
            for (zzgc.zzh zzh2 : zzd2.zzn()) {
                arrayMap.put(zzh2.zzb(), zzh2.zzc());
            }
        }
        return arrayMap;
    }

    @WorkerThread
    final @Nullable Set<String> zzg(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string);
    }

    @WorkerThread
    final SortedSet<String> zzh(String string) {
        this.zzv();
        this.zzu(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        zzgc.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return treeSet;
        }
        for (zzgc.zza.zzf zzf2 : zza2.zzc()) {
            treeSet.add(zzf2.zzb());
        }
        return treeSet;
    }

    zzhm(zzou zzou2) {
        super(zzou2);
        this.zzh = new ArrayMap();
        this.zza = new zzhs(this, 20);
        this.zzi = new zzhr(this);
    }

    @WorkerThread
    protected final void zzi(String string) {
        this.zzv();
        this.zzk.put(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void zza(String string, zzgc.zzd.zza zza2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (zzgc.zzb zzlo2 : zza2.zze()) {
                hashSet.add(zzlo2.zzb());
            }
            for (int i = 0; i < zza2.zza(); ++i) {
                void var8_13;
                zzgc.zzc.zza zza3 = (zzgc.zzc.zza)zza2.zza(i).zzch();
                if (zza3.zzb().isEmpty()) {
                    this.zzj().zzr().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zzb();
                String string3 = zzjp.zzb((String)zza3.zzb());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zzgc.zzc.zza zza4 = zza3.zza(string3);
                    zza2.zza(i, zza4);
                }
                if (var8_13.zze() && var8_13.zzc()) {
                    arrayMap.put(string2, true);
                }
                if (var8_13.zzf() && var8_13.zzd()) {
                    arrayMap2.put(var8_13.zzb(), true);
                }
                if (!var8_13.zzg()) continue;
                if (var8_13.zza() < 2 || var8_13.zza() > 65535) {
                    this.zzj().zzr().zza("Invalid sampling rate. Event name, sample rate", (Object)var8_13.zzb(), (Object)var8_13.zza());
                    continue;
                }
                arrayMap3.put(var8_13.zzb(), var8_13.zza());
            }
        }
        this.zzc.put(string, hashSet);
        this.zzd.put(string, (Map<String, Boolean>)arrayMap);
        this.zze.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzh.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    private final void zzu(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzf.get(string) == null) {
            zzat zzat2 = ((zzok)this).zzh().zze(string);
            if (zzat2 == null) {
                this.zzb.put(string, null);
                this.zzd.put(string, null);
                this.zzc.put(string, null);
                this.zze.put(string, null);
                this.zzf.put(string, null);
                this.zzj.put(string, null);
                this.zzk.put(string, null);
                this.zzl.put(string, null);
                this.zzh.put(string, null);
                return;
            }
            byte[] byArray = zzat2.zza;
            zzgc.zzd.zza zza2 = (zzgc.zzd.zza)this.zza(string, byArray).zzch();
            this.zza(string, zza2);
            this.zzb.put(string, zzhm.zza((zzgc.zzd)((zzkg)zza2.zzaj())));
            this.zzf.put(string, (zzgc.zzd)((zzkg)zza2.zzaj()));
            this.zza(string, (zzgc.zzd)((zzkg)zza2.zzaj()));
            this.zzj.put(string, zza2.zzc());
            this.zzk.put(string, zzat2.zzb);
            this.zzl.put(string, zzat2.zzc);
        }
    }

    @WorkerThread
    private final void zza(String string, zzgc.zzd zzd2) {
        if (zzd2.zza() == 0) {
            this.zza.remove((Object)string);
            return;
        }
        this.zzj().zzq().zza("EES programs found", (Object)zzd2.zza());
        zzgr.zzc zzc2 = zzd2.zzm().get(0);
        try {
            zzb zzb2 = new zzb();
            String string2 = string;
            zzhm zzhm2 = this;
            zzb2.zza("internal.remoteConfig", new zzho(zzhm2, string2));
            string2 = string;
            zzhm2 = this;
            zzb2.zza("internal.appMetadata", new zzhn(zzhm2, string2));
            zzhm2 = this;
            zzb2.zza("internal.logger", new zzhq(zzhm2));
            zzb2.zza(zzc2);
            this.zza.put((Object)string, (Object)zzb2);
            this.zzj().zzq().zza("EES program loaded for appId, activities", (Object)string, (Object)zzc2.zza().zza());
            for (zzgr.zzb zzb3 : zzc2.zza().zzd()) {
                this.zzj().zzq().zza("EES program activity", (Object)zzb3.zzb());
            }
            return;
        }
        catch (zzc zzc3) {
            this.zzj().zzg().zza("Failed to load EES program. appId", (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zzj(String string) {
        this.zzv();
        this.zzf.remove(string);
    }

    public final boolean zzk(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzgc.zzd zzd2 = this.zzf.get(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zza() != 0;
    }

    final boolean zzl(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    @WorkerThread
    final boolean zzc(String string, zzjj.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzgc.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return false;
        }
        for (zzgc.zza.zzb zzb2 : zza3.zzd()) {
            if (zza2 != zzhm.zza(zzb2.zzc())) continue;
            return zzb2.zzb() == zzgc.zza.zzd.zzb;
        }
        return false;
    }

    @WorkerThread
    final boolean zzm(String string) {
        this.zzv();
        this.zzu(string);
        zzgc.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return true;
        }
        return !zza2.zzh() || zza2.zzg();
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzv();
        this.zzu(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzd(String string, String string2) {
        this.zzv();
        this.zzu(string);
        if (this.zzl(string) && zzpn.zzf((String)string2)) {
            return true;
        }
        if (this.zzn(string) && zzpn.zzg((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzd.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzn(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    protected final boolean zza(String string, byte @Nullable [] byArray, @Nullable String string2, @Nullable String string3) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        zzgc.zzd.zza zza2 = (zzgc.zzd.zza)this.zza(string, byArray).zzch();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zza(string, (zzgc.zzd)((zzkg)zza2.zzaj()));
        this.zzf.put(string, (zzgc.zzd)((zzkg)zza2.zzaj()));
        this.zzj.put(string, zza2.zzc());
        this.zzk.put(string, string2);
        this.zzl.put(string, string3);
        this.zzb.put(string, zzhm.zza((zzgc.zzd)((zzkg)zza2.zzaj())));
        ((zzok)this).zzh().zza(string, new ArrayList<zzfw.zza>(zza2.zzd()));
        try {
            zza2.zzb();
            byArray = ((zzgc.zzd)((zzkg)zza2.zzaj())).zzce();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzr().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzgo.zza((String)string), (Object)runtimeException);
        }
        String string4 = string3;
        String string5 = string2;
        byte[] byArray2 = byArray;
        String string6 = string;
        zzar zzar2 = ((zzok)this).zzh();
        Preconditions.checkNotEmpty((String)string6);
        zzar2.zzv();
        zzar2.zzam();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        contentValues.put("config_last_modified_time", string5);
        contentValues.put("e_tag", string4);
        try {
            if ((long)zzar2.f_().update("apps", contentValues, "app_id = ?", new String[]{string6}) == 0L) {
                zzar2.zzj().zzg().zza("Failed to update remote config (got 0). appId", zzgo.zza((String)string6));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzar2.zzj().zzg().zza("Error storing remote config. appId", zzgo.zza((String)string6), (Object)sQLiteException);
        }
        this.zzf.put(string, (zzgc.zzd)((zzkg)zza2.zzaj()));
        return true;
    }

    @WorkerThread
    final boolean zzo(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("app_instance_id");
    }

    @WorkerThread
    final boolean zzp(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && (this.zzc.get(string).contains("device_model") || this.zzc.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzq(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("enhanced_user_id");
    }

    @WorkerThread
    final boolean zzr(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("google_signals");
    }

    @WorkerThread
    final boolean zzs(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && (this.zzc.get(string).contains("os_version") || this.zzc.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzt(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("user_id");
    }
}

