/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzor;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzou;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpm;
import com.google.android.gms.measurement.internal.zzpn;
import com.google.android.gms.measurement.internal.zzpo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzig
extends zzfy {
    private final zzou zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzap zza(zzp zzp2) {
        this.zzb(zzp2, false);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Future future = this.zza.zzl().zzb((Callable)new zzja(this, zzp2));
        try {
            return (zzap)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zza.zzj().zzg().zza("Failed to get consent. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
            return new zzap(null);
        }
    }

    @VisibleForTesting
    final zzbl zzb(zzbl zzbl2, zzp zzp2) {
        String string;
        zzbl zzbl3 = zzbl2;
        if (!"_cmp".equals(zzbl3.zza) || zzbl3.zzb == null || zzbl3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbl3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzp().zza("Event has been filtered ", (Object)zzbl2.toString());
            return new zzbl("_cmpx", zzbl2.zzb, zzbl2.zzc, zzbl2.zzd);
        }
        return zzbl2;
    }

    static /* bridge */ /* synthetic */ zzou zza(zzig zzig2) {
        return zzig2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzp zzp2) {
        this.zzb(zzp2, false);
        return this.zza.zzb(zzp2);
    }

    @BinderThread
    public final List<zzog> zza(zzp zzp2, Bundle bundle) {
        this.zzb(zzp2, false);
        Preconditions.checkNotNull((Object)zzp2.zza);
        if (this.zza.zze().zza(zzbn.zzdc)) {
            Future future = this.zza.zzl().zzb((Callable)new zzjd(this, zzp2, bundle));
            try {
                return (List)future.get(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
                return Collections.emptyList();
            }
        }
        Future future = this.zza.zzl().zza((Callable)new zzjg(this, zzp2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzpm> zza(zzp zzp2, boolean bl) {
        this.zzb(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zzio(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzpm> arrayList = new ArrayList<zzpm>(list.size());
            for (zzpo zzpo2 : list) {
                if (!bl && zzpn.zzf((String)zzpo2.zzc)) continue;
                arrayList.add(new zzpm(zzpo2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzag> zza(@Nullable String string, @Nullable String string2, zzp zzp2) {
        this.zzb(zzp2, false);
        String string3 = zzp2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zziw(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzag> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zziv(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzpm> zza(@Nullable String string, @Nullable String string2, boolean bl, zzp zzp2) {
        this.zzb(zzp2, false);
        String string3 = zzp2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zziu(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzpm> arrayList = new ArrayList<zzpm>(list.size());
            for (zzpo zzpo2 : list) {
                if (!bl && zzpn.zzf((String)zzpo2.zzc)) continue;
                arrayList.add(new zzpm(zzpo2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzpm> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzit(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzpm> arrayList = new ArrayList<zzpm>(list.size());
            for (zzpo zzpo2 : list) {
                if (!bl && zzpn.zzf((String)zzpo2.zzc)) continue;
                arrayList.add(new zzpm(zzpo2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzgo.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public static /* synthetic */ void zza(zzig zzig2, String string, zzop zzop2, zzgf zzgf2) {
        zzgf zzgf3 = zzgf2;
        zzop zzop3 = zzop2;
        String string2 = string;
        zzig zzig3 = zzig2;
        zzig3.zza.zzs();
        zzor zzor2 = zzig3.zza.zza(string2, zzop3);
        try {
            zzgf3.zza(zzor2);
            return;
        }
        catch (RemoteException remoteException) {
            zzig3.zza.zzj().zzg().zza("[sgtm] Failed to return upload batches for app", (Object)string2, (Object)remoteException);
            return;
        }
    }

    public static /* synthetic */ void zza(zzig zzig2, zzp zzp2) {
        zzp zzp3 = zzp2;
        zzig zzig3 = zzig2;
        zzig3.zza.zzs();
        zzig3.zza.zzg(zzp3);
    }

    public static /* synthetic */ void zza(zzig zzig2, zzp zzp2, zzae zzae2) {
        zzae zzae3 = zzae2;
        zzp zzp3 = zzp2;
        zzig zzig3 = zzig2;
        zzig3.zza.zzs();
        zzig3.zza.zza((String)Preconditions.checkNotNull((Object)zzp3.zza), zzae3);
    }

    public static /* synthetic */ void zzb(zzig zzig2, zzp zzp2) {
        zzp zzp3 = zzp2;
        zzig zzig3 = zzig2;
        zzig3.zza.zzs();
        zzig3.zza.zzf(zzp3);
    }

    public static /* synthetic */ void zza(zzig zzig2, zzp zzp2, Bundle bundle, zzga zzga2, String string) {
        String string2 = string;
        zzga zzga3 = zzga2;
        Bundle bundle2 = bundle;
        zzp zzp3 = zzp2;
        zzig zzig3 = zzig2;
        zzig3.zza.zzs();
        List<zzog> list = zzig3.zza.zza(zzp3, bundle2);
        try {
            zzga3.zza(list);
            return;
        }
        catch (RemoteException remoteException) {
            zzig3.zza.zzj().zzg().zza("Failed to return trigger URIs for app", (Object)string2, (Object)remoteException);
            return;
        }
    }

    public static /* synthetic */ void zza(zzig zzig2, Bundle bundle, String string, zzp zzp2) {
        zzp zzp3 = zzp2;
        String string2 = string;
        Bundle bundle2 = bundle;
        zzig zzig3 = zzig2;
        boolean bl = zzig3.zza.zze().zza(zzbn.zzcx);
        boolean bl2 = zzig3.zza.zze().zza(zzbn.zzcz);
        if (bundle2.isEmpty() && bl) {
            String string3 = string2;
            zzar zzar2 = zzig3.zza.zzf();
            zzar2.zzv();
            zzar2.zzam();
            try {
                zzar2.f_().execSQL("delete from default_event_params where app_id=?", (Object[])new String[]{string3});
                return;
            }
            catch (SQLiteException sQLiteException) {
                zzar2.zzj().zzg().zza("Error clearing default event params", (Object)sQLiteException);
                return;
            }
        }
        zzig3.zza.zzf().zza(string2, bundle2);
        if (zzig3.zza.zzf().zza(string2, zzp3.zzae)) {
            if (bl2) {
                Bundle bundle3 = bundle2;
                long l = zzp3.zzae;
                zzig3.zza.zzf().zza(string2, (Long)l, null, bundle3);
                return;
            }
            Bundle bundle4 = bundle2;
            zzig3.zza.zzf().zza(string2, null, null, bundle4);
        }
    }

    public zzig(zzou zzou2) {
        this(zzou2, null);
    }

    private zzig(zzou zzou2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzou2);
        this.zza = zzou2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zziq(this, zzp2));
    }

    @BinderThread
    public final void zzd(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zzin(this, zzp2));
    }

    @BinderThread
    private final void zzb(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zza(zzp2.zza, false);
        this.zza.zzq().zza(zzp2.zzb, zzp2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzig zzig2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzig2 = this;
                    if (!bl2) break block9;
                    if (zzig2.zzb == null) {
                        zzig2.zzb = "com.google.android.gms".equals(zzig2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzig2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzig2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzig2.zzb.booleanValue()) break block10;
                }
                if (zzig2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzig2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzig2.zzc = string2;
                }
                if (!string2.equals(zzig2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzgo.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(zzp zzp2, zzop zzop2, zzgf zzgf2) {
        if (!this.zza.zze().zza(zzbn.zzcj)) {
            return;
        }
        this.zzb(zzp2, false);
        String string = (String)Preconditions.checkNotNull((Object)zzp2.zza);
        zzgf zzgf3 = zzgf2;
        zzop zzop3 = zzop2;
        String string2 = string;
        zzig zzig2 = this;
        this.zza.zzl().zzb((Runnable)new zzik(zzig2, string2, zzop3, zzgf3));
    }

    final void zzc(zzbl zzbl2, zzp zzp2) {
        if (!this.zza.zzi().zzk(zzp2.zza)) {
            this.zzd(zzbl2, zzp2);
            return;
        }
        this.zza.zzj().zzq().zza("EES config found for", (Object)zzp2.zza);
        String string = zzp2.zza;
        zzot zzot2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzhm)zzot2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzq().zza("EES not loaded for", (Object)zzp2.zza);
            this.zzd(zzbl2, zzp2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbl2;
            zzot2 = this.zza.zzp();
            Bundle bundle = ((zzbl)string).zzb.zzb();
            Map<String, Object> map = ((zzpj)zzot2).zza(bundle, true);
            String string2 = zzjp.zza((String)((zzbl)string).zza);
            if (string2 == null) {
                string2 = ((zzbl)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbl)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzp2.zzb, (Object)zzbl2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzq().zza("EES was not applied to event", (Object)zzbl2.zza);
            this.zzd(zzbl2, zzp2);
            return;
        }
        if (zzb2.zzc()) {
            this.zza.zzj().zzq().zza("EES edited event", (Object)zzbl2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzp2);
        } else {
            this.zzd(zzbl2, zzp2);
        }
        if (zzb2.zzb()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzq().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzp2);
            }
        }
    }

    @BinderThread
    public final void zza(zzbl zzbl2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzbl2);
        this.zzb(zzp2, false);
        this.zzb(new zziz(this, zzbl2, zzp2));
    }

    @BinderThread
    public final void zza(zzbl zzbl2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbl2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzb(new zzjc(this, zzbl2, string));
    }

    private final void zzd(zzbl zzbl2, zzp zzp2) {
        this.zza.zzs();
        this.zza.zza(zzbl2, zzp2);
    }

    @BinderThread
    public final void zza(zzp zzp2, Bundle bundle, zzga zzga2) {
        String string;
        this.zzb(zzp2, false);
        String string2 = string = (String)Preconditions.checkNotNull((Object)zzp2.zza);
        zzga zzga3 = zzga2;
        Bundle bundle2 = bundle;
        zzp zzp3 = zzp2;
        zzig zzig2 = this;
        this.zza.zzl().zzb((Runnable)new zzii(zzig2, zzp3, bundle2, zzga3, string2));
    }

    @BinderThread
    public final void zze(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zza(zzp2.zza, false);
        this.zzb(new zzix(this, zzp2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzm()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzc(runnable);
    }

    @VisibleForTesting
    private final void zzb(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzm()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzag zzag2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotNull((Object)zzag2.zzc);
        this.zzb(zzp2, false);
        zzag zzag3 = new zzag(zzag2);
        new zzag(zzag2).zza = zzp2.zza;
        this.zzb(new zzis(this, zzag3, zzp2));
    }

    @BinderThread
    public final void zza(zzag zzag2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotNull((Object)zzag2.zzc);
        Preconditions.checkNotEmpty((String)zzag2.zza);
        this.zza(zzag2.zza, true);
        zzag zzag3 = new zzag(zzag2);
        this.zzb(new zzir(this, zzag3));
    }

    @BinderThread
    public final void zzf(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        this.zza(new zziy(this, zzp2));
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zzb(new zzip(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzp zzp2) {
        this.zzb(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzp zzp3 = zzp2;
        String string2 = string;
        Bundle bundle2 = bundle;
        zzig zzig2 = this;
        this.zzb(new zzim(zzig2, bundle2, string2, zzp3));
    }

    @BinderThread
    public final void zzg(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        zzp zzp3 = zzp2;
        zzig zzig2 = this;
        this.zza(new zzij(zzig2, zzp3));
    }

    @BinderThread
    public final void zzh(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zzil(this, zzp2));
    }

    @BinderThread
    public final void zzi(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        zzp zzp3 = zzp2;
        zzig zzig2 = this;
        this.zza(new zzih(zzig2, zzp3));
    }

    @BinderThread
    public final void zza(zzpm zzpm2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzpm2);
        this.zzb(zzp2, false);
        this.zzb(new zzje(this, zzpm2, zzp2));
    }

    @BinderThread
    public final void zza(zzp zzp2, zzae zzae2) {
        if (!this.zza.zze().zza(zzbn.zzcj)) {
            return;
        }
        this.zzb(zzp2, false);
        zzae zzae3 = zzae2;
        zzp zzp3 = zzp2;
        zzig zzig2 = this;
        this.zzb(new zzif(zzig2, zzp3, zzae3));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbl zzbl2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbl2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbl2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zzjb(this, zzbl2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzgo.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbl2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzgo.zza((String)string), (Object)this.zza.zzg().zza(zzbl2.zza), (Object)exception);
            return null;
        }
    }
}

