/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzpe;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zznp;
import com.google.android.gms.measurement.internal.zzoe;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzoi;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzon;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzor;
import com.google.android.gms.measurement.internal.zzos;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzov;
import com.google.android.gms.measurement.internal.zzow;
import com.google.android.gms.measurement.internal.zzox;
import com.google.android.gms.measurement.internal.zzoy;
import com.google.android.gms.measurement.internal.zzoz;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzpa;
import com.google.android.gms.measurement.internal.zzpb;
import com.google.android.gms.measurement.internal.zzpd;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpg;
import com.google.android.gms.measurement.internal.zzpi;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpm;
import com.google.android.gms.measurement.internal.zzpn;
import com.google.android.gms.measurement.internal.zzpo;
import com.google.android.gms.measurement.internal.zzpp;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzou
implements zzjh {
    private static volatile @Nullable zzou zza;
    private zzhm zzb;
    private zzgv zzc;
    private zzar zzd;
    private zzgy zze;
    private zzoi zzf;
    private zzx zzg;
    private final zzpj zzh;
    private zzlt zzi;
    private zznp zzj;
    private final zzos zzk;
    private @MonotonicNonNull zzhj zzl;
    private final zzic zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Deque<String> zzr = new LinkedList<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzjj> zzac;
    private final Map<String, zzbd> zzad;
    private final Map<String, zzc> zzae;
    private final Map<String, zzb> zzaf = new HashMap<String, zzb>();
    private @Nullable zzlw zzag;
    private @Nullable String zzah;
    private zzbb zzai;
    private long zzaj;
    private final zzpp zzak = new zzpd(this);

    private final int zza(String string, zzan zzan2) {
        zzjm zzjm2;
        if (this.zzb.zzb(string) == null) {
            zzan2.zza(zzjj.zza.zzd, zzam.zzi);
            return 1;
        }
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 != null && com.google.android.gms.measurement.internal.zzd.zza((String)zzh2.zzak()).zza() == zzjm.zzb && (zzjm2 = this.zzb.zza(string, zzjj.zza.zzd)) != zzjm.zza) {
            zzan2.zza(zzjj.zza.zzd, zzam.zzh);
            if (zzjm2 == zzjm.zzd) {
                return 0;
            }
            return 1;
        }
        zzan2.zza(zzjj.zza.zzd, zzam.zzb);
        if (this.zzb.zzc(string, zzjj.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzv();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzr().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzy() {
        long l = this.zzb().currentTimeMillis();
        zznp zznp2 = this.zzj;
        zznp2.zzam();
        zznp2.zzv();
        long l2 = zznp2.zzf.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zznp2.zzs().zzw().nextInt(86400000);
            zznp2.zzf.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        this.zzl().zzv();
        this.zzt();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzjj zzjj2 = this.zzb(string);
        bundle.putAll(zzjj2.zzb());
        zzbd zzbd2 = this.zza(string, this.zzd(string), zzjj2, new zzan());
        bundle.putAll(zzbd2.zzb());
        zzpo zzpo2 = this.zzf().zze(string, "_npa");
        int n = zzpo2 != null ? (zzpo2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzan());
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    private final Bundle zza(String string, zzbl zzbl2) {
        Bundle bundle = new Bundle();
        bundle.putLong("_sid", zzbl2.zzb.zzb("_sid").longValue());
        zzpo zzpo2 = this.zzf().zze(string, "_sno");
        if (zzpo2 != null && zzpo2.zze instanceof Long) {
            bundle.putLong("_sno", ((Long)zzpo2.zze).longValue());
        }
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zzou this) {
        return ((zzic)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzh zza(zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (!zzp2.zzu.isEmpty()) {
            this.zzae.put(zzp2.zza, new zzc(this, zzp2.zzu, null));
        }
        zzh zzh2 = this.zzf().zzd(zzp2.zza);
        boolean bl = false;
        zzjj zzjj2 = this.zzb(zzp2.zza).zza(zzjj.zzb((String)zzp2.zzt));
        String string = zzjj2.zzg() ? this.zzj.zza(zzp2.zza, zzp2.zzn) : "";
        if (zzh2 == null) {
            zzh2 = new zzh(this.zzm, zzp2.zza);
            if (zzjj2.zzh()) {
                zzh2.zzb(this.zza(zzjj2));
            }
            if (zzjj2.zzg()) {
                zzh2.zzh(string);
            }
        } else if (zzjj2.zzg() && string != null && !string.equals(zzh2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzh2.zzaj());
            zzh2.zzh(string);
            if (zzp2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzp2.zza, (zzjj)zzjj2).first) && !bl2) {
                if (zzjj2.zzh()) {
                    zzh2.zzb(this.zza(zzjj2));
                } else {
                    bl = true;
                }
                if (this.zzf().zze(zzp2.zza, "_id") != null && this.zzf().zze(zzp2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zzpo zzpo2 = new zzpo(zzp2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zzpo2);
                }
            } else if (TextUtils.isEmpty((CharSequence)zzh2.zzad()) && zzjj2.zzh()) {
                zzh2.zzb(this.zza(zzjj2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzh2.zzad()) && zzjj2.zzh()) {
            zzh2.zzb(this.zza(zzjj2));
        }
        zzh2.zzf(zzp2.zzb);
        zzh2.zza(zzp2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzk)) {
            zzh2.zze(zzp2.zzk);
        }
        if (zzp2.zze != 0L) {
            zzh2.zzn(zzp2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzc)) {
            zzh2.zzd(zzp2.zzc);
        }
        zzh2.zzb(zzp2.zzj);
        if (zzp2.zzd != null) {
            zzh2.zzc(zzp2.zzd);
        }
        zzh2.zzk(zzp2.zzf);
        zzh2.zzb(zzp2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzg)) {
            zzh2.zzg(zzp2.zzg);
        }
        zzh2.zza(zzp2.zzn);
        zzh2.zza(zzp2.zzq);
        zzh2.zzl(zzp2.zzr);
        zzh2.zzj(zzp2.zzv);
        if (com.google.android.gms.internal.measurement.zzog.zza() && this.zze().zza(zzbn.zzcf)) {
            zzh2.zza(zzp2.zzs);
        } else if (com.google.android.gms.internal.measurement.zzog.zza() && this.zze().zza(zzbn.zzce)) {
            zzh2.zza((List<String>)null);
        }
        zzh2.zzc(zzp2.zzw);
        zzh2.zzk(zzp2.zzac);
        if (com.google.android.gms.internal.measurement.zzoy.zza() && this.zze().zza(zzbn.zzcp)) {
            zzh2.zza(zzp2.zzaa);
        }
        zzh2.zzt(zzp2.zzx);
        zzh2.zzi(zzp2.zzad);
        if (this.zze().zza(zzbn.zzcj)) {
            zzh2.zzb(zzp2.zzaf);
        }
        if (zzh2.zzas() || bl) {
            this.zzf().zza(zzh2, bl, false);
        }
        return zzh2;
    }

    @WorkerThread
    private final @Nullable zzp zzc(String string) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzh2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzgo.zza((String)string));
            return null;
        }
        return new zzp(string, zzh2.zzah(), zzh2.zzaf(), zzh2.zze(), zzh2.zzae(), zzh2.zzq(), zzh2.zzn(), null, zzh2.zzar(), false, zzh2.zzag(), 0L, 0, zzh2.zzaq(), false, zzh2.zzaa(), zzh2.zzx(), zzh2.zzo(), zzh2.zzan(), null, this.zzb(string).zzf(), "", null, zzh2.zzat(), zzh2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzh2.zza(), zzh2.zzf(), zzh2.zzam(), zzh2.zzak(), 0L, zzh2.zzb());
    }

    public final zzx zzc() {
        return (zzx)zzou.zza(this.zzg);
    }

    public final zzaf zzd() {
        return this.zzm.zzd();
    }

    public final zzai zze(@UnknownInitialization zzou this) {
        return ((zzic)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzar zzf(@UnknownInitialization zzou this) {
        return (zzar)zzou.zza(this.zzd);
    }

    private final zzbb zzz() {
        if (this.zzai == null) {
            this.zzai = new zzpb(this, (zzjh)this.zzm);
        }
        return this.zzai;
    }

    @VisibleForTesting
    @WorkerThread
    private final zzbd zza(String string, zzbd zzbd2, zzjj zzjj2, zzan zzan2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzbd2.zzc() == zzjm.zzc) {
                n2 = zzbd2.zza();
                zzan2.zza(zzjj.zza.zzc, n2);
            } else {
                n2 = 90;
                zzan2.zza(zzjj.zza.zzc, zzam.zzi);
            }
            return new zzbd(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzjm zzjm2 = zzbd2.zzc();
        if (zzjm2 == zzjm.zzd || zzjm2 == zzjm.zzc) {
            n = zzbd2.zza();
            zzan2.zza(zzjj.zza.zzc, n);
        } else {
            zzjj.zza zza2;
            zzjj.zza zza3;
            n = 90;
            zzan zzan3 = zzan2;
            zzjj zzjj3 = zzjj2;
            zzjm zzjm3 = zzjm2;
            String string2 = string;
            zzou zzou2 = this;
            if (zzjm3 == zzjm.zzb && (zza3 = zzou2.zzb.zza(string2, zzjj.zza.zzc)) != zzjm.zza) {
                zzan3.zza(zzjj.zza.zzc, zzam.zzh);
                zza2 = zza3;
            } else {
                boolean bl;
                zza3 = zzou2.zzb.zzb(string2, zzjj.zza.zzc);
                zzjm zzjm4 = zzjj3.zzc();
                boolean bl2 = bl = zzjm4 == zzjm.zzd || zzjm4 == zzjm.zzc;
                if (zza3 == zzjj.zza.zza && bl) {
                    zzan3.zza(zzjj.zza.zzc, zzam.zzc);
                    zza2 = zzjm4;
                } else {
                    zzan3.zza(zzjj.zza.zzc, zzam.zzb);
                    zza2 = zzou2.zzb.zzc(string2, zzjj.zza.zzc) ? zzjm.zzd : zzjm.zzc;
                }
            }
            zzjm2 = zza2;
        }
        boolean bl = this.zzb.zzm(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzjm2 == zzjm.zzc || sortedSet.isEmpty()) {
            return new zzbd(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzbd(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzbd zzd(String string) {
        this.zzl().zzv();
        this.zzt();
        zzbd zzbd2 = this.zzad.get(string);
        if (zzbd2 == null) {
            zzbd2 = this.zzf().zzf(string);
            this.zzad.put(string, zzbd2);
        }
        return zzbd2;
    }

    public final zzgl zzg() {
        return this.zzm.zzk();
    }

    public final zzgo zzj(@UnknownInitialization zzou this) {
        return ((zzic)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzgv zzh() {
        return (zzgv)zzou.zza(this.zzc);
    }

    private final zzgy zzaa() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzhm zzi() {
        return (zzhm)zzou.zza(this.zzb);
    }

    public final zzhv zzl(@UnknownInitialization zzou this) {
        return ((zzic)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzic zza(zzou zzou2) {
        return zzou2.zzm;
    }

    final zzic zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzjj zzb(String string) {
        this.zzl().zzv();
        this.zzt();
        zzjj zzjj2 = this.zzac.get(string);
        if (zzjj2 == null) {
            zzjj2 = this.zzf().zzh(string);
            if (zzjj2 == null) {
                zzjj2 = zzjj.zza;
            }
            this.zza(string, zzjj2);
        }
        return zzjj2;
    }

    public final zzlt zzm() {
        return (zzlt)zzou.zza(this.zzi);
    }

    public final zznp zzn() {
        return this.zzj;
    }

    private final zzoi zzab() {
        return (zzoi)zzou.zza(this.zzf);
    }

    @WorkerThread
    final zzor zza(String string, zzop zzop2) {
        if (!this.zze().zza(zzbn.zzcj)) {
            return new zzor(Collections.emptyList());
        }
        this.zzl().zzv();
        this.zzt();
        List<zzpi> list = this.zzf().zza(string, zzop2, (int)((Integer)zzbn.zzw.zza(null)));
        ArrayList<zzon> arrayList = new ArrayList<zzon>();
        for (zzpi zzpi2 : list) {
            zzon zzon2;
            block5: {
                if (!this.zzf(zzpi2.zze())) continue;
                zzon2 = zzpi2.zzb();
                try {
                    zzgf.zzj.zzb zzb2 = zzpj.zza(zzgf.zzj.zzb(), zzon2.zzb);
                    for (int i = 0; i < zzb2.zza(); ++i) {
                        zzb2.zza(i, ((zzgf.zzk.zza)zzb2.zza(i).zzch()).zzl(this.zzb().currentTimeMillis()));
                    }
                    zzon2.zzb = ((zzgf.zzj)((zzkg)zzb2.zzaj())).zzce();
                    if (!this.zzj().zza(2)) break block5;
                    zzon2.zzf = this.zzp().zza((zzgf.zzj)((zzkg)zzb2.zzaj()));
                }
                catch (zzkp zzkp2) {
                    this.zzj().zzr().zza("Failed to parse queued batch. appId", (Object)string);
                    continue;
                }
            }
            arrayList.add(zzon2);
        }
        return new zzor(arrayList);
    }

    private static zzot zza(@Nullable zzot zzot2) {
        if (zzot2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzot2.zzao()) {
            String string = String.valueOf(((Object)((Object)zzot2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zzot2;
    }

    public final zzos zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzou zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzou> clazz = zzou.class;
        synchronized (zzou.class) {
            if (zza != null) return zza;
            zzpf zzpf2 = (zzpf)Preconditions.checkNotNull((Object)new zzpf(context));
            zza = new zzou(zzpf2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzpj zzp() {
        return (zzpj)zzou.zza(this.zzh);
    }

    public final zzpn zzq(@UnknownInitialization zzou this) {
        return ((zzic)Preconditions.checkNotNull((Object)this.zzm)).zzv();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzh zzh2) {
        try {
            if (zzh2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzac(), (int)0).versionCode;
                if (zzh2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzh2.zzac(), (int)0).versionName;
                String string2 = zzh2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private static @Nullable Boolean zzh(zzp zzp2) {
        Boolean bl = zzp2.zzq;
        if (!TextUtils.isEmpty((CharSequence)zzp2.zzad)) {
            zzjm zzjm2 = com.google.android.gms.measurement.internal.zzd.zza((String)zzp2.zzad).zza();
            switch (zzjm2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzjj zzjj2) {
        if (zzjj2.zzh()) {
            zzou zzou2 = this;
            byte[] byArray = new byte[16];
            zzou2.zzq().zzw().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzp zzp2) {
        Future future = this.zzl().zza((Callable)new zzpa(this, zzp2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzgo.zza((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    private static @Nullable String zza(@Nullable Map<String, List<String>> map, String string) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            if (entry.getValue().isEmpty()) {
                return null;
            }
            return entry.getValue().get(0);
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Deque zzb(zzou zzou2) {
        return zzou2.zzr;
    }

    @WorkerThread
    final List<zzog> zza(zzp zzp2, Bundle bundle) {
        this.zzl().zzv();
        if (!com.google.android.gms.internal.measurement.zzoy.zza() || !this.zze().zze(zzp2.zza, zzbn.zzcp) || zzp2.zza == null) {
            return new ArrayList<zzog>();
        }
        if (bundle != null) {
            int[] nArray = bundle.getIntArray("uriSources");
            long[] lArray = bundle.getLongArray("uriTimestamps");
            if (nArray != null) {
                if (lArray == null || lArray.length != nArray.length) {
                    this.zzj().zzg().zza("Uri sources and timestamps do not match");
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        long l = lArray[i];
                        int n = nArray[i];
                        String string = zzp2.zza;
                        zzar zzar2 = this.zzf();
                        Preconditions.checkNotEmpty((String)string);
                        zzar2.zzv();
                        zzar2.zzam();
                        try {
                            int n2 = zzar2.f_().delete("trigger_uris", "app_id=? and source=? and timestamp_millis<=?", new String[]{string, String.valueOf(n), String.valueOf(l)});
                            zzar2.zzj().zzq().zza("Pruned " + n2 + " trigger URIs. appId, source, timestamp", (Object)string, (Object)n, (Object)l);
                            continue;
                        }
                        catch (SQLiteException sQLiteException) {
                            zzar2.zzj().zzg().zza("Error pruning trigger URIs. appId", zzgo.zza((String)string), (Object)sQLiteException);
                        }
                    }
                }
            }
        }
        return this.zzf().zzj(zzp2.zza);
    }

    public static /* synthetic */ void zza(zzou zzou2, String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Map map2 = map;
        byte[] byArray2 = byArray;
        Throwable throwable2 = throwable;
        int n2 = n;
        zzou2.zza(string, n2, throwable2, byArray2, map2);
    }

    static /* bridge */ /* synthetic */ void zza(zzou zzou2, long l) {
        zzou2.zzaj = l;
    }

    static /* synthetic */ void zza(zzou zzou2, zzpf zzpf2) {
        zzou zzou3 = zzou2;
        zzou3.zzl().zzv();
        zzou zzou4 = zzou3;
        zzou3.zzl = new zzhj(zzou4);
        zzou4 = zzou3;
        zzar zzar2 = new zzar(zzou4);
        zzar2.zzan();
        zzou3.zzd = zzar2;
        zzou3.zze().zza((zzak)Preconditions.checkNotNull((Object)((Object)zzou3.zzb)));
        zzou4 = zzou3;
        zznp zznp2 = new zznp(zzou4);
        zznp2.zzan();
        zzou3.zzj = zznp2;
        zzou4 = zzou3;
        zzx zzx2 = new zzx(zzou4);
        zzx2.zzan();
        zzou3.zzg = zzx2;
        zzou4 = zzou3;
        zzlt zzlt2 = new zzlt(zzou4);
        zzlt2.zzan();
        zzou3.zzi = zzlt2;
        zzou4 = zzou3;
        zzoi zzoi2 = new zzoi(zzou4);
        zzoi2.zzan();
        zzou3.zzf = zzoi2;
        zzou4 = zzou3;
        zzou3.zze = new zzgy(zzou4);
        if (zzou3.zzs != zzou3.zzt) {
            zzou3.zzj().zzg().zza("Not all upload components initialized", (Object)zzou3.zzs, (Object)zzou3.zzt);
        }
        zzou3.zzn = true;
    }

    static /* synthetic */ void zzc(zzou zzou2) {
        zzou2.zzae();
    }

    private zzou(zzpf zzpf2) {
        this(zzpf2, null);
    }

    private zzou(zzpf zzpf2, @Nullable zzic zzic2) {
        Preconditions.checkNotNull((Object)zzpf2);
        this.zzm = zzic2 = zzic.zza((Context)zzpf2.zza, null, null);
        this.zzab = -1L;
        zzou zzou2 = this;
        this.zzk = new zzos(zzou2);
        zzou2 = this;
        zzpj zzpj2 = new zzpj(zzou2);
        zzpj2.zzan();
        this.zzh = zzpj2;
        zzou2 = this;
        zzgv zzgv2 = new zzgv(zzou2);
        zzgv2.zzan();
        this.zzc = zzgv2;
        zzou2 = this;
        zzhm zzhm2 = new zzhm(zzou2);
        zzhm2.zzan();
        this.zzb = zzhm2;
        this.zzac = new HashMap<String, zzjj>();
        this.zzad = new HashMap<String, zzbd>();
        this.zzae = new HashMap<String, zzc>();
        this.zzl().zzb((Runnable)new zzow(this, zzpf2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzv();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    @WorkerThread
    public final void zzr(@UnknownInitialization zzou this) {
        this.zzl().zzv();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzs() {
        int n;
        this.zzl().zzv();
        this.zzt();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzah()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzad();
        int n4 = n2;
        zzou zzou2 = this;
        zzou2.zzl().zzv();
        if (n4 > n3) {
            zzou2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzou2.zza(n3, zzou2.zzy)) {
            zzou2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzou2.zzj().zzq().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzt() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzac() {
        this.zzl().zzv();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzq().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzq().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzgf.zzk.zza zza2) {
        int n;
        int n2;
        String string2;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzp(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzs(string) && !TextUtils.isEmpty((CharSequence)(string2 = zza2.zzz())) && (n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
            zza2.zzo(string2);
        }
        if (this.zzi().zzt(string) && (n = zzpj.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzr(string)) {
            zza2.zzk();
        }
        if (this.zzi().zzo(string)) {
            zza2.zzh();
            if (this.zzb(string).zzh()) {
                zzc zzc2 = this.zzae.get(string);
                if (zzc2 == null || zzc2.zzb + this.zze().zzc(string, zzbn.zzbe) < this.zzb().elapsedRealtime()) {
                    zzc2 = new zzc(this, null);
                    this.zzae.put(string, zzc2);
                }
                zza2.zzk(zzc2.zza);
            }
        }
        if (this.zzi().zzq(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzh zzh2) {
        this.zzl().zzv();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzah()) && TextUtils.isEmpty((CharSequence)zzh2.zzaa())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzh2.zzac()), 204, (Throwable)null, (byte[])null, (Map<String, List<String>>)null);
            return;
        }
        String string = (String)Preconditions.checkNotNull((Object)zzh2.zzac());
        this.zzj().zzq().zza("Fetching remote configuration", (Object)string);
        zzgc.zzd zzd2 = this.zzi().zzc(string);
        ArrayMap arrayMap = null;
        String string2 = this.zzi().zze(string);
        if (zzd2 != null) {
            String string3;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzi().zzd(string)))) {
                if (arrayMap == null) {
                    arrayMap = new ArrayMap();
                }
                arrayMap.put("If-None-Match", string3);
            }
        }
        this.zzu = true;
        zzou zzou2 = this;
        zzox zzox2 = new zzox(zzou2);
        ArrayMap arrayMap2 = arrayMap;
        zzh zzh3 = zzh2;
        zzgv zzgv2 = this.zzh();
        zzgv2.zzv();
        zzgv2.zzam();
        Preconditions.checkNotNull((Object)zzh3);
        Preconditions.checkNotNull((Object)zzox2);
        zzh zzh4 = zzh3;
        Uri.Builder builder = new Uri.Builder();
        String string4 = zzh4.zzah();
        if (TextUtils.isEmpty((CharSequence)string4)) {
            string4 = zzh4.zzaa();
        }
        String string5 = string4;
        builder.scheme((String)zzbn.zze.zza(null)).encodedAuthority((String)zzbn.zzf.zza(null)).path("config/app/" + string5).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "114010").appendQueryParameter("runtime_version", "0");
        String string6 = builder.build().toString();
        try {
            URL uRL = new URI(string6).toURL();
            zzgv2.zzl().zza((Runnable)new zzgw(zzgv2, zzh3.zzac(), uRL, null, (Map)arrayMap2, zzox2));
            return;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
            zzgv2.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzgo.zza((String)zzh3.zzac()), (Object)string6);
            return;
        }
    }

    @WorkerThread
    final void zza(zzh zzh2, zzgf.zzk.zza zza2) {
        Object object4;
        zzan zzan2;
        this.zzl().zzv();
        this.zzt();
        zzan zzan3 = zzan2 = zzan.zza(zza2.zzw());
        Object object2 = zzh2.zzac();
        zzou zzou2 = this;
        zzou2.zzl().zzv();
        zzou2.zzt();
        Object object3 = zzou2.zzb((String)object2);
        switch (object3.zzc()) {
            case zzb: {
                zzan3.zza(zzjj.zza.zza, zzam.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                zzan3.zza(zzjj.zza.zza, object3.zza());
                break;
            }
            default: {
                zzan3.zza(zzjj.zza.zza, zzam.zzi);
            }
        }
        switch (object3.zzd()) {
            case zzb: {
                zzan3.zza(zzjj.zza.zzb, zzam.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                zzan3.zza(zzjj.zza.zzb, object3.zza());
                break;
            }
            default: {
                zzan3.zza(zzjj.zza.zzb, zzam.zzi);
            }
        }
        object3 = zzan2;
        zzan3 = zza2;
        object2 = zzh2.zzac();
        zzou2 = this;
        zzou2.zzl().zzv();
        zzou2.zzt();
        zzbd zzbd2 = zzou2.zza((String)object2, zzou2.zzd((String)object2), zzou2.zzb((String)object2), (zzan)object3);
        zzan3.zzb((Boolean)Preconditions.checkNotNull((Object)zzbd2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)zzbd2.zze())) {
            zzan3.zzh(zzbd2.zze());
        }
        object3 = zzan2;
        zzan3 = zza2;
        object2 = zzh2;
        zzou2 = this;
        zzou2.zzl().zzv();
        zzou2.zzt();
        zzbd2 = null;
        for (Object object4 : zzan3.zzac()) {
            if (!"_npa".equals(object4.zzg())) continue;
            zzbd2 = object4;
            break;
        }
        if (zzbd2 != null) {
            if (((zzan)object3).zza(zzjj.zza.zzd) == zzam.zza) {
                zzpo zzpo2 = zzou2.zzf().zze(((zzh)object2).zzac(), "_npa");
                if (zzpo2 != null) {
                    if ("tcf".equals(zzpo2.zzb)) {
                        ((zzan)object3).zza(zzjj.zza.zzd, zzam.zzg);
                    } else if ("app".equals(zzpo2.zzb)) {
                        ((zzan)object3).zza(zzjj.zza.zzd, zzam.zzf);
                    } else {
                        ((zzan)object3).zza(zzjj.zza.zzd, zzam.zzd);
                    }
                } else {
                    object4 = ((zzh)object2).zzx();
                    if (object4 == null || object4 == Boolean.TRUE && zzbd2.zzc() != 1L || object4 == Boolean.FALSE && zzbd2.zzc() != 0L) {
                        ((zzan)object3).zza(zzjj.zza.zzd, zzam.zzf);
                    } else {
                        ((zzan)object3).zza(zzjj.zza.zzd, zzam.zzd);
                    }
                }
            }
        } else {
            int n = zzou2.zza(((zzh)object2).zzac(), (zzan)object3);
            zzan3.zza((zzgf.zzp)((zzkg)zzgf.zzp.zze().zza("_npa").zzb(zzou2.zzb().currentTimeMillis()).zza((long)n).zzaj()));
            zzou2.zzj().zzq().zza("Setting user property", (Object)"non_personalized_ads(_npa)", (Object)n);
        }
        zza2.zzf(zzan2.toString());
        boolean bl = this.zzb.zzm(zzh2.zzac());
        zzou2 = zza2;
        object3 = zzou2.zzab();
        for (int i = 0; i < object3.size(); ++i) {
            if (!"_tcf".equals(((zzgf.zzf)object3.get(i)).zzg())) continue;
            zzgf.zzf.zza zza3 = (zzgf.zzf.zza)((zzgf.zzf)object3.get(i)).zzch();
            object4 = zza3.zzf();
            for (int j = 0; j < object4.size(); ++j) {
                if (!"_tcfd".equals(((zzgf.zzh)object4.get(j)).zzg())) continue;
                String string = zzoe.zza((String)((zzgf.zzh)object4.get(j)).zzh(), (boolean)bl);
                zza3.zza(j, zzgf.zzh.zze().zza("_tcfd").zzb(string));
                break;
            }
            zzou2.zza(i, zza3);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzgf.zzf.zza zza2, int n, String string) {
        List list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(((zzgf.zzh)list.get(i)).zzg())) continue;
            return;
        }
        zzgf.zzh zzh2 = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_err").zza(Long.valueOf(n).longValue()).zzaj());
        zzgf.zzh zzh3 = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_ev").zzb(string).zzaj());
        zza2.zza(zzh2).zza(zzh3);
    }

    @WorkerThread
    final void zza(zzbl zzbl2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzl().zzv();
        this.zzt();
        String string = zzp2.zza;
        long l = zzbl2.zzd;
        zzgs zzgs2 = zzgs.zza((zzbl)zzbl2);
        String string2 = string;
        zzjh zzjh2 = this;
        zzjh2.zzl().zzv();
        zzpn.zza(zzjh2.zzag == null || zzjh2.zzah == null || !zzjh2.zzah.equals(string2) ? null : zzjh2.zzag, (Bundle)zzgs2.zzc, (boolean)false);
        zzbl2 = zzgs2.zza();
        this.zzp();
        if (!zzpj.zza(zzbl2, zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        if (zzp2.zzs != null) {
            if (zzp2.zzs.contains(zzbl2.zza)) {
                Bundle bundle = zzbl2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbl2 = new zzbl(zzbl2.zza, new zzbg(bundle), zzbl2.zzc, zzbl2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbl2.zza, (Object)zzbl2.zzc);
                return;
            }
        }
        this.zzf().zzq();
        try {
            zzag zzag2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            if (zzpe.zza() && this.zze().zza(zzbn.zzde) && "_s".equals(zzbl2.zza) && !this.zzf().zzi(string, "_s") && zzbl2.zzb.zzb("_sid") != 0L) {
                if (this.zzf().zzi(string, "_f") || this.zzf().zzi(string, "_v")) {
                    this.zzf().zza(string, null, "_sid", this.zza(zzp2.zza, zzbl2));
                } else {
                    this.zzf().zza(string, (Long)(this.zzb().currentTimeMillis() - 15000L), "_sid", this.zza(zzp2.zza, zzbl2));
                }
            }
            long l2 = l;
            string2 = string;
            zzjh2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjh2.zzv();
            zzjh2.zzam();
            if (l2 < 0L) {
                zzjh2.zzj().zzr().zza("Invalid time querying timed out conditional properties", zzgo.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzjh2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzq().zza("User property timed out", (Object)((zzag)object22).zza, (Object)this.zzm.zzk().zzc(((zzag)object22).zzc.zza), ((zzag)object22).zzc.zza());
                if (((zzag)object22).zzg != null) {
                    this.zzc(new zzbl(((zzag)object22).zzg, l), zzp2);
                }
                this.zzf().zza(string, ((zzag)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzjh2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjh2.zzv();
            zzjh2.zzam();
            if (l2 < 0L) {
                zzjh2.zzj().zzr().zza("Invalid time querying expired conditional properties", zzgo.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzjh2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzag)object4.next();
                if (object == null) continue;
                this.zzj().zzq().zza("User property expired", (Object)((zzag)object).zza, (Object)this.zzm.zzk().zzc(((zzag)object).zzc.zza), ((zzag)object).zzc.zza());
                this.zzf().zzh(string, ((zzag)object).zzc.zza);
                if (((zzag)object).zzk != null) {
                    object22.add(((zzag)object).zzk);
                }
                this.zzf().zza(string, ((zzag)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbl)e;
                this.zzc(new zzbl((zzbl)object, l), zzp2);
            }
            long l3 = l;
            String string4 = zzbl2.zza;
            string2 = string;
            zzjh2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzjh2.zzv();
            zzjh2.zzam();
            if (l3 < 0L) {
                zzjh2.zzj().zzr().zza("Invalid time querying triggered conditional properties", zzgo.zza((String)string2), (Object)zzjh2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzjh2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzag2 = (zzag)iterator.next();
                if (zzag2 == null) continue;
                zzpm zzpm2 = zzag2.zzc;
                zzpo zzpo2 = new zzpo((String)Preconditions.checkNotNull((Object)zzag2.zza), zzag2.zzb, zzpm2.zza, l, Preconditions.checkNotNull((Object)zzpm2.zza()));
                if (this.zzf().zza(zzpo2)) {
                    this.zzj().zzq().zza("User property triggered", (Object)zzag2.zza, (Object)this.zzm.zzk().zzc(zzpo2.zzc), zzpo2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzgo.zza((String)zzag2.zza), (Object)this.zzm.zzk().zzc(zzpo2.zzc), zzpo2.zze);
                }
                if (zzag2.zzi != null) {
                    object.add(zzag2.zzi);
                }
                zzag2.zzc = new zzpm(zzpo2);
                zzag2.zze = true;
                this.zzf().zza(zzag2);
            }
            this.zzc(zzbl2, zzp2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzag2 = (zzbl)e;
                this.zzc(new zzbl((zzbl)zzag2, l), zzp2);
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zza(zzbl zzbl2, String string) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 == null || TextUtils.isEmpty((CharSequence)zzh2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzh2);
        if (bl == null) {
            if (!"_ui".equals(zzbl2.zza)) {
                this.zzj().zzr().zza("Could not find package. appId", zzgo.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzgo.zza((String)string));
            return;
        }
        zzp zzp2 = new zzp(string, zzh2.zzah(), zzh2.zzaf(), zzh2.zze(), zzh2.zzae(), zzh2.zzq(), zzh2.zzn(), null, zzh2.zzar(), false, zzh2.zzag(), 0L, 0, zzh2.zzaq(), false, zzh2.zzaa(), zzh2.zzx(), zzh2.zzo(), zzh2.zzan(), null, this.zzb(string).zzf(), "", null, zzh2.zzat(), zzh2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzh2.zza(), zzh2.zzf(), zzh2.zzam(), zzh2.zzak(), 0L, zzh2.zzb());
        this.zzb(zzbl2, zzp2);
    }

    @WorkerThread
    private final void zzb(zzbl zzbl2, zzp zzp2) {
        String string;
        Preconditions.checkNotEmpty((String)zzp2.zza);
        zzgs zzgs2 = zzgs.zza((zzbl)zzbl2);
        this.zzq().zza(zzgs2.zzc, this.zzf().zzc(zzp2.zza));
        this.zzq().zza(zzgs2, this.zze().zzb(zzp2.zza));
        zzbl2 = zzgs2.zza();
        zzp zzp3 = zzp2;
        zzbl zzbl3 = zzbl2;
        zzou zzou2 = this;
        if ("_cmp".equals(zzbl3.zza) && "referrer API v2".equals(zzbl3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbl3.zzb.zzd("gclid")))) {
            zzpm zzpm2 = new zzpm("_lgclid", zzbl3.zzd, (Object)string, "auto");
            zzou2.zza(zzpm2, zzp3);
        }
        this.zza(zzbl2, zzp2);
    }

    @VisibleForTesting
    private final void zza(zzgf.zzk.zza zza2, long l, boolean bl) {
        zzpo zzpo2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzpo2 = (zzpo2 = this.zzf().zze(zza2.zzu(), string)) == null || zzpo2.zze == null ? new zzpo(zza2.zzu(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zzpo(zza2.zzu(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zzpo2.zze + l));
        zzgf.zzp zzp2 = (zzgf.zzp)((zzkg)zzgf.zzp.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza(((Long)zzpo2.zze).longValue()).zzaj());
        boolean bl2 = false;
        int n = zzpj.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzp2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzp2);
        }
        if (l > 0L) {
            this.zzf().zza(zzpo2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzq().zza("Updated engagement user property. scope, value", (Object)string2, zzpo2.zze);
        }
    }

    final void zzu() {
        ++this.zzt;
    }

    @WorkerThread
    private final void zzad() {
        this.zzl().zzv();
        if ((Integer)zzbn.zzbv.zza(null) > 0) {
            this.zzae();
            return;
        }
        for (String string : this.zzr) {
            if (!com.google.android.gms.internal.measurement.zzoy.zza() || !this.zze().zze(string, zzbn.zzcp)) continue;
            this.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)string);
            Intent intent = new Intent();
            intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            intent.setPackage(string);
            this.zzm.zza().sendBroadcast(intent);
        }
        this.zzr.clear();
    }

    @VisibleForTesting
    @WorkerThread
    private final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzq().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzq();
            try {
                boolean bl;
                zzh zzh2 = this.zzf().zzd(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzh2 == null) {
                    this.zzj().zzr().zza("App does not exist in onConfigFetched. appId", zzgo.zza((String)string));
                } else if (bl || n == 404) {
                    String string2 = zzou.zza(map, "Last-Modified");
                    String string3 = zzou.zza(map, "ETag");
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string2, string3)) {
                        return;
                    }
                    zzh2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2, false, false);
                    if (n == 404) {
                        this.zzj().zzw().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzq().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzr() && this.zzag()) {
                        this.zzx();
                    } else if (this.zze().zza(zzbn.zzch) && this.zzh().zzr() && this.zzf().zzq(zzh2.zzac())) {
                        this.zze(zzh2.zzac());
                    } else {
                        this.zzaf();
                    }
                } else {
                    zzh2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzh2, false, false);
                    this.zzj().zzq().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zze.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzaf();
                }
                this.zzf().zzx();
            }
            finally {
                this.zzf().zzr();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzac();
        }
    }

    final void zza(boolean bl) {
        this.zzaf();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string, List<Pair<zzgf.zzj, zzov>> list) {
        this.zzl().zzv();
        this.zzt();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list2 = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (!bl || (n == 200 || n == 204) && throwable == null) {
                this.zzj().zzq().zza("Network upload successful with code, uploadAttempted", (Object)n, (Object)bl);
                try {
                    if (bl) {
                        this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zze.zza(0L);
                    this.zzaf();
                    if (bl) {
                        this.zzj().zzq().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else {
                        this.zzj().zzq().zza("Purged empty bundles");
                    }
                    this.zzf().zzq();
                    try {
                        if (this.zze().zza(zzbn.zzch)) {
                            Object object;
                            if (this.zze().zza(zzbn.zzcj)) {
                                zzov zzov2;
                                HashMap hashMap = new HashMap();
                                for (Pair<zzgf.zzj, zzov> pair2 : list) {
                                    object = (zzgf.zzj)pair2.first;
                                    zzov2 = (zzov)pair2.second;
                                    if (zzov2.zza() == zzlu.zzd) continue;
                                    long l = this.zzf().zza(string, (zzgf.zzj)object, zzov2.zzc(), zzov2.zzd(), zzov2.zza(), null);
                                    if (zzov2.zza() != zzlu.zze || l == -1L || object.zzd().isEmpty()) continue;
                                    hashMap.put(object.zzd(), l);
                                }
                                for (Pair<zzgf.zzj, zzov> pair2 : list) {
                                    object = (zzgf.zzj)pair2.first;
                                    zzov2 = (zzov)pair2.second;
                                    if (zzov2.zza() != zzlu.zzd) continue;
                                    Long l = (Long)hashMap.get(object.zzd());
                                    this.zzf().zza(string, (zzgf.zzj)object, zzov2.zzc(), zzov2.zzd(), zzov2.zza(), l);
                                }
                            } else {
                                for (Pair pair : list) {
                                    Pair<zzgf.zzj, zzov> pair2;
                                    pair2 = (Pair<zzgf.zzj, zzov>)pair.first;
                                    object = (zzov)pair.second;
                                    this.zzf().zza(string, (zzgf.zzj)pair2, ((zzov)object).zzc(), ((zzov)object).zzd(), ((zzov)object).zza(), null);
                                }
                            }
                        }
                        for (Long l : list2) {
                            try {
                                long l2 = l;
                                zzar zzar2 = this.zzf();
                                zzar2.zzv();
                                zzar2.zzam();
                                SQLiteDatabase sQLiteDatabase = zzar2.f_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzar2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzx();
                    }
                    finally {
                        this.zzf().zzr();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzr() && this.zzag()) {
                        this.zzx();
                    } else if (this.zze().zza(zzbn.zzch) && this.zzh().zzr() && this.zzf().zzq(string)) {
                        this.zze(string);
                    } else {
                        this.zzab = -1L;
                        this.zzaf();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzq().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = string2.substring(0, Math.min(32, string2.length()));
                this.zzj().zzw().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable, (Object)string3);
                this.zzj.zze.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list2);
                this.zzaf();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzac();
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(@NonNull String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable zzpi zzpi2) {
        this.zzl().zzv();
        this.zzt();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if ((n == 200 || n == 204) && throwable == null) {
                if (zzpi2 != null) {
                    this.zzf().zza((Long)zzpi2.zza());
                }
                this.zzj().zzq().zza("Successfully uploaded batch from upload queue. appId, status", (Object)string, (Object)n);
                if (this.zze().zza(zzbn.zzch) && this.zzh().zzr() && this.zzf().zzq(string)) {
                    this.zze(string);
                } else {
                    this.zzaf();
                }
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = string2.substring(0, Math.min(32, string2.length()));
                this.zzj().zzw().zza("Network upload failed. Will retry later. appId, status, error", (Object)string, (Object)n, throwable == null ? string3 : throwable);
                if (zzpi2 != null) {
                    this.zzf().zzb((Long)zzpi2.zza());
                }
                this.zzaf();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzac();
        }
    }

    @WorkerThread
    final void zzb(zzh zzh2, zzgf.zzk.zza zza2) {
        this.zzl().zzv();
        this.zzt();
        zzgf.zza.zza zza3 = zzgf.zza.zzc();
        byte[] byArray = zzh2.zzav();
        if (byArray != null) {
            try {
                zza3 = zzpj.zza(zza3, byArray);
            }
            catch (zzkp zzkp2) {
                this.zzj().zzr().zza("Failed to parse locally stored ad campaign info. appId", zzgo.zza((String)zzh2.zzac()));
            }
        }
        for (zzgf.zzf zzf2 : zza2.zzab()) {
            if (!zzf2.zzg().equals("_cmp")) continue;
            zzgf.zzf zzf3 = zzf2;
            zzgf.zza.zza zza4 = zza3;
            zzou zzou2 = this;
            String string = (String)zzpj.zza(zzf3, "gclid", (Object)"");
            String string2 = (String)zzpj.zza(zzf3, "gbraid", (Object)"");
            String string3 = (String)zzpj.zza(zzf3, "gad_source", (Object)"");
            if (string.isEmpty() && string2.isEmpty()) continue;
            long l = (Long)zzpj.zza(zzf3, "click_timestamp", (Object)0L);
            if (l <= 0L) {
                l = zzf3.zzd();
            }
            if ("referrer API v2".equals(zzpj.zzb(zzf3, "_cis"))) {
                if (!(l > zza4.zzb())) continue;
                if (string.isEmpty()) {
                    zza4.zzh();
                } else {
                    zza4.zzf(string);
                }
                if (string2.isEmpty()) {
                    zza4.zzg();
                } else {
                    zza4.zze(string2);
                }
                if (string3.isEmpty()) {
                    zza4.zzf();
                } else {
                    zza4.zzd(string3);
                }
                zza4.zzb(l);
                continue;
            }
            if (!(l > zza4.zza())) continue;
            if (string.isEmpty()) {
                zza4.zze();
            } else {
                zza4.zzc(string);
            }
            if (string2.isEmpty()) {
                zza4.zzd();
            } else {
                zza4.zzb(string2);
            }
            if (string3.isEmpty()) {
                zza4.zzc();
            } else {
                zza4.zza(string3);
            }
            zza4.zza(l);
        }
        if (!((zzgf.zza)((zzkg)zza3.zzaj())).equals((Object)zzgf.zza.zze())) {
            zza2.zza((zzgf.zza)((zzkg)zza3.zzaj()));
        }
        zzh2.zza(((zzgf.zza)((zzkg)zza3.zzaj())).zzce());
        if (zzh2.zzas()) {
            this.zzf().zza(zzh2, false, false);
        }
    }

    @WorkerThread
    final void zzc(zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (this.zze().zza(zzbn.zzbt)) {
            long l;
            long l2 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbn.zzbc);
            this.zze();
            long l3 = l2 - com.google.android.gms.measurement.internal.zzai.zzg();
            for (int i = 0; i < n && this.zzb(null, l = l3); ++i) {
            }
        } else {
            this.zze();
            long l = com.google.android.gms.measurement.internal.zzai.zzh();
            int n = 0;
            while ((long)n < l && this.zzb(zzp2.zza, 0L)) {
                ++n;
            }
        }
        if (this.zze().zza(zzbn.zzbu)) {
            this.zzad();
        }
        if (this.zze().zza(zzbn.zzck) && this.zzk.zza(zzp2.zza, zzgf.zzo.zza.zza((int)zzp2.zzaf))) {
            this.zza(zzp2.zza, this.zzb().currentTimeMillis());
        }
    }

    @WorkerThread
    final void zzd(zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        if (!zzou.zzi(zzp2)) {
            return;
        }
        zzh zzh2 = this.zzf().zzd(zzp2.zza);
        if (zzh2 != null && TextUtils.isEmpty((CharSequence)zzh2.zzah()) && !TextUtils.isEmpty((CharSequence)zzp2.zzb)) {
            zzh2.zzd(0L);
            this.zzf().zza(zzh2, false, false);
            this.zzi().zzj(zzp2.zza);
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        long l = zzp2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzv();
        int n = zzp2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzr().zza("Incorrect app type, assuming installed app. appId, appType", zzgo.zza((String)zzp2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzq();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzar zzar2;
            String string2;
            zzpm zzpm2;
            zzpo zzpo2 = this.zzf().zze(zzp2.zza, "_npa");
            Boolean bl = zzou.zzh(zzp2);
            if (zzpo2 == null || "auto".equals(zzpo2.zzb)) {
                if (bl != null) {
                    zzpm2 = new zzpm("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zzpo2 == null || !zzpo2.zze.equals(zzpm2.zzc)) {
                        this.zza(zzpm2, zzp2);
                    }
                } else if (zzpo2 != null) {
                    this.zza("_npa", zzp2);
                }
            }
            long l2 = l;
            zzp zzp3 = zzp2;
            zzou zzou2 = this;
            Object object3 = zzou2.zzf().zzd((String)Preconditions.checkNotNull((Object)zzp3.zza));
            if (object3 != null) {
                zzou2.zzq();
                if (zzpn.zza((String)zzp3.zzb, (String)((zzh)object3).zzah(), (String)zzp3.zzp, (String)((zzh)object3).zzaa())) {
                    zzou2.zzj().zzr().zza("New GMP App Id passed in. Removing cached database data. appId", zzgo.zza((String)((zzh)object3).zzac()));
                    string2 = ((zzh)object3).zzac();
                    zzar2 = zzou2.zzf();
                    zzar2.zzam();
                    zzar2.zzv();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzar2.f_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzar2.zzj().zzq().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzar2.zzj().zzg().zza("Error deleting application data. appId, error", zzgo.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzh)object3).zze() != Integer.MIN_VALUE && ((zzh)object3).zze() != zzp3.zzj;
                string = ((zzh)object3).zzaf();
                if (bl2 | (((zzh)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzp3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbl("_au", new zzbg(bundle), "auto", l2);
                    zzou2.zza((zzbl)object, zzp3);
                }
            }
            this.zza(zzp2);
            zzpm2 = null;
            if (n == 0) {
                zzpm2 = this.zzf().zzd(zzp2.zza, "_f");
            } else if (n == 1) {
                zzpm2 = this.zzf().zzd(zzp2.zza, "_v");
            }
            if (zzpm2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzpm zzpm3 = new zzpm("_fot", l, (Object)l3, "auto");
                    this.zza(zzpm3, zzp2);
                    zzp3 = zzp2;
                    zzou2 = this;
                    zzou2.zzl().zzv();
                    String string3 = zzp3.zza;
                    zzhj zzhj2 = (zzhj)Preconditions.checkNotNull((Object)zzou2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzhj2.zza.zzj().zzx().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzhj2.zza.zzl().zzv();
                        if (!zzhj2.zza()) {
                            zzhj2.zza.zzj().zzp().zza("Install Referrer Reporter is not available");
                        } else {
                            zzhi zzhi2 = new zzhi(zzhj2, string3);
                            object3 = zzhj2;
                            ((zzhj)object3).zza.zzl().zzv();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzhj)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzhj)object3).zza.zzj().zzx().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzar2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzar2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzar2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzar2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzhj)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzhj)object3).zza.zza(), intent, (ServiceConnection)zzhi2, 1);
                                                ((zzhj)object3).zza.zzj().zzq().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzhj)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzhj)object3).zza.zzj().zzr().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzhj)object3).zza.zzj().zzp().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzp3 = zzp2;
                    zzou2 = this;
                    zzou2.zzl().zzv();
                    zzou2.zzt();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzp3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzp3.zza);
                    object2 = string4;
                    zzar zzar3 = zzou2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzar3.zzv();
                    zzar3.zzam();
                    long l5 = zzar3.zzb((String)object2, "first_open_count");
                    if (zzou2.zzm.zza().getPackageManager() == null) {
                        zzou2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzgo.zza((String)string4));
                    } else {
                        zzar2 = null;
                        try {
                            zzar2 = Wrappers.packageManager((Context)zzou2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzou2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzgo.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzar2 != null && ((PackageInfo)zzar2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzar2).firstInstallTime != ((PackageInfo)zzar2).lastUpdateTime) {
                                if (zzou2.zze().zza(zzbn.zzcc)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zzpm("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zzou2.zza((zzpm)sQLiteDatabase, zzp3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzou2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzou2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzgo.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzar2 = new zzbl("_f", new zzbg((Bundle)object3), "auto", l4);
                    zzou2.zzb((zzbl)zzar2, zzp3);
                } else if (n == 1) {
                    zzpm zzpm4 = new zzpm("_fvt", l, (Object)l3, "auto");
                    this.zza(zzpm4, zzp2);
                    l2 = l;
                    zzp3 = zzp2;
                    zzou2 = this;
                    zzou2.zzl().zzv();
                    zzou2.zzt();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzp3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbl zzbl2 = new zzbl("_v", new zzbg((Bundle)object3), "auto", l2);
                    zzou2.zzb(zzbl2, zzp3);
                }
            } else if (zzp2.zzi) {
                l2 = l;
                zzp3 = zzp2;
                zzou2 = this;
                object3 = new Bundle();
                zzbl zzbl3 = new zzbl("_cd", new zzbg((Bundle)object3), "auto", l2);
                zzou2.zzb(zzbl3, zzp3);
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    final void zzv() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzag zzag2) {
        zzp zzp2 = this.zzc((String)Preconditions.checkNotNull((Object)zzag2.zza));
        if (zzp2 != null) {
            this.zza(zzag2, zzp2);
        }
    }

    @WorkerThread
    final void zza(zzag zzag2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotEmpty((String)zzag2.zza);
        Preconditions.checkNotNull((Object)zzag2.zzc);
        Preconditions.checkNotEmpty((String)zzag2.zzc.zza);
        this.zzl().zzv();
        this.zzt();
        if (!zzou.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        this.zzf().zzq();
        try {
            this.zza(zzp2);
            String string = (String)Preconditions.checkNotNull((Object)zzag2.zza);
            zzag zzag3 = this.zzf().zzc(string, zzag2.zzc.zza);
            if (zzag3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzag2.zza, (Object)this.zzm.zzk().zzc(zzag2.zzc.zza));
                this.zzf().zza(string, zzag2.zzc.zza);
                if (zzag3.zze) {
                    this.zzf().zzh(string, zzag2.zzc.zza);
                }
                if (zzag2.zzk != null) {
                    Bundle bundle = null;
                    if (zzag2.zzk.zzb != null) {
                        bundle = zzag2.zzk.zzb.zzb();
                    }
                    zzbl zzbl2 = this.zzq().zza(string, ((zzbl)Preconditions.checkNotNull((Object)zzag2.zzk)).zza, bundle, zzag3.zzb, zzag2.zzk.zzd, true, true);
                    this.zzc((zzbl)Preconditions.checkNotNull((Object)zzbl2), zzp2);
                }
            } else {
                this.zzj().zzr().zza("Conditional user property doesn't exist", zzgo.zza((String)zzag2.zza), (Object)this.zzm.zzk().zzc(zzag2.zzc.zza));
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @VisibleForTesting
    private static void zza(zzgf.zzf.zza zza2, @NonNull String string) {
        List list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(((zzgf.zzh)list.get(i)).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        if (!zzou.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        Boolean bl = zzou.zzh(zzp2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzpm zzpm2 = new zzpm("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zzpm2, zzp2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzq();
        try {
            this.zza(zzp2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzp2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzp2.zza), string);
            this.zzf().zzx();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zze(zzp zzp2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzp2.zza);
        zzar zzar2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzar2.zzv();
        zzar2.zzam();
        try {
            SQLiteDatabase sQLiteDatabase = zzar2.f_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray) + sQLiteDatabase.delete("upload_queue", "app_id=?", stringArray);
            if (n > 0) {
                zzar2.zzj().zzq().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzar2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzgo.zza((String)string), (Object)sQLiteException);
        }
        if (zzp2.zzh) {
            this.zzd(zzp2);
        }
    }

    @WorkerThread
    private final void zzae() {
        this.zzl().zzv();
        if (!this.zzr.isEmpty() && !this.zzz().zzc()) {
            long l = this.zzb().elapsedRealtime() - this.zzaj;
            long l2 = Math.max(0L, (long)((Integer)zzbn.zzbv.zza(null)).intValue() - l);
            this.zzj().zzq().zza("Scheduling notify next app runnable, delay in ms", (Object)l2);
            this.zzz().zza(l2);
        }
    }

    @WorkerThread
    final void zzf(zzp zzp2) {
        boolean bl;
        zzjm zzjm2;
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)zzp2.zza);
        zzbd zzbd2 = zzbd.zza((String)zzp2.zzz);
        this.zzj().zzq().zza("Setting DMA consent for package", (Object)zzp2.zza, (Object)zzbd2);
        zzbd zzbd3 = zzbd2;
        String string = zzp2.zza;
        zzou zzou2 = this;
        zzou2.zzl().zzv();
        zzou2.zzt();
        zzjm zzjm3 = zzbd.zza((Bundle)zzou2.zza(string), (int)100).zzc();
        zzou2.zzad.put(string, zzbd3);
        zzou2.zzf().zza(string, zzbd3);
        zzjm zzjm4 = zzjm2 = zzbd.zza((Bundle)zzou2.zza(string), (int)100).zzc();
        zzjm zzjm5 = zzjm3;
        String string2 = string;
        zzou zzou3 = zzou2;
        zzou3.zzl().zzv();
        zzou3.zzt();
        boolean bl2 = zzjm5 == zzjm.zzc && zzjm4 == zzjm.zzd;
        boolean bl3 = bl = zzjm5 == zzjm.zzd && zzjm4 == zzjm.zzc;
        if (bl2 || bl) {
            zzou3.zzj().zzq().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zzou3.zzf().zza((long)zzou3.zzy(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zzou3.zze().zzb(string2, zzbn.zzbg)) {
                bundle.putLong("_r", 1L);
                zzas zzas2 = zzou3.zzf().zza(zzou3.zzy(), string2, false, false, false, false, false, true, false);
                zzou3.zzj().zzq().zza("_dcu realtime event count", (Object)string2, (Object)zzas2.zzf);
            }
            zzou3.zzak.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzlw zzlw2) {
        this.zzl().zzv();
        if (this.zzah == null || this.zzah.equals(string) || zzlw2 != null) {
            this.zzah = string;
            this.zzag = zzlw2;
        }
    }

    @WorkerThread
    final void zzg(zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)zzp2.zza);
        int n = zzp2.zzy;
        zzjj zzjj2 = zzjj.zza((String)zzp2.zzt, (int)n);
        this.zzb(zzp2.zza);
        this.zzj().zzq().zza("Setting storage consent for package", (Object)zzp2.zza, (Object)zzjj2);
        this.zza(zzp2.zza, zzjj2);
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzw() {
        this.zzl().zzv();
        this.zzf().zzw();
        zzar zzar2 = this.zzf();
        zzar2.zzv();
        zzar2.zzam();
        if (zzar2.zzab() && (Long)zzbn.zzbp.zza(null) != 0L) {
            String[] stringArray;
            SQLiteDatabase sQLiteDatabase = zzar2.f_();
            int n = sQLiteDatabase.delete("trigger_uris", "abs(timestamp_millis - ?) > cast(? as integer)", stringArray = new String[]{String.valueOf(zzar2.zzb().currentTimeMillis()), String.valueOf(zzbn.zzbp.zza(null))});
            if (n > 0) {
                zzar2.zzj().zzq().zza("Deleted stale trigger uris. rowsDeleted", (Object)n);
            }
        }
        if (this.zzj.zzd.zza() == 0L) {
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzaf();
    }

    @WorkerThread
    final void zzb(zzag zzag2) {
        zzp zzp2 = this.zzc((String)Preconditions.checkNotNull((Object)zzag2.zza));
        if (zzp2 != null) {
            this.zzb(zzag2, zzp2);
        }
    }

    @WorkerThread
    final void zzb(zzag zzag2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotEmpty((String)zzag2.zza);
        Preconditions.checkNotNull((Object)zzag2.zzb);
        Preconditions.checkNotNull((Object)zzag2.zzc);
        Preconditions.checkNotEmpty((String)zzag2.zzc.zza);
        this.zzl().zzv();
        this.zzt();
        if (!zzou.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        zzag zzag3 = new zzag(zzag2);
        new zzag(zzag2).zze = false;
        this.zzf().zzq();
        try {
            boolean bl = false;
            zzag zzag4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzag3.zza), zzag3.zzc.zza);
            if (zzag4 != null && !zzag4.zzb.equals(zzag3.zzb)) {
                this.zzj().zzr().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzag3.zzc.zza), (Object)zzag3.zzb, (Object)zzag4.zzb);
            }
            if (zzag4 != null && zzag4.zze) {
                zzag3.zzb = zzag4.zzb;
                zzag3.zzd = zzag4.zzd;
                zzag3.zzh = zzag4.zzh;
                zzag3.zzf = zzag4.zzf;
                zzag3.zzi = zzag4.zzi;
                zzag3.zze = zzag4.zze;
                zzag3.zzc = new zzpm(zzag3.zzc.zza, zzag4.zzc.zzb, zzag3.zzc.zza(), zzag4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzag3.zzf)) {
                zzag3.zzc = new zzpm(zzag3.zzc.zza, zzag3.zzd, zzag3.zzc.zza(), zzag3.zzc.zze);
                zzag3.zze = true;
                bl = true;
            }
            if (zzag3.zze) {
                zzpm zzpm2 = zzag3.zzc;
                zzpo zzpo2 = new zzpo((String)Preconditions.checkNotNull((Object)zzag3.zza), zzag3.zzb, zzpm2.zza, zzpm2.zzb, Preconditions.checkNotNull((Object)zzpm2.zza()));
                if (this.zzf().zza(zzpo2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzag3.zza, (Object)this.zzm.zzk().zzc(zzpo2.zzc), zzpo2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzgo.zza((String)zzag3.zza), (Object)this.zzm.zzk().zzc(zzpo2.zzc), zzpo2.zze);
                }
                if (bl && zzag3.zzi != null) {
                    zzbl zzbl2 = new zzbl(zzag3.zzi, zzag3.zzd);
                    this.zzc(zzbl2, zzp2);
                }
            }
            if (this.zzf().zza(zzag3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzag3.zza, (Object)this.zzm.zzk().zzc(zzag3.zzc.zza), zzag3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzgo.zza((String)zzag3.zza), (Object)this.zzm.zzk().zzc(zzag3.zzc.zza), zzag3.zzc.zza());
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zza(String string, zzae zzae2) {
        if (!this.zze().zza(zzbn.zzcj)) {
            return;
        }
        this.zzl().zzv();
        this.zzt();
        zzpi zzpi2 = this.zzf().zza(zzae2.zza);
        if (zzpi2 == null) {
            this.zzj().zzr().zza("Queued batch doesn't exist. appId, rowId", (Object)string, (Object)zzae2.zza);
            return;
        }
        String string2 = zzpi2.zze();
        if (zzae2.zzb == zzlv.zza.zza()) {
            if (this.zzaf.containsKey(string2)) {
                this.zzaf.remove(string2);
            }
            this.zzf().zza((Long)zzae2.zza);
            if (zzae2.zzc > 0L) {
                long l = zzae2.zzc;
                String string3 = string;
                zzar zzar2 = this.zzf();
                if (zzar2.zze().zza(zzbn.zzcj)) {
                    zzar2.zzv();
                    zzar2.zzam();
                    Preconditions.checkNotNull((Object)l);
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("upload_type", Integer.valueOf(zzlu.zzb.zza()));
                    contentValues.put("creation_timestamp", Long.valueOf(zzar2.zzb().currentTimeMillis()));
                    try {
                        if ((long)zzar2.f_().update("upload_queue", contentValues, "rowid=? AND app_id=? AND upload_type=?", new String[]{String.valueOf(l), string3, String.valueOf(zzlu.zze.zza())}) != 1L) {
                            zzar2.zzj().zzr().zza("Google Signal pending batch not updated. appId, rowId", (Object)string3, (Object)l);
                        }
                        return;
                    }
                    catch (SQLiteException sQLiteException) {
                        zzar2.zzj().zzg().zza("Failed to update google Signal pending batch. appid, rowId", (Object)string3, (Object)l, (Object)sQLiteException);
                        throw sQLiteException;
                    }
                }
                return;
            }
        } else {
            zzb zzb2 = this.zzaf.get(string2);
            if (zzb2 == null) {
                this.zzaf.put(string2, new zzb(this));
            } else {
                zzb2.zza();
            }
            this.zzf().zzb((Long)zzae2.zza);
        }
    }

    @WorkerThread
    private final void zzaf() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzv();
            this.zzt();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzq().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzaa().zzb();
                    this.zzab().zzr();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzah() || !this.zzag()) {
                this.zzj().zzq().zza("Nothing to upload or uploading impossible");
                this.zzaa().zzb();
                this.zzab().zzr();
                return;
            }
            zzou zzou2 = this;
            long l5 = zzou2.zzb().currentTimeMillis();
            zzou2.zze();
            long l6 = Math.max(0L, (Long)zzbn.zzaj.zza(null));
            boolean bl = zzou2.zzf().zzaa() || zzou2.zzf().zzz();
            if (bl) {
                String string = zzou2.zze().zzp();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzou2.zze();
                    l4 = Math.max(0L, (Long)zzbn.zzae.zza(null));
                } else {
                    zzou2.zze();
                    l4 = Math.max(0L, (Long)zzbn.zzad.zza(null));
                }
            } else {
                zzou2.zze();
                l4 = Math.max(0L, (Long)zzbn.zzac.zza(null));
            }
            long l7 = zzou2.zzj.zzd.zza();
            long l8 = zzou2.zzj.zze.zza();
            long l9 = zzou2.zzf().d_();
            long l10 = zzou2.zzf().e_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzou2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzou2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbn.zzal.zza(null)))) break;
                        long l15 = 1L << n;
                        zzou2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbn.zzak.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzq().zza("Next upload time is 0");
            this.zzaa().zzb();
            this.zzab().zzr();
            return;
        }
        if (!this.zzh().zzr()) {
            this.zzj().zzq().zza("No network");
            this.zzaa().zza();
            this.zzab().zzr();
            return;
        }
        l2 = this.zzj.zzc.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbn.zzaa.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzaa().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbn.zzaf.zza(null));
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzq().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzab().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, zzjj zzjj2) {
        this.zzl().zzv();
        this.zzt();
        this.zzac.put(string, zzjj2);
        this.zzf().zzb(string, zzjj2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzh zzh2 = this.zzf().zzd(string);
        if (zzh2 != null) {
            zzh2.zzd(bl);
            zzh2.zza(l);
            zzh2.zzb(l2);
            if (zzh2.zzas()) {
                this.zzf().zza(zzh2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zzpm zzpm2, zzp zzp2) {
        this.zzl().zzv();
        this.zzt();
        if (!zzou.zzi(zzp2)) {
            return;
        }
        if (!zzp2.zzh) {
            this.zza(zzp2);
            return;
        }
        int n = this.zzq().zzb(zzpm2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzpm2.zza;
            this.zze();
            String string2 = zzpn.zza((String)string, (int)24, (boolean)true);
            int n2 = zzpm2.zza != null ? zzpm2.zza.length() : 0;
            this.zzq();
            zzpn.zza((zzpp)this.zzak, (String)zzp2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzpm2.zza, zzpm2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzpm2.zza;
            this.zze();
            String string3 = zzpn.zza((String)string, (int)24, (boolean)true);
            Object object = zzpm2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzpn.zza((zzpp)this.zzak, (String)zzp2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzpm2.zza, zzpm2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzpm2.zza)) {
            zzbh zzbh2;
            zzp zzp3 = zzp2;
            String string = zzpm2.zze;
            long l = zzpm2.zzb;
            zzou zzou2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzp3.zza);
            long l2 = 0L;
            zzpo zzpo2 = zzou2.zzf().zze(string4, "_sno");
            if (zzpo2 != null && zzpo2.zze instanceof Long) {
                l2 = (Long)zzpo2.zze;
            } else {
                if (zzpo2 != null) {
                    zzou2.zzj().zzr().zza("Retrieved last session number from database does not contain a valid (long) value", zzpo2.zze);
                }
                if ((zzbh2 = zzou2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbh2.zzc;
                    zzou2.zzj().zzq().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbh2 = new zzpm("_sno", l, (Object)(++l2), string);
            zzou2.zza((zzpm)zzbh2, zzp3);
        }
        zzpo zzpo3 = new zzpo((String)Preconditions.checkNotNull((Object)zzp2.zza), (String)Preconditions.checkNotNull((Object)zzpm2.zze), zzpm2.zza, zzpm2.zzb, object);
        this.zzj().zzq().zza("Setting user property", (Object)this.zzm.zzk().zzc(zzpo3.zzc), object);
        this.zzf().zzq();
        try {
            zzpo zzpo4;
            if ("_id".equals(zzpo3.zzc) && (zzpo4 = this.zzf().zze(zzp2.zza, "_id")) != null && !zzpo3.zze.equals(zzpo4.zze)) {
                this.zzf().zzh(zzp2.zza, "_lair");
            }
            this.zza(zzp2);
            boolean bl = this.zzf().zza(zzpo3);
            if ("_sid".equals(zzpm2.zza)) {
                long l = this.zzp().zza(zzp2.zzv);
                zzh zzh2 = this.zzf().zzd(zzp2.zza);
                if (zzh2 != null) {
                    zzh2.zzs(l);
                    if (zzh2.zzas()) {
                        this.zzf().zza(zzh2, false, false);
                    }
                }
            }
            this.zzf().zzx();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zzpo3.zzc), zzpo3.zze);
                this.zzq();
                zzpn.zza((zzpp)this.zzak, (String)zzp2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zzx() {
        this.zzl().zzv();
        this.zzt();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzt().zzad();
            if (bl == null) {
                this.zzj().zzr().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzaf();
                return;
            }
            zzou zzou2 = this;
            zzou2.zzl().zzv();
            if (zzou2.zzz != null) {
                this.zzj().zzq().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzr()) {
                this.zzj().zzq().zza("Network not connected, ignoring upload request");
                this.zzaf();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbn.zzbc);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzai.zzg();
            for (int i = 0; i < n && this.zzb(null, l2 = l4); ++i) {
            }
            if (com.google.android.gms.internal.measurement.zzoy.zza()) {
                this.zzad();
            }
            if ((l = this.zzj.zzd.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().g_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().c_();
                }
                this.zza(string, l3);
            } else {
                zzh zzh2;
                this.zzab = -1L;
                zzar zzar2 = this.zzf();
                this.zze();
                String string2 = zzar2.zzb(l3 - com.google.android.gms.measurement.internal.zzai.zzg());
                if (!TextUtils.isEmpty((CharSequence)string2) && (zzh2 = this.zzf().zzd(string2)) != null) {
                    this.zzb(zzh2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzac();
        }
    }

    @VisibleForTesting
    private final void zza(String string, long l) {
        int n = this.zze().zzb(string, zzbn.zzg);
        String string2 = string;
        Object object = this.zze();
        int n2 = Math.max(0, object.zzb(string2, zzbn.zzh));
        List<Pair<zzgf.zzk, Long>> list = this.zzf().zza(string, n, n2);
        if (!list.isEmpty()) {
            Object object2;
            String string3;
            boolean bl;
            zzgf.zzf zzf2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            zzgf.zzk zzk2;
            Object object8;
            if (this.zzb(string).zzg()) {
                object8 = null;
                Iterator<Pair<zzgf.zzk, Long>> iterator = list.iterator();
                while (iterator.hasNext()) {
                    zzgf.zzk zzk3 = (zzgf.zzk)iterator.next().first;
                    if (zzk3.zzap().isEmpty()) continue;
                    object8 = zzk3.zzap();
                    break;
                }
                if (object8 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzk2 = (zzgf.zzk)list.get((int)i).first;
                        if (zzk2.zzap().isEmpty() || zzk2.zzap().equals(object8)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
            }
            object8 = zzgf.zzj.zzb();
            int n3 = list.size();
            zzk2 = new ArrayList(list.size());
            boolean bl2 = this.zze().zzj(string) && this.zzb(string).zzg();
            boolean bl3 = this.zzb(string).zzg();
            boolean bl4 = this.zzb(string).zzh();
            boolean bl5 = com.google.android.gms.internal.measurement.zzpf.zza() && this.zze().zze(string, zzbn.zzcg);
            zzov zzov2 = this.zzk.zza(string);
            for (int i = 0; i < n3; ++i) {
                Object object9;
                object7 = (zzgf.zzk.zza)((zzgf.zzk)list.get((int)i).first).zzch();
                zzk2.add((Long)list.get((int)i).second);
                this.zze();
                object7.zzm(114010L).zzl(l).zzd(false);
                if (!bl2) {
                    object7.zzk();
                }
                if (!bl3) {
                    object7.zzq();
                    object7.zzn();
                }
                if (!bl4) {
                    object7.zzh();
                }
                this.zza(string, (zzgf.zzk.zza)object7);
                if (!bl5) {
                    object7.zzr();
                }
                if (!bl4) {
                    object7.zzi();
                }
                string2 = object7;
                object = this;
                object6 = string2.zzaa();
                boolean bl6 = false;
                if (TextUtils.isEmpty((CharSequence)object6) || ((String)object6).equals("00000000-0000-0000-0000-000000000000")) {
                    object5 = new ArrayList(string2.zzab());
                    boolean bl7 = false;
                    object4 = object5.iterator();
                    object3 = null;
                    Long l2 = null;
                    while (object4.hasNext()) {
                        zzf2 = (zzgf.zzf)object4.next();
                        if ("_fx".equals(zzf2.zzg())) {
                            bl6 = true;
                            object4.remove();
                            bl7 = true;
                            continue;
                        }
                        if (!"_f".equals(zzf2.zzg())) continue;
                        bl6 = true;
                        ((zzou)object).zzp();
                        zzgf.zzh zzh2 = zzpj.zza(zzf2, "_pfo");
                        if (zzh2 != null) {
                            object3 = zzh2.zzd();
                        }
                        ((zzou)object).zzp();
                        zzgf.zzh zzh3 = zzpj.zza(zzf2, "_uwa");
                        if (zzh3 == null) continue;
                        l2 = zzh3.zzd();
                    }
                    if (bl7) {
                        string2.zzl();
                        string2.zzb((Iterable)object5);
                    }
                    if (bl6) {
                        super.zza(string2.zzu(), true, (Long)object3, l2);
                    }
                }
                if (object7.zzc() == 0) continue;
                if (this.zze().zze(string, zzbn.zzbw)) {
                    object9 = ((zzgf.zzk)((zzkg)object7.zzaj())).zzce();
                    object7.zzb(this.zzp().zza((byte[])object9));
                }
                if (this.zze().zza(zzbn.zzcj)) {
                    zzgf.zzo zzo2 = zzov2.zzb();
                    object9 = zzo2;
                    if (zzo2 != null) {
                        object7.zza((zzgf.zzo)object9);
                    }
                }
                object8.zza((zzgf.zzk.zza)object7);
            }
            if (object8.zza() == 0) {
                this.zza((List<Long>)zzk2);
                this.zza(false, 204, null, null, string, Collections.emptyList());
                return;
            }
            zzgf.zzj zzj2 = (zzgf.zzj)((zzkg)object8.zzaj());
            object7 = new ArrayList();
            boolean bl8 = bl = this.zze().zza(zzbn.zzcj) && zzov2.zza() == zzlu.zzd;
            if (zzov2.zza() == zzlu.zzc || bl) {
                String string42;
                boolean bl9;
                block36: {
                    object6 = ((zzgf.zzj)((zzkg)object8.zzaj())).zzf().iterator();
                    while (object6.hasNext()) {
                        if (!((zzgf.zzk)object6.next()).zzbk()) continue;
                        bl9 = true;
                        break block36;
                    }
                    bl9 = false;
                }
                String string5 = string3 = bl9 ? UUID.randomUUID().toString() : null;
                object6 = (zzgf.zzj)((zzkg)object8.zzaj());
                string2 = string;
                object = this;
                ((zzou)object).zzl().zzv();
                ((zzou)object).zzt();
                object5 = zzgf.zzj.zza((zzgf.zzj)object6);
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    object5.zza(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)(string42 = ((zzou)object).zzi().zzf(string2)))) {
                    object5.zzb(string42);
                }
                object4 = new ArrayList();
                object3 = object6.zzf().iterator();
                while (object3.hasNext()) {
                    zzf2 = zzgf.zzk.zza((zzgf.zzk)((zzgf.zzk)object3.next()));
                    zzf2.zzk();
                    object4.add((zzgf.zzk)((zzkg)zzf2.zzaj()));
                }
                object5.zzb();
                object5.zza((Iterable)object4);
                if (((zzou)object).zze().zza(zzbn.zzci)) {
                    ((zzou)object).zzj().zzq().zza("[sgtm] Processed MeasurementBatch for sGTM with sgtmJoinId: ", (Object)(TextUtils.isEmpty((CharSequence)string5) ? "null" : object5.zzc()));
                } else {
                    ((zzou)object).zzj().zzq().zza("[sgtm] Processed MeasurementBatch for sGTM.");
                }
                zzj2 = (zzgf.zzj)((zzkg)object5.zzaj());
                if (!TextUtils.isEmpty((CharSequence)string3) && this.zze().zza(zzbn.zzci)) {
                    zzov zzov3;
                    object6 = string3;
                    string2 = (zzgf.zzj)((zzkg)object8.zzaj());
                    object = this;
                    ((zzou)object).zzl().zzv();
                    ((zzou)object).zzt();
                    string5 = zzgf.zzj.zzb();
                    ((zzou)object).zzj().zzq().zza("Processing Google Signal, sgtmJoinId:", object6);
                    string5.zza((String)object6);
                    for (String string42 : string2.zzf()) {
                        string5.zza(zzgf.zzk.zzx().zzj(string42.zzaj()).zzg(string42.zzd()));
                    }
                    object2 = (zzgf.zzj)((zzkg)string5.zzaj());
                    boolean bl10 = bl;
                    string2 = string;
                    string5 = ((zzok)this.zzk).zzm().zzf(string2);
                    if (!TextUtils.isEmpty((CharSequence)string5)) {
                        object5 = Uri.parse((String)((String)zzbn.zzr.zza(null)));
                        string42 = object5.buildUpon();
                        object3 = object5.getAuthority();
                        object4 = string5;
                        string42.authority((String)object4 + "." + (String)object3);
                        zzov3 = new zzov(string42.build().toString(), bl10 ? zzlu.zze : zzlu.zzb);
                    } else {
                        zzov3 = new zzov((String)zzbn.zzr.zza(null), bl10 ? zzlu.zze : zzlu.zzb);
                    }
                    object7.add(Pair.create((Object)object2, (Object)zzov3));
                }
                if (bl) {
                    object2 = (zzgf.zzj.zzb)zzj2.zzch();
                    for (int i = 0; i < zzj2.zza(); ++i) {
                        object2.zza(i, ((zzgf.zzk.zza)zzj2.zza(i).zzch()).zzt().zza(l));
                    }
                    object7.add(Pair.create((Object)((zzgf.zzj)((zzkg)object2.zzaj())), (Object)zzov2));
                    this.zza((List<Long>)zzk2);
                    this.zza(false, 204, null, null, string, (List<Pair<zzgf.zzj, zzov>>)object7);
                    if (this.zzf(zzov2.zzc())) {
                        this.zzj().zzq().zza("[sgtm] Sending sgtm batches available notification to app", (Object)string);
                        Intent intent = new Intent();
                        intent.setAction("com.google.android.gms.measurement.BATCHES_AVAILABLE");
                        intent.setPackage(string);
                        this.zzm.zza().sendBroadcast(intent);
                    }
                    return;
                }
            }
            string3 = null;
            if (this.zzj().zza(2)) {
                string3 = this.zzp().zza(zzj2);
            }
            this.zzp();
            object2 = zzj2.zzce();
            this.zza((List<Long>)zzk2);
            this.zzj.zze.zza(l);
            this.zzj().zzq().zza("Uploading data. app, uncompressed size, data", (Object)string, (Object)((byte[])object2).length, (Object)string3);
            this.zzv = true;
            this.zzh().zza(string, zzov2, zzj2, new zzoz(this, string, (List)object7));
        }
    }

    @WorkerThread
    private final void zze(String string) {
        this.zzl().zzv();
        this.zzt();
        this.zzw = true;
        try {
            Object object = this.zzm.zzt().zzad();
            if (object == null) {
                this.zzj().zzr().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (((Boolean)object).booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzaf();
                return;
            }
            if (!this.zzh().zzr()) {
                this.zzj().zzq().zza("Network not connected, ignoring upload request");
                this.zzaf();
                return;
            }
            if (!this.zzf().zzq(string)) {
                this.zzj().zzq().zza("Upload queue has no batches for appId", (Object)string);
                return;
            }
            object = this.zzf().zzi(string);
            if (object == null) {
                return;
            }
            zzgf.zzj zzj2 = ((zzpi)object).zzd();
            if (zzj2 == null) {
                return;
            }
            byte[] byArray = zzj2.zzce();
            if (this.zzj().zza(2)) {
                String string2 = this.zzp().zza(zzj2);
                this.zzj().zzq().zza("Uploading data from upload queue. appId, uncompressed size, data", (Object)string, (Object)byArray.length, (Object)string2);
            }
            this.zzv = true;
            this.zzh().zza(string, ((zzpi)object).zzc(), zzj2, new zzoy(this, string, (zzpi)object));
            return;
        }
        finally {
            this.zzw = false;
            this.zzac();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzgf.zzh.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzpn.zzf((String)zza2.zzf()) || zzpn.zzf((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzpn.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzpn.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzw().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbl var1_1, zzp var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzv();
        this.zzt();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzpj.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzr().zza("Dropping blocked event. appId", zzgo.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzl(var5_4) != false || this.zzi().zzn(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzpn.zza((zzpp)this.zzak, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zzd(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbn.zzai.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzgs.zza((zzbl)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = this.zze().zza(var5_4, zzbn.zzba, 10, 35);
        for (String var10_12 : new TreeSet<E>(var6_6.zzc.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzc.getParcelableArray(var10_12), var7_8);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzq().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        this.zzf().zzq();
        try {
            block73: {
                block74: {
                    block76: {
                        block80: {
                            block79: {
                                block77: {
                                    block78: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block76;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block77;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block78;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block79;
                                    }
                                    var25_19.zzj().zzr().zza("Data lost. Currency value is too big. appId", zzgo.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block80;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbn.zzao) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzv();
                                    var41_32.zzam();
                                    try {
                                        var41_32.f_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '!_ltv!_%' escape '!'order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzgo.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zzpo(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zzpo(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zzpo)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzgo.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzpn.zza((zzpp)var25_19.zzak, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzx();
                            return;
                        }
                    }
                    var11_38 = zzpn.zzg((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzpn.zza((zzbg)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzy(), var5_4, var13_40, true, var11_38, false, var12_39, false, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - com.google.android.gms.measurement.internal.zzai.zzh();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzx();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbn.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzpn.zza((zzpp)this.zzak, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzx();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbn.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzgo.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzx();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 /* !! */  = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44 /* !! */ .zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44 /* !! */ .zze);
                    }
                    if (this.zze().zza(zzbn.zzdb) && Objects.equals(var1_1.zzc, "am") && Objects.equals(var1_1.zza, "_ai") && (var19_44 /* !! */  = var18_43.get("value")) != null && var19_44 /* !! */  instanceof String) {
                        try {
                            var20_46 = Double.parseDouble((String)var19_44 /* !! */ );
                            var18_43.remove("value");
                            var18_43.putDouble("value", var20_46);
                        }
                        catch (NumberFormatException v4) {}
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzr().zza("Data lost. Too many events stored on disk, deleted. appId", zzgo.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_47 = new zzbe(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_48 = this.zzf().zzd(var5_4, var21_47.zzb);
                    if (var22_48 == null) {
                        if (this.zzf().zzb(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzgo.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_47.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzpn.zza((zzpp)this.zzak, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_49 = new zzbh(var5_4, var21_47.zzb, 0L, 0L, var21_47.zzd, 0L, null, null, null, null);
                    } else {
                        var21_47 = var21_47.zza(this.zzm, var22_48.zzf);
                        var23_49 = var22_48.zza(var21_47.zzd);
                    }
                    this.zzf().zza(var23_49);
                    var27_17 = var2_2;
                    var26_18 = var21_47;
                    var25_19 = this;
                    var25_19.zzl().zzv();
                    var25_19.zzt();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzgf.zzk.zzx().zzh(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzv)) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzg(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzjj.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zze());
                    if (var28_14.zzy().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (com.google.android.gms.internal.measurement.zzoy.zza() && var25_19.zze().zze(var27_17.zza, zzbn.zzcp)) {
                        var25_19.zzq();
                        if (zzpn.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzg() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_50 = var30_25;
                                var40_52 /* !! */  = zzgf.zzc.zza();
                                var40_52 /* !! */ .zzc((var37_50 & 1L) != 0L);
                                var40_52 /* !! */ .zze((var37_50 & 2L) != 0L);
                                var40_52 /* !! */ .zzf((var37_50 & 4L) != 0L);
                                var40_52 /* !! */ .zzg((var37_50 & 8L) != 0L);
                                var40_52 /* !! */ .zzb((var37_50 & 16L) != 0L);
                                var40_52 /* !! */ .zza((var37_50 & 32L) != 0L);
                                var40_52 /* !! */ .zzd((var37_50 & 64L) != 0L);
                                var28_14.zza((zzgf.zzc)((zzkg)var40_52 /* !! */ .zzaj()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzd(var27_17.zzf);
                    }
                    var28_14.zze(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzr();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_53 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzjj.zzb((String)var27_17.zzt))).zzg() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_53)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc(((Boolean)var32_23.second).booleanValue());
                        }
                        if (!var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zzd(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            var35_54 = var33_29.zzy();
                            if (var35_54 != null) {
                                var34_35.putLong("_pfo", Math.max(0L, var35_54));
                            }
                            if ((var36_27 = var33_29.zzz()) != null) {
                                var34_35.putLong("_uwa", var36_27.longValue());
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzak.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzad();
                    v5 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzad();
                    v5.zzo(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzc()).zzs(var25_19.zzm.zzg().zzg());
                    var28_14.zzk(var27_17.zzx);
                    if (var25_19.zzm.zzae()) {
                        var28_14.zzu();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zzd(var27_17.zza)) == null) {
                        var32_24 = new zzh(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_53));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_53.zzg()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzh)var42_31, false, false);
                    }
                    if (var31_53.zzh() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzk(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_54 = zzgf.zzp.zze().zza(((zzpo)var33_29.get((int)var34_36)).zzc).zzb(((zzpo)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzgf.zzp.zza)var35_54, ((zzpo)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzgf.zzp.zza)var35_54);
                        if (!"_sid".equals(((zzpo)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzgf.zzk)((zzkg)var28_14.zzaj()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzgo.zza((String)var28_14.zzu()), (Object)var36_28);
                        break block73;
                    }
                    v6 = var25_19.zzf();
                    var38_55 = var26_18;
                    var37_51 = var25_19;
                    if (var38_55.zzf == null) ** GOTO lbl-1000
                    for (zzgf.zzc.zza var40_52 : var38_55.zzf) {
                        if (!"_r".equals(var40_52 /* !! */ )) continue;
                        v7 = true;
                        break block74;
                    }
                    var39_57 = var37_51.zzi().zzc(var38_55.zza, var38_55.zzb);
                    var40_52 /* !! */  = var37_51.zzf().zza(var37_51.zzy(), var38_55.zza, false, false, false, false, false, false, false);
                    if (var39_57 && var40_52 /* !! */ .zze < (long)var37_51.zze().zzc(var38_55.zza)) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                }
                if (v6.zza((zzbe)var26_18, var34_37, v7)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzx();
        }
        finally {
            this.zzf().zzr();
        }
        this.zzaf();
        this.zzj().zzq().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzi(zzp zzp2) {
        return !TextUtils.isEmpty((CharSequence)zzp2.zzb) || !TextUtils.isEmpty((CharSequence)zzp2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zzb(@Nullable String var1_1, long var2_2) {
        this.zzf().zzq();
        try {
            block174: {
                block172: {
                    var4_3 = new zza(null);
                    var35_4 = var4_3;
                    var33_6 = this.zzab;
                    var31_12 = var2_2;
                    var30_19 = var1_1;
                    var29_20 = this.zzf();
                    Preconditions.checkNotNull((Object)var35_4);
                    var29_20.zzv();
                    var29_20.zzam();
                    var36_21 = null;
                    try {
                        var37_27 /* !! */  = var29_20.f_();
                        if (TextUtils.isEmpty((CharSequence)var30_19)) {
                            var39_33 = var33_6 != -1L ? new String[]{String.valueOf(var33_6), String.valueOf(var31_12)} : new String[]{String.valueOf(var31_12)};
                            var48_35 = var33_6 != -1L ? "rowid <= ? and " : "";
                            var36_21 = var37_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var48_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var39_33);
                            if (!var36_21.moveToFirst()) break block172;
                            var30_19 = var36_21.getString(0);
                            var38_36 = var36_21.getString(1);
                            var36_21.close();
                        } else {
                            var39_33 = var33_6 != -1L ? new String[]{var30_19, String.valueOf(var33_6)} : new String[]{var30_19};
                            var48_35 = var33_6 != -1L ? " and rowid <= ?" : "";
                            var36_21 = var37_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var48_35 + " order by rowid limit 1;", (String[])var39_33);
                            if (!var36_21.moveToFirst()) break block172;
                            var38_36 = var36_21.getString(0);
                            var36_21.close();
                        }
                        var36_21 = var37_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var30_19, var38_36}, null, null, "rowid", "2");
                        if (!var36_21.moveToFirst()) {
                            var29_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzgo.zza((String)var30_19));
                            break block172;
                        }
                        var39_33 = var36_21.getBlob(0);
                        try {
                            var40_37 /* !! */  = (zzgf.zzk)((zzkg)zzpj.zza(zzgf.zzk.zzx(), (byte[])var39_33).zzaj());
                        }
                        catch (IOException var41_38) {
                            var29_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzgo.zza((String)var30_19), (Object)var41_38);
                            if (var36_21 != null) {
                                var36_21.close();
                            }
                            break block172;
                        }
                        if (var36_21.moveToNext()) {
                            var29_20.zzj().zzr().zza("Get multiple raw event metadata records, expected one. appId", zzgo.zza((String)var30_19));
                        }
                        var36_21.close();
                        var35_4.zza(var40_37 /* !! */ );
                        if (var33_6 != -1L) {
                            var41_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            var42_41 = new String[]{var30_19, var38_36, String.valueOf(var33_6)};
                        } else {
                            var41_39 = "app_id = ? and metadata_fingerprint = ?";
                            var42_41 = new String[]{var30_19, var38_36};
                        }
                        var36_21 = var37_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var41_39, var42_41, null, null, "rowid", null);
                        if (!var36_21.moveToFirst()) {
                            var29_20.zzj().zzr().zza("Raw event data disappeared while in transaction. appId", zzgo.zza((String)var30_19));
                            break block172;
                        }
                        do {
                            var43_42 = var36_21.getLong(0);
                            var39_33 = var36_21.getBlob(3);
                            try {
                                var45_44 = zzpj.zza(zzgf.zzf.zze(), (byte[])var39_33);
                            }
                            catch (IOException var46_46) {
                                var29_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzgo.zza((String)var30_19), (Object)var46_46);
                                continue;
                            }
                            var45_44.zza(var36_21.getString(1)).zzb(var36_21.getLong(2));
                            if (!var35_4.zza(var43_42, (zzgf.zzf)((zzkg)var45_44.zzaj()))) break;
                        } while (var36_21.moveToNext());
                    }
                    catch (SQLiteException var37_28) {
                        var29_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzgo.zza((String)var30_19), (Object)var37_28);
                    }
                    finally {
                        if (var36_21 != null) {
                            var36_21.close();
                        }
                    }
                }
                var29_20 = var4_3;
                if (var29_20.zzc == null || var29_20.zzc.isEmpty() != false) break block174;
                var5_49 = false;
                var6_50 = ((zzgf.zzk.zza)var4_3.zza.zzch()).zzl();
                var7_51 = 0;
                var8_52 = 0L;
                var10_53 = null;
                var11_54 = -1;
                var12_55 = null;
                var13_56 = -1;
                var14_57 = false;
                for (var15_58 = 0; var15_58 < var4_3.zzc.size(); ++var15_58) {
                    block176: {
                        block175: {
                            var16_59 = var5_49;
                            var17_62 = (zzgf.zzf.zza)var4_3.zzc.get(var15_58).zzch();
                            if (this.zzi().zzd(var4_3.zza.zzab(), var17_62.zze())) {
                                this.zzj().zzr().zza("Dropping blocked raw event. appId", zzgo.zza((String)var4_3.zza.zzab()), (Object)this.zzm.zzk().zza(var17_62.zze()));
                                if (this.zzi().zzl(var4_3.zza.zzab()) != false || this.zzi().zzn(var4_3.zza.zzab()) != false || "_err".equals(var17_62.zze())) continue;
                                this.zzq();
                                zzpn.zza((zzpp)this.zzak, (String)var4_3.zza.zzab(), (int)11, (String)"_ev", (String)var17_62.zze(), (int)0);
                                continue;
                            }
                            if (com.google.android.gms.internal.measurement.zznp.zza() && this.zze().zza(zzbn.zzda) && ((var29_20 = var17_62.zze()).equals("purchase") != false || var29_20.equals("_iap") != false || var29_20.equals("ecommerce_purchase") != false)) {
                                var17_62.zza((zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_cbs").zzb(var14_57 == false && ((var29_20 = this).zza((String)(var30_19 = var4_3.zza.zzab()), "purchase") != false && super.zza((String)var30_19, "_iap") != false && super.zza((String)var30_19, "ecommerce_purchase") != false) != false ? zzjn.zza : zzjn.zzb).zzaj()));
                                var14_57 = true;
                            }
                            if (var17_62.zze().equals(zzjp.zza((String)"_ai"))) {
                                var17_62.zza("_ai");
                                this.zzj().zzq().zza("Renaming ad_impression to _ai");
                                if (this.zzj().zza(5)) {
                                    for (var18_65 = 0; var18_65 < var17_62.zza(); ++var18_65) {
                                        if (!"ad_platform".equals(var17_62.zzb(var18_65).zzg()) || var17_62.zzb(var18_65).zzh().isEmpty() || !"admob".equalsIgnoreCase(var17_62.zzb(var18_65).zzh())) continue;
                                        this.zzj().zzw().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                    }
                                }
                            }
                            if ((var18_65 = this.zzi().zzc(var4_3.zza.zzab(), var17_62.zze())) != 0) break block175;
                            this.zzp();
                            var29_20 = var17_62.zze();
                            Preconditions.checkNotEmpty((String)var29_20);
                            var31_13 = var29_20;
                            var32_99 = -1;
                            switch (var31_13.hashCode()) {
                                case 95027: {
                                    if (!var31_13.equals("_ui")) break;
                                    var32_99 = 0;
                                }
                            }
                            switch (var32_99) {
                                case 0: {
                                    v0 = true;
                                    break;
                                }
                                default: {
                                    v0 = false;
                                }
                            }
                            if (!v0) break block176;
                        }
                        var19_69 = 0;
                        var20_74 = 0;
                        for (var21_78 = 0; var21_78 < var17_62.zza(); ++var21_78) {
                            if ("_c".equals(var17_62.zzb(var21_78).zzg())) {
                                var22_82 = (zzgf.zzh)((zzkg)((zzgf.zzh.zza)var17_62.zzb(var21_78).zzch()).zza(1L).zzaj());
                                var19_69 = 1;
                                var17_62.zza(var21_78, var22_82);
                                continue;
                            }
                            if (!"_r".equals(var17_62.zzb(var21_78).zzg())) continue;
                            var22_82 = (zzgf.zzh)((zzkg)((zzgf.zzh.zza)var17_62.zzb(var21_78).zzch()).zza(1L).zzaj());
                            var20_74 = 1;
                            var17_62.zza(var21_78, var22_82);
                        }
                        if (var19_69 == 0 && var18_65 != 0) {
                            this.zzj().zzq().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var17_62.zze()));
                            var17_62.zza(zzgf.zzh.zze().zza("_c").zza(1L));
                        }
                        if (var20_74 == 0) {
                            this.zzj().zzq().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var17_62.zze()));
                            var17_62.zza(zzgf.zzh.zze().zza("_r").zza(1L));
                        }
                        var5_49 = true;
                        if (this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzab())) {
                            zzou.zza(var17_62, "_r");
                            var5_49 = var16_59;
                        }
                        if (zzpn.zzg((String)var17_62.zze()) && var18_65 != 0 && this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzab(), zzbn.zzn)) {
                            this.zzj().zzr().zza("Too many conversions. Not logging as conversion. appId", zzgo.zza((String)var4_3.zza.zzab()));
                            var23_86 = false;
                            var24_90 /* !! */  = null;
                            var25_91 = -1;
                            for (var26_95 = 0; var26_95 < var17_62.zza(); ++var26_95) {
                                var27_98 = var17_62.zzb(var26_95);
                                if ("_c".equals(var27_98.zzg())) {
                                    var24_90 /* !! */  = (zzgf.zzh.zza)var27_98.zzch();
                                    var25_91 = var26_95;
                                    continue;
                                }
                                if (!"_err".equals(var27_98.zzg())) continue;
                                var23_86 = true;
                            }
                            if (var23_86 && var24_90 /* !! */  != null) {
                                var17_62.zza(var25_91);
                            } else if (var24_90 /* !! */  != null) {
                                var26_96 = (zzgf.zzh)((zzkg)((zzgf.zzh.zza)((zzkg.zza)var24_90 /* !! */ .clone())).zza("_err").zza(10L).zzaj());
                                var17_62.zza(var25_91, var26_96);
                            } else {
                                this.zzj().zzg().zza("Did not find conversion parameter. appId", zzgo.zza((String)var4_3.zza.zzab()));
                            }
                        }
                    }
                    if (var18_65 != 0) {
                        var30_19 = var17_62;
                        var29_20 = this;
                        var31_13 = new ArrayList<E>(var30_19.zzf());
                        var32_99 = -1;
                        var33_7 = -1;
                        for (var34_104 = 0; var34_104 < var31_13.size(); ++var34_104) {
                            if ("value".equals(((zzgf.zzh)var31_13.get(var34_104)).zzg())) {
                                var32_99 = var34_104;
                                continue;
                            }
                            if (!"currency".equals(((zzgf.zzh)var31_13.get(var34_104)).zzg())) continue;
                            var33_7 = var34_104;
                        }
                        if (var32_99 != -1) {
                            if (!((zzgf.zzh)var31_13.get(var32_99)).zzl() && !((zzgf.zzh)var31_13.get(var32_99)).zzj()) {
                                var29_20.zzj().zzw().zza("Value must be specified with a numeric type.");
                                var30_19.zza(var32_99);
                                zzou.zza((zzgf.zzf.zza)var30_19, "_c");
                                zzou.zza((zzgf.zzf.zza)var30_19, 18, "value");
                            } else {
                                var34_104 = 0;
                                if (var33_7 == -1) {
                                    var34_104 = 1;
                                } else {
                                    var35_4 = ((zzgf.zzh)var31_13.get(var33_7)).zzh();
                                    if (var35_4.length() != 3) {
                                        var34_104 = 1;
                                    } else {
                                        for (var36_22 = 0; var36_22 < var35_4.length(); var36_22 += Character.charCount(var37_29)) {
                                            var37_29 = var35_4.codePointAt(var36_22);
                                            if (Character.isLetter(var37_29)) continue;
                                            var34_104 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (var34_104 != 0) {
                                    var29_20.zzj().zzw().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    var30_19.zza(var32_99);
                                    zzou.zza((zzgf.zzf.zza)var30_19, "_c");
                                    zzou.zza((zzgf.zzf.zza)var30_19, 19, "currency");
                                }
                            }
                        }
                    }
                    if ("_e".equals(var17_62.zze())) {
                        this.zzp();
                        if (zzpj.zza((zzgf.zzf)((zzkg)var17_62.zzaj()), "_fr") == null) {
                            if (var12_55 != null && Math.abs(var12_55.zzc() - var17_62.zzc()) <= 1000L) {
                                var19_70 = (zzgf.zzf.zza)((zzkg.zza)var12_55.clone());
                                if (this.zza(var17_62, var19_70)) {
                                    var10_53 = null;
                                    var12_55 = null;
                                    var6_50.zza(var13_56, var19_70);
                                } else {
                                    var10_53 = var17_62;
                                    var11_54 = var7_51;
                                }
                            } else {
                                var10_53 = var17_62;
                                var11_54 = var7_51;
                            }
                        }
                    } else if ("_vs".equals(var17_62.zze())) {
                        this.zzp();
                        if (zzpj.zza((zzgf.zzf)((zzkg)var17_62.zzaj()), "_et") == null) {
                            if (var10_53 != null && Math.abs(var10_53.zzc() - var17_62.zzc()) <= 1000L) {
                                var19_71 = (zzgf.zzf.zza)((zzkg.zza)var10_53.clone());
                                if (this.zza(var19_71, var17_62)) {
                                    var10_53 = null;
                                    var12_55 = null;
                                    var6_50.zza(var11_54, var19_71);
                                } else {
                                    var12_55 = var17_62;
                                    var13_56 = var7_51;
                                }
                            } else {
                                var12_55 = var17_62;
                                var13_56 = var7_51;
                            }
                        }
                    }
                    if (var17_62.zza() != 0) {
                        this.zzp();
                        var19_72 = zzpj.zza(var17_62.zzf());
                        for (var20_74 = 0; var20_74 < var17_62.zza(); ++var20_74) {
                            var21_79 = var17_62.zzb(var20_74);
                            if (var21_79.zzg().equals("items") && !var21_79.zzi().isEmpty()) {
                                var33_8 = var19_72;
                                var32_100 = var4_3.zza.zzab();
                                var31_14 = var17_62;
                                var30_19 = var21_79;
                                var29_20 = this;
                                var34_105 = var30_19.zzi();
                                var35_4 = new Bundle[var34_105.size()];
                                for (var36_23 = 0; var36_23 < var34_105.size(); ++var36_23) {
                                    var37_30 = (zzgf.zzh)var34_105.get(var36_23);
                                    var29_20.zzp();
                                    var38_36 = zzpj.zza(var37_30.zzi());
                                    for (zzgf.zzk var40_37 : var37_30.zzi()) {
                                        super.zza(var31_14.zze(), (zzgf.zzh.zza)var40_37 /* !! */ .zzch(), (Bundle)var38_36, var32_100);
                                    }
                                    var35_4[var36_23] = var38_36;
                                }
                                var33_8.putParcelableArray("items", (Parcelable[])var35_4);
                                continue;
                            }
                            if (var21_79.zzg().equals("items")) continue;
                            this.zza(var17_62.zze(), (zzgf.zzh.zza)var21_79.zzch(), var19_72, var4_3.zza.zzab());
                        }
                        var31_14 = var17_62;
                        var30_19 = var19_72;
                        var29_20 = this;
                        var31_14.zzd();
                        var35_4 = var30_19;
                        var34_106 = var29_20.zzp();
                        var36_24 = new ArrayList<zzgf.zzh>();
                        for (String var38_36 : var35_4.keySet()) {
                            var39_33 = zzgf.zzh.zze().zza(var38_36);
                            var40_37 /* !! */  = var35_4.get(var38_36);
                            if (var40_37 /* !! */  == null) continue;
                            var34_106.zza((zzgf.zzh.zza)var39_33, (Object)var40_37 /* !! */ );
                            var36_24.add((zzgf.zzh)((zzkg)var39_33.zzaj()));
                        }
                        var52_108 = var36_24;
                        var53_109 = var52_108.size();
                        for (var54_110 = 0; var54_110 < var53_109; ++var54_110) {
                            v1 = var52_108.get(var54_110);
                            var33_9 = (zzgf.zzh)v1;
                            var31_14.zza(var33_9);
                        }
                    }
                    var4_3.zzc.set(var15_58, (zzgf.zzf)((zzkg)var17_62.zzaj()));
                    ++var7_51;
                    var6_50.zza(var17_62);
                }
                for (var15_58 = 0; var15_58 < var7_51; ++var15_58) {
                    var16_60 = var6_50.zza(var15_58);
                    if ("_e".equals(var16_60.zzg())) {
                        this.zzp();
                        if (zzpj.zza(var16_60, "_fr") != null) {
                            var6_50.zzb(var15_58);
                            --var7_51;
                            --var15_58;
                            continue;
                        }
                    }
                    this.zzp();
                    var17_62 = zzpj.zza(var16_60, "_et");
                    if (var17_62 == null || (var18_67 = var17_62.zzl() != false ? Long.valueOf(var17_62.zzd()) : null) == null || var18_67 <= 0L) continue;
                    var8_52 += var18_67.longValue();
                }
                this.zza(var6_50, var8_52, false);
                var15_58 = 0;
                for (zzgf.zzf.zza var17_62 : var6_50.zzab()) {
                    if (!"_s".equals(var17_62.zzg())) continue;
                    var15_58 = 1;
                    break;
                }
                if (var15_58 != 0) {
                    this.zzf().zzh(var6_50.zzu(), "_se");
                }
                if (zzpj.zza(var6_50, "_sid") >= 0) {
                    this.zza(var6_50, var8_52, true);
                } else {
                    var17_63 = zzpj.zza(var6_50, "_se");
                    if (var17_63 >= 0) {
                        var6_50.zzc(var17_63);
                        this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzgo.zza((String)var4_3.zza.zzab()));
                    }
                }
                var31_15 = var6_50;
                var30_19 = var4_3.zza.zzab();
                var29_20 = this;
                var29_20.zzl().zzv();
                var29_20.zzt();
                var32_101 = var29_20.zzf().zzd((String)var30_19);
                if (var32_101 == null) {
                    var29_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzgo.zza((String)var30_19));
                } else {
                    var29_20.zza((zzh)var32_101, var31_15);
                }
                var31_15 = var6_50;
                var30_19 = var4_3.zza.zzab();
                var29_20 = this;
                var29_20.zzl().zzv();
                var29_20.zzt();
                var32_101 = var29_20.zzf().zzd((String)var30_19);
                if (var32_101 == null) {
                    var29_20.zzj().zzr().zza("Cannot populate ad_campaign_info without appInfo. appId", zzgo.zza((String)var30_19));
                } else {
                    var29_20.zzb((zzh)var32_101, var31_15);
                }
                var29_20 = var6_50;
                var29_20.zzj(0x7FFFFFFFFFFFFFFFL).zzf(-9223372036854775808L);
                for (var31_16 = 0; var31_16 < var29_20.zzc(); ++var31_16) {
                    var32_101 = var29_20.zza(var31_16);
                    if (var32_101.zzd() < var29_20.zzf()) {
                        var29_20.zzj(var32_101.zzd());
                    }
                    if (var32_101.zzd() <= var29_20.zze()) continue;
                    var29_20.zzf(var32_101.zzd());
                }
                var6_50.zzs();
                var17_64 = this.zzb(var4_3.zza.zzab()).zza(zzjj.zzb((String)var4_3.zza.zzag()));
                var18_68 = this.zzf().zzg(var4_3.zza.zzab());
                this.zzf().zza(var4_3.zza.zzab(), var17_64);
                if (!var17_64.zzh() && var18_68.zzh()) {
                    this.zzf().zzo(var4_3.zza.zzab());
                } else if (var17_64.zzh() && !var18_68.zzh()) {
                    this.zzf().zzp(var4_3.zza.zzab());
                }
                var30_19 = var17_64;
                var29_20 = var6_50;
                if (!var30_19.zzg()) {
                    var29_20.zzq();
                    var29_20.zzn();
                    var29_20.zzk();
                }
                if (!var30_19.zzh()) {
                    var29_20.zzh();
                    var29_20.zzr();
                }
                if (com.google.android.gms.internal.measurement.zzoy.zza() && this.zze().zze(var4_3.zza.zzab(), zzbn.zzcp)) {
                    this.zzq();
                    ** if (!zzpn.zzd((String)var4_3.zza.zzab()) || !this.zzb((String)var4_3.zza.zzab()).zzg() || !var4_3.zza.zzav()) goto lbl467
                    for (var19_69 = 0; var19_69 < var6_50.zzc(); ++var19_69) {
                        var20_76 = (zzgf.zzf.zza)var6_50.zza(var19_69).zzch();
                        var21_78 = 0;
                        for (zzgf.zzh var23_88 : var20_76.zzf()) {
                            if (!"_c".equals(var23_88 /* !! */ .zzg())) continue;
                            var21_78 = 1;
                            break;
                        }
                        if (var21_78 == 0) continue;
                        if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzab(), zzbn.zzbf)) {
                            var22_85 = this.zze().zzb(var4_3.zza.zzab(), zzbn.zzbs);
                            if (var22_85 > 0) {
                                if (this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzg > (long)var22_85) {
                                    var24_90 /* !! */  = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_tnr").zza(1L).zzaj());
                                    var20_76.zza((zzgf.zzh)var24_90 /* !! */ );
                                } else {
                                    var24_90 /* !! */  = null;
                                    if (this.zze().zze(var4_3.zza.zzab(), zzbn.zzcr)) {
                                        var24_90 /* !! */  = this.zzq().zzq();
                                        var25_93 = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_tu").zzb((String)var24_90 /* !! */ ).zzaj());
                                        var20_76.zza((zzgf.zzh)var25_93);
                                    }
                                    var25_93 = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_tr").zza(1L).zzaj());
                                    var20_76.zza((zzgf.zzh)var25_93);
                                    var26_97 = this.zzp().zza(var4_3.zza.zzab(), var6_50, var20_76, (String)var24_90 /* !! */ );
                                    if (var26_97 != null) {
                                        this.zzj().zzq().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzab(), (Object)var26_97.zza);
                                        this.zzf().zza(var4_3.zza.zzab(), var26_97);
                                        if (!this.zzr.contains(var4_3.zza.zzab())) {
                                            this.zzr.add(var4_3.zza.zzab());
                                        }
                                    }
                                }
                            } else {
                                var23_88 /* !! */  = null;
                                if (this.zze().zze(var4_3.zza.zzab(), zzbn.zzcr)) {
                                    var23_88 /* !! */  = this.zzq().zzq();
                                    var24_90 /* !! */  = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_tu").zzb((String)var23_88 /* !! */ ).zzaj());
                                    var20_76.zza((zzgf.zzh)var24_90 /* !! */ );
                                }
                                var24_90 /* !! */  = (zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_tr").zza(1L).zzaj());
                                var20_76.zza((zzgf.zzh)var24_90 /* !! */ );
                                var25_93 = this.zzp().zza(var4_3.zza.zzab(), var6_50, var20_76, (String)var23_88 /* !! */ );
                                if (var25_93 != null) {
                                    this.zzj().zzq().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzab(), (Object)var25_93.zza);
                                    this.zzf().zza(var4_3.zza.zzab(), var25_93);
                                    if (!this.zzr.contains(var4_3.zza.zzab())) {
                                        this.zzr.add(var4_3.zza.zzab());
                                    }
                                }
                            }
                        }
                        var6_50.zza(var19_69, (zzgf.zzf)((zzkg)var20_76.zzaj()));
lbl-1000:
                        // 2 sources

                        {
                            continue;
                        }
                    }
                }
lbl467:
                // 4 sources

                var6_50.zzi().zza(this.zzc().zza(var6_50.zzu(), var6_50.zzab(), var6_50.zzac(), var6_50.zzf(), var6_50.zze(), var17_64.zzh() == false));
                if (this.zze().zzk(var4_3.zza.zzab())) {
                    var31_17 = var4_3;
                    var30_19 = var6_50;
                    var29_20 = this;
                    var32_101 = new HashMap<K, V>();
                    var33_10 = new ArrayList<zzgf.zzf>();
                    var34_107 = var29_20.zzq().zzw();
                    for (var35_5 = 0; var35_5 < var30_19.zzc(); ++var35_5) {
                        block173: {
                            var36_25 = (zzgf.zzf.zza)var30_19.zza(var35_5).zzch();
                            if (var36_25.zze().equals("_ep")) {
                                var29_20.zzp();
                                var37_27 /* !! */  = (String)zzpj.zzb((zzgf.zzf)((zzkg)var36_25.zzaj()), "_en");
                                var38_36 = (zzbh)var32_101.get(var37_27 /* !! */ );
                                if (var38_36 == null && (var38_36 = var29_20.zzf().zzd(var31_17.zza.zzab(), (String)Preconditions.checkNotNull((Object)var37_27 /* !! */ ))) != null) {
                                    var32_101.put(var37_27 /* !! */ , var38_36);
                                }
                                if (var38_36 != null && var38_36.zzi == null) {
                                    if (var38_36.zzj != null && var38_36.zzj > 1L) {
                                        var29_20.zzp();
                                        zzpj.zza(var36_25, "_sr", (Object)var38_36.zzj);
                                    }
                                    if (var38_36.zzk != null && var38_36.zzk.booleanValue()) {
                                        var29_20.zzp();
                                        zzpj.zza(var36_25, "_efs", (Object)1L);
                                    }
                                    var33_10.add((zzgf.zzf)((zzkg)var36_25.zzaj()));
                                }
                                var30_19.zza(var35_5, var36_25);
                                continue;
                            }
                            var37_32 = var29_20.zzi().zza(var31_17.zza.zzab());
                            var29_20.zzq();
                            var39_34 = zzpn.zza((long)var36_25.zzc(), (long)var37_32);
                            var41_40 = 1;
                            var49_112 = 1L;
                            var48_35 = "_dbg";
                            var47_48 = (zzgf.zzf)((zzkg)var36_25.zzaj());
                            if (TextUtils.isEmpty((CharSequence)var48_35) || var49_112 == null) {
                                v2 = false;
                            } else {
                                for (zzgf.zzh var51_114 : var47_48.zzh()) {
                                    if (!var48_35.equals(var51_114.zzg())) continue;
                                    v2 = var49_112 instanceof Long != false && var49_112.equals(var51_114.zzd()) != false || var49_112 instanceof String != false && var49_112.equals(var51_114.zzh()) != false || var49_112 instanceof Double && var49_112.equals(var51_114.zza());
                                    break block173;
                                }
                                v2 = false;
                            }
                        }
                        if (!v2) {
                            var41_40 = var29_20.zzi().zzb(var31_17.zza.zzab(), var36_25.zze());
                        }
                        if (var41_40 <= 0) {
                            var29_20.zzj().zzr().zza("Sample rate must be positive. event, rate", (Object)var36_25.zze(), (Object)var41_40);
                            var33_10.add((zzgf.zzf)((zzkg)var36_25.zzaj()));
                            var30_19.zza(var35_5, var36_25);
                            continue;
                        }
                        var42_41 = (String[])var32_101.get(var36_25.zze());
                        if (var42_41 == null && (var42_41 = var29_20.zzf().zzd(var31_17.zza.zzab(), var36_25.zze())) == null) {
                            var29_20.zzj().zzr().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var31_17.zza.zzab(), (Object)var36_25.zze());
                            var42_41 = new zzbh(var31_17.zza.zzab(), var36_25.zze(), 1L, 1L, 1L, var36_25.zzc(), 0L, null, null, null, null);
                        }
                        var29_20.zzp();
                        var43_43 = (Long)zzpj.zzb((zzgf.zzf)((zzkg)var36_25.zzaj()), "_eid");
                        var44_111 = var43_43 != null;
                        if (var41_40 == 1) {
                            var33_10.add((zzgf.zzf)((zzkg)var36_25.zzaj()));
                            if (var44_111.booleanValue() && (var42_41.zzi != null || var42_41.zzj != null || var42_41.zzk != null)) {
                                var42_41 = var42_41.zza(null, null, null);
                                var32_101.put(var36_25.zze(), var42_41);
                            }
                            var30_19.zza(var35_5, var36_25);
                            continue;
                        }
                        if (var34_107.nextInt(var41_40) == 0) {
                            var29_20.zzp();
                            zzpj.zza(var36_25, "_sr", (Object)var41_40);
                            var33_10.add((zzgf.zzf)((zzkg)var36_25.zzaj()));
                            if (var44_111.booleanValue()) {
                                var42_41 = var42_41.zza(null, Long.valueOf(var41_40), null);
                            }
                            var32_101.put(var36_25.zze(), var42_41.zza(var36_25.zzc(), var39_34));
                        } else {
                            if (var42_41.zzh != null) {
                                var45_45 = var42_41.zzh;
                            } else {
                                var29_20.zzq();
                                var45_45 = zzpn.zza((long)var36_25.zzb(), (long)var37_32);
                            }
                            if (var45_45 != var39_34) {
                                var29_20.zzp();
                                zzpj.zza(var36_25, "_efs", (Object)1L);
                                var29_20.zzp();
                                zzpj.zza(var36_25, "_sr", (Object)var41_40);
                                var33_10.add((zzgf.zzf)((zzkg)var36_25.zzaj()));
                                if (var44_111.booleanValue()) {
                                    var42_41 = var42_41.zza(null, Long.valueOf(var41_40), Boolean.valueOf(true));
                                }
                                var32_101.put(var36_25.zze(), var42_41.zza(var36_25.zzc(), var39_34));
                            } else if (var44_111.booleanValue()) {
                                var32_101.put(var36_25.zze(), var42_41.zza(var43_43, null, null));
                            }
                        }
                        var30_19.zza(var35_5, var36_25);
                    }
                    if (var33_10.size() < var30_19.zzc()) {
                        var30_19.zzl().zzb(var33_10);
                    }
                    for (Map.Entry var36_26 : var32_101.entrySet()) {
                        var29_20.zzf().zza((zzbh)var36_26.getValue());
                    }
                }
                var19_73 = var4_3.zza.zzab();
                var20_77 = this.zzf().zzd(var19_73);
                if (var20_77 == null) {
                    this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzgo.zza((String)var4_3.zza.zzab()));
                } else if (var6_50.zzc() > 0) {
                    var21_80 = var20_77.zzs();
                    if (var21_80 != 0L) {
                        var6_50.zzh(var21_80);
                    } else {
                        var6_50.zzo();
                    }
                    var23_89 = var20_77.zzu();
                    if (var23_89 == 0L) {
                        var23_89 = var21_80;
                    }
                    if (var23_89 != 0L) {
                        var6_50.zzi(var23_89);
                    } else {
                        var6_50.zzp();
                    }
                    var20_77.zza((long)var6_50.zzc());
                    var6_50.zzg((int)var20_77.zzr());
                    var6_50.zzf((int)var20_77.zzt());
                    var20_77.zzr(var6_50.zzf());
                    var20_77.zzp(var6_50.zze());
                    var25_94 = var20_77.zzab();
                    if (var25_94 != null) {
                        var6_50.zzn(var25_94);
                    } else {
                        var6_50.zzm();
                    }
                    this.zzf().zza(var20_77, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var21_81 = this.zzi().zzc(var4_3.zza.zzab());
                    if (var21_81 == null || !var21_81.zzr()) {
                        if (var4_3.zza.i_().isEmpty()) {
                            var6_50.zzc(-1L);
                        } else {
                            this.zzj().zzr().zza("Did not find measurement config or missing version info. appId", zzgo.zza((String)var4_3.zza.zzab()));
                        }
                    } else {
                        var6_50.zzc(var21_81.zzc());
                    }
                    this.zzf().zza((zzgf.zzk)((zzkg)var6_50.zzaj()), var5_49);
                }
                var30_19 = var4_3.zzb;
                var29_20 = this.zzf();
                Preconditions.checkNotNull((Object)var30_19);
                var29_20.zzv();
                var29_20.zzam();
                var31_18 = new StringBuilder("rowid in (");
                for (var32_102 = 0; var32_102 < var30_19.size(); ++var32_102) {
                    if (var32_102 != 0) {
                        var31_18.append(",");
                    }
                    var31_18.append((Long)var30_19.get(var32_102));
                }
                var31_18.append(")");
                var33_11 = var29_20.f_().delete("raw_events", var31_18.toString(), null);
                if (var33_11 != var30_19.size()) {
                    var29_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var33_11, (Object)var30_19.size());
                }
                var30_19 = var19_73;
                var29_20 = this.zzf();
                var31_18 = var29_20.f_();
                try {
                    var31_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var30_19, var30_19});
                }
                catch (SQLiteException var32_103) {
                    var29_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzgo.zza((String)var30_19), (Object)var32_103);
                }
                this.zzf().zzx();
                return true;
            }
            this.zzf().zzx();
            return false;
        }
        finally {
            this.zzf().zzr();
        }
    }

    private final boolean zzag() {
        this.zzl().zzv();
        this.zzt();
        return this.zzf().zzy() || !TextUtils.isEmpty((CharSequence)this.zzf().g_());
    }

    @WorkerThread
    private final boolean zza(String string, String string2) {
        zzbh zzbh2 = this.zzf().zzd(string, string2);
        return zzbh2 == null || zzbh2.zzc < 1L;
    }

    @WorkerThread
    @VisibleForTesting
    private final boolean zzf(String string) {
        zzb zzb2 = this.zzaf.get(string);
        if (zzb2 == null) {
            return true;
        }
        return zzb2.zzb();
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzah() {
        this.zzl().zzv();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzq().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzcf.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzq().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzr().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzgf.zzf.zza zza2, zzgf.zzf.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzgf.zzh zzh2 = zzpj.zza((zzgf.zzf)((zzkg)zza2.zzaj()), "_sc");
        String string = zzh2 == null ? null : zzh2.zzh();
        this.zzp();
        zzgf.zzh zzh3 = zzpj.zza((zzgf.zzf)((zzkg)zza3.zzaj()), "_pc");
        String string2 = zzh3 == null ? null : zzh3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzgf.zzf.zza zza4 = zza3;
            zzgf.zzf.zza zza5 = zza2;
            zzou zzou2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzou2.zzp();
            zzgf.zzh zzh4 = zzpj.zza((zzgf.zzf)((zzkg)zza5.zzaj()), "_et");
            if (zzh4 != null && zzh4.zzl() && zzh4.zzd() > 0L) {
                long l = zzh4.zzd();
                zzou2.zzp();
                zzh4 = zzpj.zza((zzgf.zzf)((zzkg)zza4.zzaj()), "_et");
                if (zzh4 != null && zzh4.zzd() > 0L) {
                    l += zzh4.zzd();
                }
                zzou2.zzp();
                zzpj.zza(zza4, "_et", (Object)l);
                zzou2.zzp();
                zzpj.zza(zza5, "_fr", (Object)1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzv();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    static final class zzb {
        private final zzou zza;
        private int zzb;
        private long zzc;

        private final long zzc(@UnknownInitialization zzb this) {
            Preconditions.checkNotNull((Object)this.zza);
            long l = (Long)zzbn.zzt.zza(null);
            long l2 = (Long)zzbn.zzu.zza(null);
            for (int i = 1; i < this.zzb && (l <<= 1) < l2; ++i) {
            }
            return this.zza.zzb().currentTimeMillis() + Math.min(l, l2);
        }

        public zzb(zzou zzou2) {
            this.zza = zzou2;
            this.zzb = 1;
            this.zzc = this.zzc();
        }

        public final void zza() {
            ++this.zzb;
            this.zzc = this.zzc();
        }

        public final boolean zzb() {
            return this.zza.zzb().currentTimeMillis() >= this.zzc;
        }
    }

    private final class zzc {
        final String zza;
        long zzb;

        private zzc(zzou zzou2) {
            this(zzou2, zzou2.zzq().zzq());
        }

        /* synthetic */ zzc(zzou zzou2, zzpg zzpg2) {
            this(zzou2);
        }

        private zzc(zzou zzou2, String string) {
            this.zza = string;
            this.zzb = zzou2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzc(zzou zzou2, String string, zzpg zzpg2) {
            this(zzou2, string);
        }
    }

    private final class zza
    implements zzau {
        zzgf.zzk zza;
        List<Long> zzb;
        List<zzgf.zzf> zzc;
        private long zzd;

        private static long zza(zzgf.zzf zzf2) {
            return zzf2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zzpg zzpg2) {
            this();
        }

        @Override
        public final void zza(zzgf.zzk zzk2) {
            Preconditions.checkNotNull((Object)zzk2);
            this.zza = zzk2;
        }

        @Override
        public final boolean zza(long l, zzgf.zzf zzf2) {
            Preconditions.checkNotNull((Object)zzf2);
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzgf.zzf>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzou$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzou$zza.zza(zzf2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzf2.zzcf();
            zzou.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbn.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzf2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzou.this.zze();
            return n < Math.max(1, (Integer)zzbn.zzj.zza(null));
        }
    }
}

