/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzlp;
import com.google.android.gms.internal.measurement.zzoy;
import com.google.android.gms.internal.measurement.zzpf;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzou;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzpn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzpj
extends zzot {
    static int zza(zzgf.zzk.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzs().zzv();
        MessageDigest messageDigest = zzpn.zzr();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zzpn.zza((byte[])messageDigest.digest(byArray));
    }

    static Bundle zza(List<zzgf.zzh> list) {
        Bundle bundle = new Bundle();
        for (zzgf.zzh zzh2 : list) {
            String string = zzh2.zzg();
            if (zzh2.zzj()) {
                bundle.putDouble(string, zzh2.zza());
                continue;
            }
            if (zzh2.zzk()) {
                bundle.putFloat(string, zzh2.zzb());
                continue;
            }
            if (zzh2.zzn()) {
                bundle.putString(string, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            bundle.putLong(string, zzh2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zzpj zzpj2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zzpj2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbl zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzjp.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbl((String)object, new zzbg(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzog zza(String string, zzgf.zzk.zza zza2, zzgf.zzf.zza zza3, @Nullable String string2) {
        int n;
        String string3;
        if (!zzoy.zza() || !this.zze().zze(string, zzbn.zzcp)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Object object = this.zze().zzd(string, zzbn.zzbo).split(",");
        Object object2 = new HashSet<String>(((String[])object).length);
        Bundle bundle = object;
        int n2 = ((String[])object).length;
        for (int i = 0; i < n2; ++i) {
            string3 = bundle[i];
            if (((HashSet)object2).add(Objects.requireNonNull(string3))) continue;
            throw new IllegalArgumentException("duplicate element: " + string3);
        }
        Set<String> set = Collections.unmodifiableSet(object2);
        object2 = string;
        object = ((zzok)this).zzp();
        bundle = ((zzok)((Object)object)).zzm().zzf((String)object2);
        Object object3 = new Uri.Builder();
        object3.scheme(object.zze().zzd((String)object2, zzbn.zzbh));
        if (!TextUtils.isEmpty((CharSequence)bundle)) {
            string3 = object.zze().zzd((String)object2, zzbn.zzbi);
            Object object4 = bundle;
            object3.authority((String)object4 + "." + string3);
        } else {
            object3.authority(object.zze().zzd((String)object2, zzbn.zzbi));
        }
        object3.path(object.zze().zzd((String)object2, zzbn.zzbj));
        Uri.Builder builder = object3;
        zzpj.zza(builder, "gmp_app_id", zza2.zzy(), set);
        zzpj.zza(builder, "gmp_version", "114010", set);
        String string4 = zza2.zzv();
        if (this.zze().zze(string, zzbn.zzcs) && ((zzok)this).zzm().zzo(string)) {
            string4 = "";
        }
        zzpj.zza(builder, "app_instance_id", string4, set);
        zzpj.zza(builder, "rdid", zza2.zzaa(), set);
        zzpj.zza(builder, "bundle_id", zza2.zzu(), set);
        String string5 = zza3.zze();
        String string6 = zzjp.zza((String)string5);
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            string5 = string6;
        }
        zzpj.zza(builder, "app_event_name", string5, set);
        zzpj.zza(builder, "app_version", String.valueOf(zza2.zzb()), set);
        String string7 = zza2.zzz();
        if (this.zze().zze(string, zzbn.zzcs) && ((zzok)this).zzm().zzs(string) && !TextUtils.isEmpty((CharSequence)string7) && (n = string7.indexOf(".")) != -1) {
            string7 = string7.substring(0, n);
        }
        zzpj.zza(builder, "os_version", string7, set);
        zzpj.zza(builder, "timestamp", String.valueOf(zza3.zzc()), set);
        if (zza2.zzae()) {
            zzpj.zza(builder, "lat", "1", set);
        }
        zzpj.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), set);
        zzpj.zza(builder, "trigger_uri_source", "1", set);
        zzpj.zza(builder, "trigger_uri_timestamp", String.valueOf(l), set);
        zzpj.zza(builder, "request_uuid", string2, set);
        object = zza3.zzf();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzgf.zzh zzh2 = (zzgf.zzh)object3.next();
            string3 = zzh2.zzg();
            if (zzh2.zzj()) {
                bundle.putString(string3, String.valueOf(zzh2.zza()));
                continue;
            }
            if (zzh2.zzk()) {
                bundle.putString(string3, String.valueOf(zzh2.zzb()));
                continue;
            }
            if (zzh2.zzn()) {
                bundle.putString(string3, zzh2.zzh());
                continue;
            }
            if (!zzh2.zzl()) continue;
            bundle.putString(string3, String.valueOf(zzh2.zzd()));
        }
        Bundle bundle2 = bundle;
        String[] stringArray = this.zze().zzd(string, zzbn.zzbn).split("\\|");
        zzpj.zza(builder, stringArray, bundle2, set);
        object = zza2.zzac();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzgf.zzp zzp2 = (zzgf.zzp)object3.next();
            string3 = zzp2.zzg();
            if (zzp2.zzi()) {
                bundle.putString(string3, String.valueOf(zzp2.zza()));
                continue;
            }
            if (zzp2.zzj()) {
                bundle.putString(string3, String.valueOf(zzp2.zzb()));
                continue;
            }
            if (zzp2.zzm()) {
                bundle.putString(string3, zzp2.zzh());
                continue;
            }
            if (!zzp2.zzk()) continue;
            bundle.putString(string3, String.valueOf(zzp2.zzc()));
        }
        Bundle bundle3 = bundle;
        String[] stringArray2 = this.zze().zzd(string, zzbn.zzbm).split("\\|");
        zzpj.zza(builder, stringArray2, bundle3, set);
        zzpj.zza(builder, "dma", zza2.zzad() ? "1" : "0", set);
        if (!zza2.zzx().isEmpty()) {
            zzpj.zza(builder, "dma_cps", zza2.zzx(), set);
        }
        if (this.zze().zza(zzbn.zzcu) && zza2.zzaf()) {
            object3 = set;
            bundle = zza2.zzg();
            object2 = builder;
            if (!bundle.zzh().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "dl_gclid", bundle.zzh(), (Set<String>)object3);
            }
            if (!bundle.zzg().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "dl_gbraid", bundle.zzg(), (Set<String>)object3);
            }
            if (!bundle.zzf().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "dl_gs", bundle.zzf(), (Set<String>)object3);
            }
            if (bundle.zza() > 0L) {
                zzpj.zza((Uri.Builder)object2, "dl_ss_ts", String.valueOf(bundle.zza()), (Set<String>)object3);
            }
            if (!bundle.zzk().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "mr_gclid", bundle.zzk(), (Set<String>)object3);
            }
            if (!bundle.zzj().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "mr_gbraid", bundle.zzj(), (Set<String>)object3);
            }
            if (!bundle.zzi().isEmpty()) {
                zzpj.zza((Uri.Builder)object2, "mr_gs", bundle.zzi(), (Set<String>)object3);
            }
            if (bundle.zzb() > 0L) {
                zzpj.zza((Uri.Builder)object2, "mr_click_ts", String.valueOf(bundle.zzb()), (Set<String>)object3);
            }
        }
        return new zzog(builder.build().toString(), l, 1);
    }

    final zzgf.zzf zza(zzbe zzbe2) {
        zzgf.zzf.zza zza2 = zzgf.zzf.zze().zza(zzbe2.zze);
        for (String string : zzbe2.zzf) {
            zzgf.zzh.zza zza3 = zzgf.zzh.zze().zza(string);
            Object object = zzbe2.zzf.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        if (!TextUtils.isEmpty((CharSequence)zzbe2.zzc) && zzbe2.zzf.zzc("_o") == null) {
            zza2.zza((zzgf.zzh)((zzkg)zzgf.zzh.zze().zza("_o").zzb(zzbe2.zzc).zzaj()));
        }
        return (zzgf.zzf)((zzkg)zza2.zzaj());
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzgf.zzh zza(zzgf.zzf zzf2, String string) {
        for (zzgf.zzh zzh2 : zzf2.zzh()) {
            if (!zzh2.zzg().equals(string)) continue;
            return zzh2;
        }
        return null;
    }

    static <BuilderT extends zzlp> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzkp {
        zzjt zzjt2 = zzjt.zza();
        if (zzjt2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzjt2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzgf.zzf zzf2, String string) {
        zzgf.zzh zzh2 = zzpj.zza(zzf2, string);
        if (zzh2 != null) {
            if (zzh2.zzn()) {
                return zzh2.zzh();
            }
            if (zzh2.zzl()) {
                return zzh2.zzd();
            }
            if (zzh2.zzj()) {
                return zzh2.zza();
            }
            if (zzh2.zzc() > 0) {
                return zzpj.zzb(zzh2.zzi());
            }
        }
        return null;
    }

    static Object zza(zzgf.zzf zzf2, String string, Object object) {
        Object object2 = zzpj.zzb(zzf2, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    final String zza(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzgf.zzj zzj2) {
        if (zzj2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzj2.zzh()) {
            zzpj.zza(stringBuilder, 0, "upload_subdomain", zzj2.zze());
        }
        if (zzj2.zzg()) {
            zzpj.zza(stringBuilder, 0, "sgtm_join_id", zzj2.zzd());
        }
        Iterator iterator = zzj2.zzf().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzgf.zzk zzk2;
            zzgf.zzk zzk3 = zzk2 = (zzgf.zzk)iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zzpj zzpj2 = this;
            if (zzk3 == null) continue;
            zzpj.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzk3.zzbs()) {
                zzpj.zza(stringBuilder3, 1, "protocol_version", zzk3.zzf());
            }
            if (zzpf.zza() && zzpj2.zze().zze(zzk3.zzab(), zzbn.zzcg) && zzk3.zzbv()) {
                zzpj.zza(stringBuilder3, 1, "session_stitching_token", zzk3.zzaq());
            }
            zzpj.zza(stringBuilder3, 1, "platform", zzk3.zzao());
            if (zzk3.zzbn()) {
                zzpj.zza(stringBuilder3, 1, "gmp_version", zzk3.zzo());
            }
            if (zzk3.zzcb()) {
                zzpj.zza(stringBuilder3, 1, "uploading_gmp_version", zzk3.zzu());
            }
            if (zzk3.zzbl()) {
                zzpj.zza(stringBuilder3, 1, "dynamite_version", zzk3.zzm());
            }
            if (zzk3.zzbe()) {
                zzpj.zza(stringBuilder3, 1, "config_version", zzk3.zzk());
            }
            zzpj.zza(stringBuilder3, 1, "gmp_app_id", zzk3.i_());
            zzpj.zza(stringBuilder3, 1, "admob_app_id", zzk3.zzaa());
            zzpj.zza(stringBuilder3, 1, "app_id", zzk3.zzab());
            zzpj.zza(stringBuilder3, 1, "app_version", zzk3.zzae());
            if (zzk3.zzba()) {
                zzpj.zza(stringBuilder3, 1, "app_version_major", zzk3.zzb());
            }
            zzpj.zza(stringBuilder3, 1, "firebase_instance_id", zzk3.zzak());
            if (zzk3.zzbj()) {
                zzpj.zza(stringBuilder3, 1, "dev_cert_hash", zzk3.zzl());
            }
            zzpj.zza(stringBuilder3, 1, "app_store", zzk3.zzad());
            if (zzk3.zzca()) {
                zzpj.zza(stringBuilder3, 1, "upload_timestamp_millis", zzk3.zzt());
            }
            if (zzk3.zzbx()) {
                zzpj.zza(stringBuilder3, 1, "start_timestamp_millis", zzk3.zzr());
            }
            if (zzk3.zzbm()) {
                zzpj.zza(stringBuilder3, 1, "end_timestamp_millis", zzk3.zzn());
            }
            if (zzk3.zzbr()) {
                zzpj.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzk3.zzq());
            }
            if (zzk3.zzbq()) {
                zzpj.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzk3.zzp());
            }
            zzpj.zza(stringBuilder3, 1, "app_instance_id", zzk3.zzac());
            zzpj.zza(stringBuilder3, 1, "resettable_device_id", zzk3.zzap());
            zzpj.zza(stringBuilder3, 1, "ds_id", zzk3.zzaj());
            if (zzk3.zzbp()) {
                zzpj.zza(stringBuilder3, 1, "limited_ad_tracking", zzk3.zzax());
            }
            zzpj.zza(stringBuilder3, 1, "os_version", zzk3.zzan());
            zzpj.zza(stringBuilder3, 1, "device_model", zzk3.zzai());
            zzpj.zza(stringBuilder3, 1, "user_default_language", zzk3.zzar());
            if (zzk3.zzbz()) {
                zzpj.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzk3.zzh());
            }
            if (zzk3.zzbd()) {
                zzpj.zza(stringBuilder3, 1, "bundle_sequential_index", zzk3.zzc());
            }
            if (zzk3.zzbi()) {
                zzpj.zza(stringBuilder3, 1, "delivery_index", zzk3.zzd());
            }
            if (zzk3.zzbu()) {
                zzpj.zza(stringBuilder3, 1, "service_upload", zzk3.zzay());
            }
            zzpj.zza(stringBuilder3, 1, "health_monitor", zzk3.zzam());
            if (zzk3.zzbt()) {
                zzpj.zza(stringBuilder3, 1, "retry_counter", zzk3.zzg());
            }
            if (zzk3.zzbg()) {
                zzpj.zza(stringBuilder3, 1, "consent_signals", zzk3.zzag());
            }
            if (zzk3.zzbo()) {
                zzpj.zza(stringBuilder3, 1, "is_dma_region", zzk3.zzaw());
            }
            if (zzk3.zzbh()) {
                zzpj.zza(stringBuilder3, 1, "core_platform_services", zzk3.zzah());
            }
            if (zzk3.zzbf()) {
                zzpj.zza(stringBuilder3, 1, "consent_diagnostics", zzk3.zzaf());
            }
            if (zzk3.zzby()) {
                zzpj.zza(stringBuilder3, 1, "target_os_version", zzk3.zzs());
            }
            if (zzoy.zza() && zzpj2.zze().zze(zzk3.zzab(), zzbn.zzcp)) {
                zzpj.zza(stringBuilder3, 1, "ad_services_version", zzk3.zza());
                if (zzk3.zzbb()) {
                    object2 = zzk3.zzw();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zzpj.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zzpj.zza(stringBuilder2, 2, "eligible", object2.zzf());
                        zzpj.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", object2.zzh());
                        zzpj.zza(stringBuilder2, 2, "pre_r", object2.zzi());
                        zzpj.zza(stringBuilder2, 2, "r_extensions_too_old", object2.zzj());
                        zzpj.zza(stringBuilder2, 2, "adservices_extension_too_old", object2.zze());
                        zzpj.zza(stringBuilder2, 2, "ad_storage_not_allowed", object2.zzd());
                        zzpj.zza(stringBuilder2, 2, "measurement_manager_disabled", object2.zzg());
                        zzpj.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            if (zzk3.zzaz()) {
                object2 = zzk3.zzv();
                stringBuilder2 = stringBuilder3;
                zzpj.zza(stringBuilder2, 2);
                stringBuilder2.append("ad_campaign_info {\n");
                if (object2.zzn()) {
                    zzpj.zza(stringBuilder2, 2, "deep_link_gclid", object2.zzh());
                }
                if (object2.zzm()) {
                    zzpj.zza(stringBuilder2, 2, "deep_link_gbraid", object2.zzg());
                }
                if (object2.zzl()) {
                    zzpj.zza(stringBuilder2, 2, "deep_link_gad_source", object2.zzf());
                }
                if (object2.zzo()) {
                    zzpj.zza(stringBuilder2, 2, "deep_link_session_millis", object2.zza());
                }
                if (object2.zzs()) {
                    zzpj.zza(stringBuilder2, 2, "market_referrer_gclid", object2.zzk());
                }
                if (object2.zzr()) {
                    zzpj.zza(stringBuilder2, 2, "market_referrer_gbraid", object2.zzj());
                }
                if (object2.zzq()) {
                    zzpj.zza(stringBuilder2, 2, "market_referrer_gad_source", object2.zzi());
                }
                if (object2.zzp()) {
                    zzpj.zza(stringBuilder2, 2, "market_referrer_click_millis", object2.zzb());
                }
                zzpj.zza(stringBuilder2, 2);
                stringBuilder2.append("}\n");
            }
            if (zzk3.zzbc()) {
                zzpj.zza(stringBuilder3, 1, "batching_timestamp_millis", zzk3.zzj());
            }
            if (zzk3.zzbw()) {
                object2 = zzk3.zzz();
                stringBuilder2 = stringBuilder3;
                zzpj.zza(stringBuilder2, 2);
                stringBuilder2.append("sgtm_diagnostics {\n");
                zzpj.zza(stringBuilder2, 2, "upload_type", object2.zzd().name());
                zzpj.zza(stringBuilder2, 2, "client_upload_eligibility", object2.zzb().name());
                zzpj.zza(stringBuilder2, 2, "service_upload_eligibility", object2.zzc().name());
                zzpj.zza(stringBuilder2, 2);
                stringBuilder2.append("}\n");
            }
            object2 = zzk3.zzau();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzpj zzpj3 = zzpj2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzgf.zzp)iterator2.next();
                    if (object == null) continue;
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zzpj.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zzpj.zza(stringBuilder2, 2, "name", zzpj3.zzi().zzc(object.zzg()));
                    zzpj.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zzpj.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zzpj.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List list = zzk3.zzas();
            zzk3.zzab();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzgf.zzd zzd2 = (zzgf.zzd)object.next();
                    if (zzd2 == null) continue;
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzd2.zzg()) {
                        zzpj.zza(stringBuilder2, 2, "audience_id", zzd2.zza());
                    }
                    if (zzd2.zzh()) {
                        zzpj.zza(stringBuilder2, 2, "new_audience", zzd2.zzf());
                    }
                    zzpj.zza(stringBuilder2, 2, "current_data", zzd2.zzd());
                    if (zzd2.zzi()) {
                        zzpj.zza(stringBuilder2, 2, "previous_data", zzd2.zze());
                    }
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzk3.zzat();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzpj3 = zzpj2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzgf.zzf)iterator2.next();
                    if (object == null) continue;
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zzpj.zza(stringBuilder2, 2, "name", zzpj3.zzi().zza(object.zzg()));
                    if (object.zzk()) {
                        zzpj.zza(stringBuilder2, 2, "timestamp_millis", object.zzd());
                    }
                    if (object.zzj()) {
                        zzpj.zza(stringBuilder2, 2, "previous_timestamp_millis", object.zzc());
                    }
                    if (object.zzi()) {
                        zzpj.zza(stringBuilder2, 2, "count", object.zza());
                    }
                    if (object.zzb() != 0) {
                        zzpj3.zza(stringBuilder2, 2, object.zzh());
                    }
                    zzpj.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zzpj.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("} // End-of-batch\n");
        return stringBuilder.toString();
    }

    final String zza(zzfw.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zzpj.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zzpj.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zzpj.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zzpj.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zzpj.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzfw.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zzpj.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzfw.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zzpj.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zzpj.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zzpj.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zzpj.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzr().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzr().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzr() {
        Map map = zzbn.zza((Context)this.zzg.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbn.zzaz.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzr().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzr().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zzpj)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zzpj)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zzpj)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzpj(zzou zzou2) {
        super(zzou2);
    }

    static void zza(zzgf.zzf.zza zza2, String string, Object object) {
        List list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(((zzgf.zzh)list.get(i)).zzg())) continue;
            n = i;
            break;
        }
        zzgf.zzh.zza zza3 = zzgf.zzh.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza(((Long)object).longValue());
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza(((Double)object).doubleValue());
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zzpj.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzgf.zzm zzm2) {
        int n2;
        if (zzm2 == null) {
            return;
        }
        ++n;
        zzpj.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzm2.zzb() != 0) {
            zzpj.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long l : zzm2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zzd() != 0) {
            zzpj.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzm2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzm2.zza() != 0) {
            zzpj.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (Long l : zzm2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l.zzf() ? Integer.valueOf(l.zza()) : null).append(":").append(l.zze() ? Long.valueOf(l.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzm2.zzc() != 0) {
            zzpj.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (Long l : zzm2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l.zzf() ? Integer.valueOf(l.zzb()) : null).append(": [");
                int n3 = 0;
                Iterator iterator = l.zze().iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l2);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zzpj.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzgf.zzh> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzgf.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            zzpj.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzpj.zza(stringBuilder, n, "name", zzh2.zzm() ? this.zzi().zzb(zzh2.zzg()) : null);
            zzpj.zza(stringBuilder, n, "string_value", zzh2.zzn() ? zzh2.zzh() : null);
            zzpj.zza(stringBuilder, n, "int_value", zzh2.zzl() ? Long.valueOf(zzh2.zzd()) : null);
            zzpj.zza(stringBuilder, n, "double_value", zzh2.zzj() ? Double.valueOf(zzh2.zza()) : null);
            if (zzh2.zzc() > 0) {
                this.zza(stringBuilder, n, zzh2.zzi());
            }
            zzpj.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfw.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzpj.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zzpj.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zzpj.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzfw.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zzpj.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zzpj.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zzpj.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zzpj.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zzpj.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zzpj.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zzpj.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zzpj.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zzpj.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfw.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzpj.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zzpj.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zzpj.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zzpj.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zzpj.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zzpj.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zzpj.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zzpj.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzgf.zzh.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zza2.zza(((Double)object).doubleValue());
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzgf.zzh> arrayList = new ArrayList<zzgf.zzh>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzgf.zzh.zza zza3 = zzgf.zzh.zze();
                for (String string : bundle.keySet()) {
                    zzgf.zzh.zza zza4 = zzgf.zzh.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza(((Long)object2).longValue());
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza(((Double)object2).doubleValue());
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzgf.zzh)((zzkg)zza3.zzaj()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzgf.zzp.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zza2.zza(((Double)object).doubleValue());
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbl zzbl2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzbl2);
        Preconditions.checkNotNull((Object)zzp2);
        return !TextUtils.isEmpty((CharSequence)zzp2.zzb) || !TextUtils.isEmpty((CharSequence)zzp2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    static Bundle[] zzb(List<zzgf.zzh> list) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (zzgf.zzh zzh2 : list) {
            if (zzh2 == null) continue;
            Bundle bundle = new Bundle();
            for (zzgf.zzh zzh3 : zzh2.zzi()) {
                if (zzh3.zzn()) {
                    bundle.putString(zzh3.zzg(), zzh3.zzh());
                    continue;
                }
                if (zzh3.zzl()) {
                    bundle.putLong(zzh3.zzg(), zzh3.zzd());
                    continue;
                }
                if (!zzh3.zzj()) continue;
                bundle.putDouble(zzh3.zzg(), zzh3.zza());
            }
            if (bundle.isEmpty()) continue;
            arrayList.add(bundle);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }
}

