/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzr;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzpa;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpk;
import com.google.android.gms.measurement.internal.zzpz;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhz
extends zzpf
implements zzam {
    private final Map<String, @Nullable Map<String, String>> zzb = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Set<String>> zzc = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zzd = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zze = new ArrayMap();
    private final Map<String, @Nullable zzfz.zzd> zzf = new ArrayMap();
    private final Map<String, @Nullable Map<String, Integer>> zzh;
    @VisibleForTesting
    final LruCache<String, zzb> zza;
    private final zzv zzi;
    private final Map<String, @Nullable String> zzj = new ArrayMap();
    private final Map<String, @Nullable String> zzk = new ArrayMap();
    private final Map<String, @Nullable String> zzl = new ArrayMap();

    @WorkerThread
    final int zzb(String string, String string2) {
        this.zzv();
        this.zzu(string);
        Map<String, Integer> map = this.zzh.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zza(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzr().zza("Unable to parse timezone offset. appId", zzhc.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    static /* synthetic */ zzb zza(zzhz zzhz2, String string) {
        String string2 = string;
        zzhz zzhz3 = zzhz2;
        zzhz3.zzam();
        Preconditions.checkNotEmpty((String)string2);
        if (!zzhz3.zzk(string2)) {
            return null;
        }
        if (zzhz3.zzf.containsKey(string2) && zzhz3.zzf.get(string2) != null) {
            zzhz3.zza(string2, zzhz3.zzf.get(string2));
        } else {
            zzhz3.zzu(string2);
        }
        return (zzb)zzhz3.zza.snapshot().get(string2);
    }

    static /* synthetic */ zzb zzb(zzhz zzhz2, String string) {
        String string2 = string;
        zzhz zzhz3 = zzhz2;
        zzhz3.zzam();
        Preconditions.checkNotEmpty((String)string2);
        zzar zzar2 = ((zzpa)zzhz3).zzh().zze(string2);
        if (zzar2 == null) {
            return null;
        }
        zzhz3.zzj().zzq().zza("Populate EES config from database on cache miss. appId", (Object)string2);
        zzhz3.zza(string2, zzhz3.zza(string2, zzar2.zza));
        return (zzb)zzhz3.zza.snapshot().get(string2);
    }

    public static /* synthetic */ zzal zza(zzhz zzhz2) {
        zzhz zzhz3 = zzhz2;
        return new zzr(zzhz3.zzi);
    }

    @WorkerThread
    final zzjx zza(String string, zzju.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzfz.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return zzjx.zza;
        }
        for (zzfz.zza.zza zza4 : zza3.zzf()) {
            if (zzhz.zza(zza4.zzc()) != zza2) continue;
            switch (zza4.zzb()) {
                case zzc: {
                    return zzjx.zzc;
                }
                case zzb: {
                    return zzjx.zzd;
                }
            }
            return zzjx.zza;
        }
        return zzjx.zza;
    }

    @WorkerThread
    final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzju.zza zzb(String string, zzju.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzfz.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return null;
        }
        for (zzfz.zza.zzc zzc2 : zza3.zze()) {
            zzju.zza zza4 = zzhz.zza(zzc2.zzc());
            if (zza2 != zza4) continue;
            return zzhz.zza(zzc2.zzb());
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzju.zza zza(zzfz.zza.zze zze2) {
        switch (zze2) {
            case zzb: {
                return zzju.zza.zza;
            }
            case zzc: {
                return zzju.zza.zzb;
            }
            case zzd: {
                return zzju.zza.zzc;
            }
            case zze: {
                return zzju.zza.zzd;
            }
        }
        return null;
    }

    @WorkerThread
    final @Nullable zzfz.zza zzb(String string) {
        this.zzv();
        this.zzu(string);
        zzfz.zzd zzd2 = this.zzc(string);
        if (zzd2 == null || !zzd2.zzo()) {
            return null;
        }
        return zzd2.zzd();
    }

    @WorkerThread
    protected final @Nullable zzfz.zzd zzc(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        this.zzu(string);
        return this.zzf.get(string);
    }

    @WorkerThread
    private final zzfz.zzd zza(String string, byte @Nullable [] byArray) {
        zzfz.zzd zzd2;
        if (byArray == null) {
            return zzfz.zzd.zzg();
        }
        try {
            zzd2 = (zzfz.zzd)((zzki)zzpz.zza(zzfz.zzd.zze(), byArray).zzaj());
            this.zzj().zzq().zza("Parsed config. version, gmp_app_id", (Object)(zzd2.zzr() ? Long.valueOf(zzd2.zzc()) : null), (Object)(zzd2.zzp() ? zzd2.zzi() : null));
        }
        catch (zzkq zzkq2) {
            this.zzj().zzr().zza("Unable to merge remote config. appId", zzhc.zza((String)string), (Object)zzkq2);
            return zzfz.zzd.zzg();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzr().zza("Unable to merge remote config. appId", zzhc.zza((String)string), (Object)runtimeException);
            return zzfz.zzd.zzg();
        }
        return zzd2;
    }

    @WorkerThread
    public final @Nullable String zza(String string, String string2) {
        this.zzv();
        this.zzu(string);
        Map<String, String> map = this.zzb.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @WorkerThread
    protected final @Nullable String zzd(String string) {
        this.zzv();
        return this.zzl.get(string);
    }

    @WorkerThread
    protected final @Nullable String zze(String string) {
        this.zzv();
        return this.zzk.get(string);
    }

    @WorkerThread
    final @Nullable String zzf(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzj.get(string);
    }

    static /* bridge */ /* synthetic */ Map zzb(zzhz zzhz2) {
        return zzhz2.zzb;
    }

    private static Map<String, String> zza(zzfz.zzd zzd2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzd2 != null) {
            for (zzfz.zzh zzh2 : zzd2.zzn()) {
                arrayMap.put(zzh2.zzb(), zzh2.zzc());
            }
        }
        return arrayMap;
    }

    @WorkerThread
    final @Nullable Set<String> zzg(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string);
    }

    @WorkerThread
    final SortedSet<String> zzh(String string) {
        this.zzv();
        this.zzu(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        zzfz.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return treeSet;
        }
        for (zzfz.zza.zzf zzf2 : zza2.zzc()) {
            treeSet.add(zzf2.zzb());
        }
        return treeSet;
    }

    zzhz(zzpk zzpk2) {
        super(zzpk2);
        this.zzh = new ArrayMap();
        this.zza = new zzic(this, 20);
        this.zzi = new zzif(this);
    }

    @WorkerThread
    protected final void zzi(String string) {
        this.zzv();
        this.zzk.put(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void zza(String string, zzfz.zzd.zza zza2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (zzfz.zzb zzlt2 : zza2.zzf()) {
                hashSet.add(zzlt2.zzb());
            }
            for (int i = 0; i < zza2.zza(); ++i) {
                void var8_13;
                zzfz.zzc.zza zza3 = (zzfz.zzc.zza)zza2.zza(i).zzch();
                if (zza3.zzb().isEmpty()) {
                    this.zzj().zzr().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zzb();
                String string3 = zzka.zzb((String)zza3.zzb());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zzfz.zzc.zza zza4 = zza3.zza(string3);
                    zza2.zza(i, zza4);
                }
                if (var8_13.zze() && var8_13.zzc()) {
                    arrayMap.put(string2, true);
                }
                if (var8_13.zzf() && var8_13.zzd()) {
                    arrayMap2.put(var8_13.zzb(), true);
                }
                if (!var8_13.zzg()) continue;
                if (var8_13.zza() < 2 || var8_13.zza() > 65535) {
                    this.zzj().zzr().zza("Invalid sampling rate. Event name, sample rate", (Object)var8_13.zzb(), (Object)var8_13.zza());
                    continue;
                }
                arrayMap3.put(var8_13.zzb(), var8_13.zza());
            }
        }
        this.zzc.put(string, hashSet);
        this.zzd.put(string, (Map<String, Boolean>)arrayMap);
        this.zze.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzh.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    private final void zzu(String string) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzf.get(string) == null) {
            zzar zzar2 = ((zzpa)this).zzh().zze(string);
            if (zzar2 == null) {
                this.zzb.put(string, null);
                this.zzd.put(string, null);
                this.zzc.put(string, null);
                this.zze.put(string, null);
                this.zzf.put(string, null);
                this.zzj.put(string, null);
                this.zzk.put(string, null);
                this.zzl.put(string, null);
                this.zzh.put(string, null);
                return;
            }
            byte[] byArray = zzar2.zza;
            zzfz.zzd.zza zza2 = (zzfz.zzd.zza)this.zza(string, byArray).zzch();
            this.zza(string, zza2);
            this.zzb.put(string, zzhz.zza((zzfz.zzd)((zzki)zza2.zzaj())));
            this.zzf.put(string, (zzfz.zzd)((zzki)zza2.zzaj()));
            this.zza(string, (zzfz.zzd)((zzki)zza2.zzaj()));
            this.zzj.put(string, zza2.zzd());
            this.zzk.put(string, zzar2.zzb);
            this.zzl.put(string, zzar2.zzc);
        }
    }

    @WorkerThread
    private final void zza(String string, zzfz.zzd zzd2) {
        if (zzd2.zza() == 0) {
            this.zza.remove((Object)string);
            return;
        }
        this.zzj().zzq().zza("EES programs found", (Object)zzd2.zza());
        zzgo.zzc zzc2 = zzd2.zzm().get(0);
        try {
            zzb zzb2 = new zzb();
            String string2 = string;
            zzhz zzhz2 = this;
            zzb2.zza("internal.remoteConfig", new zzhy(zzhz2, string2));
            string2 = string;
            zzhz2 = this;
            zzb2.zza("internal.appMetadata", new zzib(zzhz2, string2));
            zzhz2 = this;
            zzb2.zza("internal.logger", new zzia(zzhz2));
            zzb2.zza(zzc2);
            this.zza.put((Object)string, (Object)zzb2);
            this.zzj().zzq().zza("EES program loaded for appId, activities", (Object)string, (Object)zzc2.zza().zza());
            for (zzgo.zzb zzb3 : zzc2.zza().zzd()) {
                this.zzj().zzq().zza("EES program activity", (Object)zzb3.zzb());
            }
            return;
        }
        catch (zzc zzc3) {
            this.zzj().zzg().zza("Failed to load EES program. appId", (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zzj(String string) {
        this.zzv();
        this.zzf.remove(string);
    }

    public final boolean zzk(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzfz.zzd zzd2 = this.zzf.get(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zza() != 0;
    }

    final boolean zzl(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    @WorkerThread
    final boolean zzc(String string, zzju.zza zza2) {
        this.zzv();
        this.zzu(string);
        zzfz.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return false;
        }
        for (zzfz.zza.zza zza4 : zza3.zzd()) {
            if (zza2 != zzhz.zza(zza4.zzc())) continue;
            return zza4.zzb() == zzfz.zza.zzd.zzb;
        }
        return false;
    }

    @WorkerThread
    final boolean zzm(String string) {
        this.zzv();
        this.zzu(string);
        zzfz.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return true;
        }
        return !zza2.zzh() || zza2.zzg();
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzv();
        this.zzu(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzd(String string, String string2) {
        this.zzv();
        this.zzu(string);
        if (this.zzl(string) && zzqd.zzf((String)string2)) {
            return true;
        }
        if (this.zzn(string) && zzqd.zzg((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzd.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzn(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    protected final boolean zza(String string, byte @Nullable [] byArray, @Nullable String string2, @Nullable String string3) {
        this.zzam();
        this.zzv();
        Preconditions.checkNotEmpty((String)string);
        zzfz.zzd.zza zza2 = (zzfz.zzd.zza)this.zza(string, byArray).zzch();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zza(string, (zzfz.zzd)((zzki)zza2.zzaj()));
        this.zzf.put(string, (zzfz.zzd)((zzki)zza2.zzaj()));
        this.zzj.put(string, zza2.zzd());
        this.zzk.put(string, string2);
        this.zzl.put(string, string3);
        this.zzb.put(string, zzhz.zza((zzfz.zzd)((zzki)zza2.zzaj())));
        ((zzpa)this).zzh().zza(string, new ArrayList<zzfw.zza>(zza2.zze()));
        try {
            zza2.zzb();
            byArray = ((zzfz.zzd)((zzki)zza2.zzaj())).zzce();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzr().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzhc.zza((String)string), (Object)runtimeException);
        }
        String string4 = string3;
        String string5 = string2;
        byte[] byArray2 = byArray;
        String string6 = string;
        zzap zzap2 = ((zzpa)this).zzh();
        Preconditions.checkNotEmpty((String)string6);
        zzap2.zzv();
        zzap2.zzam();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        contentValues.put("config_last_modified_time", string5);
        contentValues.put("e_tag", string4);
        try {
            if ((long)zzap2.f_().update("apps", contentValues, "app_id = ?", new String[]{string6}) == 0L) {
                zzap2.zzj().zzg().zza("Failed to update remote config (got 0). appId", zzhc.zza((String)string6));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzap2.zzj().zzg().zza("Error storing remote config. appId", zzhc.zza((String)string6), (Object)sQLiteException);
        }
        if (this.zze().zza(zzbl.zzdn)) {
            zza2.zzc();
        }
        this.zzf.put(string, (zzfz.zzd)((zzki)zza2.zzaj()));
        return true;
    }

    @WorkerThread
    final boolean zzo(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("app_instance_id");
    }

    @WorkerThread
    final boolean zzp(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && (this.zzc.get(string).contains("device_model") || this.zzc.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzq(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("enhanced_user_id");
    }

    @WorkerThread
    final boolean zzr(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("google_signals");
    }

    @WorkerThread
    final boolean zzs(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && (this.zzc.get(string).contains("os_version") || this.zzc.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzt(String string) {
        this.zzv();
        this.zzu(string);
        return this.zzc.get(string) != null && this.zzc.get(string).contains("user_id");
    }
}

