/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzow;
import com.google.android.gms.measurement.internal.zzpb;
import com.google.android.gms.measurement.internal.zzpd;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpk;
import com.google.android.gms.measurement.internal.zzpy;
import com.google.android.gms.measurement.internal.zzpz;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzqa;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzir
extends zzgj {
    private final zzpk zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzan zza(zzq zzq2) {
        this.zzb(zzq2, false);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Future future = this.zza.zzl().zzb((Callable)new zzjl(this, zzq2));
        try {
            return (zzan)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zza.zzj().zzg().zza("Failed to get consent. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
            return new zzan(null);
        }
    }

    @VisibleForTesting
    final zzbj zzb(zzbj zzbj2, zzq zzq2) {
        String string;
        zzbj zzbj3 = zzbj2;
        if (!"_cmp".equals(zzbj3.zza) || zzbj3.zzb == null || zzbj3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbj3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzp().zza("Event has been filtered ", (Object)zzbj2.toString());
            return new zzbj("_cmpx", zzbj2.zzb, zzbj2.zzc, zzbj2.zzd);
        }
        return zzbj2;
    }

    static /* bridge */ /* synthetic */ zzpk zza(zzir zzir2) {
        return zzir2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzq zzq2) {
        this.zzb(zzq2, false);
        return this.zza.zzb(zzq2);
    }

    @BinderThread
    public final List<zzow> zza(zzq zzq2, Bundle bundle) {
        this.zzb(zzq2, false);
        Preconditions.checkNotNull((Object)zzq2.zza);
        if (this.zza.zze().zza(zzbl.zzdh)) {
            Future future = this.zza.zzl().zzb((Callable)new zzjo(this, zzq2, bundle));
            try {
                return (List)future.get(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
                return Collections.emptyList();
            }
        }
        Future future = this.zza.zzl().zza((Callable)new zzjr(this, zzq2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzpy> zza(zzq zzq2, boolean bl) {
        this.zzb(zzq2, false);
        String string = zzq2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zziz(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzpy> arrayList = new ArrayList<zzpy>(list.size());
            for (zzqa zzqa2 : list) {
                if (!bl && zzqd.zzf((String)zzqa2.zzc)) continue;
                arrayList.add(new zzpy(zzqa2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzai> zza(@Nullable String string, @Nullable String string2, zzq zzq2) {
        this.zzb(zzq2, false);
        String string3 = zzq2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzjh(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzai> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzjg(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzpy> zza(@Nullable String string, @Nullable String string2, boolean bl, zzq zzq2) {
        this.zzb(zzq2, false);
        String string3 = zzq2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzjf(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzpy> arrayList = new ArrayList<zzpy>(list.size());
            for (zzqa zzqa2 : list) {
                if (!bl && zzqd.zzf((String)zzqa2.zzc)) continue;
                arrayList.add(new zzpy(zzqa2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzpy> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzje(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzpy> arrayList = new ArrayList<zzpy>(list.size());
            for (zzqa zzqa2 : list) {
                if (!bl && zzqd.zzf((String)zzqa2.zzc)) continue;
                arrayList.add(new zzpy(zzqa2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzhc.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public static /* synthetic */ void zza(zzir zzir2, String string, zzpb zzpb2, zzgq zzgq2) {
        zzgq zzgq3 = zzgq2;
        zzpb zzpb3 = zzpb2;
        String string2 = string;
        zzir zzir3 = zzir2;
        zzir3.zza.zzs();
        zzpd zzpd2 = zzir3.zza.zza(string2, zzpb3);
        try {
            zzgq3.zza(zzpd2);
            zzir3.zza.zzj().zzq().zza("[sgtm] Sending queued upload batches to client. appId, count", (Object)string2, (Object)zzpd2.zza.size());
            return;
        }
        catch (RemoteException remoteException) {
            zzir3.zza.zzj().zzg().zza("[sgtm] Failed to return upload batches for app", (Object)string2, (Object)remoteException);
            return;
        }
    }

    public static /* synthetic */ void zza(zzir zzir2, zzq zzq2) {
        zzq zzq3 = zzq2;
        zzir zzir3 = zzir2;
        zzir3.zza.zzs();
        zzir3.zza.zzg(zzq3);
    }

    public static /* synthetic */ void zza(zzir zzir2, zzq zzq2, zzag zzag2) {
        zzag zzag3 = zzag2;
        zzq zzq3 = zzq2;
        zzir zzir3 = zzir2;
        zzir3.zza.zzs();
        zzir3.zza.zza((String)Preconditions.checkNotNull((Object)zzq3.zza), zzag3);
    }

    public static /* synthetic */ void zzb(zzir zzir2, zzq zzq2) {
        zzq zzq3 = zzq2;
        zzir zzir3 = zzir2;
        zzir3.zza.zzs();
        zzir3.zza.zzf(zzq3);
    }

    public static /* synthetic */ void zza(zzir zzir2, zzq zzq2, Bundle bundle, zzgl zzgl2, String string) {
        String string2 = string;
        zzgl zzgl3 = zzgl2;
        Bundle bundle2 = bundle;
        zzq zzq3 = zzq2;
        zzir zzir3 = zzir2;
        zzir3.zza.zzs();
        List<zzow> list = zzir3.zza.zza(zzq3, bundle2);
        try {
            zzgl3.zza(list);
            return;
        }
        catch (RemoteException remoteException) {
            zzir3.zza.zzj().zzg().zza("Failed to return trigger URIs for app", (Object)string2, (Object)remoteException);
            return;
        }
    }

    public static /* synthetic */ void zza(zzir zzir2, Bundle bundle, String string, zzq zzq2) {
        zzq zzq3 = zzq2;
        String string2 = string;
        Bundle bundle2 = bundle;
        zzir zzir3 = zzir2;
        boolean bl = zzir3.zza.zze().zza(zzbl.zzdc);
        boolean bl2 = zzir3.zza.zze().zza(zzbl.zzde);
        if (bundle2.isEmpty() && bl) {
            String string3 = string2;
            zzap zzap2 = zzir3.zza.zzf();
            zzap2.zzv();
            zzap2.zzam();
            try {
                zzap2.f_().execSQL("delete from default_event_params where app_id=?", (Object[])new String[]{string3});
                return;
            }
            catch (SQLiteException sQLiteException) {
                zzap2.zzj().zzg().zza("Error clearing default event params", (Object)sQLiteException);
                return;
            }
        }
        zzir3.zza.zzf().zza(string2, bundle2);
        if (zzir3.zza.zzf().zza(string2, zzq3.zzae)) {
            if (bl2) {
                Bundle bundle3 = bundle2;
                long l = zzq3.zzae;
                zzir3.zza.zzf().zza(string2, (Long)l, null, bundle3);
                return;
            }
            Bundle bundle4 = bundle2;
            zzir3.zza.zzf().zza(string2, null, null, bundle4);
        }
    }

    public zzir(zzpk zzpk2) {
        this(zzpk2, null);
    }

    private zzir(zzpk zzpk2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzpk2);
        this.zza = zzpk2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzq zzq2) {
        this.zzb(zzq2, false);
        this.zzb(new zzjb(this, zzq2));
    }

    @BinderThread
    public final void zzd(zzq zzq2) {
        this.zzb(zzq2, false);
        this.zzb(new zziy(this, zzq2));
    }

    @BinderThread
    private final void zzb(zzq zzq2, boolean bl) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zza(zzq2.zza, false);
        this.zza.zzq().zza(zzq2.zzb, zzq2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzir zzir2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzir2 = this;
                    if (!bl2) break block9;
                    if (zzir2.zzb == null) {
                        zzir2.zzb = "com.google.android.gms".equals(zzir2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzir2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzir2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzir2.zzb.booleanValue()) break block10;
                }
                if (zzir2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzir2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzir2.zzc = string2;
                }
                if (!string2.equals(zzir2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzhc.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(zzq zzq2, zzpb zzpb2, zzgq zzgq2) {
        if (!this.zza.zze().zza(zzbl.zzco)) {
            try {
                zzgq2.zza(new zzpd(Collections.emptyList()));
                this.zza.zzj().zzq().zza("[sgtm] Client upload is not enabled on the service side.");
                return;
            }
            catch (RemoteException remoteException) {
                this.zza.zzj().zzr().zza("[sgtm] UploadBatchesCallback failed.", (Object)remoteException);
                return;
            }
        }
        this.zzb(zzq2, false);
        String string = (String)Preconditions.checkNotNull((Object)zzq2.zza);
        zzgq zzgq3 = zzgq2;
        zzpb zzpb3 = zzpb2;
        String string2 = string;
        zzir zzir2 = this;
        this.zza.zzl().zzb((Runnable)new zziv(zzir2, string2, zzpb3, zzgq3));
    }

    final void zzc(zzbj zzbj2, zzq zzq2) {
        if (!this.zza.zzi().zzk(zzq2.zza)) {
            this.zzd(zzbj2, zzq2);
            return;
        }
        this.zza.zzj().zzq().zza("EES config found for", (Object)zzq2.zza);
        String string = zzq2.zza;
        zzpf zzpf2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzhz)zzpf2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzq().zza("EES not loaded for", (Object)zzq2.zza);
            this.zzd(zzbj2, zzq2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbj2;
            zzpf2 = this.zza.zzp();
            Bundle bundle = ((zzbj)string).zzb.zzb();
            Map<String, Object> map = ((zzpz)zzpf2).zza(bundle, true);
            String string2 = zzka.zza((String)((zzbj)string).zza);
            if (string2 == null) {
                string2 = ((zzbj)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbj)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzq2.zzb, (Object)zzbj2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzq().zza("EES was not applied to event", (Object)zzbj2.zza);
            this.zzd(zzbj2, zzq2);
            return;
        }
        if (zzb2.zzc()) {
            this.zza.zzj().zzq().zza("EES edited event", (Object)zzbj2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzq2);
        } else {
            this.zzd(zzbj2, zzq2);
        }
        if (zzb2.zzb()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzq().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzq2);
            }
        }
    }

    @BinderThread
    public final void zza(zzbj zzbj2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzbj2);
        this.zzb(zzq2, false);
        this.zzb(new zzjk(this, zzbj2, zzq2));
    }

    @BinderThread
    public final void zza(zzbj zzbj2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbj2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzb(new zzjn(this, zzbj2, string));
    }

    private final void zzd(zzbj zzbj2, zzq zzq2) {
        this.zza.zzs();
        this.zza.zza(zzbj2, zzq2);
    }

    @BinderThread
    public final void zza(zzq zzq2, Bundle bundle, zzgl zzgl2) {
        String string;
        this.zzb(zzq2, false);
        String string2 = string = (String)Preconditions.checkNotNull((Object)zzq2.zza);
        zzgl zzgl3 = zzgl2;
        Bundle bundle2 = bundle;
        zzq zzq3 = zzq2;
        zzir zzir2 = this;
        this.zza.zzl().zzb((Runnable)new zzit(zzir2, zzq3, bundle2, zzgl3, string2));
    }

    @BinderThread
    public final void zze(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zza(zzq2.zza, false);
        this.zzb(new zzji(this, zzq2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzm()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzc(runnable);
    }

    @VisibleForTesting
    private final void zzb(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzm()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzai zzai2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotNull((Object)zzai2.zzc);
        this.zzb(zzq2, false);
        zzai zzai3 = new zzai(zzai2);
        new zzai(zzai2).zza = zzq2.zza;
        this.zzb(new zzjd(this, zzai3, zzq2));
    }

    @BinderThread
    public final void zza(zzai zzai2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotNull((Object)zzai2.zzc);
        Preconditions.checkNotEmpty((String)zzai2.zza);
        this.zza(zzai2.zza, true);
        zzai zzai3 = new zzai(zzai2);
        this.zzb(new zzjc(this, zzai3));
    }

    @BinderThread
    public final void zzf(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzt);
        this.zza(new zzjj(this, zzq2));
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zzb(new zzja(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzq zzq2) {
        this.zzb(zzq2, false);
        String string = zzq2.zza;
        Preconditions.checkNotNull((Object)string);
        zzq zzq3 = zzq2;
        String string2 = string;
        Bundle bundle2 = bundle;
        zzir zzir2 = this;
        this.zzb(new zzix(zzir2, bundle2, string2, zzq3));
    }

    @BinderThread
    public final void zzg(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzt);
        zzq zzq3 = zzq2;
        zzir zzir2 = this;
        this.zza(new zziu(zzir2, zzq3));
    }

    @BinderThread
    public final void zzh(zzq zzq2) {
        this.zzb(zzq2, false);
        this.zzb(new zziw(this, zzq2));
    }

    @BinderThread
    public final void zzi(zzq zzq2) {
        Preconditions.checkNotEmpty((String)zzq2.zza);
        Preconditions.checkNotNull((Object)zzq2.zzt);
        zzq zzq3 = zzq2;
        zzir zzir2 = this;
        this.zza(new zzis(zzir2, zzq3));
    }

    @BinderThread
    public final void zza(zzpy zzpy2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzpy2);
        this.zzb(zzq2, false);
        this.zzb(new zzjp(this, zzpy2, zzq2));
    }

    @BinderThread
    public final void zza(zzq zzq2, zzag zzag2) {
        if (!this.zza.zze().zza(zzbl.zzco)) {
            return;
        }
        this.zzb(zzq2, false);
        zzag zzag3 = zzag2;
        zzq zzq3 = zzq2;
        zzir zzir2 = this;
        this.zzb(new zziq(zzir2, zzq3, zzag3));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbj zzbj2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbj2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbj2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zzjm(this, zzbj2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzhc.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbj2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzhc.zza((String)string), (Object)this.zza.zzg().zza(zzbj2.zza), (Object)exception);
            return null;
        }
    }
}

