/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.BroadcastOptions;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzki;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zznu;
import com.google.android.gms.internal.measurement.zzoh;
import com.google.android.gms.internal.measurement.zzpr;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmg;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzoa;
import com.google.android.gms.measurement.internal.zzow;
import com.google.android.gms.measurement.internal.zzoy;
import com.google.android.gms.measurement.internal.zzoz;
import com.google.android.gms.measurement.internal.zzpa;
import com.google.android.gms.measurement.internal.zzpb;
import com.google.android.gms.measurement.internal.zzpd;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzph;
import com.google.android.gms.measurement.internal.zzpi;
import com.google.android.gms.measurement.internal.zzpj;
import com.google.android.gms.measurement.internal.zzpl;
import com.google.android.gms.measurement.internal.zzpm;
import com.google.android.gms.measurement.internal.zzpn;
import com.google.android.gms.measurement.internal.zzpo;
import com.google.android.gms.measurement.internal.zzpp;
import com.google.android.gms.measurement.internal.zzpq;
import com.google.android.gms.measurement.internal.zzpt;
import com.google.android.gms.measurement.internal.zzpu;
import com.google.android.gms.measurement.internal.zzpv;
import com.google.android.gms.measurement.internal.zzpy;
import com.google.android.gms.measurement.internal.zzpz;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzqa;
import com.google.android.gms.measurement.internal.zzqc;
import com.google.android.gms.measurement.internal.zzqd;
import com.google.android.gms.measurement.internal.zzv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzpk
implements zzjs {
    private static volatile @Nullable zzpk zza;
    private zzhz zzb;
    private zzhf zzc;
    private zzap zzd;
    private zzhm zze;
    private zzoy zzf;
    private zzv zzg;
    private final zzpz zzh;
    private zzme zzi;
    private zzoa zzj;
    private final zzpi zzk;
    private @MonotonicNonNull zzht zzl;
    private final zzim zzm;
    private AtomicBoolean zzn = new AtomicBoolean(false);
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Deque<String> zzr = new LinkedList<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzju> zzac;
    private final Map<String, zzbb> zzad;
    private final Map<String, zza> zzae;
    private final Map<String, zzc> zzaf = new HashMap<String, zzc>();
    private @Nullable zzmh zzag;
    private @Nullable String zzah;
    private zzaz zzai;
    private long zzaj;
    private final zzqc zzak = new zzpp(this);

    private final int zza(String string, zzal zzal2) {
        zzjx zzjx2;
        if (this.zzb.zzb(string) == null) {
            zzal2.zza(zzju.zza.zzd, zzao.zzi);
            return 1;
        }
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 != null && com.google.android.gms.measurement.internal.zzf.zza((String)zzg2.zzak()).zza() == zzjx.zzb && (zzjx2 = this.zzb.zza(string, zzju.zza.zzd)) != zzjx.zza) {
            zzal2.zza(zzju.zza.zzd, zzao.zzh);
            if (zzjx2 == zzjx.zzd) {
                return 0;
            }
            return 1;
        }
        zzal2.zza(zzju.zza.zzd, zzao.zzb);
        if (this.zzb.zzc(string, zzju.zza.zzd)) {
            return 0;
        }
        return 1;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzv();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzr().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzy() {
        long l = this.zzb().currentTimeMillis();
        zzoa zzoa2 = this.zzj;
        zzoa2.zzam();
        zzoa2.zzv();
        long l2 = zzoa2.zzf.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzoa2.zzs().zzw().nextInt(86400000);
            zzoa2.zzf.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    @WorkerThread
    final @Nullable Bundle zza(String string) {
        this.zzl().zzv();
        this.zzt();
        if (this.zzi().zzb(string) == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        zzju zzju2 = this.zzb(string);
        bundle.putAll(zzju2.zzb());
        zzbb zzbb2 = this.zza(string, this.zzd(string), zzju2, new zzal());
        bundle.putAll(zzbb2.zzb());
        zzqa zzqa2 = this.zzf().zze(string, "_npa");
        int n = zzqa2 != null ? (zzqa2.zze.equals(1L) ? 1 : 0) : this.zza(string, new zzal());
        bundle.putString("ad_personalization", n == 1 ? "denied" : "granted");
        return bundle;
    }

    private final Bundle zza(String string, zzbj zzbj2) {
        Bundle bundle = new Bundle();
        bundle.putLong("_sid", zzbj2.zzb.zzb("_sid").longValue());
        zzqa zzqa2 = this.zzf().zze(string, "_sno");
        if (zzqa2 != null && zzqa2.zze instanceof Long) {
            bundle.putLong("_sno", ((Long)zzqa2.zze).longValue());
        }
        return bundle;
    }

    public final Clock zzb(@UnknownInitialization zzpk this) {
        return ((zzim)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzg zza(zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        if (!zzq2.zzu.isEmpty()) {
            this.zzae.put(zzq2.zza, new zza(this, zzq2.zzu, null));
        }
        zzg zzg2 = this.zzf().zzd(zzq2.zza);
        boolean bl = false;
        zzju zzju2 = this.zzb(zzq2.zza).zza(zzju.zzb((String)zzq2.zzt));
        String string = zzju2.zzg() ? this.zzj.zza(zzq2.zza, zzq2.zzn) : "";
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzm, zzq2.zza);
            if (zzju2.zzh()) {
                zzg2.zzb(this.zza(zzju2));
            }
            if (zzju2.zzg()) {
                zzg2.zzh(string);
            }
        } else if (zzju2.zzg() && string != null && !string.equals(zzg2.zzaj())) {
            boolean bl2 = TextUtils.isEmpty((CharSequence)zzg2.zzaj());
            zzg2.zzh(string);
            if (zzq2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzq2.zza, (zzju)zzju2).first) && !bl2) {
                if (zzju2.zzh()) {
                    zzg2.zzb(this.zza(zzju2));
                } else {
                    bl = true;
                }
                if (this.zzf().zze(zzq2.zza, "_id") != null && this.zzf().zze(zzq2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zzqa zzqa2 = new zzqa(zzq2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zzqa2);
                }
            } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzju2.zzh()) {
                zzg2.zzb(this.zza(zzju2));
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zzad()) && zzju2.zzh()) {
            zzg2.zzb(this.zza(zzju2));
        }
        zzg2.zzf(zzq2.zzb);
        zzg2.zza(zzq2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzq2.zzk)) {
            zzg2.zze(zzq2.zzk);
        }
        if (zzq2.zze != 0L) {
            zzg2.zzn(zzq2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzq2.zzc)) {
            zzg2.zzd(zzq2.zzc);
        }
        zzg2.zzb(zzq2.zzj);
        if (zzq2.zzd != null) {
            zzg2.zzc(zzq2.zzd);
        }
        zzg2.zzk(zzq2.zzf);
        zzg2.zzb(zzq2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzq2.zzg)) {
            zzg2.zzg(zzq2.zzg);
        }
        zzg2.zza(zzq2.zzn);
        zzg2.zza(zzq2.zzq);
        zzg2.zzl(zzq2.zzr);
        zzg2.zzj(zzq2.zzv);
        if (zzoh.zza() && this.zze().zza(zzbl.zzcj)) {
            zzg2.zza(zzq2.zzs);
        } else if (zzoh.zza() && this.zze().zza(zzbl.zzci)) {
            zzg2.zza((List<String>)null);
        }
        zzg2.zzc(zzq2.zzw);
        zzg2.zzk(zzq2.zzac);
        if (com.google.android.gms.internal.measurement.zzpf.zza() && this.zze().zza(zzbl.zzcu)) {
            zzg2.zza(zzq2.zzaa);
        }
        zzg2.zzt(zzq2.zzx);
        zzg2.zzi(zzq2.zzad);
        if (this.zze().zza(zzbl.zzco)) {
            zzg2.zzb(zzq2.zzaf);
        }
        if (zzg2.zzas() || bl) {
            this.zzf().zza(zzg2, bl, false);
        }
        return zzg2;
    }

    @WorkerThread
    private final @Nullable zzq zzc(String string) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzhc.zza((String)string));
            return null;
        }
        return new zzq(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzf(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak(), 0L, zzg2.zzb());
    }

    public final zzv zzc() {
        return (zzv)zzpk.zza(this.zzg);
    }

    public final zzad zzd() {
        return this.zzm.zzd();
    }

    public final zzak zze(@UnknownInitialization zzpk this) {
        return ((zzim)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzap zzf(@UnknownInitialization zzpk this) {
        return (zzap)zzpk.zza(this.zzd);
    }

    private final zzaz zzz() {
        if (this.zzai == null) {
            this.zzai = new zzpn(this, (zzjs)this.zzm);
        }
        return this.zzai;
    }

    @VisibleForTesting
    @WorkerThread
    private final zzbb zza(String string, zzbb zzbb2, zzju zzju2, zzal zzal2) {
        int n;
        if (this.zzi().zzb(string) == null) {
            int n2;
            if (zzbb2.zzc() == zzjx.zzc) {
                n2 = zzbb2.zza();
                zzal2.zza(zzju.zza.zzc, n2);
            } else {
                n2 = 90;
                zzal2.zza(zzju.zza.zzc, zzao.zzi);
            }
            return new zzbb(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
        }
        zzjx zzjx2 = zzbb2.zzc();
        if (zzjx2 == zzjx.zzd || zzjx2 == zzjx.zzc) {
            n = zzbb2.zza();
            zzal2.zza(zzju.zza.zzc, n);
        } else {
            zzju.zza zza2;
            zzju.zza zza3;
            n = 90;
            zzal zzal3 = zzal2;
            zzju zzju3 = zzju2;
            zzjx zzjx3 = zzjx2;
            String string2 = string;
            zzpk zzpk2 = this;
            if (zzjx3 == zzjx.zzb && (zza3 = zzpk2.zzb.zza(string2, zzju.zza.zzc)) != zzjx.zza) {
                zzal3.zza(zzju.zza.zzc, zzao.zzh);
                zza2 = zza3;
            } else {
                boolean bl;
                zza3 = zzpk2.zzb.zzb(string2, zzju.zza.zzc);
                zzjx zzjx4 = zzju3.zzc();
                boolean bl2 = bl = zzjx4 == zzjx.zzd || zzjx4 == zzjx.zzc;
                if (zza3 == zzju.zza.zza && bl) {
                    zzal3.zza(zzju.zza.zzc, zzao.zzc);
                    zza2 = zzjx4;
                } else {
                    zzal3.zza(zzju.zza.zzc, zzao.zzb);
                    zza2 = zzpk2.zzb.zzc(string2, zzju.zza.zzc) ? zzjx.zzd : zzjx.zzc;
                }
            }
            zzjx2 = zza2;
        }
        boolean bl = this.zzb.zzm(string);
        SortedSet<String> sortedSet = this.zzi().zzh(string);
        if (zzjx2 == zzjx.zzc || sortedSet.isEmpty()) {
            return new zzbb(Boolean.valueOf(false), n, Boolean.valueOf(bl), "-");
        }
        return new zzbb(Boolean.valueOf(true), n, Boolean.valueOf(bl), bl ? TextUtils.join((CharSequence)"", sortedSet) : "");
    }

    @WorkerThread
    private final zzbb zzd(String string) {
        this.zzl().zzv();
        this.zzt();
        zzbb zzbb2 = this.zzad.get(string);
        if (zzbb2 == null) {
            zzbb2 = this.zzf().zzf(string);
            this.zzad.put(string, zzbb2);
        }
        return zzbb2;
    }

    public final zzgv zzg() {
        return this.zzm.zzk();
    }

    public final zzhc zzj(@UnknownInitialization zzpk this) {
        return ((zzim)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzhf zzh() {
        return (zzhf)zzpk.zza(this.zzc);
    }

    private final zzhm zzaa() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzhz zzi() {
        return (zzhz)zzpk.zza(this.zzb);
    }

    public final zzij zzl(@UnknownInitialization zzpk this) {
        return ((zzim)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzim zza(zzpk zzpk2) {
        return zzpk2.zzm;
    }

    final zzim zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzju zzb(String string) {
        this.zzl().zzv();
        this.zzt();
        zzju zzju2 = this.zzac.get(string);
        if (zzju2 == null) {
            zzju2 = this.zzf().zzh(string);
            if (zzju2 == null) {
                zzju2 = zzju.zza;
            }
            this.zza(string, zzju2);
        }
        return zzju2;
    }

    public final zzme zzm() {
        return (zzme)zzpk.zza(this.zzi);
    }

    public final zzoa zzn() {
        return this.zzj;
    }

    private final zzoy zzab() {
        return (zzoy)zzpk.zza(this.zzf);
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final zzpd zza(String var1_1, zzpb var2_2) {
        if (!this.zze().zza(zzbl.zzco)) {
            return new zzpd(Collections.emptyList());
        }
        this.zzl().zzv();
        this.zzt();
        var3_3 = this.zzf().zza(var1_1, var2_2, (int)((Integer)zzbl.zzaa.zza(null)));
        var4_4 = new ArrayList<zzoz>();
        for (zzpu var6_6 : var3_3) {
            block9: {
                block11: {
                    block10: {
                        if (!this.zzb(var1_1, var6_6.zzh())) {
                            this.zzj().zzq().zza("[sgtm] batch skipped due to destination in backoff. appId, rowId, url", (Object)var1_1, (Object)var6_6.zzc(), (Object)var6_6.zzh());
                            continue;
                        }
                        var11_11 = var6_6;
                        var10_10 = this;
                        var12_12 = var11_11.zza();
                        if (var12_12 > 0) break block10;
                        v0 = true;
                        break block11;
                    }
                    if (var12_12 > (Integer)zzbl.zzy.zza(null)) ** GOTO lbl-1000
                    var13_13 = Math.min((Long)zzbl.zzw.zza(null) * (1L << var12_12 - 1), (Long)zzbl.zzx.zza(null));
                    if (var10_10.zzb().currentTimeMillis() >= var11_11.zzb() + var13_13) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (!v0) {
                    this.zzj().zzq().zza("[sgtm] batch skipped waiting for next retry. appId, rowId, lastUploadMillis", (Object)var1_1, (Object)var6_6.zzc(), (Object)var6_6.zzb());
                    continue;
                }
                var7_7 = var6_6.zze();
                try {
                    var8_8 = zzpz.zza(zzgg.zzj.zzb(), var7_7.zzb);
                    for (var9_9 = 0; var9_9 < var8_8.zza(); ++var9_9) {
                        var8_8.zza(var9_9, ((zzgg.zzk.zza)var8_8.zza(var9_9).zzch()).zzl(this.zzb().currentTimeMillis()));
                    }
                    var7_7.zzb = ((zzgg.zzj)((zzki)var8_8.zzaj())).zzce();
                    if (!this.zzj().zza(2)) break block9;
                    var7_7.zzf = this.zzp().zza((zzgg.zzj)((zzki)var8_8.zzaj()));
                }
                catch (zzkq v1) {
                    this.zzj().zzr().zza("Failed to parse queued batch. appId", (Object)var1_1);
                    continue;
                }
            }
            var4_4.add(var7_7);
        }
        return new zzpd(var4_4);
    }

    private static zzpf zza(@Nullable zzpf zzpf2) {
        if (zzpf2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzpf2.zzao()) {
            String string = String.valueOf(((Object)((Object)zzpf2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zzpf2;
    }

    public final zzpi zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzpk zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzpk> clazz = zzpk.class;
        synchronized (zzpk.class) {
            if (zza != null) return zza;
            zzpv zzpv2 = (zzpv)Preconditions.checkNotNull((Object)new zzpv(context));
            zza = new zzpk(zzpv2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzpz zzp() {
        return (zzpz)zzpk.zza(this.zzh);
    }

    public final zzqd zzq(@UnknownInitialization zzpk this) {
        return ((zzim)Preconditions.checkNotNull((Object)this.zzm)).zzv();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzg zzg2) {
        try {
            if (zzg2.zze() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionCode;
                if (zzg2.zze() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzac(), (int)0).versionName;
                String string2 = zzg2.zzaf();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    private static @Nullable Boolean zzh(zzq zzq2) {
        Boolean bl = zzq2.zzq;
        if (!TextUtils.isEmpty((CharSequence)zzq2.zzad)) {
            zzjx zzjx2 = com.google.android.gms.measurement.internal.zzf.zza((String)zzq2.zzad).zza();
            switch (zzjx2) {
                case zzd: {
                    bl = false;
                    break;
                }
                case zzc: {
                    bl = true;
                    break;
                }
                case zzb: 
                case zza: {
                    bl = null;
                }
            }
        }
        return bl;
    }

    @WorkerThread
    private final @Nullable String zza(zzju zzju2) {
        if (zzju2.zzh()) {
            zzpk zzpk2 = this;
            byte[] byArray = new byte[16];
            zzpk2.zzq().zzw().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzq zzq2) {
        Future future = this.zzl().zza((Callable)new zzpq(this, zzq2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzhc.zza((String)zzq2.zza), (Object)exception);
            return null;
        }
    }

    private static @Nullable String zza(@Nullable Map<String, List<String>> map, String string) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            if (entry.getValue().isEmpty()) {
                return null;
            }
            return entry.getValue().get(0);
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Deque zzb(zzpk zzpk2) {
        return zzpk2.zzr;
    }

    @WorkerThread
    final List<zzow> zza(zzq zzq2, Bundle bundle) {
        this.zzl().zzv();
        if (!com.google.android.gms.internal.measurement.zzpf.zza() || !this.zze().zze(zzq2.zza, zzbl.zzcu) || zzq2.zza == null) {
            return new ArrayList<zzow>();
        }
        if (bundle != null) {
            int[] nArray = bundle.getIntArray("uriSources");
            long[] lArray = bundle.getLongArray("uriTimestamps");
            if (nArray != null) {
                if (lArray == null || lArray.length != nArray.length) {
                    this.zzj().zzg().zza("Uri sources and timestamps do not match");
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        long l = lArray[i];
                        int n = nArray[i];
                        String string = zzq2.zza;
                        zzap zzap2 = this.zzf();
                        Preconditions.checkNotEmpty((String)string);
                        zzap2.zzv();
                        zzap2.zzam();
                        try {
                            int n2 = zzap2.f_().delete("trigger_uris", "app_id=? and source=? and timestamp_millis<=?", new String[]{string, String.valueOf(n), String.valueOf(l)});
                            zzap2.zzj().zzq().zza("Pruned " + n2 + " trigger URIs. appId, source, timestamp", (Object)string, (Object)n, (Object)l);
                            continue;
                        }
                        catch (SQLiteException sQLiteException) {
                            zzap2.zzj().zzg().zza("Error pruning trigger URIs. appId", zzhc.zza((String)string), (Object)sQLiteException);
                        }
                    }
                }
            }
        }
        return this.zzf().zzj(zzq2.zza);
    }

    public static /* synthetic */ void zza(zzpk zzpk2, String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Map map2 = map;
        byte[] byArray2 = byArray;
        Throwable throwable2 = throwable;
        int n2 = n;
        zzpk2.zza(string, n2, throwable2, byArray2, map2);
    }

    static /* bridge */ /* synthetic */ void zza(zzpk zzpk2, long l) {
        zzpk2.zzaj = l;
    }

    static /* synthetic */ void zza(zzpk zzpk2, zzpv zzpv2) {
        zzpk zzpk3 = zzpk2;
        zzpk3.zzl().zzv();
        zzpk zzpk4 = zzpk3;
        zzpk3.zzl = new zzht(zzpk4);
        zzpk4 = zzpk3;
        zzap zzap2 = new zzap(zzpk4);
        zzap2.zzan();
        zzpk3.zzd = zzap2;
        zzpk3.zze().zza((zzam)Preconditions.checkNotNull((Object)((Object)zzpk3.zzb)));
        zzpk4 = zzpk3;
        zzoa zzoa2 = new zzoa(zzpk4);
        zzoa2.zzan();
        zzpk3.zzj = zzoa2;
        zzpk4 = zzpk3;
        zzv zzv2 = new zzv(zzpk4);
        zzv2.zzan();
        zzpk3.zzg = zzv2;
        zzpk4 = zzpk3;
        zzme zzme2 = new zzme(zzpk4);
        zzme2.zzan();
        zzpk3.zzi = zzme2;
        zzpk4 = zzpk3;
        zzoy zzoy2 = new zzoy(zzpk4);
        zzoy2.zzan();
        zzpk3.zzf = zzoy2;
        zzpk4 = zzpk3;
        zzpk3.zze = new zzhm(zzpk4);
        if (zzpk3.zzs != zzpk3.zzt) {
            zzpk3.zzj().zzg().zza("Not all upload components initialized", (Object)zzpk3.zzs, (Object)zzpk3.zzt);
        }
        zzpk3.zzn.set(true);
    }

    static /* synthetic */ void zzc(zzpk zzpk2) {
        zzpk2.zzae();
    }

    static /* synthetic */ void zza(Context context, Intent intent) {
        zzpk.zzb(context, intent);
    }

    private zzpk(zzpv zzpv2) {
        this(zzpv2, null);
    }

    private zzpk(zzpv zzpv2, @Nullable zzim zzim2) {
        Preconditions.checkNotNull((Object)zzpv2);
        this.zzm = zzim2 = zzim.zza((Context)zzpv2.zza, null, null);
        this.zzab = -1L;
        zzpk zzpk2 = this;
        this.zzk = new zzpi(zzpk2);
        zzpk2 = this;
        zzpz zzpz2 = new zzpz(zzpk2);
        zzpz2.zzan();
        this.zzh = zzpz2;
        zzpk2 = this;
        zzhf zzhf2 = new zzhf(zzpk2);
        zzhf2.zzan();
        this.zzc = zzhf2;
        zzpk2 = this;
        zzhz zzhz2 = new zzhz(zzpk2);
        zzhz2.zzan();
        this.zzb = zzhz2;
        this.zzac = new HashMap<String, zzju>();
        this.zzad = new HashMap<String, zzbb>();
        this.zzae = new HashMap<String, zza>();
        this.zzl().zzb((Runnable)new zzpm(this, zzpv2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzv();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    @WorkerThread
    public final void zzr(@UnknownInitialization zzpk this) {
        this.zzl().zzv();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzs() {
        int n;
        this.zzl().zzv();
        this.zzt();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzah()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzad();
        int n4 = n2;
        zzpk zzpk2 = this;
        zzpk2.zzl().zzv();
        if (n4 > n3) {
            zzpk2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzpk2.zza(n3, zzpk2.zzy)) {
            zzpk2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzpk2.zzj().zzq().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzt() {
        if (!this.zzn.get()) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzac() {
        this.zzl().zzv();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzq().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzq().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzgg.zzk.zza zza2) {
        int n;
        int n2;
        String string2;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzp(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzs(string) && !TextUtils.isEmpty((CharSequence)(string2 = zza2.zzz())) && (n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
            zza2.zzp(string2);
        }
        if (this.zzi().zzt(string) && (n = zzpz.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzr(string)) {
            zza2.zzk();
        }
        if (this.zzi().zzo(string)) {
            zza2.zzh();
            if (this.zzb(string).zzh()) {
                zza zza3 = this.zzae.get(string);
                if (zza3 == null || zza3.zzb + this.zze().zzc(string, zzbl.zzbi) < this.zzb().elapsedRealtime()) {
                    zza3 = new zza(this, null);
                    this.zzae.put(string, zza3);
                }
                zza2.zzk(zza3.zza);
            }
        }
        if (this.zzi().zzq(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzl().zzv();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzah()) && TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzg2.zzac()), 204, (Throwable)null, (byte[])null, (Map<String, List<String>>)null);
            return;
        }
        String string = (String)Preconditions.checkNotNull((Object)zzg2.zzac());
        this.zzj().zzq().zza("Fetching remote configuration", (Object)string);
        zzfz.zzd zzd2 = this.zzi().zzc(string);
        ArrayMap arrayMap = null;
        String string2 = this.zzi().zze(string);
        if (zzd2 != null) {
            String string3;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzi().zzd(string)))) {
                if (arrayMap == null) {
                    arrayMap = new ArrayMap();
                }
                arrayMap.put("If-None-Match", string3);
            }
        }
        this.zzu = true;
        zzpk zzpk2 = this;
        zzpj zzpj2 = new zzpj(zzpk2);
        ArrayMap arrayMap2 = arrayMap;
        zzg zzg3 = zzg2;
        zzhf zzhf2 = this.zzh();
        zzhf2.zzv();
        zzhf2.zzam();
        Preconditions.checkNotNull((Object)zzg3);
        Preconditions.checkNotNull((Object)zzpj2);
        zzg zzg4 = zzg3;
        Uri.Builder builder = new Uri.Builder();
        String string4 = zzg4.zzah();
        if (TextUtils.isEmpty((CharSequence)string4)) {
            string4 = zzg4.zzaa();
        }
        String string5 = string4;
        builder.scheme((String)zzbl.zze.zza(null)).encodedAuthority((String)zzbl.zzf.zza(null)).path("config/app/" + string5).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "118003").appendQueryParameter("runtime_version", "0");
        String string6 = builder.build().toString();
        try {
            URL uRL = new URI(string6).toURL();
            zzhf2.zzl().zza((Runnable)new zzhk(zzhf2, zzg3.zzac(), uRL, null, (Map)arrayMap2, zzpj2));
            return;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
            zzhf2.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzhc.zza((String)zzg3.zzac()), (Object)string6);
            return;
        }
    }

    @WorkerThread
    final void zza(zzg zzg2, zzgg.zzk.zza zza2) {
        Object object4;
        zzal zzal2;
        this.zzl().zzv();
        this.zzt();
        zzal zzal3 = zzal2 = zzal.zza(zza2.zzw());
        Object object2 = zzg2.zzac();
        zzpk zzpk2 = this;
        zzpk2.zzl().zzv();
        zzpk2.zzt();
        Object object3 = zzpk2.zzb((String)object2);
        switch (object3.zzc()) {
            case zzb: {
                zzal3.zza(zzju.zza.zza, zzao.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                zzal3.zza(zzju.zza.zza, object3.zza());
                break;
            }
            default: {
                zzal3.zza(zzju.zza.zza, zzao.zzi);
            }
        }
        switch (object3.zzd()) {
            case zzb: {
                zzal3.zza(zzju.zza.zzb, zzao.zzh);
                break;
            }
            case zzd: 
            case zzc: {
                zzal3.zza(zzju.zza.zzb, object3.zza());
                break;
            }
            default: {
                zzal3.zza(zzju.zza.zzb, zzao.zzi);
            }
        }
        object3 = zzal2;
        zzal3 = zza2;
        object2 = zzg2.zzac();
        zzpk2 = this;
        zzpk2.zzl().zzv();
        zzpk2.zzt();
        zzbb zzbb2 = zzpk2.zza((String)object2, zzpk2.zzd((String)object2), zzpk2.zzb((String)object2), (zzal)object3);
        zzal3.zzb((Boolean)Preconditions.checkNotNull((Object)zzbb2.zzd()));
        if (!TextUtils.isEmpty((CharSequence)zzbb2.zze())) {
            zzal3.zzh(zzbb2.zze());
        }
        object3 = zzal2;
        zzal3 = zza2;
        object2 = zzg2;
        zzpk2 = this;
        zzpk2.zzl().zzv();
        zzpk2.zzt();
        zzbb2 = null;
        for (Object object4 : zzal3.zzac()) {
            if (!"_npa".equals(object4.zzg())) continue;
            zzbb2 = object4;
            break;
        }
        if (zzbb2 != null) {
            if (((zzal)object3).zza(zzju.zza.zzd) == zzao.zza) {
                zzqa zzqa2 = zzpk2.zzf().zze(((zzg)object2).zzac(), "_npa");
                if (zzqa2 != null) {
                    if ("tcf".equals(zzqa2.zzb)) {
                        ((zzal)object3).zza(zzju.zza.zzd, zzao.zzg);
                    } else if ("app".equals(zzqa2.zzb)) {
                        ((zzal)object3).zza(zzju.zza.zzd, zzao.zzf);
                    } else {
                        ((zzal)object3).zza(zzju.zza.zzd, zzao.zzd);
                    }
                } else {
                    object4 = ((zzg)object2).zzx();
                    if (object4 == null || ((Boolean)object4).booleanValue() && zzbb2.zzc() != 1L || !((Boolean)object4).booleanValue() && zzbb2.zzc() != 0L) {
                        ((zzal)object3).zza(zzju.zza.zzd, zzao.zzf);
                    } else {
                        ((zzal)object3).zza(zzju.zza.zzd, zzao.zzd);
                    }
                }
            }
        } else {
            int n = zzpk2.zza(((zzg)object2).zzac(), (zzal)object3);
            zzal3.zza((zzgg.zzp)((zzki)zzgg.zzp.zze().zza("_npa").zzb(zzpk2.zzb().currentTimeMillis()).zza((long)n).zzaj()));
            zzpk2.zzj().zzq().zza("Setting user property", (Object)"non_personalized_ads(_npa)", (Object)n);
        }
        zza2.zzf(zzal2.toString());
        boolean bl = this.zzb.zzm(zzg2.zzac());
        zzpk2 = zza2;
        object3 = zzpk2.zzab();
        for (int i = 0; i < object3.size(); ++i) {
            if (!"_tcf".equals(((zzgg.zzf)object3.get(i)).zzg())) continue;
            zzgg.zzf.zza zza3 = (zzgg.zzf.zza)((zzgg.zzf)object3.get(i)).zzch();
            object4 = zza3.zzf();
            for (int j = 0; j < object4.size(); ++j) {
                String string;
                if (!"_tcfd".equals(((zzgg.zzh)object4.get(j)).zzg())) continue;
                boolean bl2 = bl;
                String string2 = ((zzgg.zzh)object4.get(j)).zzh();
                if (!bl2 || string2.length() <= 4) {
                    string = string2;
                } else {
                    char[] cArray = string2.toCharArray();
                    int n = 0;
                    for (int k = 1; k < 64; ++k) {
                        if (cArray[4] != "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_".charAt(k)) continue;
                        n = k;
                        break;
                    }
                    cArray[4] = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_".charAt(n | 1);
                    string = String.valueOf(cArray);
                }
                String string3 = string;
                zza3.zza(j, zzgg.zzh.zze().zza("_tcfd").zzb(string3));
                break;
            }
            zzpk2.zza(i, zza3);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzgg.zzf.zza zza2, int n, String string) {
        List list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(((zzgg.zzh)list.get(i)).zzg())) continue;
            return;
        }
        zzgg.zzh zzh2 = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_err").zza(Long.valueOf(n).longValue()).zzaj());
        zzgg.zzh zzh3 = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_ev").zzb(string).zzaj());
        zza2.zza(zzh2).zza(zzh3);
    }

    @WorkerThread
    final void zza(zzbj zzbj2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        this.zzl().zzv();
        this.zzt();
        String string = zzq2.zza;
        long l = zzbj2.zzd;
        zzhg zzhg2 = zzhg.zza((zzbj)zzbj2);
        String string2 = string;
        zzjs zzjs2 = this;
        zzjs2.zzl().zzv();
        zzqd.zza(zzjs2.zzag == null || zzjs2.zzah == null || !zzjs2.zzah.equals(string2) ? null : zzjs2.zzag, (Bundle)zzhg2.zzc, (boolean)false);
        zzbj2 = zzhg2.zza();
        this.zzp();
        if (!zzpz.zza(zzbj2, zzq2)) {
            return;
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        if (zzq2.zzs != null) {
            if (zzq2.zzs.contains(zzbj2.zza)) {
                Bundle bundle = zzbj2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbj2 = new zzbj(zzbj2.zza, new zzbi(bundle), zzbj2.zzc, zzbj2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbj2.zza, (Object)zzbj2.zzc);
                return;
            }
        }
        this.zzf().zzq();
        try {
            zzai zzai2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            if (com.google.android.gms.internal.measurement.zzpq.zza() && this.zze().zza(zzbl.zzdj) && "_s".equals(zzbj2.zza) && !this.zzf().zzi(string, "_s") && zzbj2.zzb.zzb("_sid") != 0L) {
                if (this.zzf().zzi(string, "_f") || this.zzf().zzi(string, "_v")) {
                    this.zzf().zza(string, null, "_sid", this.zza(zzq2.zza, zzbj2));
                } else {
                    this.zzf().zza(string, (Long)(this.zzb().currentTimeMillis() - 15000L), "_sid", this.zza(zzq2.zza, zzbj2));
                }
            }
            long l2 = l;
            string2 = string;
            zzjs2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjs2.zzv();
            zzjs2.zzam();
            if (l2 < 0L) {
                zzjs2.zzj().zzr().zza("Invalid time querying timed out conditional properties", zzhc.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzjs2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzq().zza("User property timed out", (Object)((zzai)object22).zza, (Object)this.zzm.zzk().zzc(((zzai)object22).zzc.zza), ((zzai)object22).zzc.zza());
                if (((zzai)object22).zzg != null) {
                    this.zzc(new zzbj(((zzai)object22).zzg, l), zzq2);
                }
                this.zzf().zza(string, ((zzai)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzjs2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzjs2.zzv();
            zzjs2.zzam();
            if (l2 < 0L) {
                zzjs2.zzj().zzr().zza("Invalid time querying expired conditional properties", zzhc.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzjs2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzai)object4.next();
                if (object == null) continue;
                this.zzj().zzq().zza("User property expired", (Object)((zzai)object).zza, (Object)this.zzm.zzk().zzc(((zzai)object).zzc.zza), ((zzai)object).zzc.zza());
                this.zzf().zzh(string, ((zzai)object).zzc.zza);
                if (((zzai)object).zzk != null) {
                    object22.add(((zzai)object).zzk);
                }
                this.zzf().zza(string, ((zzai)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbj)e;
                this.zzc(new zzbj((zzbj)object, l), zzq2);
            }
            long l3 = l;
            String string4 = zzbj2.zza;
            string2 = string;
            zzjs2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzjs2.zzv();
            zzjs2.zzam();
            if (l3 < 0L) {
                zzjs2.zzj().zzr().zza("Invalid time querying triggered conditional properties", zzhc.zza((String)string2), (Object)zzjs2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzjs2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzai2 = (zzai)iterator.next();
                if (zzai2 == null) continue;
                zzpy zzpy2 = zzai2.zzc;
                zzqa zzqa2 = new zzqa((String)Preconditions.checkNotNull((Object)zzai2.zza), zzai2.zzb, zzpy2.zza, l, Preconditions.checkNotNull((Object)zzpy2.zza()));
                if (this.zzf().zza(zzqa2)) {
                    this.zzj().zzq().zza("User property triggered", (Object)zzai2.zza, (Object)this.zzm.zzk().zzc(zzqa2.zzc), zzqa2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzhc.zza((String)zzai2.zza), (Object)this.zzm.zzk().zzc(zzqa2.zzc), zzqa2.zze);
                }
                if (zzai2.zzi != null) {
                    object.add(zzai2.zzi);
                }
                zzai2.zzc = new zzpy(zzqa2);
                zzai2.zze = true;
                this.zzf().zza(zzai2);
            }
            this.zzc(zzbj2, zzq2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzai2 = (zzbj)e;
                this.zzc(new zzbj((zzbj)zzai2, l), zzq2);
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zza(zzbj zzbj2, String string) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaf())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzbj2.zza)) {
                this.zzj().zzr().zza("Could not find package. appId", zzhc.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzhc.zza((String)string));
            return;
        }
        zzq zzq2 = new zzq(string, zzg2.zzah(), zzg2.zzaf(), zzg2.zze(), zzg2.zzae(), zzg2.zzq(), zzg2.zzn(), null, zzg2.zzar(), false, zzg2.zzag(), 0L, 0, zzg2.zzaq(), false, zzg2.zzaa(), zzg2.zzx(), zzg2.zzo(), zzg2.zzan(), null, this.zzb(string).zzf(), "", null, zzg2.zzat(), zzg2.zzw(), this.zzb(string).zza(), this.zzd(string).zzf(), zzg2.zza(), zzg2.zzf(), zzg2.zzam(), zzg2.zzak(), 0L, zzg2.zzb());
        this.zzb(zzbj2, zzq2);
    }

    @WorkerThread
    private final void zzb(zzbj zzbj2, zzq zzq2) {
        String string;
        Preconditions.checkNotEmpty((String)zzq2.zza);
        zzhg zzhg2 = zzhg.zza((zzbj)zzbj2);
        this.zzq().zza(zzhg2.zzc, this.zzf().zzc(zzq2.zza));
        this.zzq().zza(zzhg2, this.zze().zzb(zzq2.zza));
        zzbj2 = zzhg2.zza();
        zzq zzq3 = zzq2;
        zzbj zzbj3 = zzbj2;
        zzpk zzpk2 = this;
        if ("_cmp".equals(zzbj3.zza) && "referrer API v2".equals(zzbj3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbj3.zzb.zzd("gclid")))) {
            zzpy zzpy2 = new zzpy("_lgclid", zzbj3.zzd, (Object)string, "auto");
            zzpk2.zza(zzpy2, zzq3);
        }
        this.zza(zzbj2, zzq2);
    }

    @VisibleForTesting
    private final void zza(zzgg.zzk.zza zza2, long l, boolean bl) {
        zzqa zzqa2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzqa2 = (zzqa2 = this.zzf().zze(zza2.zzu(), string)) == null || zzqa2.zze == null ? new zzqa(zza2.zzu(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zzqa(zza2.zzu(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zzqa2.zze + l));
        zzgg.zzp zzp2 = (zzgg.zzp)((zzki)zzgg.zzp.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza(((Long)zzqa2.zze).longValue()).zzaj());
        boolean bl2 = false;
        int n = zzpz.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzp2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzp2);
        }
        if (l > 0L) {
            this.zzf().zza(zzqa2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzq().zza("Updated engagement user property. scope, value", (Object)string2, zzqa2.zze);
        }
    }

    final void zzu() {
        ++this.zzt;
    }

    @WorkerThread
    private final void zzad() {
        this.zzl().zzv();
        this.zzae();
    }

    @VisibleForTesting
    @WorkerThread
    private final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzq().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzq();
            try {
                boolean bl;
                zzg zzg2 = this.zzf().zzd(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj().zzr().zza("App does not exist in onConfigFetched. appId", zzhc.zza((String)string));
                } else if (bl || n == 404) {
                    String string2 = zzpk.zza(map, "Last-Modified");
                    String string3 = zzpk.zza(map, "ETag");
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string2, string3)) {
                        return;
                    }
                    zzg2.zzd(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    if (n == 404) {
                        this.zzj().zzw().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzq().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzr() && this.zzag()) {
                        this.zzx();
                    } else if (this.zze().zza(zzbl.zzcl) && this.zzh().zzr() && this.zzf().zzq(zzg2.zzac())) {
                        this.zze(zzg2.zzac());
                    } else {
                        this.zzaf();
                    }
                } else {
                    zzg2.zzm(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2, false, false);
                    this.zzj().zzq().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zze.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzaf();
                }
                this.zzf().zzx();
            }
            finally {
                this.zzf().zzr();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzac();
        }
    }

    final void zza(boolean bl) {
        this.zzaf();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string, List<Pair<zzgg.zzj, zzph>> list) {
        this.zzl().zzv();
        this.zzt();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list2 = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (!bl || (n == 200 || n == 204) && throwable == null) {
                this.zzj().zzq().zza("Network upload successful with code, uploadAttempted", (Object)n, (Object)bl);
                try {
                    if (bl) {
                        this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zze.zza(0L);
                    this.zzaf();
                    if (bl) {
                        this.zzj().zzq().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else {
                        this.zzj().zzq().zza("Purged empty bundles");
                    }
                    this.zzf().zzq();
                    try {
                        if (this.zze().zza(zzbl.zzcl)) {
                            Object object;
                            if (this.zze().zza(zzbl.zzco)) {
                                zzph zzph2;
                                HashMap hashMap = new HashMap();
                                for (Pair<zzgg.zzj, zzph> pair2 : list) {
                                    object = (zzgg.zzj)pair2.first;
                                    zzph2 = (zzph)pair2.second;
                                    if (zzph2.zza() == zzmf.zzd) continue;
                                    long l = this.zzf().zza(string, (zzgg.zzj)object, zzph2.zzc(), zzph2.zzd(), zzph2.zza(), null);
                                    if (zzph2.zza() != zzmf.zze || l == -1L || object.zzd().isEmpty()) continue;
                                    hashMap.put(object.zzd(), l);
                                }
                                for (Pair<zzgg.zzj, zzph> pair2 : list) {
                                    object = (zzgg.zzj)pair2.first;
                                    zzph2 = (zzph)pair2.second;
                                    if (zzph2.zza() != zzmf.zzd) continue;
                                    Long l = (Long)hashMap.get(object.zzd());
                                    this.zzf().zza(string, (zzgg.zzj)object, zzph2.zzc(), zzph2.zzd(), zzph2.zza(), l);
                                }
                            } else {
                                for (Pair pair : list) {
                                    Pair<zzgg.zzj, zzph> pair2;
                                    pair2 = (Pair<zzgg.zzj, zzph>)pair.first;
                                    object = (zzph)pair.second;
                                    this.zzf().zza(string, (zzgg.zzj)pair2, ((zzph)object).zzc(), ((zzph)object).zzd(), ((zzph)object).zza(), null);
                                }
                            }
                        }
                        for (Long l : list2) {
                            try {
                                long l2 = l;
                                zzap zzap2 = this.zzf();
                                zzap2.zzv();
                                zzap2.zzam();
                                SQLiteDatabase sQLiteDatabase = zzap2.f_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzap2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzx();
                    }
                    finally {
                        this.zzf().zzr();
                    }
                    this.zzaa = null;
                    if (this.zze().zza(zzbl.zzcl) && this.zzh().zzr() && this.zzf().zzq(string)) {
                        this.zze(string);
                    } else if (this.zzh().zzr() && this.zzag()) {
                        this.zzx();
                    } else {
                        this.zzab = -1L;
                        this.zzaf();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzq().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = string2.substring(0, Math.min(32, string2.length()));
                this.zzj().zzw().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable, (Object)string3);
                this.zzj.zze.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list2);
                this.zzaf();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzac();
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(@NonNull String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable zzpu zzpu2) {
        this.zzl().zzv();
        this.zzt();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if ((n == 200 || n == 204) && throwable == null) {
                if (zzpu2 != null) {
                    this.zzf().zza((Long)zzpu2.zzc());
                }
                this.zzj().zzq().zza("Successfully uploaded batch from upload queue. appId, status", (Object)string, (Object)n);
                if (this.zze().zza(zzbl.zzcl) && this.zzh().zzr() && this.zzf().zzq(string)) {
                    this.zze(string);
                } else {
                    this.zzaf();
                }
            } else {
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                String string3 = string2.substring(0, Math.min(32, string2.length()));
                this.zzj().zzw().zza("Network upload failed. Will retry later. appId, status, error", (Object)string, (Object)n, throwable == null ? string3 : throwable);
                if (zzpu2 != null) {
                    this.zzf().zzb((Long)zzpu2.zzc());
                }
                this.zzaf();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzac();
        }
    }

    @WorkerThread
    final void zzb(zzg zzg2, zzgg.zzk.zza zza2) {
        this.zzl().zzv();
        this.zzt();
        zzgg.zza.zza zza3 = zzgg.zza.zzc();
        byte[] byArray = zzg2.zzav();
        if (byArray != null) {
            try {
                zza3 = zzpz.zza(zza3, byArray);
            }
            catch (zzkq zzkq2) {
                this.zzj().zzr().zza("Failed to parse locally stored ad campaign info. appId", zzhc.zza((String)zzg2.zzac()));
            }
        }
        for (zzgg.zzf zzf2 : zza2.zzab()) {
            if (!zzf2.zzg().equals("_cmp")) continue;
            zzgg.zzf zzf3 = zzf2;
            zzgg.zza.zza zza4 = zza3;
            zzpk zzpk2 = this;
            String string = (String)zzpz.zza(zzf3, "gclid", (Object)"");
            String string2 = (String)zzpz.zza(zzf3, "gbraid", (Object)"");
            String string3 = (String)zzpz.zza(zzf3, "gad_source", (Object)"");
            if (string.isEmpty() && string2.isEmpty()) continue;
            long l = (Long)zzpz.zza(zzf3, "click_timestamp", (Object)0L);
            if (l <= 0L) {
                l = zzf3.zzd();
            }
            if ("referrer API v2".equals(zzpz.zzb(zzf3, "_cis"))) {
                if (!(l > zza4.zzb())) continue;
                if (string.isEmpty()) {
                    zza4.zzh();
                } else {
                    zza4.zzf(string);
                }
                if (string2.isEmpty()) {
                    zza4.zzg();
                } else {
                    zza4.zze(string2);
                }
                if (string3.isEmpty()) {
                    zza4.zzf();
                } else {
                    zza4.zzd(string3);
                }
                zza4.zzb(l);
                continue;
            }
            if (!(l > zza4.zza())) continue;
            if (string.isEmpty()) {
                zza4.zze();
            } else {
                zza4.zzc(string);
            }
            if (string2.isEmpty()) {
                zza4.zzd();
            } else {
                zza4.zzb(string2);
            }
            if (string3.isEmpty()) {
                zza4.zzc();
            } else {
                zza4.zza(string3);
            }
            zza4.zza(l);
        }
        if (!((zzgg.zza)((zzki)zza3.zzaj())).equals((Object)zzgg.zza.zze())) {
            zza2.zza((zzgg.zza)((zzki)zza3.zzaj()));
        }
        zzg2.zza(((zzgg.zza)((zzki)zza3.zzaj())).zzce());
        if (zzg2.zzas()) {
            this.zzf().zza(zzg2, false, false);
        }
    }

    @WorkerThread
    final void zzc(zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        if (this.zze().zza(zzbl.zzbx)) {
            long l;
            long l2 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbl.zzbg);
            this.zze();
            long l3 = l2 - com.google.android.gms.measurement.internal.zzak.zzg();
            for (int i = 0; i < n && this.zzb(null, l = l3); ++i) {
            }
        } else {
            this.zze();
            long l = com.google.android.gms.measurement.internal.zzak.zzh();
            int n = 0;
            while ((long)n < l && this.zzb(zzq2.zza, 0L)) {
                ++n;
            }
        }
        if (this.zze().zza(zzbl.zzby)) {
            this.zzad();
        }
        if (this.zze().zza(zzbl.zzcp) && this.zzk.zza(zzq2.zza, zzgg.zzo.zzb.zza((int)zzq2.zzaf))) {
            this.zzj().zzq().zza("[sgtm] Going background, trigger client side upload. appId", (Object)zzq2.zza);
            this.zza(zzq2.zza, this.zzb().currentTimeMillis());
        }
    }

    @WorkerThread
    final void zzd(zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.zza);
        if (!zzpk.zzi(zzq2)) {
            return;
        }
        zzg zzg2 = this.zzf().zzd(zzq2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzah()) && !TextUtils.isEmpty((CharSequence)zzq2.zzb)) {
            zzg2.zzd(0L);
            this.zzf().zza(zzg2, false, false);
            this.zzi().zzj(zzq2.zza);
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        long l = zzq2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzv();
        int n = zzq2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzr().zza("Incorrect app type, assuming installed app. appId, appType", zzhc.zza((String)zzq2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzq();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzap zzap2;
            String string2;
            zzpy zzpy2;
            zzqa zzqa2 = this.zzf().zze(zzq2.zza, "_npa");
            Boolean bl = zzpk.zzh(zzq2);
            if (zzqa2 == null || "auto".equals(zzqa2.zzb)) {
                if (bl != null) {
                    zzpy2 = new zzpy("_npa", l, (Object)(bl != false ? 1L : 0L), "auto");
                    if (zzqa2 == null || !zzqa2.zze.equals(zzpy2.zzc)) {
                        this.zza(zzpy2, zzq2);
                    }
                } else if (zzqa2 != null) {
                    this.zza("_npa", zzq2);
                }
            }
            long l2 = l;
            zzq zzq3 = zzq2;
            zzpk zzpk2 = this;
            Object object3 = zzpk2.zzf().zzd((String)Preconditions.checkNotNull((Object)zzq3.zza));
            if (object3 != null) {
                zzpk2.zzq();
                if (zzqd.zza((String)zzq3.zzb, (String)((zzg)object3).zzah(), (String)zzq3.zzp, (String)((zzg)object3).zzaa())) {
                    zzpk2.zzj().zzr().zza("New GMP App Id passed in. Removing cached database data. appId", zzhc.zza((String)((zzg)object3).zzac()));
                    string2 = ((zzg)object3).zzac();
                    zzap2 = zzpk2.zzf();
                    zzap2.zzam();
                    zzap2.zzv();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzap2.f_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzap2.zzj().zzq().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzap2.zzj().zzg().zza("Error deleting application data. appId, error", zzhc.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl2 = ((zzg)object3).zze() != Integer.MIN_VALUE && ((zzg)object3).zze() != zzq3.zzj;
                string = ((zzg)object3).zzaf();
                if (bl2 | (((zzg)object3).zze() == Integer.MIN_VALUE && string != null && !string.equals(zzq3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbj("_au", new zzbi(bundle), "auto", l2);
                    zzpk2.zza((zzbj)object, zzq3);
                }
            }
            this.zza(zzq2);
            zzpy2 = null;
            if (n == 0) {
                zzpy2 = this.zzf().zzd(zzq2.zza, "_f");
            } else if (n == 1) {
                zzpy2 = this.zzf().zzd(zzq2.zza, "_v");
            }
            if (zzpy2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzpy zzpy3 = new zzpy("_fot", l, (Object)l3, "auto");
                    this.zza(zzpy3, zzq2);
                    zzq3 = zzq2;
                    zzpk2 = this;
                    zzpk2.zzl().zzv();
                    String string3 = zzq3.zza;
                    zzht zzht2 = (zzht)Preconditions.checkNotNull((Object)zzpk2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzht2.zza.zzj().zzx().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzht2.zza.zzl().zzv();
                        if (!zzht2.zza()) {
                            zzht2.zza.zzj().zzp().zza("Install Referrer Reporter is not available");
                        } else {
                            zzhw zzhw2 = new zzhw(zzht2, string3);
                            object3 = zzht2;
                            ((zzht)object3).zza.zzl().zzv();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzht)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzht)object3).zza.zzj().zzx().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzap2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzap2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzap2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzap2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzht)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl3 = ConnectionTracker.getInstance().bindService(((zzht)object3).zza.zza(), intent, (ServiceConnection)zzhw2, 1);
                                                ((zzht)object3).zza.zzj().zzq().zza("Install Referrer Service is", (Object)(bl3 ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzht)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzht)object3).zza.zzj().zzr().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzht)object3).zza.zzj().zzp().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzq3 = zzq2;
                    zzpk2 = this;
                    zzpk2.zzl().zzv();
                    zzpk2.zzt();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzq3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzq3.zza);
                    object2 = string4;
                    zzap zzap3 = zzpk2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzap3.zzv();
                    zzap3.zzam();
                    long l5 = zzap3.zzb((String)object2, "first_open_count");
                    if (zzpk2.zzm.zza().getPackageManager() == null) {
                        zzpk2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzhc.zza((String)string4));
                    } else {
                        zzap2 = null;
                        try {
                            zzap2 = Wrappers.packageManager((Context)zzpk2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzpk2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzhc.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzap2 != null && ((PackageInfo)zzap2).firstInstallTime != 0L) {
                            boolean bl4 = false;
                            if (((PackageInfo)zzap2).firstInstallTime != ((PackageInfo)zzap2).lastUpdateTime) {
                                if (zzpk2.zze().zza(zzbl.zzcg)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl4 = true;
                            }
                            sQLiteDatabase = new zzpy("_fi", l4, (Object)(bl4 ? 1L : 0L), "auto");
                            zzpk2.zza((zzpy)sQLiteDatabase, zzq3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzpk2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzpk2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzhc.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzap2 = new zzbj("_f", new zzbi((Bundle)object3), "auto", l4);
                    zzpk2.zzb((zzbj)zzap2, zzq3);
                } else if (n == 1) {
                    zzpy zzpy4 = new zzpy("_fvt", l, (Object)l3, "auto");
                    this.zza(zzpy4, zzq2);
                    l2 = l;
                    zzq3 = zzq2;
                    zzpk2 = this;
                    zzpk2.zzl().zzv();
                    zzpk2.zzt();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzq3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbj zzbj2 = new zzbj("_v", new zzbi((Bundle)object3), "auto", l2);
                    zzpk2.zzb(zzbj2, zzq3);
                }
            } else if (zzq2.zzi) {
                l2 = l;
                zzq3 = zzq2;
                zzpk2 = this;
                object3 = new Bundle();
                zzbj zzbj3 = new zzbj("_cd", new zzbi((Bundle)object3), "auto", l2);
                zzpk2.zzb(zzbj3, zzq3);
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    final void zzv() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzai zzai2) {
        zzq zzq2 = this.zzc((String)Preconditions.checkNotNull((Object)zzai2.zza));
        if (zzq2 != null) {
            this.zza(zzai2, zzq2);
        }
    }

    @WorkerThread
    final void zza(zzai zzai2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)zzai2.zza);
        Preconditions.checkNotNull((Object)zzai2.zzc);
        Preconditions.checkNotEmpty((String)zzai2.zzc.zza);
        this.zzl().zzv();
        this.zzt();
        if (!zzpk.zzi(zzq2)) {
            return;
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        this.zzf().zzq();
        try {
            this.zza(zzq2);
            String string = (String)Preconditions.checkNotNull((Object)zzai2.zza);
            zzai zzai3 = this.zzf().zzc(string, zzai2.zzc.zza);
            if (zzai3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzai2.zza, (Object)this.zzm.zzk().zzc(zzai2.zzc.zza));
                this.zzf().zza(string, zzai2.zzc.zza);
                if (zzai3.zze) {
                    this.zzf().zzh(string, zzai2.zzc.zza);
                }
                if (zzai2.zzk != null) {
                    Bundle bundle = null;
                    if (zzai2.zzk.zzb != null) {
                        bundle = zzai2.zzk.zzb.zzb();
                    }
                    zzbj zzbj2 = this.zzq().zza(string, ((zzbj)Preconditions.checkNotNull((Object)zzai2.zzk)).zza, bundle, zzai3.zzb, zzai2.zzk.zzd, true, true);
                    this.zzc((zzbj)Preconditions.checkNotNull((Object)zzbj2), zzq2);
                }
            } else {
                this.zzj().zzr().zza("Conditional user property doesn't exist", zzhc.zza((String)zzai2.zza), (Object)this.zzm.zzk().zzc(zzai2.zzc.zza));
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @VisibleForTesting
    private static void zza(zzgg.zzf.zza zza2, @NonNull String string) {
        List list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(((zzgg.zzh)list.get(i)).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        if (!zzpk.zzi(zzq2)) {
            return;
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        Boolean bl = zzpk.zzh(zzq2);
        if ("_npa".equals(string) && bl != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zzpy zzpy2 = new zzpy("_npa", this.zzb().currentTimeMillis(), (Object)(bl != false ? 1L : 0L), "auto");
            this.zza(zzpy2, zzq2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzq();
        try {
            this.zza(zzq2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzq2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzq2.zza), string);
            this.zzf().zzx();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zze(zzq zzq2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzq2.zza);
        zzap zzap2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzap2.zzv();
        zzap2.zzam();
        try {
            SQLiteDatabase sQLiteDatabase = zzap2.f_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("events_snapshot", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray) + sQLiteDatabase.delete("upload_queue", "app_id=?", stringArray);
            if (n > 0) {
                zzap2.zzj().zzq().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzap2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzhc.zza((String)string), (Object)sQLiteException);
        }
        if (zzq2.zzh) {
            this.zzd(zzq2);
        }
    }

    @WorkerThread
    private final void zzae() {
        this.zzl().zzv();
        if (!this.zzr.isEmpty() && !this.zzz().zzc()) {
            long l = this.zzb().elapsedRealtime() - this.zzaj;
            long l2 = Math.max(0L, (long)((Integer)zzbl.zzbz.zza(null)).intValue() - l);
            this.zzj().zzq().zza("Scheduling notify next app runnable, delay in ms", (Object)l2);
            this.zzz().zza(l2);
        }
    }

    private static void zzb(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 34) {
            context.sendBroadcast(intent);
            return;
        }
        context.sendBroadcast(intent, null, BroadcastOptions.makeBasic().setShareIdentityEnabled(true).toBundle());
    }

    @WorkerThread
    final void zzf(zzq zzq2) {
        boolean bl;
        zzjx zzjx2;
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)zzq2.zza);
        zzbb zzbb2 = zzbb.zza((String)zzq2.zzz);
        this.zzj().zzq().zza("Setting DMA consent for package", (Object)zzq2.zza, (Object)zzbb2);
        zzbb zzbb3 = zzbb2;
        String string = zzq2.zza;
        zzpk zzpk2 = this;
        zzpk2.zzl().zzv();
        zzpk2.zzt();
        zzjx zzjx3 = zzbb.zza((Bundle)zzpk2.zza(string), (int)100).zzc();
        zzpk2.zzad.put(string, zzbb3);
        zzpk2.zzf().zza(string, zzbb3);
        zzjx zzjx4 = zzjx2 = zzbb.zza((Bundle)zzpk2.zza(string), (int)100).zzc();
        zzjx zzjx5 = zzjx3;
        String string2 = string;
        zzpk zzpk3 = zzpk2;
        zzpk3.zzl().zzv();
        zzpk3.zzt();
        boolean bl2 = zzjx5 == zzjx.zzc && zzjx4 == zzjx.zzd;
        boolean bl3 = bl = zzjx5 == zzjx.zzd && zzjx4 == zzjx.zzc;
        if (bl2 || bl) {
            zzpk3.zzj().zzq().zza("Generated _dcu event for", (Object)string2);
            Bundle bundle = new Bundle();
            if (zzpk3.zzf().zza((long)zzpk3.zzy(), (String)string2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzf < (long)zzpk3.zze().zzb(string2, zzbl.zzbk)) {
                bundle.putLong("_r", 1L);
                zzau zzau2 = zzpk3.zzf().zza(zzpk3.zzy(), string2, false, false, false, false, false, true, false);
                zzpk3.zzj().zzq().zza("_dcu realtime event count", (Object)string2, (Object)zzau2.zzf);
            }
            zzpk3.zzak.zza(string2, "_dcu", bundle);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzmh zzmh2) {
        this.zzl().zzv();
        if (this.zzah == null || this.zzah.equals(string) || zzmh2 != null) {
            this.zzah = string;
            this.zzag = zzmh2;
        }
    }

    @WorkerThread
    final void zzg(zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        Preconditions.checkNotEmpty((String)zzq2.zza);
        int n = zzq2.zzy;
        zzju zzju2 = zzju.zza((String)zzq2.zzt, (int)n);
        this.zzb(zzq2.zza);
        this.zzj().zzq().zza("Setting storage consent for package", (Object)zzq2.zza, (Object)zzju2);
        this.zza(zzq2.zza, zzju2);
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzw() {
        this.zzl().zzv();
        this.zzf().zzw();
        zzap zzap2 = this.zzf();
        zzap2.zzv();
        zzap2.zzam();
        if (zzap2.zzab() && (Long)zzbl.zzbt.zza(null) != 0L) {
            String[] stringArray;
            SQLiteDatabase sQLiteDatabase = zzap2.f_();
            int n = sQLiteDatabase.delete("trigger_uris", "abs(timestamp_millis - ?) > cast(? as integer)", stringArray = new String[]{String.valueOf(zzap2.zzb().currentTimeMillis()), String.valueOf(zzbl.zzbt.zza(null))});
            if (n > 0) {
                zzap2.zzj().zzq().zza("Deleted stale trigger uris. rowsDeleted", (Object)n);
            }
        }
        if (this.zzj.zzd.zza() == 0L) {
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzaf();
    }

    @WorkerThread
    final void zzb(zzai zzai2) {
        zzq zzq2 = this.zzc((String)Preconditions.checkNotNull((Object)zzai2.zza));
        if (zzq2 != null) {
            this.zzb(zzai2, zzq2);
        }
    }

    @WorkerThread
    final void zzb(zzai zzai2, zzq zzq2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)zzai2.zza);
        Preconditions.checkNotNull((Object)zzai2.zzb);
        Preconditions.checkNotNull((Object)zzai2.zzc);
        Preconditions.checkNotEmpty((String)zzai2.zzc.zza);
        this.zzl().zzv();
        this.zzt();
        if (!zzpk.zzi(zzq2)) {
            return;
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        zzai zzai3 = new zzai(zzai2);
        new zzai(zzai2).zze = false;
        this.zzf().zzq();
        try {
            boolean bl = false;
            zzai zzai4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzai3.zza), zzai3.zzc.zza);
            if (zzai4 != null && !zzai4.zzb.equals(zzai3.zzb)) {
                this.zzj().zzr().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzai3.zzc.zza), (Object)zzai3.zzb, (Object)zzai4.zzb);
            }
            if (zzai4 != null && zzai4.zze) {
                zzai3.zzb = zzai4.zzb;
                zzai3.zzd = zzai4.zzd;
                zzai3.zzh = zzai4.zzh;
                zzai3.zzf = zzai4.zzf;
                zzai3.zzi = zzai4.zzi;
                zzai3.zze = zzai4.zze;
                zzai3.zzc = new zzpy(zzai3.zzc.zza, zzai4.zzc.zzb, zzai3.zzc.zza(), zzai4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzai3.zzf)) {
                zzai3.zzc = new zzpy(zzai3.zzc.zza, zzai3.zzd, zzai3.zzc.zza(), zzai3.zzc.zze);
                zzai3.zze = true;
                bl = true;
            }
            if (zzai3.zze) {
                zzpy zzpy2 = zzai3.zzc;
                zzqa zzqa2 = new zzqa((String)Preconditions.checkNotNull((Object)zzai3.zza), zzai3.zzb, zzpy2.zza, zzpy2.zzb, Preconditions.checkNotNull((Object)zzpy2.zza()));
                if (this.zzf().zza(zzqa2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzai3.zza, (Object)this.zzm.zzk().zzc(zzqa2.zzc), zzqa2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzhc.zza((String)zzai3.zza), (Object)this.zzm.zzk().zzc(zzqa2.zzc), zzqa2.zze);
                }
                if (bl && zzai3.zzi != null) {
                    zzbj zzbj2 = new zzbj(zzai3.zzi, zzai3.zzd);
                    this.zzc(zzbj2, zzq2);
                }
            }
            if (this.zzf().zza(zzai3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzai3.zza, (Object)this.zzm.zzk().zzc(zzai3.zzc.zza), zzai3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzhc.zza((String)zzai3.zza), (Object)this.zzm.zzk().zzc(zzai3.zzc.zza), zzai3.zzc.zza());
            }
            this.zzf().zzx();
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zza(String string, zzag zzag2) {
        if (!this.zze().zza(zzbl.zzco)) {
            return;
        }
        this.zzl().zzv();
        this.zzt();
        zzpu zzpu2 = this.zzf().zza(zzag2.zza);
        if (zzpu2 == null) {
            this.zzj().zzr().zza("[sgtm] Queued batch doesn't exist. appId, rowId", (Object)string, (Object)zzag2.zza);
            return;
        }
        String string2 = zzpu2.zzh();
        if (zzag2.zzb == zzmg.zzb.zza()) {
            if (this.zzaf.containsKey(string2)) {
                this.zzaf.remove(string2);
            }
            this.zzf().zza((Long)zzag2.zza);
            this.zzj().zzq().zza("[sgtm] queued batch deleted after successful client upload. appId, rowId", (Object)string, (Object)zzag2.zza);
            if (zzag2.zzc > 0L) {
                long l = zzag2.zzc;
                String string3 = string;
                zzap zzap2 = this.zzf();
                if (zzap2.zze().zza(zzbl.zzco)) {
                    zzap2.zzv();
                    zzap2.zzam();
                    Preconditions.checkNotNull((Object)l);
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("upload_type", Integer.valueOf(zzmf.zzb.zza()));
                    contentValues.put("creation_timestamp", Long.valueOf(zzap2.zzb().currentTimeMillis()));
                    try {
                        if ((long)zzap2.f_().update("upload_queue", contentValues, "rowid=? AND app_id=? AND upload_type=?", new String[]{String.valueOf(l), string3, String.valueOf(zzmf.zze.zza())}) != 1L) {
                            zzap2.zzj().zzr().zza("Google Signal pending batch not updated. appId, rowId", (Object)string3, (Object)l);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzap2.zzj().zzg().zza("Failed to update google Signal pending batch. appid, rowId", (Object)string3, (Object)l, (Object)sQLiteException);
                        throw sQLiteException;
                    }
                }
                this.zzj().zzq().zza("[sgtm] queued Google Signal batch updated. appId, signalRowId", (Object)string, (Object)zzag2.zzc);
                this.zze(string);
                return;
            }
        } else {
            if (zzag2.zzb == zzmg.zzd.zza()) {
                zzc zzc2 = this.zzaf.get(string2);
                if (zzc2 == null) {
                    zzc2 = new zzc(this);
                    this.zzaf.put(string2, zzc2);
                } else {
                    zzc2.zza();
                }
                long l = (zzc2.zzc - this.zzb().currentTimeMillis()) / 1000L;
                this.zzj().zzq().zza("[sgtm] Putting sGTM server in backoff mode. appId, destination, nextRetryInSeconds", (Object)string, (Object)string2, (Object)l);
            }
            this.zzf().zzb((Long)zzag2.zza);
            this.zzj().zzq().zza("[sgtm] increased batch retry count after failed client upload. appId, rowId", (Object)string, (Object)zzag2.zza);
        }
    }

    @WorkerThread
    private final void zzaf() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzv();
            this.zzt();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzq().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzaa().zzb();
                    this.zzab().zzr();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzah() || !this.zzag()) {
                this.zzj().zzq().zza("Nothing to upload or uploading impossible");
                this.zzaa().zzb();
                this.zzab().zzr();
                return;
            }
            zzpk zzpk2 = this;
            long l5 = zzpk2.zzb().currentTimeMillis();
            zzpk2.zze();
            long l6 = Math.max(0L, (Long)zzbl.zzan.zza(null));
            boolean bl = zzpk2.zzf().zzaa() || zzpk2.zzf().zzz();
            if (bl) {
                String string = zzpk2.zze().zzp();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzpk2.zze();
                    l4 = Math.max(0L, (Long)zzbl.zzai.zza(null));
                } else {
                    zzpk2.zze();
                    l4 = Math.max(0L, (Long)zzbl.zzah.zza(null));
                }
            } else {
                zzpk2.zze();
                l4 = Math.max(0L, (Long)zzbl.zzag.zza(null));
            }
            long l7 = zzpk2.zzj.zzd.zza();
            long l8 = zzpk2.zzj.zze.zza();
            long l9 = zzpk2.zzf().d_();
            long l10 = zzpk2.zzf().e_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzpk2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzpk2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbl.zzap.zza(null)))) break;
                        long l15 = 1L << n;
                        zzpk2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbl.zzao.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzq().zza("Next upload time is 0");
            this.zzaa().zzb();
            this.zzab().zzr();
            return;
        }
        if (!this.zzh().zzr()) {
            this.zzj().zzq().zza("No network");
            this.zzaa().zza();
            this.zzab().zzr();
            return;
        }
        l2 = this.zzj.zzc.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbl.zzae.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzaa().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbl.zzaj.zza(null));
            this.zzj.zzd.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzq().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzab().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, zzju zzju2) {
        this.zzl().zzv();
        this.zzt();
        this.zzac.put(string, zzju2);
        this.zzf().zzb(string, zzju2);
    }

    @WorkerThread
    private final void zza(String string, boolean bl, @Nullable Long l, @Nullable Long l2) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 != null) {
            zzg2.zzd(bl);
            zzg2.zza(l);
            zzg2.zzb(l2);
            if (zzg2.zzas()) {
                this.zzf().zza(zzg2, false, false);
            }
        }
    }

    @WorkerThread
    final void zza(zzpy zzpy2, zzq zzq2) {
        this.zzl().zzv();
        this.zzt();
        if (!zzpk.zzi(zzq2)) {
            return;
        }
        if (!zzq2.zzh) {
            this.zza(zzq2);
            return;
        }
        int n = this.zzq().zzb(zzpy2.zza);
        if (n != 0) {
            this.zzq();
            String string = zzpy2.zza;
            this.zze();
            String string2 = zzqd.zza((String)string, (int)24, (boolean)true);
            int n2 = zzpy2.zza != null ? zzpy2.zza.length() : 0;
            this.zzq();
            zzqd.zza((zzqc)this.zzak, (String)zzq2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zzpy2.zza, zzpy2.zza());
        if (n != 0) {
            this.zzq();
            String string = zzpy2.zza;
            this.zze();
            String string3 = zzqd.zza((String)string, (int)24, (boolean)true);
            Object object = zzpy2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzqd.zza((zzqc)this.zzak, (String)zzq2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zzpy2.zza, zzpy2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzpy2.zza)) {
            zzbf zzbf2;
            zzq zzq3 = zzq2;
            String string = zzpy2.zze;
            long l = zzpy2.zzb;
            zzpk zzpk2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzq3.zza);
            long l2 = 0L;
            zzqa zzqa2 = zzpk2.zzf().zze(string4, "_sno");
            if (zzqa2 != null && zzqa2.zze instanceof Long) {
                l2 = (Long)zzqa2.zze;
            } else {
                if (zzqa2 != null) {
                    zzpk2.zzj().zzr().zza("Retrieved last session number from database does not contain a valid (long) value", zzqa2.zze);
                }
                if ((zzbf2 = zzpk2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzbf2.zzc;
                    zzpk2.zzj().zzq().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzbf2 = new zzpy("_sno", l, (Object)(++l2), string);
            zzpk2.zza((zzpy)zzbf2, zzq3);
        }
        zzqa zzqa3 = new zzqa((String)Preconditions.checkNotNull((Object)zzq2.zza), (String)Preconditions.checkNotNull((Object)zzpy2.zze), zzpy2.zza, zzpy2.zzb, object);
        this.zzj().zzq().zza("Setting user property", (Object)this.zzm.zzk().zzc(zzqa3.zzc), object);
        this.zzf().zzq();
        try {
            zzqa zzqa4;
            if ("_id".equals(zzqa3.zzc) && (zzqa4 = this.zzf().zze(zzq2.zza, "_id")) != null && !zzqa3.zze.equals(zzqa4.zze)) {
                this.zzf().zzh(zzq2.zza, "_lair");
            }
            this.zza(zzq2);
            boolean bl = this.zzf().zza(zzqa3);
            if ("_sid".equals(zzpy2.zza)) {
                long l = this.zzp().zza(zzq2.zzv);
                zzg zzg2 = this.zzf().zzd(zzq2.zza);
                if (zzg2 != null) {
                    zzg2.zzs(l);
                    if (zzg2.zzas()) {
                        this.zzf().zza(zzg2, false, false);
                    }
                }
            }
            this.zzf().zzx();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zzqa3.zzc), zzqa3.zze);
                this.zzq();
                zzqd.zza((zzqc)this.zzak, (String)zzq2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzr();
        }
    }

    @WorkerThread
    final void zzx() {
        this.zzl().zzv();
        this.zzt();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzt().zzad();
            if (bl == null) {
                this.zzj().zzr().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzaf();
                return;
            }
            zzpk zzpk2 = this;
            zzpk2.zzl().zzv();
            if (zzpk2.zzz != null) {
                this.zzj().zzq().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzr()) {
                this.zzj().zzq().zza("Network not connected, ignoring upload request");
                this.zzaf();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbl.zzbg);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzak.zzg();
            for (int i = 0; i < n && this.zzb(null, l2 = l4); ++i) {
            }
            if (com.google.android.gms.internal.measurement.zzpf.zza()) {
                this.zzad();
            }
            if ((l = this.zzj.zzd.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().g_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().c_();
                }
                this.zza(string, l3);
            } else {
                zzg zzg2;
                this.zzab = -1L;
                zzap zzap2 = this.zzf();
                this.zze();
                String string2 = zzap2.zzb(l3 - com.google.android.gms.measurement.internal.zzak.zzg());
                if (!TextUtils.isEmpty((CharSequence)string2) && (zzg2 = this.zzf().zzd(string2)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzac();
        }
    }

    @VisibleForTesting
    private final void zza(String string, long l) {
        int n = this.zze().zzb(string, zzbl.zzg);
        String string2 = string;
        Object object = this.zze();
        int n2 = Math.max(0, object.zzb(string2, zzbl.zzh));
        List<Pair<zzgg.zzk, Long>> list = this.zzf().zza(string, n, n2);
        if (!list.isEmpty()) {
            Object object2;
            String string3;
            boolean bl;
            zzgg.zzf zzf2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            zzgg.zzk zzk2;
            Object object8;
            if (this.zzb(string).zzg()) {
                object8 = null;
                Iterator<Pair<zzgg.zzk, Long>> iterator = list.iterator();
                while (iterator.hasNext()) {
                    zzgg.zzk zzk3 = (zzgg.zzk)iterator.next().first;
                    if (zzk3.zzap().isEmpty()) continue;
                    object8 = zzk3.zzap();
                    break;
                }
                if (object8 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzk2 = (zzgg.zzk)list.get((int)i).first;
                        if (zzk2.zzap().isEmpty() || zzk2.zzap().equals(object8)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
            }
            object8 = zzgg.zzj.zzb();
            int n3 = list.size();
            zzk2 = new ArrayList(list.size());
            boolean bl2 = this.zze().zzj(string) && this.zzb(string).zzg();
            boolean bl3 = this.zzb(string).zzg();
            boolean bl4 = this.zzb(string).zzh();
            boolean bl5 = zzpr.zza() && this.zze().zze(string, zzbl.zzck);
            zzph zzph2 = this.zzk.zza(string);
            for (int i = 0; i < n3; ++i) {
                Object object9;
                object7 = (zzgg.zzk.zza)((zzgg.zzk)list.get((int)i).first).zzch();
                zzk2.add((Long)list.get((int)i).second);
                this.zze();
                object7.zzm(118003L).zzl(l).zzd(false);
                if (!bl2) {
                    object7.zzk();
                }
                if (!bl3) {
                    object7.zzq();
                    object7.zzn();
                }
                if (!bl4) {
                    object7.zzh();
                }
                this.zza(string, (zzgg.zzk.zza)object7);
                if (!bl5) {
                    object7.zzr();
                }
                if (!bl4) {
                    object7.zzi();
                }
                string2 = object7;
                object = this;
                object6 = string2.zzaa();
                boolean bl6 = false;
                if (TextUtils.isEmpty((CharSequence)object6) || ((String)object6).equals("00000000-0000-0000-0000-000000000000")) {
                    object5 = new ArrayList(string2.zzab());
                    boolean bl7 = false;
                    object4 = object5.iterator();
                    object3 = null;
                    Long l2 = null;
                    while (object4.hasNext()) {
                        zzf2 = (zzgg.zzf)object4.next();
                        if ("_fx".equals(zzf2.zzg())) {
                            bl6 = true;
                            object4.remove();
                            bl7 = true;
                            continue;
                        }
                        if (!"_f".equals(zzf2.zzg())) continue;
                        bl6 = true;
                        ((zzpk)object).zzp();
                        zzgg.zzh zzh2 = zzpz.zza(zzf2, "_pfo");
                        if (zzh2 != null) {
                            object3 = zzh2.zzd();
                        }
                        ((zzpk)object).zzp();
                        zzgg.zzh zzh3 = zzpz.zza(zzf2, "_uwa");
                        if (zzh3 == null) continue;
                        l2 = zzh3.zzd();
                    }
                    if (bl7) {
                        string2.zzl();
                        string2.zzb((Iterable)object5);
                    }
                    if (bl6) {
                        super.zza(string2.zzu(), true, (Long)object3, l2);
                    }
                }
                if (object7.zzc() == 0) continue;
                if (this.zze().zze(string, zzbl.zzca)) {
                    object9 = ((zzgg.zzk)((zzki)object7.zzaj())).zzce();
                    object7.zzb(this.zzp().zza((byte[])object9));
                }
                if (this.zze().zza(zzbl.zzco)) {
                    zzgg.zzo zzo2 = zzph2.zzb();
                    object9 = zzo2;
                    if (zzo2 != null) {
                        object7.zza((zzgg.zzo)object9);
                    }
                }
                object8.zza((zzgg.zzk.zza)object7);
            }
            if (object8.zza() == 0) {
                this.zza((List<Long>)zzk2);
                this.zza(false, 204, null, null, string, Collections.emptyList());
                return;
            }
            zzgg.zzj zzj2 = (zzgg.zzj)((zzki)object8.zzaj());
            object7 = new ArrayList();
            boolean bl8 = bl = this.zze().zza(zzbl.zzco) && zzph2.zza() == zzmf.zzd;
            if (zzph2.zza() == zzmf.zzc || bl) {
                String string42;
                boolean bl9;
                block37: {
                    object6 = ((zzgg.zzj)((zzki)object8.zzaj())).zzf().iterator();
                    while (object6.hasNext()) {
                        if (!((zzgg.zzk)object6.next()).zzbk()) continue;
                        bl9 = true;
                        break block37;
                    }
                    bl9 = false;
                }
                String string5 = string3 = bl9 ? UUID.randomUUID().toString() : null;
                object6 = (zzgg.zzj)((zzki)object8.zzaj());
                string2 = string;
                object = this;
                ((zzpk)object).zzl().zzv();
                ((zzpk)object).zzt();
                object5 = zzgg.zzj.zza((zzgg.zzj)object6);
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    object5.zza(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)(string42 = ((zzpk)object).zzi().zzf(string2)))) {
                    object5.zzb(string42);
                }
                object4 = new ArrayList();
                object3 = object6.zzf().iterator();
                while (object3.hasNext()) {
                    zzf2 = zzgg.zzk.zza((zzgg.zzk)((zzgg.zzk)object3.next()));
                    zzf2.zzk();
                    object4.add((zzgg.zzk)((zzki)zzf2.zzaj()));
                }
                object5.zzb();
                object5.zza((Iterable)object4);
                if (((zzpk)object).zze().zza(zzbl.zzcm)) {
                    ((zzpk)object).zzj().zzq().zza("[sgtm] Processed MeasurementBatch for sGTM with sgtmJoinId: ", (Object)(TextUtils.isEmpty((CharSequence)string5) ? "null" : object5.zzc()));
                } else {
                    ((zzpk)object).zzj().zzq().zza("[sgtm] Processed MeasurementBatch for sGTM.");
                }
                zzj2 = (zzgg.zzj)((zzki)object5.zzaj());
                if (!TextUtils.isEmpty((CharSequence)string3) && this.zze().zza(zzbl.zzcm)) {
                    zzph zzph3;
                    object6 = string3;
                    string2 = (zzgg.zzj)((zzki)object8.zzaj());
                    object = this;
                    ((zzpk)object).zzl().zzv();
                    ((zzpk)object).zzt();
                    string5 = zzgg.zzj.zzb();
                    ((zzpk)object).zzj().zzq().zza("[sgtm] Processing Google Signal, sgtmJoinId:", object6);
                    string5.zza((String)object6);
                    for (String string42 : string2.zzf()) {
                        string5.zza(zzgg.zzk.zzx().zzj(string42.zzaj()).zzg(string42.zzd()));
                    }
                    object2 = (zzgg.zzj)((zzki)string5.zzaj());
                    boolean bl10 = bl;
                    string2 = string;
                    string5 = ((zzpa)this.zzk).zzm().zzf(string2);
                    if (!TextUtils.isEmpty((CharSequence)string5)) {
                        object5 = Uri.parse((String)((String)zzbl.zzr.zza(null)));
                        string42 = object5.buildUpon();
                        object3 = object5.getAuthority();
                        object4 = string5;
                        string42.authority((String)object4 + "." + (String)object3);
                        zzph3 = new zzph(string42.build().toString(), bl10 ? zzmf.zze : zzmf.zzb);
                    } else {
                        zzph3 = new zzph((String)zzbl.zzr.zza(null), bl10 ? zzmf.zze : zzmf.zzb);
                    }
                    object7.add(Pair.create((Object)object2, (Object)zzph3));
                }
                if (bl) {
                    object2 = (zzgg.zzj.zza)zzj2.zzch();
                    for (int i = 0; i < zzj2.zza(); ++i) {
                        object2.zza(i, ((zzgg.zzk.zza)zzj2.zza(i).zzch()).zzt().zza(l));
                    }
                    object7.add(Pair.create((Object)((zzgg.zzj)((zzki)object2.zzaj())), (Object)zzph2));
                    this.zza((List<Long>)zzk2);
                    this.zza(false, 204, null, null, string, (List<Pair<zzgg.zzj, zzph>>)object7);
                    if (this.zzb(string, zzph2.zzc())) {
                        this.zzj().zzq().zza("[sgtm] Sending sgtm batches available notification to app", (Object)string);
                        Intent intent = new Intent();
                        intent.setAction("com.google.android.gms.measurement.BATCHES_AVAILABLE");
                        intent.setPackage(string);
                        zzpk.zzb(this.zzm.zza(), intent);
                    }
                    return;
                }
            }
            if (this.zze().zza(zzbl.zzcn) && !this.zzh().zzr()) {
                return;
            }
            string3 = null;
            if (this.zzj().zza(2)) {
                string3 = this.zzp().zza(zzj2);
            }
            this.zzp();
            object2 = zzj2.zzce();
            this.zza((List<Long>)zzk2);
            this.zzj.zze.zza(l);
            this.zzj().zzq().zza("Uploading data. app, uncompressed size, data", (Object)string, (Object)((byte[])object2).length, (Object)string3);
            this.zzv = true;
            this.zzh().zza(string, zzph2, zzj2, new zzpl(this, string, (List)object7));
        }
    }

    @WorkerThread
    private final void zze(String string) {
        this.zzl().zzv();
        this.zzt();
        this.zzw = true;
        try {
            Object object = this.zzm.zzt().zzad();
            if (object == null) {
                this.zzj().zzr().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (((Boolean)object).booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzaf();
                return;
            }
            if (!this.zzh().zzr()) {
                this.zzj().zzq().zza("Network not connected, ignoring upload request");
                this.zzaf();
                return;
            }
            if (!this.zzf().zzq(string)) {
                this.zzj().zzq().zza("[sgtm] Upload queue has no batches for appId", (Object)string);
                return;
            }
            object = this.zzf().zzi(string);
            if (object == null) {
                return;
            }
            zzgg.zzj zzj2 = ((zzpu)object).zzg();
            if (zzj2 == null) {
                return;
            }
            this.zzj().zzq().zza("[sgtm] Uploading data from upload queue. appId, type, url", (Object)string, (Object)((zzpu)object).zzd(), (Object)((zzpu)object).zzh());
            byte[] byArray = zzj2.zzce();
            if (this.zzj().zza(2)) {
                String string2 = this.zzp().zza(zzj2);
                this.zzj().zzq().zza("[sgtm] Uploading data from upload queue. appId, uncompressed size, data", (Object)string, (Object)byArray.length, (Object)string2);
            }
            this.zzv = true;
            this.zzh().zza(string, ((zzpu)object).zzf(), zzj2, new zzpo(this, string, (zzpu)object));
            return;
        }
        finally {
            this.zzw = false;
            this.zzac();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzgg.zzh.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzqd.zzf((String)zza2.zzf()) || zzqd.zzf((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzqd.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzqd.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzw().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbj var1_1, zzq var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzv();
        this.zzt();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzpz.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzr().zza("Dropping blocked event. appId", zzhc.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzl(var5_4) != false || this.zzi().zzn(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzqd.zza((zzqc)this.zzak, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zzd(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzp(), var7_7.zzg());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbl.zzam.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzhg.zza((zzbj)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = this.zze().zza(var5_4, zzbl.zzbe, 10, 35);
        for (String var10_12 : new TreeSet<E>(var6_6.zzc.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzc.getParcelableArray(var10_12), var7_8);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzq().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        this.zzf().zzq();
        try {
            block74: {
                block75: {
                    block77: {
                        block81: {
                            block80: {
                                block78: {
                                    block79: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block77;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block78;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block79;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block80;
                                    }
                                    var25_19.zzj().zzr().zza("Data lost. Currency value is too big. appId", zzhc.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block81;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + (String)var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbl.zzas) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzv();
                                    var41_32.zzam();
                                    try {
                                        var41_32.f_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '!_ltv!_%' escape '!'order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzhc.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zzqa(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zzqa(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zzqa)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzhc.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzqd.zza((zzqc)var25_19.zzak, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzx();
                            return;
                        }
                    }
                    var11_38 = zzqd.zzg((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzqd.zza((zzbi)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzy(), var5_4, var13_40, true, var11_38, false, var12_39, false, false, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - com.google.android.gms.measurement.internal.zzak.zzh();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzhc.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzx();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbl.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzhc.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzqd.zza((zzqc)this.zzak, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzx();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbl.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzhc.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzx();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzd(var5_4, var2_2.zzac)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 /* !! */  = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44 /* !! */ .zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44 /* !! */ .zze);
                    }
                    if (this.zze().zza(zzbl.zzdg) && Objects.equals(var1_1.zzc, "am") && Objects.equals(var1_1.zza, "_ai") && (var19_44 /* !! */  = var18_43.get("value")) != null && var19_44 /* !! */  instanceof String) {
                        try {
                            var20_46 = Double.parseDouble((String)var19_44 /* !! */ );
                            var18_43.remove("value");
                            var18_43.putDouble("value", var20_46);
                        }
                        catch (NumberFormatException v4) {}
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzr().zza("Data lost. Too many events stored on disk, deleted. appId", zzhc.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_47 = new zzbg(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_48 = this.zzf().zzd(var5_4, var21_47.zzb);
                    if (var22_48 == null) {
                        if (this.zzf().zzb(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzhc.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_47.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzqd.zza((zzqc)this.zzak, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_49 = new zzbf(var5_4, var21_47.zzb, 0L, 0L, var21_47.zzd, 0L, null, null, null, null);
                    } else {
                        var21_47 = var21_47.zza(this.zzm, var22_48.zzf);
                        var23_49 = var22_48.zza(var21_47.zzd);
                    }
                    this.zzf().zza(var23_49);
                    var27_17 = var2_2;
                    var26_18 = var21_47;
                    var25_19 = this;
                    var25_19.zzl().zzv();
                    var25_19.zzt();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzgg.zzk.zzx().zzh(1).zzq("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzv)) {
                        var28_14.zzs(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzg(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzn(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzju.zzb((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zze());
                    if (var28_14.zzy().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (com.google.android.gms.internal.measurement.zzpf.zza() && var25_19.zze().zze(var27_17.zza, zzbl.zzcu)) {
                        var25_19.zzq();
                        if (zzqd.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzg() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_50 = var30_25;
                                var40_52 /* !! */  = zzgg.zzc.zza();
                                var40_52 /* !! */ .zzc((var37_50 & 1L) != 0L);
                                var40_52 /* !! */ .zze((var37_50 & 2L) != 0L);
                                var40_52 /* !! */ .zzf((var37_50 & 4L) != 0L);
                                var40_52 /* !! */ .zzg((var37_50 & 8L) != 0L);
                                var40_52 /* !! */ .zzb((var37_50 & 16L) != 0L);
                                var40_52 /* !! */ .zza((var37_50 & 32L) != 0L);
                                var40_52 /* !! */ .zzd((var37_50 & 64L) != 0L);
                                var28_14.zza((zzgg.zzc)((zzki)var40_52 /* !! */ .zzaj()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzd(var27_17.zzf);
                    }
                    var28_14.zze(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzr();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if (var25_19.zze().zza(zzbl.zzdl)) {
                        var28_14.zzl("");
                    }
                    if ((var31_53 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzju.zzb((String)var27_17.zzt))).zzg() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_53)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzr((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc(((Boolean)var32_23.second).booleanValue());
                        }
                        if (!var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zzd(var27_17.zza)) != null && var33_29.zzau()) {
                            var25_19.zza(var27_17.zza, false, null, null);
                            var34_35 = new Bundle();
                            var35_54 = var33_29.zzy();
                            if (var35_54 != null) {
                                var34_35.putLong("_pfo", Math.max(0L, var35_54));
                            }
                            if ((var36_27 = var33_29.zzz()) != null) {
                                var34_35.putLong("_uwa", var36_27.longValue());
                            }
                            var34_35.putLong("_r", 1L);
                            var25_19.zzak.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzae();
                    v5 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzae();
                    v5.zzp(Build.VERSION.RELEASE).zzj((int)var25_19.zzm.zzg().zzc()).zzt(var25_19.zzm.zzg().zzg());
                    var28_14.zzk(var27_17.zzx);
                    if (var25_19.zzm.zzae()) {
                        var28_14.zzu();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zzd(var27_17.zza)) == null) {
                        var32_24 = new zzg(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_53));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_53.zzg()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzq(0L);
                        var32_24.zzr(0L);
                        var32_24.zzp(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zzb(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzn(var27_17.zze);
                        var32_24.zzk(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzl(var27_17.zzr);
                        var42_31 = var32_24;
                        var25_19.zzf().zza((zzg)var42_31, false, false);
                    }
                    if (var31_53.zzh() && !TextUtils.isEmpty((CharSequence)var32_24.zzad())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzad()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzag())) {
                        var28_14.zzm((String)Preconditions.checkNotNull((Object)var32_24.zzag()));
                    }
                    var33_29 = var25_19.zzf().zzk(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_54 = zzgg.zzp.zze().zza(((zzqa)var33_29.get((int)var34_36)).zzc).zzb(((zzqa)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza((zzgg.zzp.zza)var35_54, ((zzqa)var33_29.get((int)var34_36)).zze);
                        var28_14.zza((zzgg.zzp.zza)var35_54);
                        if (!"_sid".equals(((zzqa)var33_29.get((int)var34_36)).zzc) || var32_24.zzv() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzv()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzgg.zzk)((zzki)var28_14.zzaj()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzhc.zza((String)var28_14.zzu()), (Object)var36_28);
                        break block74;
                    }
                    v6 = var25_19.zzf();
                    var38_55 = var26_18;
                    var37_51 = var25_19;
                    if (var38_55.zzf == null) ** GOTO lbl-1000
                    for (zzgg.zzc.zza var40_52 : var38_55.zzf) {
                        if (!"_r".equals(var40_52 /* !! */ )) continue;
                        v7 = true;
                        break block75;
                    }
                    var39_57 = var37_51.zzi().zzc(var38_55.zza, var38_55.zzb);
                    var40_52 /* !! */  = var37_51.zzf().zza(var37_51.zzy(), var38_55.zza, false, false, false, false, false, false, false);
                    if (var39_57 && var40_52 /* !! */ .zze < (long)var37_51.zze().zzc(var38_55.zza)) {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                }
                if (v6.zza((zzbg)var26_18, var34_37, v7)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzx();
        }
        finally {
            this.zzf().zzr();
        }
        this.zzaf();
        this.zzj().zzq().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zzi(zzq zzq2) {
        return !TextUtils.isEmpty((CharSequence)zzq2.zzb) || !TextUtils.isEmpty((CharSequence)zzq2.zzp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @WorkerThread
    private final boolean zzb(@Nullable String var1_1, long var2_2) {
        this.zzf().zzq();
        try {
            block174: {
                block172: {
                    var4_3 = new zzb(null);
                    var35_4 = var4_3;
                    var33_6 = this.zzab;
                    var31_12 = var2_2;
                    var30_19 = var1_1;
                    var29_20 = this.zzf();
                    Preconditions.checkNotNull((Object)var35_4);
                    var29_20.zzv();
                    var29_20.zzam();
                    var36_21 = null;
                    try {
                        var37_27 /* !! */  = var29_20.f_();
                        if (TextUtils.isEmpty((CharSequence)var30_19)) {
                            var39_33 = var33_6 != -1L ? new String[]{String.valueOf(var33_6), String.valueOf(var31_12)} : new String[]{String.valueOf(var31_12)};
                            var48_35 = var33_6 != -1L ? "rowid <= ? and " : "";
                            var36_21 = var37_27 /* !! */ .rawQuery("select app_id, metadata_fingerprint from raw_events where " + var48_35 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])var39_33);
                            if (!var36_21.moveToFirst()) break block172;
                            var30_19 = var36_21.getString(0);
                            var38_36 = var36_21.getString(1);
                            var36_21.close();
                        } else {
                            var39_33 = var33_6 != -1L ? new String[]{var30_19, String.valueOf(var33_6)} : new String[]{var30_19};
                            var48_35 = var33_6 != -1L ? " and rowid <= ?" : "";
                            var36_21 = var37_27 /* !! */ .rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + var48_35 + " order by rowid limit 1;", (String[])var39_33);
                            if (!var36_21.moveToFirst()) break block172;
                            var38_36 = var36_21.getString(0);
                            var36_21.close();
                        }
                        var36_21 = var37_27 /* !! */ .query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{var30_19, var38_36}, null, null, "rowid", "2");
                        if (!var36_21.moveToFirst()) {
                            var29_20.zzj().zzg().zza("Raw event metadata record is missing. appId", zzhc.zza((String)var30_19));
                            break block172;
                        }
                        var39_33 = var36_21.getBlob(0);
                        try {
                            var40_37 /* !! */  = (zzgg.zzk)((zzki)zzpz.zza(zzgg.zzk.zzx(), (byte[])var39_33).zzaj());
                        }
                        catch (IOException var41_38) {
                            var29_20.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzhc.zza((String)var30_19), (Object)var41_38);
                            if (var36_21 != null) {
                                var36_21.close();
                            }
                            break block172;
                        }
                        if (var36_21.moveToNext()) {
                            var29_20.zzj().zzr().zza("Get multiple raw event metadata records, expected one. appId", zzhc.zza((String)var30_19));
                        }
                        var36_21.close();
                        var35_4.zza(var40_37 /* !! */ );
                        if (var33_6 != -1L) {
                            var41_39 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            var42_41 = new String[]{var30_19, var38_36, String.valueOf(var33_6)};
                        } else {
                            var41_39 = "app_id = ? and metadata_fingerprint = ?";
                            var42_41 = new String[]{var30_19, var38_36};
                        }
                        var36_21 = var37_27 /* !! */ .query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, var41_39, var42_41, null, null, "rowid", null);
                        if (!var36_21.moveToFirst()) {
                            var29_20.zzj().zzr().zza("Raw event data disappeared while in transaction. appId", zzhc.zza((String)var30_19));
                            break block172;
                        }
                        do {
                            var43_42 = var36_21.getLong(0);
                            var39_33 = var36_21.getBlob(3);
                            try {
                                var45_44 = zzpz.zza(zzgg.zzf.zze(), (byte[])var39_33);
                            }
                            catch (IOException var46_46) {
                                var29_20.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzhc.zza((String)var30_19), (Object)var46_46);
                                continue;
                            }
                            var45_44.zza(var36_21.getString(1)).zzb(var36_21.getLong(2));
                            if (!var35_4.zza(var43_42, (zzgg.zzf)((zzki)var45_44.zzaj()))) break;
                        } while (var36_21.moveToNext());
                    }
                    catch (SQLiteException var37_28) {
                        var29_20.zzj().zzg().zza("Data loss. Error selecting raw event. appId", zzhc.zza((String)var30_19), (Object)var37_28);
                    }
                    finally {
                        if (var36_21 != null) {
                            var36_21.close();
                        }
                    }
                }
                var29_20 = var4_3;
                if (var29_20.zzc == null || var29_20.zzc.isEmpty() != false) break block174;
                var5_49 = false;
                var6_50 = ((zzgg.zzk.zza)var4_3.zza.zzch()).zzl();
                var7_51 = 0;
                var8_52 = 0L;
                var10_53 = null;
                var11_54 = -1;
                var12_55 = null;
                var13_56 = -1;
                var14_57 = false;
                for (var15_58 = 0; var15_58 < var4_3.zzc.size(); ++var15_58) {
                    block176: {
                        block175: {
                            var16_59 = var5_49;
                            var17_62 = (zzgg.zzf.zza)var4_3.zzc.get(var15_58).zzch();
                            if (this.zzi().zzd(var4_3.zza.zzab(), var17_62.zze())) {
                                this.zzj().zzr().zza("Dropping blocked raw event. appId", zzhc.zza((String)var4_3.zza.zzab()), (Object)this.zzm.zzk().zza(var17_62.zze()));
                                if (this.zzi().zzl(var4_3.zza.zzab()) != false || this.zzi().zzn(var4_3.zza.zzab()) != false || "_err".equals(var17_62.zze())) continue;
                                this.zzq();
                                zzqd.zza((zzqc)this.zzak, (String)var4_3.zza.zzab(), (int)11, (String)"_ev", (String)var17_62.zze(), (int)0);
                                continue;
                            }
                            if (zznu.zza() && this.zze().zza(zzbl.zzdf) && ((var29_20 = var17_62.zze()).equals("purchase") != false || var29_20.equals("_iap") != false || var29_20.equals("ecommerce_purchase") != false)) {
                                var17_62.zza((zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_cbs").zzb(var14_57 == false && ((var29_20 = this).zza((String)(var30_19 = var4_3.zza.zzab()), "purchase") != false && super.zza((String)var30_19, "_iap") != false && super.zza((String)var30_19, "ecommerce_purchase") != false) != false ? zzjy.zza : zzjy.zzb).zzaj()));
                                var14_57 = true;
                            }
                            if (var17_62.zze().equals(zzka.zza((String)"_ai"))) {
                                var17_62.zza("_ai");
                                this.zzj().zzq().zza("Renaming ad_impression to _ai");
                                if (this.zzj().zza(5)) {
                                    for (var18_65 = 0; var18_65 < var17_62.zza(); ++var18_65) {
                                        if (!"ad_platform".equals(var17_62.zzb(var18_65).zzg()) || var17_62.zzb(var18_65).zzh().isEmpty() || !"admob".equalsIgnoreCase(var17_62.zzb(var18_65).zzh())) continue;
                                        this.zzj().zzw().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                    }
                                }
                            }
                            if ((var18_65 = this.zzi().zzc(var4_3.zza.zzab(), var17_62.zze())) != 0) break block175;
                            this.zzp();
                            var29_20 = var17_62.zze();
                            Preconditions.checkNotEmpty((String)var29_20);
                            var31_13 = var29_20;
                            var32_99 = -1;
                            switch (var31_13.hashCode()) {
                                case 95027: {
                                    if (!var31_13.equals("_ui")) break;
                                    var32_99 = 0;
                                }
                            }
                            switch (var32_99) {
                                case 0: {
                                    v0 = true;
                                    break;
                                }
                                default: {
                                    v0 = false;
                                }
                            }
                            if (!v0) break block176;
                        }
                        var19_69 = 0;
                        var20_74 = 0;
                        for (var21_78 = 0; var21_78 < var17_62.zza(); ++var21_78) {
                            if ("_c".equals(var17_62.zzb(var21_78).zzg())) {
                                var22_82 = (zzgg.zzh)((zzki)((zzgg.zzh.zza)var17_62.zzb(var21_78).zzch()).zza(1L).zzaj());
                                var19_69 = 1;
                                var17_62.zza(var21_78, var22_82);
                                continue;
                            }
                            if (!"_r".equals(var17_62.zzb(var21_78).zzg())) continue;
                            var22_82 = (zzgg.zzh)((zzki)((zzgg.zzh.zza)var17_62.zzb(var21_78).zzch()).zza(1L).zzaj());
                            var20_74 = 1;
                            var17_62.zza(var21_78, var22_82);
                        }
                        if (var19_69 == 0 && var18_65 != 0) {
                            this.zzj().zzq().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(var17_62.zze()));
                            var17_62.zza(zzgg.zzh.zze().zza("_c").zza(1L));
                        }
                        if (var20_74 == 0) {
                            this.zzj().zzq().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(var17_62.zze()));
                            var17_62.zza(zzgg.zzh.zze().zza("_r").zza(1L));
                        }
                        var5_49 = true;
                        if (this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zze > (long)this.zze().zzc(var4_3.zza.zzab())) {
                            zzpk.zza(var17_62, "_r");
                            var5_49 = var16_59;
                        }
                        if (zzqd.zzg((String)var17_62.zze()) && var18_65 != 0 && this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(var4_3.zza.zzab(), zzbl.zzn)) {
                            this.zzj().zzr().zza("Too many conversions. Not logging as conversion. appId", zzhc.zza((String)var4_3.zza.zzab()));
                            var23_86 = false;
                            var24_90 /* !! */  = null;
                            var25_91 = -1;
                            for (var26_95 = 0; var26_95 < var17_62.zza(); ++var26_95) {
                                var27_98 = var17_62.zzb(var26_95);
                                if ("_c".equals(var27_98.zzg())) {
                                    var24_90 /* !! */  = (zzgg.zzh.zza)var27_98.zzch();
                                    var25_91 = var26_95;
                                    continue;
                                }
                                if (!"_err".equals(var27_98.zzg())) continue;
                                var23_86 = true;
                            }
                            if (var23_86 && var24_90 /* !! */  != null) {
                                var17_62.zza(var25_91);
                            } else if (var24_90 /* !! */  != null) {
                                var26_96 = (zzgg.zzh)((zzki)((zzgg.zzh.zza)((zzki.zzb)var24_90 /* !! */ .clone())).zza("_err").zza(10L).zzaj());
                                var17_62.zza(var25_91, var26_96);
                            } else {
                                this.zzj().zzg().zza("Did not find conversion parameter. appId", zzhc.zza((String)var4_3.zza.zzab()));
                            }
                        }
                    }
                    if (var18_65 != 0) {
                        var30_19 = var17_62;
                        var29_20 = this;
                        var31_13 = new ArrayList<E>(var30_19.zzf());
                        var32_99 = -1;
                        var33_7 = -1;
                        for (var34_104 = 0; var34_104 < var31_13.size(); ++var34_104) {
                            if ("value".equals(((zzgg.zzh)var31_13.get(var34_104)).zzg())) {
                                var32_99 = var34_104;
                                continue;
                            }
                            if (!"currency".equals(((zzgg.zzh)var31_13.get(var34_104)).zzg())) continue;
                            var33_7 = var34_104;
                        }
                        if (var32_99 != -1) {
                            if (!((zzgg.zzh)var31_13.get(var32_99)).zzl() && !((zzgg.zzh)var31_13.get(var32_99)).zzj()) {
                                var29_20.zzj().zzw().zza("Value must be specified with a numeric type.");
                                var30_19.zza(var32_99);
                                zzpk.zza((zzgg.zzf.zza)var30_19, "_c");
                                zzpk.zza((zzgg.zzf.zza)var30_19, 18, "value");
                            } else {
                                var34_104 = 0;
                                if (var33_7 == -1) {
                                    var34_104 = 1;
                                } else {
                                    var35_4 = ((zzgg.zzh)var31_13.get(var33_7)).zzh();
                                    if (var35_4.length() != 3) {
                                        var34_104 = 1;
                                    } else {
                                        for (var36_22 = 0; var36_22 < var35_4.length(); var36_22 += Character.charCount(var37_29)) {
                                            var37_29 = var35_4.codePointAt(var36_22);
                                            if (Character.isLetter(var37_29)) continue;
                                            var34_104 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (var34_104 != 0) {
                                    var29_20.zzj().zzw().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    var30_19.zza(var32_99);
                                    zzpk.zza((zzgg.zzf.zza)var30_19, "_c");
                                    zzpk.zza((zzgg.zzf.zza)var30_19, 19, "currency");
                                }
                            }
                        }
                    }
                    if ("_e".equals(var17_62.zze())) {
                        this.zzp();
                        if (zzpz.zza((zzgg.zzf)((zzki)var17_62.zzaj()), "_fr") == null) {
                            if (var12_55 != null && Math.abs(var12_55.zzc() - var17_62.zzc()) <= 1000L) {
                                var19_70 = (zzgg.zzf.zza)((zzki.zzb)var12_55.clone());
                                if (this.zza(var17_62, var19_70)) {
                                    var10_53 = null;
                                    var12_55 = null;
                                    var6_50.zza(var13_56, var19_70);
                                } else {
                                    var10_53 = var17_62;
                                    var11_54 = var7_51;
                                }
                            } else {
                                var10_53 = var17_62;
                                var11_54 = var7_51;
                            }
                        }
                    } else if ("_vs".equals(var17_62.zze())) {
                        this.zzp();
                        if (zzpz.zza((zzgg.zzf)((zzki)var17_62.zzaj()), "_et") == null) {
                            if (var10_53 != null && Math.abs(var10_53.zzc() - var17_62.zzc()) <= 1000L) {
                                var19_71 = (zzgg.zzf.zza)((zzki.zzb)var10_53.clone());
                                if (this.zza(var19_71, var17_62)) {
                                    var10_53 = null;
                                    var12_55 = null;
                                    var6_50.zza(var11_54, var19_71);
                                } else {
                                    var12_55 = var17_62;
                                    var13_56 = var7_51;
                                }
                            } else {
                                var12_55 = var17_62;
                                var13_56 = var7_51;
                            }
                        }
                    }
                    if (var17_62.zza() != 0) {
                        this.zzp();
                        var19_72 = zzpz.zza(var17_62.zzf());
                        for (var20_74 = 0; var20_74 < var17_62.zza(); ++var20_74) {
                            var21_79 = var17_62.zzb(var20_74);
                            if (var21_79.zzg().equals("items") && !var21_79.zzi().isEmpty()) {
                                var33_8 = var19_72;
                                var32_100 = var4_3.zza.zzab();
                                var31_14 = var17_62;
                                var30_19 = var21_79;
                                var29_20 = this;
                                var34_105 = var30_19.zzi();
                                var35_4 = new Bundle[var34_105.size()];
                                for (var36_23 = 0; var36_23 < var34_105.size(); ++var36_23) {
                                    var37_30 = (zzgg.zzh)var34_105.get(var36_23);
                                    var29_20.zzp();
                                    var38_36 = zzpz.zza(var37_30.zzi());
                                    for (zzgg.zzk var40_37 : var37_30.zzi()) {
                                        super.zza(var31_14.zze(), (zzgg.zzh.zza)var40_37 /* !! */ .zzch(), (Bundle)var38_36, var32_100);
                                    }
                                    var35_4[var36_23] = var38_36;
                                }
                                var33_8.putParcelableArray("items", (Parcelable[])var35_4);
                                continue;
                            }
                            if (var21_79.zzg().equals("items")) continue;
                            this.zza(var17_62.zze(), (zzgg.zzh.zza)var21_79.zzch(), var19_72, var4_3.zza.zzab());
                        }
                        var31_14 = var17_62;
                        var30_19 = var19_72;
                        var29_20 = this;
                        var31_14.zzd();
                        var35_4 = var30_19;
                        var34_106 = var29_20.zzp();
                        var36_24 = new ArrayList<zzgg.zzh>();
                        for (String var38_36 : var35_4.keySet()) {
                            var39_33 = zzgg.zzh.zze().zza(var38_36);
                            var40_37 /* !! */  = var35_4.get(var38_36);
                            if (var40_37 /* !! */  == null) continue;
                            var34_106.zza((zzgg.zzh.zza)var39_33, (Object)var40_37 /* !! */ );
                            var36_24.add((zzgg.zzh)((zzki)var39_33.zzaj()));
                        }
                        var52_108 = var36_24;
                        var53_109 = var52_108.size();
                        for (var54_110 = 0; var54_110 < var53_109; ++var54_110) {
                            v1 = var52_108.get(var54_110);
                            var33_9 = (zzgg.zzh)v1;
                            var31_14.zza(var33_9);
                        }
                    }
                    var4_3.zzc.set(var15_58, (zzgg.zzf)((zzki)var17_62.zzaj()));
                    ++var7_51;
                    var6_50.zza(var17_62);
                }
                for (var15_58 = 0; var15_58 < var7_51; ++var15_58) {
                    var16_60 = var6_50.zza(var15_58);
                    if ("_e".equals(var16_60.zzg())) {
                        this.zzp();
                        if (zzpz.zza(var16_60, "_fr") != null) {
                            var6_50.zzb(var15_58);
                            --var7_51;
                            --var15_58;
                            continue;
                        }
                    }
                    this.zzp();
                    var17_62 = zzpz.zza(var16_60, "_et");
                    if (var17_62 == null || (var18_67 = var17_62.zzl() != false ? Long.valueOf(var17_62.zzd()) : null) == null || var18_67 <= 0L) continue;
                    var8_52 += var18_67.longValue();
                }
                this.zza(var6_50, var8_52, false);
                var15_58 = 0;
                for (zzgg.zzf.zza var17_62 : var6_50.zzab()) {
                    if (!"_s".equals(var17_62.zzg())) continue;
                    var15_58 = 1;
                    break;
                }
                if (var15_58 != 0) {
                    this.zzf().zzh(var6_50.zzu(), "_se");
                }
                if (zzpz.zza(var6_50, "_sid") >= 0) {
                    this.zza(var6_50, var8_52, true);
                } else {
                    var17_63 = zzpz.zza(var6_50, "_se");
                    if (var17_63 >= 0) {
                        var6_50.zzc(var17_63);
                        this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzhc.zza((String)var4_3.zza.zzab()));
                    }
                }
                var31_15 = var6_50;
                var30_19 = var4_3.zza.zzab();
                var29_20 = this;
                var29_20.zzl().zzv();
                var29_20.zzt();
                var32_101 = var29_20.zzf().zzd((String)var30_19);
                if (var32_101 == null) {
                    var29_20.zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzhc.zza((String)var30_19));
                } else {
                    var29_20.zza((zzg)var32_101, var31_15);
                }
                var31_15 = var6_50;
                var30_19 = var4_3.zza.zzab();
                var29_20 = this;
                var29_20.zzl().zzv();
                var29_20.zzt();
                var32_101 = var29_20.zzf().zzd((String)var30_19);
                if (var32_101 == null) {
                    var29_20.zzj().zzr().zza("Cannot populate ad_campaign_info without appInfo. appId", zzhc.zza((String)var30_19));
                } else {
                    var29_20.zzb((zzg)var32_101, var31_15);
                }
                var29_20 = var6_50;
                var29_20.zzj(0x7FFFFFFFFFFFFFFFL).zzf(-9223372036854775808L);
                for (var31_16 = 0; var31_16 < var29_20.zzc(); ++var31_16) {
                    var32_101 = var29_20.zza(var31_16);
                    if (var32_101.zzd() < var29_20.zzf()) {
                        var29_20.zzj(var32_101.zzd());
                    }
                    if (var32_101.zzd() <= var29_20.zze()) continue;
                    var29_20.zzf(var32_101.zzd());
                }
                var6_50.zzs();
                var17_64 = this.zzb(var4_3.zza.zzab()).zza(zzju.zzb((String)var4_3.zza.zzag()));
                var18_68 = this.zzf().zzg(var4_3.zza.zzab());
                this.zzf().zza(var4_3.zza.zzab(), var17_64);
                if (!var17_64.zzh() && var18_68.zzh()) {
                    this.zzf().zzo(var4_3.zza.zzab());
                } else if (var17_64.zzh() && !var18_68.zzh()) {
                    this.zzf().zzp(var4_3.zza.zzab());
                }
                var30_19 = var17_64;
                var29_20 = var6_50;
                if (!var30_19.zzg()) {
                    var29_20.zzq();
                    var29_20.zzn();
                    var29_20.zzk();
                }
                if (!var30_19.zzh()) {
                    var29_20.zzh();
                    var29_20.zzr();
                }
                if (com.google.android.gms.internal.measurement.zzpf.zza() && this.zze().zze(var4_3.zza.zzab(), zzbl.zzcu)) {
                    this.zzq();
                    ** if (!zzqd.zzd((String)var4_3.zza.zzab()) || !this.zzb((String)var4_3.zza.zzab()).zzg() || !var4_3.zza.zzav()) goto lbl467
                    for (var19_69 = 0; var19_69 < var6_50.zzc(); ++var19_69) {
                        var20_76 = (zzgg.zzf.zza)var6_50.zza(var19_69).zzch();
                        var21_78 = 0;
                        for (zzgg.zzh var23_88 : var20_76.zzf()) {
                            if (!"_c".equals(var23_88 /* !! */ .zzg())) continue;
                            var21_78 = 1;
                            break;
                        }
                        if (var21_78 == 0) continue;
                        if (var4_3.zza.zza() >= this.zze().zzb(var4_3.zza.zzab(), zzbl.zzbj)) {
                            var22_85 = this.zze().zzb(var4_3.zza.zzab(), zzbl.zzbw);
                            if (var22_85 > 0) {
                                if (this.zzf().zza((long)this.zzy(), (String)var4_3.zza.zzab(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzg > (long)var22_85) {
                                    var24_90 /* !! */  = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_tnr").zza(1L).zzaj());
                                    var20_76.zza((zzgg.zzh)var24_90 /* !! */ );
                                } else {
                                    var24_90 /* !! */  = null;
                                    if (this.zze().zze(var4_3.zza.zzab(), zzbl.zzcw)) {
                                        var24_90 /* !! */  = this.zzq().zzq();
                                        var25_93 = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_tu").zzb((String)var24_90 /* !! */ ).zzaj());
                                        var20_76.zza((zzgg.zzh)var25_93);
                                    }
                                    var25_93 = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_tr").zza(1L).zzaj());
                                    var20_76.zza((zzgg.zzh)var25_93);
                                    var26_97 = this.zzp().zza(var4_3.zza.zzab(), var6_50, var20_76, (String)var24_90 /* !! */ );
                                    if (var26_97 != null) {
                                        this.zzj().zzq().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzab(), (Object)var26_97.zza);
                                        this.zzf().zza(var4_3.zza.zzab(), var26_97);
                                        if (!this.zzr.contains(var4_3.zza.zzab())) {
                                            this.zzr.add(var4_3.zza.zzab());
                                        }
                                    }
                                }
                            } else {
                                var23_88 /* !! */  = null;
                                if (this.zze().zze(var4_3.zza.zzab(), zzbl.zzcw)) {
                                    var23_88 /* !! */  = this.zzq().zzq();
                                    var24_90 /* !! */  = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_tu").zzb((String)var23_88 /* !! */ ).zzaj());
                                    var20_76.zza((zzgg.zzh)var24_90 /* !! */ );
                                }
                                var24_90 /* !! */  = (zzgg.zzh)((zzki)zzgg.zzh.zze().zza("_tr").zza(1L).zzaj());
                                var20_76.zza((zzgg.zzh)var24_90 /* !! */ );
                                var25_93 = this.zzp().zza(var4_3.zza.zzab(), var6_50, var20_76, (String)var23_88 /* !! */ );
                                if (var25_93 != null) {
                                    this.zzj().zzq().zza("Generated trigger URI. appId, uri", (Object)var4_3.zza.zzab(), (Object)var25_93.zza);
                                    this.zzf().zza(var4_3.zza.zzab(), var25_93);
                                    if (!this.zzr.contains(var4_3.zza.zzab())) {
                                        this.zzr.add(var4_3.zza.zzab());
                                    }
                                }
                            }
                        }
                        var6_50.zza(var19_69, (zzgg.zzf)((zzki)var20_76.zzaj()));
lbl-1000:
                        // 2 sources

                        {
                            continue;
                        }
                    }
                }
lbl467:
                // 4 sources

                var6_50.zzi().zza(this.zzc().zza(var6_50.zzu(), var6_50.zzab(), var6_50.zzac(), var6_50.zzf(), var6_50.zze(), var17_64.zzh() == false));
                if (this.zze().zzk(var4_3.zza.zzab())) {
                    var31_17 = var4_3;
                    var30_19 = var6_50;
                    var29_20 = this;
                    var32_101 = new HashMap<K, V>();
                    var33_10 = new ArrayList<zzgg.zzf>();
                    var34_107 = var29_20.zzq().zzw();
                    for (var35_5 = 0; var35_5 < var30_19.zzc(); ++var35_5) {
                        block173: {
                            var36_25 = (zzgg.zzf.zza)var30_19.zza(var35_5).zzch();
                            if (var36_25.zze().equals("_ep")) {
                                var29_20.zzp();
                                var37_27 /* !! */  = (String)zzpz.zzb((zzgg.zzf)((zzki)var36_25.zzaj()), "_en");
                                var38_36 = (zzbf)var32_101.get(var37_27 /* !! */ );
                                if (var38_36 == null && (var38_36 = var29_20.zzf().zzd(var31_17.zza.zzab(), (String)Preconditions.checkNotNull((Object)var37_27 /* !! */ ))) != null) {
                                    var32_101.put(var37_27 /* !! */ , var38_36);
                                }
                                if (var38_36 != null && var38_36.zzi == null) {
                                    if (var38_36.zzj != null && var38_36.zzj > 1L) {
                                        var29_20.zzp();
                                        zzpz.zza(var36_25, "_sr", (Object)var38_36.zzj);
                                    }
                                    if (var38_36.zzk != null && var38_36.zzk.booleanValue()) {
                                        var29_20.zzp();
                                        zzpz.zza(var36_25, "_efs", (Object)1L);
                                    }
                                    var33_10.add((zzgg.zzf)((zzki)var36_25.zzaj()));
                                }
                                var30_19.zza(var35_5, var36_25);
                                continue;
                            }
                            var37_32 = var29_20.zzi().zza(var31_17.zza.zzab());
                            var29_20.zzq();
                            var39_34 = zzqd.zza((long)var36_25.zzc(), (long)var37_32);
                            var41_40 = 1;
                            var49_112 = 1L;
                            var48_35 = "_dbg";
                            var47_48 = (zzgg.zzf)((zzki)var36_25.zzaj());
                            if (TextUtils.isEmpty((CharSequence)var48_35) || var49_112 == null) {
                                v2 = false;
                            } else {
                                for (zzgg.zzh var51_114 : var47_48.zzh()) {
                                    if (!var48_35.equals(var51_114.zzg())) continue;
                                    v2 = var49_112 instanceof Long != false && var49_112.equals(var51_114.zzd()) != false || var49_112 instanceof String != false && var49_112.equals(var51_114.zzh()) != false || var49_112 instanceof Double && var49_112.equals(var51_114.zza());
                                    break block173;
                                }
                                v2 = false;
                            }
                        }
                        if (!v2) {
                            var41_40 = var29_20.zzi().zzb(var31_17.zza.zzab(), var36_25.zze());
                        }
                        if (var41_40 <= 0) {
                            var29_20.zzj().zzr().zza("Sample rate must be positive. event, rate", (Object)var36_25.zze(), (Object)var41_40);
                            var33_10.add((zzgg.zzf)((zzki)var36_25.zzaj()));
                            var30_19.zza(var35_5, var36_25);
                            continue;
                        }
                        var42_41 = (String[])var32_101.get(var36_25.zze());
                        if (var42_41 == null && (var42_41 = var29_20.zzf().zzd(var31_17.zza.zzab(), var36_25.zze())) == null) {
                            var29_20.zzj().zzr().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)var31_17.zza.zzab(), (Object)var36_25.zze());
                            var42_41 = new zzbf(var31_17.zza.zzab(), var36_25.zze(), 1L, 1L, 1L, var36_25.zzc(), 0L, null, null, null, null);
                        }
                        var29_20.zzp();
                        var43_43 = (Long)zzpz.zzb((zzgg.zzf)((zzki)var36_25.zzaj()), "_eid");
                        var44_111 = var43_43 != null;
                        if (var41_40 == 1) {
                            var33_10.add((zzgg.zzf)((zzki)var36_25.zzaj()));
                            if (var44_111.booleanValue() && (var42_41.zzi != null || var42_41.zzj != null || var42_41.zzk != null)) {
                                var42_41 = var42_41.zza(null, null, null);
                                var32_101.put(var36_25.zze(), var42_41);
                            }
                            var30_19.zza(var35_5, var36_25);
                            continue;
                        }
                        if (var34_107.nextInt(var41_40) == 0) {
                            var29_20.zzp();
                            zzpz.zza(var36_25, "_sr", (Object)var41_40);
                            var33_10.add((zzgg.zzf)((zzki)var36_25.zzaj()));
                            if (var44_111.booleanValue()) {
                                var42_41 = var42_41.zza(null, Long.valueOf(var41_40), null);
                            }
                            var32_101.put(var36_25.zze(), var42_41.zza(var36_25.zzc(), var39_34));
                        } else {
                            if (var42_41.zzh != null) {
                                var45_45 = var42_41.zzh;
                            } else {
                                var29_20.zzq();
                                var45_45 = zzqd.zza((long)var36_25.zzb(), (long)var37_32);
                            }
                            if (var45_45 != var39_34) {
                                var29_20.zzp();
                                zzpz.zza(var36_25, "_efs", (Object)1L);
                                var29_20.zzp();
                                zzpz.zza(var36_25, "_sr", (Object)var41_40);
                                var33_10.add((zzgg.zzf)((zzki)var36_25.zzaj()));
                                if (var44_111.booleanValue()) {
                                    var42_41 = var42_41.zza(null, Long.valueOf(var41_40), Boolean.valueOf(true));
                                }
                                var32_101.put(var36_25.zze(), var42_41.zza(var36_25.zzc(), var39_34));
                            } else if (var44_111.booleanValue()) {
                                var32_101.put(var36_25.zze(), var42_41.zza(var43_43, null, null));
                            }
                        }
                        var30_19.zza(var35_5, var36_25);
                    }
                    if (var33_10.size() < var30_19.zzc()) {
                        var30_19.zzl().zzb(var33_10);
                    }
                    for (Map.Entry var36_26 : var32_101.entrySet()) {
                        var29_20.zzf().zza((zzbf)var36_26.getValue());
                    }
                }
                var19_73 = var4_3.zza.zzab();
                var20_77 = this.zzf().zzd(var19_73);
                if (var20_77 == null) {
                    this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzhc.zza((String)var4_3.zza.zzab()));
                } else if (var6_50.zzc() > 0) {
                    var21_80 = var20_77.zzs();
                    if (var21_80 != 0L) {
                        var6_50.zzh(var21_80);
                    } else {
                        var6_50.zzo();
                    }
                    var23_89 = var20_77.zzu();
                    if (var23_89 == 0L) {
                        var23_89 = var21_80;
                    }
                    if (var23_89 != 0L) {
                        var6_50.zzi(var23_89);
                    } else {
                        var6_50.zzp();
                    }
                    var20_77.zza((long)var6_50.zzc());
                    var6_50.zzg((int)var20_77.zzr());
                    var6_50.zzf((int)var20_77.zzt());
                    var20_77.zzr(var6_50.zzf());
                    var20_77.zzp(var6_50.zze());
                    var25_94 = var20_77.zzab();
                    if (var25_94 != null) {
                        var6_50.zzo(var25_94);
                    } else {
                        var6_50.zzm();
                    }
                    this.zzf().zza(var20_77, false, false);
                }
                if (var6_50.zzc() > 0) {
                    var21_81 = this.zzi().zzc(var4_3.zza.zzab());
                    if (var21_81 == null || !var21_81.zzr()) {
                        if (var4_3.zza.zzal().isEmpty()) {
                            var6_50.zzc(-1L);
                        } else {
                            this.zzj().zzr().zza("Did not find measurement config or missing version info. appId", zzhc.zza((String)var4_3.zza.zzab()));
                        }
                    } else {
                        var6_50.zzc(var21_81.zzc());
                    }
                    this.zzf().zza((zzgg.zzk)((zzki)var6_50.zzaj()), var5_49);
                }
                var30_19 = var4_3.zzb;
                var29_20 = this.zzf();
                Preconditions.checkNotNull((Object)var30_19);
                var29_20.zzv();
                var29_20.zzam();
                var31_18 = new StringBuilder("rowid in (");
                for (var32_102 = 0; var32_102 < var30_19.size(); ++var32_102) {
                    if (var32_102 != 0) {
                        var31_18.append(",");
                    }
                    var31_18.append((Long)var30_19.get(var32_102));
                }
                var31_18.append(")");
                var33_11 = var29_20.f_().delete("raw_events", var31_18.toString(), null);
                if (var33_11 != var30_19.size()) {
                    var29_20.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)var33_11, (Object)var30_19.size());
                }
                var30_19 = var19_73;
                var29_20 = this.zzf();
                var31_18 = var29_20.f_();
                try {
                    var31_18.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{var30_19, var30_19});
                }
                catch (SQLiteException var32_103) {
                    var29_20.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzhc.zza((String)var30_19), (Object)var32_103);
                }
                this.zzf().zzx();
                return true;
            }
            this.zzf().zzx();
            return false;
        }
        finally {
            this.zzf().zzr();
        }
    }

    private final boolean zzag() {
        this.zzl().zzv();
        this.zzt();
        return this.zzf().zzy() || !TextUtils.isEmpty((CharSequence)this.zzf().g_());
    }

    @WorkerThread
    private final boolean zza(String string, String string2) {
        zzbf zzbf2 = this.zzf().zzd(string, string2);
        return zzbf2 == null || zzbf2.zzc < 1L;
    }

    @WorkerThread
    @VisibleForTesting
    private final boolean zzb(String string, String string2) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 != null && this.zzq().zzd(string, zzg2.zzam())) {
            this.zzaf.remove(string2);
            return true;
        }
        zzc zzc2 = this.zzaf.get(string2);
        if (zzc2 == null) {
            return true;
        }
        return zzc2.zzb();
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzah() {
        this.zzl().zzv();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzq().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(zzcf.zza().zza(file, string));
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzq().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzr().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzgg.zzf.zza zza2, zzgg.zzf.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzgg.zzh zzh2 = zzpz.zza((zzgg.zzf)((zzki)zza2.zzaj()), "_sc");
        String string = zzh2 == null ? null : zzh2.zzh();
        this.zzp();
        zzgg.zzh zzh3 = zzpz.zza((zzgg.zzf)((zzki)zza3.zzaj()), "_pc");
        String string2 = zzh3 == null ? null : zzh3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzgg.zzf.zza zza4 = zza3;
            zzgg.zzf.zza zza5 = zza2;
            zzpk zzpk2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzpk2.zzp();
            zzgg.zzh zzh4 = zzpz.zza((zzgg.zzf)((zzki)zza5.zzaj()), "_et");
            if (zzh4 != null && zzh4.zzl() && zzh4.zzd() > 0L) {
                long l = zzh4.zzd();
                zzpk2.zzp();
                zzh4 = zzpz.zza((zzgg.zzf)((zzki)zza4.zzaj()), "_et");
                if (zzh4 != null && zzh4.zzd() > 0L) {
                    l += zzh4.zzd();
                }
                zzpk2.zzp();
                zzpz.zza(zza4, "_et", (Object)l);
                zzpk2.zzp();
                zzpz.zza(zza5, "_fr", (Object)1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzv();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @VisibleForTesting
    static final class zzc {
        private final zzpk zza;
        private int zzb;
        private long zzc;

        private final long zzc(@UnknownInitialization zzc this) {
            Preconditions.checkNotNull((Object)this.zza);
            long l = (Long)zzbl.zzu.zza(null);
            long l2 = (Long)zzbl.zzv.zza(null);
            for (int i = 1; i < this.zzb && (l <<= 1) < l2; ++i) {
            }
            return this.zza.zzb().currentTimeMillis() + Math.min(l, l2);
        }

        public zzc(zzpk zzpk2) {
            this.zza = zzpk2;
            this.zzb = 1;
            this.zzc = this.zzc();
        }

        public final void zza() {
            ++this.zzb;
            this.zzc = this.zzc();
        }

        public final boolean zzb() {
            return this.zza.zzb().currentTimeMillis() >= this.zzc;
        }
    }

    private final class zza {
        final String zza;
        long zzb;

        private zza(zzpk zzpk2) {
            this(zzpk2, zzpk2.zzq().zzq());
        }

        /* synthetic */ zza(zzpk zzpk2, zzpt zzpt2) {
            this(zzpk2);
        }

        private zza(zzpk zzpk2, String string) {
            this.zza = string;
            this.zzb = zzpk2.zzb().elapsedRealtime();
        }

        /* synthetic */ zza(zzpk zzpk2, String string, zzpt zzpt2) {
            this(zzpk2, string);
        }
    }

    private final class zzb
    implements zzaw {
        zzgg.zzk zza;
        List<Long> zzb;
        List<zzgg.zzf> zzc;
        private long zzd;

        private static long zza(zzgg.zzf zzf2) {
            return zzf2.zzd() / 1000L / 60L / 60L;
        }

        private zzb() {
        }

        /* synthetic */ zzb(zzpt zzpt2) {
            this();
        }

        @Override
        public final void zza(zzgg.zzk zzk2) {
            Preconditions.checkNotNull((Object)zzk2);
            this.zza = zzk2;
        }

        @Override
        public final boolean zza(long l, zzgg.zzf zzf2) {
            Preconditions.checkNotNull((Object)zzf2);
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzgg.zzf>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzpk$zzb.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzpk$zzb.zza(zzf2)) {
                return false;
            }
            long l2 = this.zzd + (long)zzf2.zzcf();
            zzpk.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbl.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zzf2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzpk.this.zze();
            return n < Math.max(1, (Integer)zzbl.zzj.zza(null));
        }
    }
}

