/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzg;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class zzae
implements Iterable,
zzao,
zzak {
    @VisibleForTesting
    final SortedMap zza = new TreeMap();
    @VisibleForTesting
    final Map zzb = new TreeMap();

    public zzae() {
    }

    public zzae(List list) {
        this();
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                int n2 = n++;
                this.zzn(n2, (zzao)list.get(n2));
            }
        }
    }

    public final List zzb() {
        ArrayList<zzao> arrayList = new ArrayList<zzao>(this.zzh());
        for (int i = 0; i < this.zzh(); ++i) {
            arrayList.add(this.zzl(i));
        }
        return arrayList;
    }

    @Override
    public final String zzc() {
        return this.zzs(",");
    }

    @Override
    public final Double zzd() {
        SortedMap sortedMap = this.zza;
        if (sortedMap.size() == 1) {
            return this.zzl(0).zzd();
        }
        if (sortedMap.size() <= 0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public final Boolean zze() {
        return true;
    }

    @Override
    public final Iterator zzf() {
        Iterator iterator = this.zza.keySet().iterator();
        Iterator iterator2 = this.zzb.keySet().iterator();
        return new zzac(this, iterator, iterator2);
    }

    public final Iterator iterator() {
        return new zzad(this);
    }

    public final Iterator zzg() {
        return this.zza.keySet().iterator();
    }

    public final int zzh() {
        SortedMap sortedMap = ((zzae)((Object)sortedMap)).zza;
        if (sortedMap.isEmpty()) {
            return 0;
        }
        return (Integer)sortedMap.lastKey() + 1;
    }

    public final int zzi() {
        return this.zza.size();
    }

    @Override
    public final zzao zzcA(String string, zzg zzg2, List list) {
        if ("concat".equals(string) || "every".equals(string) || "filter".equals(string) || "forEach".equals(string) || "indexOf".equals(string) || "join".equals(string) || "lastIndexOf".equals(string) || "map".equals(string) || "pop".equals(string) || "push".equals(string) || "reduce".equals(string) || "reduceRight".equals(string) || "reverse".equals(string) || "shift".equals(string) || "slice".equals(string) || "some".equals(string) || "sort".equals(string) || "splice".equals(string) || "toString".equals(string) || "unshift".equals(string)) {
            return zzba.zza(string, this, zzg2, list);
        }
        return zzak.zzu(this, new zzas(string), zzg2, list);
    }

    @Override
    public final boolean zzj(String string) {
        return "length".equals(string) || this.zzb.containsKey(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final zzao zzk(String string) {
        zzao zzao2;
        void var1_2;
        if ("length".equals(var1_2)) {
            return new zzah(Double.valueOf(this.zzh()));
        }
        if (this.zzj((String)var1_2) && (zzao2 = (zzao)this.zzb.get(var1_2)) != null) {
            return zzao2;
        }
        return zzf;
    }

    /*
     * WARNING - void declaration
     */
    public final zzao zzl(int n) {
        zzao zzao2;
        void var1_2;
        if (var1_2 >= this.zzh()) {
            throw new IndexOutOfBoundsException("Attempting to get element outside of current array");
        }
        if (this.zzo((int)var1_2) && (zzao2 = (zzao)this.zza.get((int)var1_2)) != null) {
            return zzao2;
        }
        return zzf;
    }

    @Override
    public final void zzm(String string, zzao zzao2) {
        if (zzao2 == null) {
            this.zzb.remove(string);
            return;
        }
        this.zzb.put(string, zzao2);
    }

    @RequiresNonNull(value={"elements"})
    public final void zzn(int n, zzao zzao2) {
        if (n > 32468) {
            throw new IllegalStateException("Array too large");
        }
        if (n < 0) {
            int n2 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 21);
            stringBuilder.append("Out of bounds index: ");
            stringBuilder.append(n);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        if (zzao2 == null) {
            this.zza.remove(n);
            return;
        }
        this.zza.put(n, zzao2);
    }

    public final boolean zzo(int n) {
        if (n < 0 || n > (Integer)(this = ((zzae)this).zza).lastKey()) {
            int n2 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 21);
            stringBuilder.append("Out of bounds index: ");
            stringBuilder.append(n);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        return this.containsKey(n);
    }

    public final void zzp() {
        this.zza.clear();
    }

    public final void zzq(int n, zzao zzao2) {
        if (n < 0) {
            int n2 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 21);
            stringBuilder.append("Invalid value index: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (n >= this.zzh()) {
            this.zzn(n, zzao2);
            return;
        }
        SortedMap sortedMap = this.zza;
        for (int i = ((Integer)sortedMap.lastKey()).intValue(); i >= n; --i) {
            Integer n3 = i;
            zzao zzao3 = (zzao)sortedMap.get(n3);
            if (zzao3 == null) continue;
            this.zzn(i + 1, zzao3);
            sortedMap.remove(n3);
        }
        this.zzn(n, zzao2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzr(int n) {
        SortedMap sortedMap = this.zza;
        int n2 = (Integer)sortedMap.lastKey();
        if (n > n2 || n < 0) return;
        sortedMap.remove(n);
        if (n == n2) {
            n2 = n + -1;
            Integer n3 = n2;
            if (sortedMap.containsKey(n3) || n2 < 0) return;
            sortedMap.put(n3, zzao.zzf);
            return;
        }
        for (n2 = n + 1; n2 <= (Integer)sortedMap.lastKey(); ++n2) {
            Integer n4 = n2;
            zzao zzao2 = (zzao)sortedMap.get(n4);
            if (zzao2 == null) continue;
            sortedMap.put(n2 + -1, zzao2);
            sortedMap.remove(n4);
        }
    }

    public final int hashCode() {
        return this.zza.hashCode() * 31;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzae)) {
            return false;
        }
        zzae zzae2 = (zzae)object;
        if (this.zzh() != zzae2.zzh()) {
            return false;
        }
        SortedMap sortedMap = this.zza;
        if (sortedMap.isEmpty()) {
            return zzae2.zza.isEmpty();
        }
        for (int i = ((Integer)sortedMap.firstKey()).intValue(); i <= (Integer)sortedMap.lastKey(); ++i) {
            if (this.zzl(i).equals(zzae2.zzl(i))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        return this.zzs(",");
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String zzs(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.zza.isEmpty()) {
            String string2;
            int n = 0;
            while (true) {
                string2 = string == null ? "" : string;
                if (n >= this.zzh()) break;
                zzao zzao2 = this.zzl(n);
                stringBuilder.append(string2);
                if (!(zzao2 instanceof zzat) && !(zzao2 instanceof zzam)) {
                    stringBuilder.append(zzao2.zzc());
                }
                ++n;
            }
            stringBuilder.delete(0, string2.length());
        }
        return stringBuilder.toString();
    }

    @Override
    public final zzao zzt() {
        zzae zzae2 = new zzae();
        for (Map.Entry entry : ((zzae)this).zza.entrySet()) {
            if (entry.getValue() instanceof zzak) {
                zzae2.zza.put((Integer)entry.getKey(), (zzao)entry.getValue());
                continue;
            }
            zzae2.zza.put((Integer)entry.getKey(), ((zzao)entry.getValue()).zzt());
        }
        return zzae2;
    }
}

