/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhq;
import com.google.android.gms.internal.measurement.zzhr;
import com.google.android.gms.internal.measurement.zzhs;
import com.google.android.gms.internal.measurement.zzhv;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzic;
import com.google.android.gms.internal.measurement.zzid;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzit;
import com.google.android.gms.internal.measurement.zziu;
import com.google.android.gms.internal.measurement.zzlq;
import com.google.android.gms.internal.measurement.zzmq;
import com.google.android.gms.internal.measurement.zznk;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqu;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzor;
import com.google.android.gms.measurement.internal.zzot;
import com.google.android.gms.measurement.internal.zzpf;
import com.google.android.gms.measurement.internal.zzpo;
import com.google.android.gms.measurement.internal.zzr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public final class zzpj
extends zzor {
    zzpj(zzpf zzpf2) {
        super(zzpf2);
    }

    @Override
    protected final boolean zzbb() {
        return false;
    }

    final void zzc(zzit zzit2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzit2.zzd();
        zzit2.zzf();
        zzit2.zzh();
        if (object instanceof String) {
            zzit2.zzc((String)object);
            return;
        }
        if (object instanceof Long) {
            zzit2.zze(((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            zzit2.zzg(((Double)object).doubleValue());
            return;
        }
        this.zzu.zzaV().zzb().zzb("Ignoring invalid (type) user attribute value", object);
    }

    /*
     * Unable to fully structure code
     */
    final void zzd(zzhv var1_2, Object var2_3) {
        block9: {
            Preconditions.checkNotNull((Object)var2_3);
            var1_2.zze();
            var1_2.zzg();
            var1_2.zzi();
            var1_2.zzm();
            if (var2_3 instanceof String) {
                var1_2.zzd((String)var2_3);
                return;
            }
            if (var2_3 instanceof Long) {
                var1_2.zzf(((Long)var2_3).longValue());
                return;
            }
            if (var2_3 instanceof Double) {
                var1_2.zzh(((Double)var2_3).doubleValue());
                return;
            }
            if (!(var2_3 instanceof Bundle[])) break block9;
            var2_3 = var2_3;
            var3_4 = new ArrayList<zzhw>();
            block0: for (Bundle var5_6 : var2_3) {
                if (var5_6 == null) lbl-1000:
                // 3 sources

                {
                    continue block0;
                }
                var6_7 = zzhw.zzn();
                block2: for (Object var8_9 : var5_6.keySet()) {
                    block10: {
                        var9_10 = zzhw.zzn();
                        var9_10.zzb((String)var8_9);
                        var8_9 = var5_6.get((String)var8_9);
                        if (var8_9 instanceof Long) {
                            var9_10.zzf(((Long)var8_9).longValue());
lbl39:
                            // 3 sources

                            while (true) {
                                var6_7.zzk(var9_10);
                                continue block2;
                                break;
                            }
                        }
                        if (!(var8_9 instanceof String)) break block10;
                        var9_10.zzd((String)var8_9);
                        ** GOTO lbl39
                    }
                    if (!(var8_9 instanceof Double)) continue;
                    var9_10.zzh(((Double)var8_9).doubleValue());
                    ** continue;
                }
                if (var6_7.zzj() <= 0) ** GOTO lbl-1000
                var3_4.add((zzhw)var6_7.zzbc());
                ** continue;
            }
            var1_2.zzl(var3_4);
            return;
        }
        this.zzu.zzaV().zzb().zzb("Ignoring invalid (type) event param value", (Object)var2_3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=30)
    final zzog zzf(String string, zzic zzic2, zzhr object, String string22) {
        int n;
        zzql.zza();
        zzib zzib2 = ((zzjd)object3).zzu;
        if (!zzib2.zzc().zzp(string, zzfx.zzaP)) {
            return null;
        }
        long l = zzib2.zzaZ().currentTimeMillis();
        Set<String> set = Set.of(zzib2.zzc().zzk(string, zzfx.zzau).split(","));
        Object object2 = ((zzok)((Object)object3)).zzg;
        zzot zzot2 = ((zzpf)object2).zzf();
        Object object3 = zzot2.zzg.zzh().zzc(string);
        Uri.Builder builder = new Uri.Builder();
        zzib zzib3 = zzot2.zzu;
        builder.scheme(zzib3.zzc().zzk(string, zzfx.zzan));
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            String string3 = zzib3.zzc().zzk(string, zzfx.zzao);
            int n2 = String.valueOf(object3).length() + 1;
            int n3 = String.valueOf(string3).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + n3);
            stringBuilder.append((String)object3);
            stringBuilder.append(".");
            stringBuilder.append(string3);
            builder.authority(stringBuilder.toString());
        } else {
            builder.authority(zzib3.zzc().zzk(string, zzfx.zzao));
        }
        builder.path(zzib3.zzc().zzk(string, zzfx.zzap));
        object3 = zzic2.zzac();
        zzpj.zzN(builder, "gmp_app_id", (String)object3, set);
        zzib2.zzc().zzi();
        zzpj.zzN(builder, "gmp_version", String.valueOf(130000L), set);
        object3 = zzic2.zzV();
        zzib3 = zzfx.zzaS;
        if (zzib2.zzc().zzp(string, (zzfw)zzib3) && ((zzpf)object2).zzh().zzt(string)) {
            object3 = "";
        }
        zzpj.zzN(builder, "app_instance_id", (String)object3, set);
        object3 = zzic2.zzP();
        zzpj.zzN(builder, "rdid", (String)object3, set);
        object3 = zzic2.zzK();
        zzpj.zzN(builder, "bundle_id", (String)object3, set);
        object3 = object.zzk();
        String string4 = zzjl.zza((String)object3);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            object3 = string4;
        }
        zzpj.zzN(builder, "app_event_name", (String)object3, set);
        object3 = String.valueOf(zzic2.zzai());
        zzpj.zzN(builder, "app_version", (String)object3, set);
        object3 = zzic2.zzD();
        if (zzib2.zzc().zzp(string, (zzfw)zzib3) && ((zzpf)object2).zzh().zzq(string) && !TextUtils.isEmpty((CharSequence)object3) && (n = ((String)object3).indexOf(".")) != -1) {
            object3 = ((String)object3).substring(0, n);
        }
        zzpj.zzN(builder, "os_version", (String)object3, set);
        object3 = String.valueOf(object.zzn());
        zzpj.zzN(builder, "timestamp", (String)object3, set);
        if (zzic2.zzS()) {
            zzpj.zzN(builder, "lat", "1", set);
        }
        object3 = String.valueOf(zzic2.zzaG());
        zzpj.zzN(builder, "privacy_sandbox_version", (String)object3, set);
        zzpj.zzN(builder, "trigger_uri_source", "1", set);
        object3 = String.valueOf(l);
        zzpj.zzN(builder, "trigger_uri_timestamp", (String)object3, set);
        zzpj.zzN(builder, "request_uuid", string22, set);
        object3 = new Bundle();
        for (String string22 : object.zza()) {
            object2 = string22.zzb();
            if (string22.zzi()) {
                object3.putString((String)object2, String.valueOf(string22.zzj()));
                continue;
            }
            if (string22.zzg()) {
                object3.putString((String)object2, String.valueOf(string22.zzh()));
                continue;
            }
            if (string22.zzc()) {
                object3.putString((String)object2, string22.zzd());
                continue;
            }
            if (!string22.zze()) continue;
            object3.putString((String)object2, String.valueOf(string22.zzf()));
        }
        zzpj.zzQ(builder, zzib2.zzc().zzk(string, zzfx.zzat).split("\\|"), (Bundle)object3, set);
        object3 = new Bundle();
        for (String string22 : zzic2.zzk()) {
            object2 = string22.zzc();
            if (string22.zzj()) {
                object3.putString((String)object2, String.valueOf(string22.zzk()));
                continue;
            }
            if (string22.zzh()) {
                object3.putString((String)object2, String.valueOf(string22.zzi()));
                continue;
            }
            if (string22.zzd()) {
                object3.putString((String)object2, string22.zze());
                continue;
            }
            if (!string22.zzf()) continue;
            object3.putString((String)object2, String.valueOf(string22.zzg()));
        }
        zzpj.zzQ(builder, zzib2.zzc().zzk(string, zzfx.zzas).split("\\|"), (Bundle)object3, set);
        object3 = true != zzic2.zzaC() ? "0" : "1";
        zzpj.zzN(builder, "dma", (String)object3, set);
        if (!zzic2.zzaE().isEmpty()) {
            object3 = zzic2.zzaE();
            zzpj.zzN(builder, "dma_cps", (String)object3, set);
        }
        if (zzic2.zzaK()) {
            object3 = zzic2.zzaL();
            if (!object3.zzb().isEmpty()) {
                string = object3.zzb();
                zzpj.zzN(builder, "dl_gclid", string, set);
            }
            if (!object3.zzd().isEmpty()) {
                string = object3.zzd();
                zzpj.zzN(builder, "dl_gbraid", string, set);
            }
            if (!object3.zzf().isEmpty()) {
                string = object3.zzf();
                zzpj.zzN(builder, "dl_gs", string, set);
            }
            if (object3.zzh() > 0L) {
                string = String.valueOf(object3.zzh());
                zzpj.zzN(builder, "dl_ss_ts", string, set);
            }
            if (!object3.zzj().isEmpty()) {
                string = object3.zzj();
                zzpj.zzN(builder, "mr_gclid", string, set);
            }
            if (!object3.zzm().isEmpty()) {
                string = object3.zzm();
                zzpj.zzN(builder, "mr_gbraid", string, set);
            }
            if (!object3.zzo().isEmpty()) {
                string = object3.zzo();
                zzpj.zzN(builder, "mr_gs", string, set);
            }
            if (object3.zzq() > 0L) {
                object3 = String.valueOf(object3.zzq());
                zzpj.zzN(builder, "mr_click_ts", (String)object3, set);
            }
        }
        return new zzog(builder.build().toString(), l, 1);
    }

    final zzhs zzh(zzbb zzbb2) {
        zzhr zzhr2 = zzhs.zzk();
        zzhr2.zzq(zzbb2.zze);
        zzbe zzbe2 = zzbb2.zzf;
        zzbd zzbd2 = new zzbd(zzbe2);
        while (zzbd2.hasNext()) {
            String string = zzbd2.zza();
            zzhv zzhv2 = zzhw.zzn();
            zzhv2.zzb(string);
            Object object = zzbe2.zza(string);
            Preconditions.checkNotNull((Object)object);
            ((zzpj)((Object)string)).zzd(zzhv2, object);
            zzhr2.zzg(zzhv2);
        }
        String string = zzbb2.zzc;
        if (!TextUtils.isEmpty((CharSequence)string) && zzbe2.zza("_o") == null) {
            zzhv zzhv3 = zzhw.zzn();
            zzhv3.zzb("_o");
            zzhv3.zzd(string);
            zzhr2.zzf((zzhw)zzhv3.zzbc());
        }
        return (zzhs)zzhr2.zzbc();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzi(com.google.android.gms.internal.measurement.zzib var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        if (var1_1.zzf()) {
            var3_3 = var1_1.zzg();
            zzpj.zzS(var2_2, 0, "upload_subdomain", var3_3);
        }
        if (var1_1.zzd()) {
            var3_3 = var1_1.zze();
            zzpj.zzS(var2_2, 0, "sgtm_join_id", var3_3);
        }
        var3_3 = var1_1.zza().iterator();
        block23: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("} // End-of-batch\n");
                return var2_2.toString();
            }
            var4_4 = (zzid)var3_3.next();
            if (var4_4 == null) continue;
            zzpj.zzM(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_4.zza()) {
                var1_1 = var4_4.zzb();
                zzpj.zzS(var2_2, 1, "protocol_version", var1_1);
            }
            zzqu.zza();
            var5_5 = this.zzu;
            if (var5_5.zzc().zzp(var4_4.zzA(), zzfx.zzaM) && var4_4.zzag()) {
                var1_1 = var4_4.zzah();
                zzpj.zzS(var2_2, 1, "session_stitching_token", var1_1);
            }
            var1_1 = var4_4.zzt();
            zzpj.zzS(var2_2, 1, "platform", var1_1);
            if (var4_4.zzC()) {
                var1_1 = var4_4.zzD();
                zzpj.zzS(var2_2, 1, "gmp_version", var1_1);
            }
            if (var4_4.zzE()) {
                var1_1 = var4_4.zzF();
                zzpj.zzS(var2_2, 1, "uploading_gmp_version", var1_1);
            }
            if (var4_4.zzac()) {
                var1_1 = var4_4.zzad();
                zzpj.zzS(var2_2, 1, "dynamite_version", var1_1);
            }
            if (var4_4.zzW()) {
                var1_1 = var4_4.zzX();
                zzpj.zzS(var2_2, 1, "config_version", var1_1);
            }
            var1_1 = var4_4.zzP();
            zzpj.zzS(var2_2, 1, "gmp_app_id", var1_1);
            var1_1 = var4_4.zzA();
            zzpj.zzS(var2_2, 1, "app_id", var1_1);
            var1_1 = var4_4.zzB();
            zzpj.zzS(var2_2, 1, "app_version", var1_1);
            if (var4_4.zzU()) {
                var1_1 = var4_4.zzV();
                zzpj.zzS(var2_2, 1, "app_version_major", var1_1);
            }
            var1_1 = var4_4.zzT();
            zzpj.zzS(var2_2, 1, "firebase_instance_id", var1_1);
            if (var4_4.zzK()) {
                var1_1 = var4_4.zzL();
                zzpj.zzS(var2_2, 1, "dev_cert_hash", var1_1);
            }
            var1_1 = var4_4.zzz();
            zzpj.zzS(var2_2, 1, "app_store", var1_1);
            if (var4_4.zzi()) {
                var1_1 = var4_4.zzj();
                zzpj.zzS(var2_2, 1, "upload_timestamp_millis", var1_1);
            }
            if (var4_4.zzk()) {
                var1_1 = var4_4.zzm();
                zzpj.zzS(var2_2, 1, "start_timestamp_millis", var1_1);
            }
            if (var4_4.zzn()) {
                var1_1 = var4_4.zzo();
                zzpj.zzS(var2_2, 1, "end_timestamp_millis", var1_1);
            }
            if (var4_4.zzp()) {
                var1_1 = var4_4.zzq();
                zzpj.zzS(var2_2, 1, "previous_bundle_start_timestamp_millis", var1_1);
            }
            if (var4_4.zzr()) {
                var1_1 = var4_4.zzs();
                zzpj.zzS(var2_2, 1, "previous_bundle_end_timestamp_millis", var1_1);
            }
            var1_1 = var4_4.zzJ();
            zzpj.zzS(var2_2, 1, "app_instance_id", var1_1);
            var1_1 = var4_4.zzG();
            zzpj.zzS(var2_2, 1, "resettable_device_id", var1_1);
            var1_1 = var4_4.zzZ();
            zzpj.zzS(var2_2, 1, "ds_id", var1_1);
            if (var4_4.zzH()) {
                var1_1 = var4_4.zzI();
                zzpj.zzS(var2_2, 1, "limited_ad_tracking", var1_1);
            }
            var1_1 = var4_4.zzu();
            zzpj.zzS(var2_2, 1, "os_version", var1_1);
            var1_1 = var4_4.zzv();
            zzpj.zzS(var2_2, 1, "device_model", var1_1);
            var1_1 = var4_4.zzw();
            zzpj.zzS(var2_2, 1, "user_default_language", var1_1);
            if (var4_4.zzx()) {
                var1_1 = var4_4.zzy();
                zzpj.zzS(var2_2, 1, "time_zone_offset_minutes", var1_1);
            }
            if (var4_4.zzM()) {
                var1_1 = var4_4.zzN();
                zzpj.zzS(var2_2, 1, "bundle_sequential_index", var1_1);
            }
            if (var4_4.zzau()) {
                var1_1 = var4_4.zzav();
                zzpj.zzS(var2_2, 1, "delivery_index", var1_1);
            }
            if (var4_4.zzQ()) {
                var1_1 = var4_4.zzR();
                zzpj.zzS(var2_2, 1, "service_upload", var1_1);
            }
            var1_1 = var4_4.zzO();
            zzpj.zzS(var2_2, 1, "health_monitor", var1_1);
            if (var4_4.zzaa()) {
                var1_1 = var4_4.zzab();
                zzpj.zzS(var2_2, 1, "retry_counter", var1_1);
            }
            if (var4_4.zzae()) {
                var1_1 = var4_4.zzaf();
                zzpj.zzS(var2_2, 1, "consent_signals", var1_1);
            }
            if (var4_4.zzan()) {
                var1_1 = var4_4.zzao();
                zzpj.zzS(var2_2, 1, "is_dma_region", var1_1);
            }
            if (var4_4.zzap()) {
                var1_1 = var4_4.zzaq();
                zzpj.zzS(var2_2, 1, "core_platform_services", var1_1);
            }
            if (var4_4.zzal()) {
                var1_1 = var4_4.zzam();
                zzpj.zzS(var2_2, 1, "consent_diagnostics", var1_1);
            }
            if (var4_4.zzai()) {
                var1_1 = var4_4.zzaj();
                zzpj.zzS(var2_2, 1, "target_os_version", var1_1);
            }
            zzql.zza();
            if (var5_5.zzc().zzp(var4_4.zzA(), zzfx.zzaP)) {
                var1_1 = var4_4.zzar();
                zzpj.zzS(var2_2, 1, "ad_services_version", var1_1);
                if (var4_4.zzas() && (var1_1 = var4_4.zzat()) != null) {
                    zzpj.zzM(var2_2, 2);
                    var2_2.append("attribution_eligibility_status {\n");
                    var6_6 = var1_1.zza();
                    zzpj.zzS(var2_2, 2, "eligible", var6_6);
                    var6_6 = var1_1.zzb();
                    zzpj.zzS(var2_2, 2, "no_access_adservices_attribution_permission", var6_6);
                    var6_6 = var1_1.zzc();
                    zzpj.zzS(var2_2, 2, "pre_r", var6_6);
                    var6_6 = var1_1.zzd();
                    zzpj.zzS(var2_2, 2, "r_extensions_too_old", var6_6);
                    var6_6 = var1_1.zze();
                    zzpj.zzS(var2_2, 2, "adservices_extension_too_old", var6_6);
                    var6_6 = var1_1.zzf();
                    zzpj.zzS(var2_2, 2, "ad_storage_not_allowed", var6_6);
                    var1_1 = var1_1.zzg();
                    zzpj.zzS(var2_2, 2, "measurement_manager_disabled", var1_1);
                    zzpj.zzM(var2_2, 2);
                    var2_2.append("}\n");
                }
            }
            if (var4_4.zzaw()) {
                var1_1 = var4_4.zzax();
                zzpj.zzM(var2_2, 2);
                var2_2.append("ad_campaign_info {\n");
                if (var1_1.zza()) {
                    var6_6 = var1_1.zzb();
                    zzpj.zzS(var2_2, 2, "deep_link_gclid", var6_6);
                }
                if (var1_1.zzc()) {
                    var6_6 = var1_1.zzd();
                    zzpj.zzS(var2_2, 2, "deep_link_gbraid", var6_6);
                }
                if (var1_1.zze()) {
                    var6_6 = var1_1.zzf();
                    zzpj.zzS(var2_2, 2, "deep_link_gad_source", var6_6);
                }
                if (var1_1.zzg()) {
                    var6_6 = var1_1.zzh();
                    zzpj.zzS(var2_2, 2, "deep_link_session_millis", var6_6);
                }
                if (var1_1.zzi()) {
                    var6_6 = var1_1.zzj();
                    zzpj.zzS(var2_2, 2, "market_referrer_gclid", var6_6);
                }
                if (var1_1.zzk()) {
                    var6_6 = var1_1.zzm();
                    zzpj.zzS(var2_2, 2, "market_referrer_gbraid", var6_6);
                }
                if (var1_1.zzn()) {
                    var6_6 = var1_1.zzo();
                    zzpj.zzS(var2_2, 2, "market_referrer_gad_source", var6_6);
                }
                if (var1_1.zzp()) {
                    var1_1 = var1_1.zzq();
                    zzpj.zzS(var2_2, 2, "market_referrer_click_millis", var1_1);
                }
                zzpj.zzM(var2_2, 2);
                var2_2.append("}\n");
            }
            if (var4_4.zzaA()) {
                var1_1 = var4_4.zzaB();
                zzpj.zzS(var2_2, 1, "batching_timestamp_millis", var1_1);
            }
            if (var4_4.zzay()) {
                var6_6 = var4_4.zzaz();
                zzpj.zzM(var2_2, 2);
                var2_2.append("sgtm_diagnostics {\n");
                switch (var6_6.zzf()) {
                    default: {
                        var1_1 = "SDK_SERVICE_UPLOAD";
                        break;
                    }
                    case 1: {
                        var1_1 = "UPLOAD_TYPE_UNKNOWN";
                        break;
                    }
                    case 4: {
                        var1_1 = "PACKAGE_SERVICE_UPLOAD";
                        break;
                    }
                    case 3: {
                        var1_1 = "SDK_CLIENT_UPLOAD";
                        break;
                    }
                    case 2: {
                        var1_1 = "GA_UPLOAD";
                    }
                }
                zzpj.zzS(var2_2, 2, "upload_type", var1_1);
                var1_1 = var6_6.zza().name();
                zzpj.zzS(var2_2, 2, "client_upload_eligibility", var1_1);
                switch (var6_6.zzg()) {
                    default: {
                        var1_1 = "NON_PLAY_MISSING_SGTM_SERVER_URL";
                        break;
                    }
                    case 1: {
                        var1_1 = "SERVICE_UPLOAD_ELIGIBILITY_UNKNOWN";
                        break;
                    }
                    case 5: {
                        var1_1 = "MISSING_SGTM_PROXY_INFO";
                        break;
                    }
                    case 4: {
                        var1_1 = "MISSING_SGTM_SETTINGS";
                        break;
                    }
                    case 3: {
                        var1_1 = "NOT_IN_ROLLOUT";
                        break;
                    }
                    case 2: {
                        var1_1 = "SERVICE_UPLOAD_ELIGIBLE";
                    }
                }
                zzpj.zzS(var2_2, 2, "service_upload_eligibility", var1_1);
                zzpj.zzM(var2_2, 2);
                var2_2.append("}\n");
            }
            if (var4_4.zzaC()) {
                v0 = var4_4.zzaD();
                zzpj.zzM(var2_2, 2);
                var2_2.append("consent_info_extra {\n");
                for (zziu var7_7 : v0.zza()) {
                    zzpj.zzM(var2_2, 3);
                    var2_2.append("limited_data_modes {\n");
                    switch (var7_7 /* !! */ .zzc()) {
                        default: {
                            var1_1 = "AD_PERSONALIZATION";
                            break;
                        }
                        case 1: {
                            var1_1 = "CONSENT_TYPE_UNSPECIFIED";
                            break;
                        }
                        case 4: {
                            var1_1 = "AD_USER_DATA";
                            break;
                        }
                        case 3: {
                            var1_1 = "ANALYTICS_STORAGE";
                            break;
                        }
                        case 2: {
                            var1_1 = "AD_STORAGE";
                        }
                    }
                    zzpj.zzS(var2_2, 3, "type", var1_1);
                    switch (var7_7 /* !! */ .zzd()) {
                        default: {
                            var1_1 = "NO_DATA_MODE";
                            break;
                        }
                        case 1: {
                            var1_1 = "NOT_LIMITED";
                            break;
                        }
                        case 2: {
                            var1_1 = "LIMITED_MODE";
                        }
                    }
                    zzpj.zzS(var2_2, 3, "mode", var1_1);
                    zzpj.zzM(var2_2, 3);
                    var2_2.append("}\n");
                }
                zzpj.zzM(var2_2, 2);
                var2_2.append("}\n");
            }
            if ((var1_1 = var4_4.zzf()) == null) ** GOTO lbl276
            var6_6 = var1_1.iterator();
            while (true) {
                block82: {
                    if (var6_6.hasNext()) break block82;
lbl276:
                    // 2 sources

                    if ((var1_1 = var4_4.zzS()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var6_6 = (zzhg)var1_1.next();
                            if (var6_6 == null) continue;
                            zzpj.zzM(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var6_6.zza()) {
                                var7_7 /* !! */  = Integer.valueOf(var6_6.zzb());
                                zzpj.zzS(var2_2, 2, "audience_id", var7_7 /* !! */ );
                            }
                            if (var6_6.zzf()) {
                                var7_7 /* !! */  = Boolean.valueOf(var6_6.zzg());
                                zzpj.zzS(var2_2, 2, "new_audience", var7_7 /* !! */ );
                            }
                            var7_7 /* !! */  = var6_6.zzc();
                            zzpj.zzR(var2_2, 2, "current_data", (zzii)var7_7 /* !! */ );
                            if (var6_6.zzd()) {
                                var6_6 = var6_6.zze();
                                zzpj.zzR(var2_2, 2, "previous_data", (zzii)var6_6);
                            }
                            zzpj.zzM(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_4.zzc()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_4 = (zzhs)var1_1.next();
                            if (var4_4 == null) continue;
                            zzpj.zzM(var2_2, 2);
                            var2_2.append("event {\n");
                            var6_6 = var5_5.zzl().zza(var4_4.zzd());
                            zzpj.zzS(var2_2, 2, "name", var6_6);
                            if (var4_4.zze()) {
                                var6_6 = var4_4.zzf();
                                zzpj.zzS(var2_2, 2, "timestamp_millis", var6_6);
                            }
                            if (var4_4.zzg()) {
                                var6_6 = var4_4.zzh();
                                zzpj.zzS(var2_2, 2, "previous_timestamp_millis", var6_6);
                            }
                            if (var4_4.zzi()) {
                                var6_6 = var4_4.zzj();
                                zzpj.zzS(var2_2, 2, "count", var6_6);
                            }
                            if (var4_4.zzb() != 0) {
                                this.zzK(var2_2, 2, var4_4.zza());
                            }
                            zzpj.zzM(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzpj.zzM(var2_2, 1);
                    var2_2.append("}\n");
                    continue block23;
                }
                var7_7 /* !! */  = (zziu)var6_6.next();
                if (var7_7 /* !! */  == null) continue;
                zzpj.zzM(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var7_7 /* !! */ .zza() != false ? Long.valueOf(var7_7 /* !! */ .zzb()) : null;
                zzpj.zzS(var2_2, 2, "set_timestamp_millis", var1_1);
                var1_1 = var5_5.zzl().zzc(var7_7 /* !! */ .zzc());
                zzpj.zzS(var2_2, 2, "name", var1_1);
                var1_1 = var7_7 /* !! */ .zze();
                zzpj.zzS(var2_2, 2, "string_value", var1_1);
                var1_1 = var7_7 /* !! */ .zzf() != false ? Long.valueOf(var7_7 /* !! */ .zzg()) : null;
                zzpj.zzS(var2_2, 2, "int_value", var1_1);
                var1_1 = var7_7 /* !! */ .zzj() != false ? Double.valueOf(var7_7 /* !! */ .zzk()) : null;
                zzpj.zzS(var2_2, 2, "double_value", var1_1);
                zzpj.zzM(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzj(zzff object) {
        Object object2;
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzff)((Object)object)).zza()) {
            object2 = ((zzff)((Object)object)).zzb();
            zzpj.zzS(stringBuilder, 0, "filter_id", object2);
        }
        object2 = this.zzu.zzl().zza(((zzff)((Object)object)).zzc());
        zzpj.zzS(stringBuilder, 0, "event_name", object2);
        object2 = zzpj.zzO(((zzff)((Object)object)).zzi(), ((zzff)((Object)object)).zzj(), ((zzff)((Object)object)).zzm());
        if (!((String)object2).isEmpty()) {
            zzpj.zzS(stringBuilder, 0, "filter_type", object2);
        }
        if (((zzff)((Object)object)).zzg()) {
            object2 = ((zzff)((Object)object)).zzh();
            zzpj.zzT(stringBuilder, 1, "event_count_filter", (zzfl)((Object)object2));
        }
        if (((zzff)((Object)object)).zze() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzff)((Object)object)).zzd().iterator();
            while (object.hasNext()) {
                this.zzL(stringBuilder, 2, (zzfh)((Object)object.next()));
            }
        }
        zzpj.zzM(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzk(zzfn zzfn2) {
        Object object;
        if (zzfn2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzfn2.zza()) {
            object = zzfn2.zzb();
            zzpj.zzS(stringBuilder, 0, "filter_id", object);
        }
        object = this.zzu.zzl().zzc(zzfn2.zzc());
        zzpj.zzS(stringBuilder, 0, "property_name", object);
        object = zzpj.zzO(zzfn2.zze(), zzfn2.zzf(), zzfn2.zzh());
        if (!((String)object).isEmpty()) {
            zzpj.zzS(stringBuilder, 0, "filter_type", object);
        }
        this.zzL(stringBuilder, 1, zzfn2.zzd());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzK(StringBuilder stringBuilder, int n, List iterator) {
        if (iterator != null) {
            int n2 = n + 1;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                zzhw zzhw2 = (zzhw)iterator.next();
                if (zzhw2 == null) continue;
                zzpj.zzM(stringBuilder, n2);
                stringBuilder.append("param {\n");
                Object object = zzhw2.zza() ? this.zzu.zzl().zzb(zzhw2.zzb()) : null;
                zzpj.zzS(stringBuilder, n2, "name", object);
                object = zzhw2.zzc() ? zzhw2.zzd() : null;
                zzpj.zzS(stringBuilder, n2, "string_value", object);
                object = zzhw2.zze() ? Long.valueOf(zzhw2.zzf()) : null;
                zzpj.zzS(stringBuilder, n2, "int_value", object);
                object = zzhw2.zzi() ? Double.valueOf(zzhw2.zzj()) : null;
                zzpj.zzS(stringBuilder, n2, "double_value", object);
                if (zzhw2.zzm() > 0) {
                    this.zzK(stringBuilder, n2, zzhw2.zzk());
                }
                zzpj.zzM(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzL(StringBuilder stringBuilder, int n, zzfh zzfh2) {
        Object object;
        if (zzfh2 == null) {
            return;
        }
        zzpj.zzM(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzfh2.zze()) {
            Boolean bl = zzfh2.zzf();
            zzpj.zzS(stringBuilder, n, "complement", bl);
        }
        if (zzfh2.zzg()) {
            object = ((zzjd)object).zzu.zzl().zzb(zzfh2.zzh());
            zzpj.zzS(stringBuilder, n, "param_name", object);
        }
        if (zzfh2.zza()) {
            int n2 = n + 1;
            zzfr zzfr2 = zzfh2.zzb();
            if (zzfr2 != null) {
                zzpj.zzM(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzfr2.zza()) {
                    switch (zzfr2.zzj()) {
                        default: {
                            object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            object = "EXACT";
                            break;
                        }
                        case 5: {
                            object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            object = "REGEXP";
                        }
                    }
                    zzpj.zzS(stringBuilder, n2, "match_type", object);
                }
                if (zzfr2.zzb()) {
                    object = zzfr2.zzc();
                    zzpj.zzS(stringBuilder, n2, "expression", object);
                }
                if (zzfr2.zzd()) {
                    object = zzfr2.zze();
                    zzpj.zzS(stringBuilder, n2, "case_sensitive", object);
                }
                if (zzfr2.zzg() > 0) {
                    zzpj.zzM(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    object = zzfr2.zzf().iterator();
                    while (object.hasNext()) {
                        StringBuilder stringBuilder2 = stringBuilder;
                        zzpj.zzM(stringBuilder2, n2 + 2);
                        stringBuilder2.append((String)object.next());
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzpj.zzM(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzfh2.zzc()) {
            object = zzfh2.zzd();
            zzpj.zzT(stringBuilder, n + 1, "number_filter", (zzfl)((Object)object));
        }
        zzpj.zzM(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Parcelable zzl(byte[] byArray, Parcelable.Creator creator) {
        Parcel parcel;
        block5: {
            zzpj zzpj2;
            if (byArray == null) {
                return null;
            }
            parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                zzpj2 = (Parcelable)creator.createFromParcel(parcel);
                break block5;
            }
            catch (SafeParcelReader.ParseException parseException) {
                try {
                    zzpj2 = zzpj2.zzu.zzaV();
                    zzpj2.zzb().zza("Failed to load parcelable from buffer");
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }
            zzpj2 = null;
        }
        parcel.recycle();
        return zzpj2;
    }

    static boolean zzm(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zzn(List list, int n) {
        return n < list.size() * 64 && ((Long)list.get(n / 64) & 1L << n % 64) != 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    static List zzp(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                int n5;
                if (n3 >= 64 || (n5 = n2 * 64 + n3) >= (n4 = bitSet.length())) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n5) ? l | 1L << n3 : l;
                l = l2;
                ++n3;
            }
            break;
        }
        return arrayList;
    }

    final List zzq(List object, List object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzu.zzaV().zze().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                Integer n2 = arrayList.size();
                this.zzu.zzaV().zze().zzc("Ignoring bit index greater than bitSet size", object2, (Object)n2);
                continue;
            }
            ArrayList<Long> arrayList2 = arrayList;
            int n3 = n;
            arrayList2.set(n3, (Long)arrayList2.get(n3) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n4 = arrayList.size() + -1;
        while (n4 >= 0 && (Long)arrayList.get(n4) == 0L) {
            n = n4;
            n4 += -1;
        }
        return arrayList.subList(0, n);
    }

    final boolean zzs(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzu.zzaZ().currentTimeMillis() - l) > l2;
    }

    @WorkerThread
    final long zzt(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        zzpj zzpj2 = zzpj2.zzu;
        zzpj2.zzk().zzg();
        MessageDigest messageDigest = zzpo.zzO();
        if (messageDigest == null) {
            zzpj2.zzaV().zzb().zza("Failed to get MD5");
            return 0L;
        }
        return zzpo.zzP((byte[])messageDigest.digest(byArray));
    }

    final long zzu(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zzt(string.getBytes(Charset.forName("UTF-8")));
    }

    final byte[] zzv(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            Object object = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            object.zzu.zzaV().zzb().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return object;
    }

    static zznk zzw(zznk zznk2, byte[] byArray) throws zzmq {
        zzlq zzlq2 = zzlq.zza();
        if (zzlq2 != null) {
            return zznk2.zzaV(byArray, zzlq2);
        }
        return zznk2.zzaW(byArray);
    }

    static int zzx(zzic zzic2, String string) {
        for (int i = 0; i < zzic2.zzl(); ++i) {
            if (!string.equals(zzic2.zzm(i).zzc())) continue;
            return i;
        }
        return -1;
    }

    static Bundle[] zzy(List object) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        object = object.iterator();
        while (object.hasNext()) {
            zzhw zzhw2 = (zzhw)object.next();
            if (zzhw2 == null) continue;
            Bundle bundle = new Bundle();
            for (zzhw zzhw3 : zzhw2.zzk()) {
                if (zzhw3.zzc()) {
                    bundle.putString(zzhw3.zzb(), zzhw3.zzd());
                    continue;
                }
                if (zzhw3.zze()) {
                    bundle.putLong(zzhw3.zzb(), zzhw3.zzf());
                    continue;
                }
                if (!zzhw3.zzi()) continue;
                bundle.putDouble(zzhw3.zzb(), zzhw3.zzj());
            }
            if (bundle.isEmpty()) continue;
            arrayList.add(bundle);
        }
        ArrayList<Bundle> arrayList2 = arrayList;
        return arrayList2.toArray(new Bundle[arrayList2.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map zzz(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            boolean bl2 = object instanceof Parcelable[];
            if (bl2 || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (bl2) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzz((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzz((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzz((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    final zzbg zzA(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzB(zzaa2.zzf(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzjl.zzb((String)zzaa2.zzb())) == null) {
            object = zzaa2.zzb();
        }
        return new zzbg((String)object, new zzbe(bundle), (String)object2, zzaa2.zza());
    }

    final Bundle zzB(Map map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v == null) {
                bundle.putString(string, null);
                continue;
            }
            if (v instanceof Long) {
                bundle.putLong(string, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Double) {
                bundle.putDouble(string, ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)v;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(this.zzB((Map)arrayList.get(i), false));
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, v.toString());
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzC(zzhr zzhr2, String string, Object object) {
        int n;
        List list;
        block3: {
            list = zzhr2.zza();
            for (n = 0; n < list.size(); ++n) {
                if (!string.equals(((zzhw)list.get(n)).zzb())) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        list = zzhw.zzn();
        list.zzb(string);
        list.zzf((Long)object);
        if (n >= 0) {
            zzhr2.zze(n, (zzhv)list);
            return;
        }
        zzhr2.zzg((zzhv)list);
    }

    private static final void zzM(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static final void zzN(Uri.Builder builder, String string, String string2, Set set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    @WorkerThread
    static final boolean zzD(zzbg zzbg2, zzr zzr2) {
        Preconditions.checkNotNull((Object)zzbg2);
        Preconditions.checkNotNull((Object)zzr2);
        return !TextUtils.isEmpty((CharSequence)zzr2.zzb);
    }

    static final Bundle zzE(List object) {
        Bundle bundle = new Bundle();
        object = object.iterator();
        while (object.hasNext()) {
            zzhw zzhw2 = (zzhw)object.next();
            String string = zzhw2.zzb();
            if (zzhw2.zzi()) {
                bundle.putDouble(string, zzhw2.zzj());
                continue;
            }
            if (zzhw2.zzg()) {
                bundle.putFloat(string, zzhw2.zzh());
                continue;
            }
            if (zzhw2.zzc()) {
                bundle.putString(string, zzhw2.zzd());
                continue;
            }
            if (!zzhw2.zze()) continue;
            bundle.putLong(string, zzhw2.zzf());
        }
        return bundle;
    }

    static final zzhw zzF(zzhs object, String string) {
        for (zzhw zzhw2 : object.zza()) {
            if (!zzhw2.zzb().equals(string)) continue;
            return zzhw2;
        }
        return null;
    }

    private static final String zzO(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    private static final Object zzP(zzhw zzhw2) {
        if (zzhw2.zzc()) {
            return zzhw2.zzd();
        }
        if (zzhw2.zze()) {
            return zzhw2.zzf();
        }
        if (zzhw2.zzi()) {
            return zzhw2.zzj();
        }
        if (zzhw2.zzm() > 0) {
            return zzpj.zzy(zzhw2.zzk());
        }
        return null;
    }

    private static final void zzQ(Uri.Builder builder, String[] stringArray, Bundle bundle, Set set) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = stringArray[i].split(",");
            String string = object[0];
            object = object[((String[])object).length + -1];
            String string2 = bundle.getString(string);
            if (string2 == null) continue;
            zzpj.zzN(builder, (String)object, string2, set);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzR(StringBuilder stringBuilder, int n, String iterator, zzii object) {
        void var5_27;
        Long l;
        Iterator iterator2;
        Object object2;
        if (object2 == null) {
            return;
        }
        zzpj.zzM(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (object2.zzd() != 0) {
            zzpj.zzM(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = object2.zzc().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                l = (Long)iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (object2.zzb() != 0) {
            zzpj.zzM(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = object2.zza().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                l = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (object2.zzf() != 0) {
            zzpj.zzM(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = object2.zze().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                l = (zzhq)iterator2.next();
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (l.zza()) {
                    Integer n2 = l.zzb();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (l.zzc()) {
                    Long l2 = l.zzd();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (object2.zzh() != 0) {
            zzpj.zzM(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = object2.zzg().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object2 = (zzik)iterator2.next();
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (object2.zza()) {
                    Integer n3 = object2.zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object2 = object2.zzc().iterator();
                boolean bl2 = false;
                while (object2.hasNext()) {
                    void var1_20;
                    long l3 = (Long)object2.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l3);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzpj.zzM(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzS(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzpj.zzM(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Map zzG(zzhs object, String ... stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (zzhw zzhw2 : object.zza()) {
            Object object2;
            if (!Arrays.asList(stringArray).contains(zzhw2.zzb()) || (object2 = zzpj.zzP(zzhw2)) == null) continue;
            hashMap.put(zzhw2.zzb(), object2);
        }
        return hashMap;
    }

    static final Map zzH(zzhs object, String hashMap) {
        hashMap = new HashMap<String, Object>();
        for (zzhw zzhw2 : object.zza()) {
            Object object2;
            if (!zzhw2.zzb().startsWith("gad_") || (object2 = zzpj.zzP(zzhw2)) == null) continue;
            hashMap.put(zzhw2.zzb(), object2);
        }
        return hashMap;
    }

    static final Object zzI(zzhs zzhs2, String string) {
        if ((zzhs2 = zzpj.zzF(zzhs2, string)) == null) {
            return null;
        }
        return zzpj.zzP((zzhw)zzhs2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzT(StringBuilder stringBuilder, int n, String object, zzfl zzfl2) {
        if (zzfl2 == null) {
            return;
        }
        zzpj.zzM(stringBuilder, n);
        stringBuilder.append((String)object);
        stringBuilder.append(" {\n");
        if (zzfl2.zza()) {
            switch (zzfl2.zzm()) {
                default: {
                    object = "BETWEEN";
                    break;
                }
                case 1: {
                    object = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    object = "EQUAL";
                    break;
                }
                case 3: {
                    object = "GREATER_THAN";
                    break;
                }
                case 2: {
                    object = "LESS_THAN";
                }
            }
            zzpj.zzS(stringBuilder, n, "comparison_type", object);
        }
        if (zzfl2.zzb()) {
            object = zzfl2.zzc();
            zzpj.zzS(stringBuilder, n, "match_as_float", object);
        }
        if (zzfl2.zzd()) {
            object = zzfl2.zze();
            zzpj.zzS(stringBuilder, n, "comparison_value", object);
        }
        if (zzfl2.zzf()) {
            object = zzfl2.zzg();
            zzpj.zzS(stringBuilder, n, "min_comparison_value", object);
        }
        if (zzfl2.zzh()) {
            object = zzfl2.zzi();
            zzpj.zzS(stringBuilder, n, "max_comparison_value", object);
        }
        zzpj.zzM(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    static final Object zzJ(zzhs object, String string, Object object2) {
        if ((object = zzpj.zzI(object, string)) == null) {
            return object2;
        }
        return object;
    }
}

