/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;

public class zzw
extends zzm.zza {
    private final zzv zzaKG;
    private final boolean zzaOf;

    public zzw(zzv zzv2) {
        zzx.zzw((Object)zzv2);
        this.zzaKG = zzv2;
        this.zzaOf = false;
    }

    public zzw(zzv zzv2, boolean bl) {
        zzx.zzw((Object)zzv2);
        this.zzaKG = zzv2;
        this.zzaOf = bl;
    }

    @Override
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzx.zzw((Object)eventParcel);
        zzx.zzw((Object)appMetadata);
        this.zzed(appMetadata.packageName);
        this.zzaKG.zzzr().zzh(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzaKG.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzx.zzw((Object)userAttributeParcel);
        zzx.zzw((Object)appMetadata);
        this.zzed(appMetadata.packageName);
        if (userAttributeParcel.getValue() == null) {
            this.zzaKG.zzzr().zzh(new Runnable(){

                @Override
                public void run() {
                    zzw.this.zzaKG.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.zzaKG.zzzr().zzh(new Runnable(){

                @Override
                public void run() {
                    zzw.this.zzaKG.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    public void zza(final AppMetadata appMetadata) {
        zzx.zzw((Object)appMetadata);
        this.zzed(appMetadata.packageName);
        this.zzaKG.zzzr().zzh(new Runnable(){

            @Override
            public void run() {
                zzw.this.zzaKG.zzb(appMetadata);
            }
        });
    }

    private void zzed(String string) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzaKG.zzyd().zzzK().zzec("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzee(string);
        }
        catch (SecurityException securityException) {
            this.zzaKG.zzyd().zzzK().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    private void zzee(String string) throws SecurityException {
        int n = this.zzaOf ? Process.myUid() : Binder.getCallingUid();
        if (GooglePlayServicesUtil.zzb((Context)this.zzaKG.getContext(), (int)n, (String)string)) {
            return;
        }
        if (GooglePlayServicesUtil.zze((Context)this.zzaKG.getContext(), (int)n) && !this.zzaKG.zzAi()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

