/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class zzae
extends zzv {
    zzae(zzt zzt2) {
        super(zzt2);
    }

    void zzc(String string2, int n, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException(string2 + " name is required and can't be null");
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException(string2 + " name is required and can't be empty");
        }
        char c = string3.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw new IllegalArgumentException(string2 + " name must start with a letter or _");
        }
        for (int i = 1; i < string3.length(); ++i) {
            char c2 = string3.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException(string2 + " name must consist of letters, digits or _ (underscores)");
        }
        if (string3.length() > n) {
            throw new IllegalArgumentException(string2 + " name is too long. The maximum supported length is " + n);
        }
    }

    public void zzeE(String string2) {
        this.zzc("event", this.zzAX().zzAt(), string2);
    }

    public void zzeF(String string2) {
        this.zzc("user attribute", this.zzAX().zzAu(), string2);
    }

    public void zzeG(String string2) {
        this.zzc("event param", this.zzAX().zzAu(), string2);
    }

    private void zza(String string2, String string3, int n, Object object) {
        if (object == null) {
            this.zzzz().zzBo().zzj(string2 + " value can't be null. Ignoring " + string2, string3);
            return;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string4 = String.valueOf(object);
            if (string4.length() > n) {
                this.zzzz().zzBo().zze("Ignoring " + string2 + ". Value is too long. name, value length", string3, string4.length());
            }
            return;
        }
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Float) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Double) {
            return Float.valueOf((float)((Double)object).doubleValue());
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string2 = String.valueOf(object);
            if (string2.length() > n) {
                if (bl) {
                    return string2.substring(0, n);
                }
                return null;
            }
            return string2;
        }
        return null;
    }

    public Object zzk(String string2, Object object) {
        return this.zza(!TextUtils.isEmpty((CharSequence)string2) && string2.startsWith("_") ? this.zzAX().zzAw() : this.zzAX().zzAv(), object, false);
    }

    private int zzeH(String string2) {
        if ("_ldl".equals(string2)) {
            return this.zzAX().zzAy();
        }
        return this.zzAX().zzAx();
    }

    public void zzl(String string2, Object object) {
        if ("_ldl".equals(string2)) {
            this.zza("user attribute referrer", string2, this.zzeH(string2), object);
        } else {
            this.zza("user attribute", string2, this.zzeH(string2), object);
        }
    }

    public Object zzm(String string2, Object object) {
        if ("_ldl".equals(string2)) {
            return this.zza(this.zzeH(string2), object, true);
        }
        return this.zza(this.zzeH(string2), object, false);
    }

    public void zza(zzqq.zze zze2, Object object) {
        zzx.zzy((Object)object);
        zze2.zzakS = null;
        zze2.zzaVo = null;
        zze2.zzaVi = null;
        if (object instanceof String) {
            zze2.zzakS = (String)object;
        } else if (object instanceof Long) {
            zze2.zzaVo = (Long)object;
        } else if (object instanceof Float) {
            zze2.zzaVi = (Float)object;
        } else {
            this.zzzz().zzBl().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzqq.zzb zzb2, Object object) {
        zzx.zzy((Object)object);
        zzb2.zzakS = null;
        zzb2.zzaVo = null;
        zzb2.zzaVi = null;
        if (object instanceof String) {
            zzb2.zzakS = (String)object;
        } else if (object instanceof Long) {
            zzb2.zzaVo = (Long)object;
        } else if (object instanceof Float) {
            zzb2.zzaVi = (Float)object;
        } else {
            this.zzzz().zzBl().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string2, Object object) {
        if (object instanceof Long) {
            bundle.putLong(string2, ((Long)object).longValue());
            return;
        }
        if (object instanceof Float) {
            bundle.putFloat(string2, ((Float)object).floatValue());
            return;
        }
        if (object instanceof String) {
            String string3 = String.valueOf(object);
            bundle.putString(string2, string3);
            return;
        }
        if (string2 != null) {
            this.zzzz().zzBo().zze("Not putting event parameter. Invalid value type. name, type", string2, object.getClass().getSimpleName());
        }
    }

    public byte[] zzg(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzzz().zzBl().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzq(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzzz().zzBl().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zza(zzqq.zzc zzc2) {
        try {
            int n = zzc2.getSerializedSize();
            byte[] byArray = new byte[n];
            zztd zztd2 = zztd.zzD((byte[])byArray);
            zzc2.writeTo(zztd2);
            zztd2.zzHy();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzzz().zzBl().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzc(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zziT().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, Class<? extends BroadcastReceiver> clazz, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, clazz), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zza(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean zzbh(String string2) {
        this.zziS();
        int n = this.getContext().checkCallingOrSelfPermission(string2);
        return n == 0;
    }
}

