/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.zza;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzm
extends zzw {
    private static final X500Principal zzaTf = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzaRd;
    private String zzRl;
    private String zzaSj;
    private String zzRk;
    private long zzaTg;
    private String zzaSf;

    zzm(zzt zzt2) {
        super(zzt2);
    }

    @Override
    protected void zzir() {
        String string2;
        String string3 = "Unknown";
        String string4 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string5 = packageManager.getInstallerPackageName(string2 = this.getContext().getPackageName());
        if (string5 == null) {
            string5 = "manual_install";
        } else if ("com.android.vending".equals(string5)) {
            string5 = "";
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (packageInfo != null) {
                CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string4 = charSequence.toString();
                }
                string3 = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzzz().zzBl().zzj("Error retrieving package info: appName", string4);
        }
        this.zzaRd = string2;
        this.zzaSj = string5;
        this.zzRl = string3;
        this.zzRk = string4;
        long l = 0L;
        try {
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("MD5");
            if (!this.zzBk()) {
                PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                if (messageDigest != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                    byte[] byArray = messageDigest.digest(packageInfo.signatures[0].toByteArray());
                    l = zzm.zzp(byArray);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.zzzz().zzBl().zzj("Could not get MD5 instance", noSuchAlgorithmException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzzz().zzBl().zzj("Package name not found", (Object)nameNotFoundException);
        }
        this.zzaTg = l;
    }

    AppMetadata zzex(String string2) {
        return new AppMetadata(this.zzaRd, this.zzBi(), this.zzRl, this.zzaSj, this.zzAX().zzAE(), this.zzBj(), string2, this.zzAW().zzzC());
    }

    String zzBi() {
        block8: {
            this.zzje();
            if (this.zzAX().zzka()) {
                return "";
            }
            if (this.zzaSf == null) {
                Status status = zza.zzaS(this.getContext());
                if (status != null && status.isSuccess()) {
                    try {
                        if (zza.zzzC()) {
                            String string2 = zza.zzzA();
                            this.zzaSf = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
                            break block8;
                        }
                        this.zzaSf = "";
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.zzaSf = "";
                        this.zzzz().zzBl().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
                    }
                } else {
                    this.zzaSf = "";
                    this.zzzz().zzBl().zzj("getGoogleAppId failed with status", status == null ? 0 : status.getStatusCode());
                    if (status != null && status.getStatusMessage() != null) {
                        this.zzzz().zzBq().zzez(status.getStatusMessage());
                    }
                }
            }
        }
        return this.zzaSf;
    }

    long zzBj() {
        this.zzje();
        return this.zzaTg;
    }

    static long zzp(byte[] byArray) {
        zzx.zzy((Object)byArray);
        zzx.zzaa((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    boolean zzBk() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(zzaTf);
            }
        }
        catch (CertificateException certificateException) {
            this.zzzz().zzBl().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzzz().zzBl().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

