/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.UUID;

class zzr
extends zzw {
    static final Pair<String, Long> zzaTD = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzRN;
    public final zzb zzaTE = new zzb("health_monitor", this.zzAX().zzkG());
    public final zza zzaTF = new zza("last_upload", 0L);
    public final zza zzaTG = new zza("last_upload_attempt", 0L);
    public final zza zzaTH = new zza("backoff", 0L);
    public final zza zzaTI = new zza("last_delete_stale", 0L);
    private String zzaTJ;
    private boolean zzaTK;
    private long zzaTL;
    private final SecureRandom zzaTM = new SecureRandom();

    Pair<String, Boolean> zzBt() {
        this.zziS();
        long l = this.zziT().elapsedRealtime();
        if (this.zzaTJ != null && l < this.zzaTL) {
            return new Pair((Object)this.zzaTJ, (Object)this.zzaTK);
        }
        this.zzaTL = l + this.zzAX().zzAD();
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzaTJ = info.getId();
            this.zzaTK = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzzz().zzBq().zzj("Unable to get advertising id", throwable);
            this.zzaTJ = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaTJ, (Object)this.zzaTK);
    }

    String zzBu() {
        String string2 = (String)this.zzBt().first;
        MessageDigest messageDigest = zzr.zzbs("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    static MessageDigest zzbs(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    String zzBv() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    zzr(zzt zzt2) {
        super(zzt2);
    }

    @Override
    protected void zzir() {
        this.zzRN = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
    }

    private SharedPreferences zzBw() {
        this.zziS();
        this.zzje();
        return this.zzRN;
    }

    Boolean zzBx() {
        this.zziS();
        if (!this.zzBw().contains("use_service")) {
            return null;
        }
        return this.zzBw().getBoolean("use_service", false);
    }

    void zzap(boolean bl) {
        this.zziS();
        this.zzzz().zzBr().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzBw().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    boolean zzzC() {
        this.zziS();
        return this.zzBw().getBoolean("measurement_enabled", true);
    }

    void setMeasurementEnabled(boolean enabled) {
        this.zziS();
        this.zzzz().zzBr().zzj("Setting measurementEnabled", enabled);
        SharedPreferences.Editor editor = this.zzBw().edit();
        editor.putBoolean("measurement_enabled", enabled);
        editor.apply();
    }

    public final class zza {
        private final String zzuX;
        private final long zzaTN;
        private boolean zzaTO;
        private long zzaBq;

        public zza(String string2, long l) {
            zzx.zzcG((String)string2);
            this.zzuX = string2;
            this.zzaTN = l;
        }

        private void zzBy() {
            if (this.zzaTO) {
                return;
            }
            this.zzaTO = true;
            this.zzaBq = zzr.this.zzRN.getLong(this.zzuX, this.zzaTN);
        }

        public long get() {
            this.zzBy();
            return this.zzaBq;
        }

        public void set(long value) {
            SharedPreferences.Editor editor = zzr.this.zzRN.edit();
            editor.putLong(this.zzuX, value);
            editor.apply();
            this.zzaBq = value;
        }
    }

    public final class zzb {
        final String zzaTQ;
        private final String zzaTR;
        private final String zzaTS;
        private final long zzRR;

        private zzb(String string2, long l) {
            zzx.zzcG((String)string2);
            zzx.zzab((l > 0L ? 1 : 0) != 0);
            this.zzaTQ = string2 + ":start";
            this.zzaTR = string2 + ":count";
            this.zzaTS = string2 + ":value";
            this.zzRR = l;
        }

        private void zzlu() {
            zzr.this.zziS();
            long l = zzr.this.zziT().currentTimeMillis();
            SharedPreferences.Editor editor = zzr.this.zzRN.edit();
            editor.remove(this.zzaTR);
            editor.remove(this.zzaTS);
            editor.putLong(this.zzaTQ, l);
            editor.apply();
        }

        private long zzlv() {
            zzr.this.zziS();
            long l = this.zzlx();
            if (l == 0L) {
                this.zzlu();
                return 0L;
            }
            return Math.abs(l - zzr.this.zziT().currentTimeMillis());
        }

        public void zzbn(String string2) {
            this.zzg(string2, 1L);
        }

        public void zzg(String string2, long l) {
            long l2;
            zzr.this.zziS();
            long l3 = this.zzlx();
            if (l3 == 0L) {
                this.zzlu();
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((l2 = zzr.this.zzRN.getLong(this.zzaTR, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzr.this.zzRN.edit();
                editor.putString(this.zzaTS, string2);
                editor.putLong(this.zzaTR, l);
                editor.apply();
                return;
            }
            long l4 = zzr.this.zzaTM.nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzr.this.zzRN.edit();
            if (bl) {
                editor.putString(this.zzaTS, string2);
            }
            editor.putLong(this.zzaTR, l2 + l);
            editor.apply();
        }

        public Pair<String, Long> zzlw() {
            zzr.this.zziS();
            long l = this.zzlv();
            if (l < this.zzRR) {
                return null;
            }
            if (l > this.zzRR * 2L) {
                this.zzlu();
                return null;
            }
            String string2 = zzr.this.zzBw().getString(this.zzaTS, null);
            long l2 = zzr.this.zzBw().getLong(this.zzaTR, 0L);
            this.zzlu();
            if (string2 == null || l2 <= 0L) {
                return zzaTD;
            }
            return new Pair((Object)string2, (Object)l2);
        }

        private long zzlx() {
            return zzr.this.zzBw().getLong(this.zzaTQ, 0L);
        }
    }
}

