/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzw;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

public class zzs
extends zzw {
    private zzc zzaTT;
    private zzc zzaTU;
    private final BlockingQueue<FutureTask<?>> zzaTV;
    private final BlockingQueue<FutureTask<?>> zzaTW;
    private final Thread.UncaughtExceptionHandler zzaTX;
    private final Thread.UncaughtExceptionHandler zzaTY;
    private final Object zzaTZ = new Object();
    private final Semaphore zzaUa = new Semaphore(2);
    private volatile boolean zzaUb;

    zzs(zzt zzt2) {
        super(zzt2);
        this.zzaTV = new LinkedBlockingQueue();
        this.zzaTW = new LinkedBlockingQueue();
        this.zzaTX = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzaTY = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzir() {
    }

    @Override
    public void zziS() {
        if (Thread.currentThread() != this.zzaTT) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzAR() {
        if (Thread.currentThread() != this.zzaTU) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public void zzg(Runnable runnable) throws IllegalStateException {
        this.zzje();
        zzx.zzy((Object)runnable);
        this.zza(new zza(runnable, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzaTZ;
        synchronized (object) {
            this.zzaTV.add(futureTask);
            if (this.zzaTT == null) {
                this.zzaTT = new zzc("Measurement Worker", this.zzaTV);
                this.zzaTT.setUncaughtExceptionHandler(this.zzaTX);
                this.zzaTT.start();
            } else {
                this.zzaTT.zzeQ();
            }
        }
    }

    public void zzh(Runnable runnable) throws IllegalStateException {
        this.zzje();
        zzx.zzy((Object)runnable);
        this.zzb(new zza(runnable, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(FutureTask<?> futureTask) {
        Object object = this.zzaTZ;
        synchronized (object) {
            this.zzaTW.add(futureTask);
            if (this.zzaTU == null) {
                this.zzaTU = new zzc("Measurement Network", this.zzaTW);
                this.zzaTU.setUncaughtExceptionHandler(this.zzaTY);
                this.zzaTU.start();
            } else {
                this.zzaTU.zzeQ();
            }
        }
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzaUc;

        public zzb(String string2) {
            zzx.zzy((Object)string2);
            this.zzaUc = string2;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable error) {
            zzs.this.zzzz().zzBl().zzj(this.zzaUc, error);
        }
    }

    private final class zza<V>
    extends FutureTask<V> {
        private final String zzaUc;

        zza(Runnable runnable, String string2) {
            super(runnable, null);
            zzx.zzy((Object)string2);
            this.zzaUc = string2;
        }

        @Override
        protected void setException(Throwable error) {
            zzs.this.zzzz().zzBl().zzj(this.zzaUc, error);
            super.setException(error);
        }
    }

    private final class zzc
    extends Thread {
        private final Object zzaUe;
        private final BlockingQueue<FutureTask<?>> zzaUf;

        public zzc(String string2, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzx.zzy((Object)string2);
            this.zzaUe = new Object();
            this.zzaUf = blockingQueue;
            this.setName(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                FutureTask futureTask;
                if ((futureTask = (FutureTask)this.zzaUf.poll()) != null) {
                    futureTask.run();
                    continue;
                }
                Object object = this.zzaUe;
                synchronized (object) {
                    if (this.zzaUf.peek() == null && !zzs.this.zzaUb) {
                        try {
                            this.zzaUe.wait(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.zza(interruptedException);
                        }
                    }
                }
                object = zzs.this.zzaTZ;
                synchronized (object) {
                    if (this.zzaUf.peek() == null) {
                        zzs.this.zzaUa.release();
                        zzs.this.zzaTZ.notifyAll();
                        if (this == zzs.this.zzaTT) {
                            zzs.this.zzaTT = null;
                        } else if (this == zzs.this.zzaTU) {
                            zzs.this.zzaTU = null;
                        } else {
                            zzs.this.zzzz().zzBl().zzez("Current scheduler thread is neither worker nor network");
                        }
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzeQ() {
            Object object = this.zzaUe;
            synchronized (object) {
                this.zzaUe.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzs.this.zzzz().zzBm().zzj(this.getName() + " was interrupted", interruptedException);
        }
    }
}

