/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.AppMeasurementReceiver;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import com.google.android.gms.measurement.internal.zzz;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class zzt {
    private static zzx zzaUg;
    private static volatile zzt zzaUh;
    private final Context mContext;
    private final zzc zzaUi;
    private final zzr zzaUj;
    private final zzo zzaUk;
    private final zzs zzaUl;
    private final AppMeasurement zzaUm;
    private final zzae zzaUn;
    private final zzd zzaUo;
    private final zzp zzaUp;
    private final zznl zzqD;
    private final zzz zzaUq;
    private final zzf zzaUr;
    private final zzy zzaUs;
    private final zzm zzaUt;
    private final zzq zzaUu;
    private final zzab zzaUv;
    private final boolean zzOQ;
    private Boolean zzaUw;
    private List<Long> zzaUx;
    private int zzaUy;
    private int zzaUz;

    zzt(zzx zzx2) {
        com.google.android.gms.common.internal.zzx.zzy((Object)zzx2);
        this.mContext = zzx2.mContext;
        this.zzqD = zzx2.zzj(this);
        this.zzaUi = zzx2.zza(this);
        zzr zzr2 = zzx2.zzb(this);
        zzr2.zza();
        this.zzaUj = zzr2;
        zzo zzo2 = zzx2.zzc(this);
        zzo2.zza();
        this.zzaUk = zzo2;
        this.zzaUn = zzx2.zzg(this);
        zzf zzf2 = zzx2.zzl(this);
        zzf2.zza();
        this.zzaUr = zzf2;
        zzm zzm2 = zzx2.zzm(this);
        zzm2.zza();
        this.zzaUt = zzm2;
        zzd zzd2 = zzx2.zzh(this);
        zzd2.zza();
        this.zzaUo = zzd2;
        zzp zzp2 = zzx2.zzi(this);
        zzp2.zza();
        this.zzaUp = zzp2;
        zzz zzz2 = zzx2.zzk(this);
        zzz2.zza();
        this.zzaUq = zzz2;
        zzy zzy2 = zzx2.zzf(this);
        zzy2.zza();
        this.zzaUs = zzy2;
        zzab zzab2 = zzx2.zzo(this);
        zzab2.zza();
        this.zzaUv = zzab2;
        this.zzaUu = zzx2.zzn(this);
        this.zzaUm = zzx2.zze(this);
        zzs zzs2 = zzx2.zzd(this);
        zzs2.zza();
        this.zzaUl = zzs2;
        if (this.zzaUy != this.zzaUz) {
            this.zzzz().zzBl().zze("Not all components initialized", this.zzaUy, this.zzaUz);
        }
        this.zzOQ = true;
        if (!this.zzaUi.zzka() && !this.zzBI()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzBB().zzBR();
                } else {
                    this.zzzz().zzBq().zzez("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzzz().zzBm().zzez("Application context is not an Application");
            }
        }
        this.zzaUl.zzg(new Runnable(){

            @Override
            public void run() {
                zzt.this.start();
            }
        });
    }

    void zzje() {
        if (!this.zzOQ) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    protected boolean zzBz() {
        this.zzje();
        this.zziS();
        if (this.zzaUw == null) {
            this.zzaUw = this.zzAU().zzbh("android.permission.INTERNET") && this.zzAU().zzbh("android.permission.ACCESS_NETWORK_STATE") && AppMeasurementReceiver.zzX(this.getContext()) && AppMeasurementService.zzY(this.getContext());
            if (this.zzaUw.booleanValue() && !this.zzAX().zzka()) {
                this.zzaUw = !TextUtils.isEmpty((CharSequence)this.zzAS().zzBi());
            }
        }
        return this.zzaUw;
    }

    protected void start() {
        this.zziS();
        this.zzzz().zzBp().zzez("App measurement is starting up");
        this.zzzz().zzBq().zzez("Debug logging enabled");
        if (this.zzBI() && (!this.zzaUl.isInitialized() || this.zzaUl.zzBP())) {
            this.zzzz().zzBl().zzez("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzBD().zzAZ();
        if (!this.zzBz()) {
            if (!this.zzAU().zzbh("android.permission.INTERNET")) {
                this.zzzz().zzBl().zzez("App is missing INTERNET permission");
            }
            if (!this.zzAU().zzbh("android.permission.ACCESS_NETWORK_STATE")) {
                this.zzzz().zzBl().zzez("App is missing ACCESS_NETWORK_STATE permission");
            }
            if (!AppMeasurementReceiver.zzX(this.getContext())) {
                this.zzzz().zzBl().zzez("AppMeasurementReceiver not registered/enabled");
            }
            if (!AppMeasurementService.zzY(this.getContext())) {
                this.zzzz().zzBl().zzez("AppMeasurementService not registered/enabled");
            }
            this.zzzz().zzBl().zzez("Uploading is not possible. App measurement disabled");
        } else if (!(this.zzAX().zzka() || this.zzBI() || TextUtils.isEmpty((CharSequence)this.zzAS().zzBi()))) {
            this.zzBB().zzBS();
        }
        this.zzBM();
    }

    public zzc zzAX() {
        return this.zzaUi;
    }

    public zzr zzAW() {
        this.zza((zzv)this.zzaUj);
        return this.zzaUj;
    }

    public zzo zzzz() {
        this.zza(this.zzaUk);
        return this.zzaUk;
    }

    public zzs zzAV() {
        this.zza(this.zzaUl);
        return this.zzaUl;
    }

    zzs zzBA() {
        return this.zzaUl;
    }

    public zzy zzBB() {
        this.zza(this.zzaUs);
        return this.zzaUs;
    }

    public AppMeasurement zzBC() {
        return this.zzaUm;
    }

    public zzae zzAU() {
        this.zza(this.zzaUn);
        return this.zzaUn;
    }

    public zzd zzBD() {
        this.zza(this.zzaUo);
        return this.zzaUo;
    }

    public zzp zzBE() {
        this.zza(this.zzaUp);
        return this.zzaUp;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zznl zziT() {
        return this.zzqD;
    }

    public zzz zzAT() {
        this.zza(this.zzaUq);
        return this.zzaUq;
    }

    public zzf zzBF() {
        this.zza(this.zzaUr);
        return this.zzaUr;
    }

    public zzm zzAS() {
        this.zza(this.zzaUt);
        return this.zzaUt;
    }

    public zzq zzBG() {
        if (this.zzaUu == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzaUu;
    }

    public zzab zzBH() {
        this.zza(this.zzaUv);
        return this.zzaUv;
    }

    public void zziS() {
        this.zzAV().zziS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzt zzaU(Context context) {
        com.google.android.gms.common.internal.zzx.zzy((Object)context);
        com.google.android.gms.common.internal.zzx.zzy((Object)context.getApplicationContext());
        if (zzaUh != null) return zzaUh;
        Class<zzt> clazz = zzt.class;
        synchronized (zzt.class) {
            if (zzaUh != null) return zzaUh;
            zzx zzx2 = zzaUg != null ? zzaUg : new zzx(context);
            zzaUh = zzx2.zzBQ();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaUh;
        }
    }

    private void zza(zzw zzw2) {
        if (zzw2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzw2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzv zzv2) {
        if (zzv2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    protected boolean zzBI() {
        return false;
    }

    void zzc(AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        com.google.android.gms.common.internal.zzx.zzcG((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    void zza(EventParcel eventParcel, String string2) {
        zza zza2 = this.zzBD().zzew(string2);
        if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzRl)) {
            this.zzzz().zzBq().zzj("No app data available; dropping event", string2);
            return;
        }
        AppMetadata appMetadata = new AppMetadata(string2, zza2.zzaSf, zza2.zzRl, zza2.zzaSj, zza2.zzaSk, zza2.zzaSl, null, zza2.zzaSm);
        this.zzb(eventParcel, appMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        com.google.android.gms.common.internal.zzx.zzcG((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaSn)) {
            return;
        }
        this.zzzz().zzBr().zzj("Logging event", eventParcel);
        zzg zzg2 = new zzg(this, eventParcel.zzaSM, appMetadata.packageName, eventParcel.name, eventParcel.zzaSN, 0L, eventParcel.zzaSL.zzBh());
        this.zzBD().beginTransaction();
        try {
            zzh zzh2;
            this.zze(appMetadata);
            zzh zzh3 = this.zzBD().zzL(appMetadata.packageName, zzg2.mName);
            if (zzh3 == null) {
                zzh2 = new zzh(appMetadata.packageName, zzg2.mName, 1L, 1L, zzg2.zzacS);
            } else {
                zzg2 = zzg2.zza(this, zzh3.zzaSH);
                zzh2 = zzh3.zzQ(zzg2.zzacS);
            }
            this.zzBD().zza(zzh2);
            zzqq.zzd zzd2 = this.zza(new zzg[]{zzg2}, appMetadata);
            this.zzBD().zza(zzd2);
            this.zzBD().setTransactionSuccessful();
            this.zzzz().zzBq().zzj("Event logged", zzg2);
        }
        finally {
            this.zzBD().endTransaction();
        }
        this.zzBM();
    }

    void zziR() {
        if (this.zzAX().zzka()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    zzqq.zzd zza(zzg[] zzgArray, AppMetadata appMetadata) {
        zztk zztk2;
        int n;
        com.google.android.gms.common.internal.zzx.zzy((Object)appMetadata);
        com.google.android.gms.common.internal.zzx.zzy((Object)zzgArray);
        this.zziS();
        zzqq.zzd zzd2 = new zzqq.zzd();
        zzd2.zzaVr = 1;
        zzd2.zzaVz = "android";
        zzd2.appId = appMetadata.packageName;
        zzd2.zzaSo = appMetadata.zzaSo;
        zzd2.zzaKi = appMetadata.zzaKi;
        zzd2.zzaVD = appMetadata.zzaSp;
        zzd2.zzaSn = appMetadata.zzaSn;
        zzd2.zzaVI = appMetadata.zzaSq == 0L ? null : Long.valueOf(appMetadata.zzaSq);
        Pair<String, Boolean> pair = this.zzAW().zzBt();
        if (pair != null && pair.first != null && pair.second != null) {
            zzd2.zzaVF = (String)pair.first;
            zzd2.zzaVG = (Boolean)pair.second;
        }
        zzd2.zzaVA = this.zzBF().zzhb();
        zzd2.osVersion = this.zzBF().zzBe();
        zzd2.zzaVC = (int)this.zzBF().zzBf();
        zzd2.zzaVB = this.zzBF().zzBg();
        zzd2.zzaVE = null;
        zzd2.zzaVu = null;
        zzd2.zzaVv = zzgArray[0].zzacS;
        zzd2.zzaVw = zzgArray[0].zzacS;
        for (int i = 1; i < zzgArray.length; ++i) {
            zzd2.zzaVv = Math.min(zzd2.zzaVv, zzgArray[i].zzacS);
            zzd2.zzaVw = Math.max(zzd2.zzaVw, zzgArray[i].zzacS);
        }
        zza zza2 = this.zzBD().zzew(appMetadata.packageName);
        if (zza2 == null) {
            zza2 = new zza(appMetadata.packageName, this.zzAW().zzBv(), appMetadata.zzaSn, this.zzAW().zzBu(), 0L, 0L, appMetadata.zzaKi, appMetadata.zzaSo, appMetadata.zzaSp, appMetadata.zzaSq, appMetadata.zzaSs);
        }
        zza zza3 = zza2.zza(this.zzzz(), zzd2.zzaVw);
        this.zzBD().zza(zza3);
        zzd2.zzaVH = zza3.zzaSe;
        zzd2.zzaVJ = (int)zza3.zzaSh;
        zzd2.zzaVx = zzd2.zzaVy = zza2.zzaSi == 0L ? null : Long.valueOf(zza2.zzaSi);
        List<zzac> list = this.zzBD().zzev(appMetadata.packageName);
        zzd2.zzaVt = new zzqq.zze[list.size()];
        for (n = 0; n < list.size(); ++n) {
            zztk2 = new zzqq.zze();
            zzd2.zzaVt[n] = zztk2;
            zztk2.name = list.get((int)n).mName;
            zztk2.zzaVM = list.get((int)n).zzaVf;
            this.zzAU().zza((zzqq.zze)zztk2, list.get((int)n).zzLI);
        }
        zzd2.zzaVs = new zzqq.zza[zzgArray.length];
        for (n = 0; n < zzgArray.length; ++n) {
            zztk2 = new zzqq.zza();
            zzd2.zzaVs[n] = zztk2;
            zztk2.name = zzgArray[n].mName;
            zztk2.zzaVl = zzgArray[n].zzacS;
            zztk2.zzaVk = new zzqq.zzb[zzgArray[n].zzaSE.size()];
            int n2 = 0;
            for (String string2 : zzgArray[n].zzaSE) {
                zzqq.zzb zzb2 = new zzqq.zzb();
                zztk2.zzaVk[n2++] = zzb2;
                zzb2.name = string2;
                Object object = zzgArray[n].zzaSE.get(string2);
                this.zzAU().zza(zzb2, object);
            }
        }
        zzd2.zzaSr = this.zzzz().zzBs();
        return zzd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaSn)) {
            return;
        }
        this.zzAU().zzeF(userAttributeParcel.name);
        Object object = this.zzAU().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzac zzac2 = new zzac(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.zzaVg, object);
        this.zzzz().zzBq().zze("Setting user attribute", zzac2.mName, object);
        this.zzBD().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzBD().zza(zzac2);
            this.zzBD().setTransactionSuccessful();
            this.zzzz().zzBq().zze("User attribute set", zzac2.mName, zzac2.zzLI);
        }
        finally {
            this.zzBD().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaSn)) {
            return;
        }
        this.zzzz().zzBq().zzj("Removing user attribute", userAttributeParcel.name);
        this.zzBD().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzBD().zzM(appMetadata.packageName, userAttributeParcel.name);
            this.zzBD().setTransactionSuccessful();
            this.zzzz().zzBq().zzj("User attribute removed", userAttributeParcel.name);
        }
        finally {
            this.zzBD().endTransaction();
        }
    }

    private boolean zzBJ() {
        this.zziS();
        return this.zzaUx != null;
    }

    private void zzx(List<Long> list) {
        com.google.android.gms.common.internal.zzx.zzab((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzaUx != null) {
            this.zzzz().zzBl().zzez("Set uploading progress before finishing the previous upload");
        } else {
            this.zzaUx = new ArrayList<Long>(list);
        }
    }

    public void zzBK() {
        String string2;
        this.zziS();
        this.zzje();
        if (!this.zzAX().zzka()) {
            Boolean bl = this.zzAW().zzBx();
            if (bl == null) {
                this.zzzz().zzBm().zzez("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzzz().zzBl().zzez("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzBJ()) {
            this.zzzz().zzBm().zzez("Uploading requested multiple times");
            return;
        }
        if (!this.zzBE().zzlk()) {
            this.zzzz().zzBm().zzez("Network not connected, ignoring upload request");
            this.zzBM();
            return;
        }
        long l = this.zzAW().zzaTF.get();
        if (l != 0L) {
            this.zzzz().zzBq().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(this.zziT().currentTimeMillis() - l));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.zzBD().zzAY()))) {
            int n = this.zzAX().zzAI();
            int n2 = this.zzAX().zzAJ();
            List<Pair<zzqq.zzd, Long>> list = this.zzBD().zzn(string2, n, n2);
            if (!list.isEmpty()) {
                String string3 = null;
                for (Pair<zzqq.zzd, Long> object2 : list) {
                    zzqq.zzd zzd2 = (zzqq.zzd)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zzd2.zzaVF)) continue;
                    string3 = zzd2.zzaVF;
                    break;
                }
                if (string3 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzqq.zzd zzd3 = (zzqq.zzd)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zzd3.zzaVF) || zzd3.zzaVF.equals(string3)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzqq.zzc();
                ((zzqq.zzc)((Object)object3)).zzaVp = new zzqq.zzd[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                long l2 = this.zziT().currentTimeMillis();
                for (int i = 0; i < ((zzqq.zzc)((Object)object3)).zzaVp.length; ++i) {
                    ((zzqq.zzc)((Object)object3)).zzaVp[i] = (zzqq.zzd)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzqq.zzc)((Object)object3)).zzaVp[i].zzaVE = this.zzAX().zzAE();
                    ((zzqq.zzc)((Object)object3)).zzaVp[i].zzaVu = l2;
                    ((zzqq.zzc)((Object)object3)).zzaVp[i].zzaVK = this.zzAX().zzka();
                }
                byte[] byArray = this.zzAU().zza((zzqq.zzc)((Object)object3));
                String string4 = this.zzAX().zzAK();
                try {
                    URL uRL = new URL(string4);
                    this.zzx(arrayList);
                    this.zzAW().zzaTG.set(this.zziT().currentTimeMillis());
                    this.zzBE().zza(uRL, byArray, new zzp.zza(){

                        @Override
                        public void zza(int n, Throwable throwable, byte[] byArray) {
                            zzt.this.zzb(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzzz().zzBl().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, Throwable throwable, byte[] byArray) {
        this.zziS();
        this.zzje();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzaUx;
        this.zzaUx = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzAW().zzaTF.set(this.zziT().currentTimeMillis());
            this.zzAW().zzaTG.set(0L);
            this.zzBM();
            this.zzzz().zzBr().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzBD().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzBD().zzP(l);
                }
                this.zzBD().setTransactionSuccessful();
            }
            finally {
                this.zzBD().endTransaction();
            }
            if (this.zzBE().zzlk() && this.zzBL()) {
                this.zzBK();
            } else {
                this.zzBM();
            }
        } else {
            boolean bl;
            this.zzzz().zzBr().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzAW().zzaTG.set(this.zziT().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzAW().zzaTH.set(this.zziT().currentTimeMillis());
            }
            this.zzBM();
        }
    }

    private boolean zzBL() {
        return !TextUtils.isEmpty((CharSequence)this.zzBD().zzAY());
    }

    private void zzBM() {
        this.zziS();
        this.zzje();
        if (!this.zzBz() || !this.zzBL()) {
            this.zzBG().unregister();
            this.zzBH().cancel();
            return;
        }
        long l = this.zzBN();
        if (l == 0L) {
            this.zzBG().unregister();
            this.zzBH().cancel();
            return;
        }
        if (!this.zzBE().zzlk()) {
            this.zzBG().zzlh();
            this.zzBH().cancel();
            return;
        }
        long l2 = this.zzAW().zzaTH.get();
        long l3 = this.zzAX().zzAL();
        if (!this.zzAU().zzc(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzBG().unregister();
        long l4 = l - this.zziT().currentTimeMillis();
        if (l4 <= 0L) {
            this.zzBH().zzt(1L);
        } else {
            this.zzzz().zzBr().zzj("Upload scheduled in approximately ms", l4);
            this.zzBH().zzt(l4);
        }
    }

    private long zzBN() {
        long l = this.zziT().currentTimeMillis();
        long l2 = this.zzAX().zzAO();
        long l3 = this.zzAX().zzAM();
        long l4 = this.zzAW().zzaTF.get();
        long l5 = this.zzAW().zzaTG.get();
        long l6 = this.zzBD().zzBb();
        if (l6 == 0L) {
            return 0L;
        }
        l6 = l - Math.abs(l6 - l);
        long l7 = l6 + l2;
        if (!this.zzAU().zzc(l4, l3)) {
            l7 = l4 + l3;
        }
        if (l5 != 0L && l5 >= l6) {
            long l8 = l7;
            for (int i = 0; i < this.zzAX().zzAQ(); ++i) {
                long l9 = 1 << i;
                if ((l8 += this.zzAX().zzAP() * l9) <= l5) continue;
                return l8;
            }
            return 0L;
        }
        return l7;
    }

    public void zzJ(boolean bl) {
        this.zzBM();
    }

    void zzb(zzw zzw2) {
        ++this.zzaUy;
    }

    void zzBO() {
        ++this.zzaUz;
    }

    public void zzd(AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        com.google.android.gms.common.internal.zzx.zzy((Object)appMetadata);
        com.google.android.gms.common.internal.zzx.zzcG((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaSn)) {
            return;
        }
        this.zze(appMetadata);
        zzh zzh2 = this.zzBD().zzL(appMetadata.packageName, "_f");
        if (zzh2 == null) {
            long l = this.zziT().currentTimeMillis();
            long l2 = (1L + l / 3600000L) * 3600000L;
            UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
            this.zzb(userAttributeParcel, appMetadata);
            Bundle bundle = new Bundle();
            bundle.putLong("_c", 1L);
            EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    private void zze(AppMetadata appMetadata) {
        this.zziS();
        this.zzje();
        com.google.android.gms.common.internal.zzx.zzy((Object)appMetadata);
        com.google.android.gms.common.internal.zzx.zzcG((String)appMetadata.packageName);
        zza zza2 = this.zzBD().zzew(appMetadata.packageName);
        String string2 = this.zzAW().zzBu();
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new zza(appMetadata.packageName, this.zzAW().zzBv(), appMetadata.zzaSn, string2, 0L, 0L, appMetadata.zzaKi, appMetadata.zzaSo, appMetadata.zzaSp, appMetadata.zzaSq, appMetadata.zzaSs);
            bl = true;
        } else if (!string2.equals(zza2.zzaSg)) {
            zza2 = zza2.zzJ(this.zzAW().zzBv(), string2);
            bl = true;
        }
        if (!(TextUtils.isEmpty((CharSequence)appMetadata.zzaSn) || appMetadata.zzaSn.equals(zza2.zzaSf) && appMetadata.zzaSp == zza2.zzaSk)) {
            zza2 = zza2.zze(appMetadata.zzaSn, appMetadata.zzaSp);
            bl = true;
        }
        if (!(TextUtils.isEmpty((CharSequence)appMetadata.zzaKi) || appMetadata.zzaKi.equals(zza2.zzRl) && appMetadata.zzaSo.equals(zza2.zzaSj))) {
            zza2 = zza2.zzK(appMetadata.zzaKi, appMetadata.zzaSo);
            bl = true;
        }
        if (appMetadata.zzaSq != zza2.zzaSl) {
            zza2 = zza2.zzO(appMetadata.zzaSq);
            bl = true;
        }
        if (appMetadata.zzaSs != zza2.zzaSm) {
            zza2 = zza2.zzao(appMetadata.zzaSs);
            bl = true;
        }
        if (bl) {
            this.zzBD().zza(zza2);
        }
    }
}

