/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzt;

public class zzu
extends zzl.zza {
    private final zzt zzaQX;
    private final boolean zzaUB;

    public zzu(zzt zzt2) {
        zzx.zzy((Object)zzt2);
        this.zzaQX = zzt2;
        this.zzaUB = false;
    }

    public zzu(zzt zzt2, boolean bl) {
        zzx.zzy((Object)zzt2);
        this.zzaQX = zzt2;
        this.zzaUB = bl;
    }

    void zzeA(String string2) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string2) && (stringArray = string2.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzaQX.zzzz().zzBm().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.zzaQX.zzAW().zzaTE.zzg(stringArray[1], l);
            } else {
                this.zzaQX.zzzz().zzBm().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    public void zzb(final AppMetadata appMetadata) {
        zzx.zzy((Object)appMetadata);
        this.zzeB(appMetadata.packageName);
        this.zzaQX.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzu.this.zzeA(appMetadata.zzaSr);
                zzu.this.zzaQX.zzc(appMetadata);
            }
        });
    }

    @Override
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzx.zzy((Object)eventParcel);
        zzx.zzy((Object)appMetadata);
        this.zzeB(appMetadata.packageName);
        this.zzaQX.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzu.this.zzeA(appMetadata.zzaSr);
                zzu.this.zzaQX.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    public void zza(final EventParcel eventParcel, final String string2, final String string3) {
        zzx.zzy((Object)eventParcel);
        zzx.zzcG((String)string2);
        this.zzeB(string2);
        this.zzaQX.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzu.this.zzeA(string3);
                zzu.this.zzaQX.zza(eventParcel, string2);
            }
        });
    }

    @Override
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzx.zzy((Object)userAttributeParcel);
        zzx.zzy((Object)appMetadata);
        this.zzeB(appMetadata.packageName);
        if (userAttributeParcel.getValue() == null) {
            this.zzaQX.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzu.this.zzeA(appMetadata.zzaSr);
                    zzu.this.zzaQX.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.zzaQX.zzAV().zzg(new Runnable(){

                @Override
                public void run() {
                    zzu.this.zzeA(appMetadata.zzaSr);
                    zzu.this.zzaQX.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    public void zza(final AppMetadata appMetadata) {
        zzx.zzy((Object)appMetadata);
        this.zzeB(appMetadata.packageName);
        this.zzaQX.zzAV().zzg(new Runnable(){

            @Override
            public void run() {
                zzu.this.zzeA(appMetadata.zzaSr);
                zzu.this.zzaQX.zzd(appMetadata);
            }
        });
    }

    private void zzeB(String string2) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzaQX.zzzz().zzBl().zzez("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzeC(string2);
        }
        catch (SecurityException securityException) {
            this.zzaQX.zzzz().zzBl().zzj("Measurement Service called with invalid calling package", string2);
            throw securityException;
        }
    }

    private void zzeC(String string2) throws SecurityException {
        int n = this.zzaUB ? Process.myUid() : Binder.getCallingUid();
        if (GooglePlayServicesUtil.zzb((Context)this.zzaQX.getContext(), (int)n, (String)string2)) {
            return;
        }
        if (GooglePlayServicesUtil.zze((Context)this.zzaQX.getContext(), (int)n) && !this.zzaQX.zzBI()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
    }
}

