/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.Method;

public class zzab
extends zzz {
    private zza zzaYD;
    private AppMeasurement.zza zzaYE;
    private boolean zzaYF;

    protected zzab(zzw zzw2) {
        super(zzw2);
    }

    @Override
    protected void zziJ() {
    }

    @TargetApi(value=14)
    public void zzDk() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.zzaYD == null) {
                this.zzaYD = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaYD);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaYD);
            this.zzAo().zzCK().zzfg("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean enabled) {
        this.zzjv();
        this.zzjj();
        this.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzab.this.zzas(enabled);
            }
        });
    }

    @WorkerThread
    private void zzas(boolean bl) {
        this.zzjk();
        this.zzjj();
        this.zzjv();
        this.zzAo().zzCJ().zzj("Setting app measurement enabled (FE)", bl);
        this.zzCo().setMeasurementEnabled(bl);
        this.zzCi().zzDo();
    }

    public void zze(String string2, String string3, Bundle bundle) {
        this.zzjj();
        this.zza(string2, string3, bundle, true, null);
    }

    private void zza(String string2, String string3, Bundle bundle, boolean bl, String string4) {
        this.zza(string2, string3, bundle, bl, string4, this.zzjl().currentTimeMillis());
    }

    private void zza(String string2, String string3, Bundle bundle, boolean bl, String string4, long l) {
        int n;
        zzx.zzcM((String)string2);
        this.zzCk().zzfr(string3);
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            n = 0;
            int n2 = this.zzCp().zzBA();
            for (String string5 : bundle.keySet()) {
                Object object;
                this.zzCk().zzft(string5);
                if (zzaj.zzfq(string5)) {
                    zzx.zzb((++n <= n2 ? 1 : 0) != 0, (Object)("Event can't contain more then " + n2 + " params"));
                }
                if ((object = this.zzCk().zzk(string5, bundle.get(string5))) == null) continue;
                this.zzCk().zza(bundle2, string5, object);
            }
        }
        n = this.zzCp().zzBD();
        String string6 = string2.length() <= n ? string2 : string2.substring(0, n);
        bundle2.putString("_o", string6);
        this.zza(string2, string3, l, bundle2, bl, string4);
    }

    protected void zza(final String string2, final String string3, final long l, final Bundle bundle, final boolean bl, final String string4) {
        zzx.zzz((Object)bundle);
        this.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzab.this.zzb(string2, string3, l, bundle, bl, string4);
            }
        });
    }

    @WorkerThread
    private void zzb(String string2, String string3, long l, Bundle bundle, boolean bl, String string4) {
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        zzx.zzz((Object)bundle);
        this.zzjk();
        this.zzjv();
        if (!this.zzCo().zzAr()) {
            this.zzAo().zzCJ().zzfg("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzaYF) {
            this.zzaYF = true;
            this.zzDm();
        }
        if (bl && this.zzaYE != null && !zzaj.zzfv(string3)) {
            this.zzAo().zzCJ().zze("Passing event to registered event handler (FE)", string3, bundle);
            this.zzaYE.zza(string2, string3, bundle, l);
        } else {
            if (!this.zzaTV.zzCS()) {
                return;
            }
            this.zzAo().zzCJ().zze("Logging event (FE)", string3, bundle);
            EventParcel eventParcel = new EventParcel(string3, new EventParams(bundle), string2, l);
            this.zzCi().zzb(eventParcel, string4);
        }
    }

    public void zza(String string2, String string3, Object object) {
        zzx.zzcM((String)string2);
        long l = this.zzjl().currentTimeMillis();
        this.zzCk().zzfs(string3);
        if (object != null) {
            this.zzCk().zzl(string3, object);
            Object object2 = this.zzCk().zzm(string3, object);
            if (object2 != null) {
                this.zza(string2, string3, l, object2);
            }
        } else {
            this.zza(string2, string3, l, null);
        }
    }

    void zza(final String string2, final String string3, final long l, final Object object) {
        this.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzab.this.zza(string2, string3, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string2, String string3, Object object, long l) {
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        this.zzjk();
        this.zzjj();
        this.zzjv();
        if (!this.zzCo().zzAr()) {
            this.zzAo().zzCJ().zzfg("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzaTV.zzCS()) {
            return;
        }
        this.zzAo().zzCJ().zze("Setting user property (FE)", string3, object);
        UserAttributeParcel userAttributeParcel = new UserAttributeParcel(string3, l, object, string2);
        this.zzCi().zza(userAttributeParcel);
    }

    @WorkerThread
    public void zzDl() {
        this.zzjk();
        this.zzjj();
        this.zzjv();
        if (!this.zzaTV.zzCS()) {
            return;
        }
        this.zzCi().zzDl();
        String string2 = this.zzCo().zzCQ();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.zzCh().zzCy())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string2);
            this.zze("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    private void zzDm() {
        try {
            Class<?> clazz = Class.forName(this.zzDn());
            this.zzh(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzAo().zzCI().zzfg("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzDn() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzh(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzAo().zzCF().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzfo(String string2) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                zzab.this.zza("auto", "_ldl", string2);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            try {
                Uri uri;
                zzab.this.zzAo().zzCK().zzfg("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    String string2 = uri.getQueryParameter("referrer");
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        return;
                    }
                    if (!string2.contains("gclid")) {
                        zzab.this.zzAo().zzCJ().zzfg("Activity created with data 'referrer' param without gclid");
                        return;
                    }
                    zzab.this.zzAo().zzCJ().zzj("Activity created with referrer", string2);
                    this.zzfo(string2);
                }
            }
            catch (Throwable throwable) {
                zzab.this.zzAo().zzCE().zzj("Throwable caught in onActivityCreated", throwable);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzab.this.zzCm().zzDw();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzab.this.zzCm().zzDu();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }
}

