/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.support.annotation.BinderThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.zze;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzx
extends zzm.zza {
    private final zzw zzaTV;
    private final boolean zzaYw;

    public zzx(zzw zzw2) {
        com.google.android.gms.common.internal.zzx.zzz((Object)zzw2);
        this.zzaTV = zzw2;
        this.zzaYw = false;
    }

    public zzx(zzw zzw2, boolean bl) {
        com.google.android.gms.common.internal.zzx.zzz((Object)zzw2);
        this.zzaTV = zzw2;
        this.zzaYw = bl;
    }

    @WorkerThread
    void zzfl(String string2) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string2) && (stringArray = string2.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzaTV.zzAo().zzCF().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.zzaTV.zzCo().zzaXi.zzf(stringArray[1], l);
            } else {
                this.zzaTV.zzAo().zzCF().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        com.google.android.gms.common.internal.zzx.zzz((Object)appMetadata);
        this.zzfm(appMetadata.packageName);
        this.zzaTV.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzx.this.zzfl(appMetadata.zzaVx);
                zzx.this.zzaTV.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        com.google.android.gms.common.internal.zzx.zzz((Object)eventParcel);
        com.google.android.gms.common.internal.zzx.zzz((Object)appMetadata);
        this.zzfm(appMetadata.packageName);
        this.zzaTV.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzx.this.zzfl(appMetadata.zzaVx);
                zzx.this.zzaTV.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string2, final String string3) {
        com.google.android.gms.common.internal.zzx.zzz((Object)eventParcel);
        com.google.android.gms.common.internal.zzx.zzcM((String)string2);
        this.zzfm(string2);
        this.zzaTV.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzx.this.zzfl(string3);
                zzx.this.zzaTV.zza(eventParcel, string2);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        com.google.android.gms.common.internal.zzx.zzz((Object)userAttributeParcel);
        com.google.android.gms.common.internal.zzx.zzz((Object)appMetadata);
        this.zzfm(appMetadata.packageName);
        if (userAttributeParcel.getValue() == null) {
            this.zzaTV.zzCn().zzg(new Runnable(){

                @Override
                public void run() {
                    zzx.this.zzfl(appMetadata.zzaVx);
                    zzx.this.zzaTV.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.zzaTV.zzCn().zzg(new Runnable(){

                @Override
                public void run() {
                    zzx.this.zzfl(appMetadata.zzaVx);
                    zzx.this.zzaTV.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        com.google.android.gms.common.internal.zzx.zzz((Object)appMetadata);
        this.zzfm(appMetadata.packageName);
        Future<List<zzai>> future = this.zzaTV.zzCn().zzd(new Callable<List<zzai>>(){

            public List<zzai> zzDh() throws Exception {
                return zzx.this.zzaTV.zzCj().zzeX(appMetadata.zzaVt);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzDh();
            }
        });
        try {
            List<zzai> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzai zzai2 : list) {
                if (!bl && zzaj.zzfv(zzai2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzai2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzaTV.zzAo().zzCE().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        com.google.android.gms.common.internal.zzx.zzz((Object)appMetadata);
        this.zzfm(appMetadata.packageName);
        this.zzaTV.zzCn().zzg(new Runnable(){

            @Override
            public void run() {
                zzx.this.zzfl(appMetadata.zzaVx);
                zzx.this.zzaTV.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzfm(String string2) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzaTV.zzAo().zzCE().zzfg("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzfn(string2);
        }
        catch (SecurityException securityException) {
            this.zzaTV.zzAo().zzCE().zzj("Measurement Service called with invalid calling package", string2);
            throw securityException;
        }
    }

    private void zzfn(String string2) throws SecurityException {
        int n = this.zzaYw ? Process.myUid() : Binder.getCallingUid();
        if (zze.zzb((Context)this.zzaTV.getContext(), (int)n, (String)string2)) {
            return;
        }
        if (zze.zzf((Context)this.zzaTV.getContext(), (int)n) && !this.zzaTV.zzCZ()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
    }
}

