/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.mlkit_vision_face;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.os.ConfigurationCompat;
import androidx.core.os.LocaleListCompat;
import com.google.android.gms.internal.mlkit_vision_face.zzat;
import com.google.android.gms.internal.mlkit_vision_face.zzbl;
import com.google.android.gms.internal.mlkit_vision_face.zzbw;
import com.google.android.gms.internal.mlkit_vision_face.zzej;
import com.google.android.gms.internal.mlkit_vision_face.zzel;
import com.google.android.gms.internal.mlkit_vision_face.zzem;
import com.google.android.gms.internal.mlkit_vision_face.zzen;
import com.google.android.gms.internal.mlkit_vision_face.zzgb;
import com.google.android.gms.internal.mlkit_vision_face.zzw;
import com.google.android.gms.tasks.Task;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.mlkit.common.sdkinternal.CommonUtils;
import com.google.mlkit.common.sdkinternal.LibraryVersion;
import com.google.mlkit.common.sdkinternal.MLTaskExecutor;
import com.google.mlkit.common.sdkinternal.SharedPrefManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class zzek {
    @Nullable
    private static List<String> zzb;
    private final String zzc;
    private final String zzd;
    private final zzb zze;
    private final SharedPrefManager zzf;
    private final Task<String> zzg;
    private final Task<String> zzh;
    private final Map<zzbw, Long> zzi = new HashMap<zzbw, Long>();
    private final Map<zzbw, zzat<Object, Long>> zzj = new HashMap<zzbw, zzat<Object, Long>>();
    private static boolean zzk;
    private static boolean zzl;
    public static final Component<?> zza;

    private zzek(Context context, SharedPrefManager sharedPrefManager, zzb zzb2) {
        this.zzc = context.getPackageName();
        this.zzd = CommonUtils.getAppVersion((Context)context);
        this.zzf = sharedPrefManager;
        this.zze = zzb2;
        this.zzg = MLTaskExecutor.getInstance().scheduleCallable(zzej.zza);
        MLTaskExecutor mLTaskExecutor = MLTaskExecutor.getInstance();
        SharedPrefManager sharedPrefManager2 = sharedPrefManager;
        sharedPrefManager2.getClass();
        this.zzh = mLTaskExecutor.scheduleCallable(zzem.zza(sharedPrefManager2));
    }

    public final void zza(@NonNull zzbl.zzad.zza zza2, @NonNull zzbw zzbw2) {
        MLTaskExecutor.workerThreadExecutor().execute(new zzel(this, zza2, zzbw2));
    }

    @WorkerThread
    public final void zza(@NonNull zzc zzc2, @NonNull zzbw zzbw2) {
        long l = SystemClock.elapsedRealtime();
        if (!this.zza(zzbw2, l, 30L)) {
            return;
        }
        this.zzi.put(zzbw2, l);
        this.zza(zzc2.zza(), zzbw2);
    }

    @WorkerThread
    public final <K> void zza(@NonNull K k, long l, @NonNull zzbw zzbw2, @NonNull zza<K> zza2) {
        if (!zzk) {
            return;
        }
        if (!this.zzj.containsKey(zzbw2)) {
            this.zzj.put(zzbw2, zzw.zzf());
        }
        zzat<Object, Long> zzat2 = this.zzj.get(zzbw2);
        zzat2.zza(k, l);
        long l2 = SystemClock.elapsedRealtime();
        if (!this.zza(zzbw2, l2, 30L)) {
            return;
        }
        this.zzi.put(zzbw2, l2);
        Iterator iterator = zzat2.zzh().iterator();
        while (iterator.hasNext()) {
            Object k2;
            Object k3 = k2 = iterator.next();
            List<Long> list = zzat2.zza(k2);
            Collections.sort(list);
            zzbl.zzab.zza zza3 = zzbl.zzab.zza();
            List<Long> list2 = list;
            long l3 = 0L;
            for (long l4 : list2) {
                l3 += l4;
            }
            zzbl.zzab zzab2 = (zzbl.zzab)((zzgb)zza3.zzc(l3 / (long)list2.size()).zza(zzek.zza(list, 100.0)).zzf(zzek.zza(list, 75.0)).zze(zzek.zza(list, 50.0)).zzd(zzek.zza(list, 25.0)).zzb(zzek.zza(list, 0.0)).zzg());
            this.zza(zza2.zza(k3, zzat2.zza(k2).size(), zzab2), zzbw2);
        }
        this.zzj.remove(zzbw2);
    }

    @VisibleForTesting
    private static long zza(List<Long> list, double d) {
        int n = (int)Math.ceil(d / 100.0 * (double)list.size());
        return list.get(Math.max(n - 1, 0));
    }

    @WorkerThread
    private final boolean zza(@NonNull zzbw zzbw2, long l, long l2) {
        if (this.zzi.get(zzbw2) == null) {
            return true;
        }
        return l - this.zzi.get(zzbw2) > TimeUnit.SECONDS.toMillis(30L);
    }

    @NonNull
    private static synchronized List<String> zzb() {
        if (zzb != null) {
            return zzb;
        }
        LocaleListCompat localeListCompat = ConfigurationCompat.getLocales((Configuration)Resources.getSystem().getConfiguration());
        zzb = new ArrayList<String>(localeListCompat.size());
        for (int i = 0; i < localeListCompat.size(); ++i) {
            Locale locale = localeListCompat.get(i);
            zzb.add(CommonUtils.languageTagFromLocale((Locale)locale));
        }
        return zzb;
    }

    final /* synthetic */ void zzb(zzbl.zzad.zza zza2, zzbw zzbw2) {
        String string = zza2.zza().zza();
        if ("NA".equals(string) || "".equals(string)) {
            string = "NA";
        }
        zzek zzek2 = this;
        zzbl.zzbg.zza zza3 = zzbl.zzbg.zzb().zza(this.zzc).zzb(this.zzd).zzd(string).zza((Iterable<String>)zzek.zzb()).zzb(true).zzc(zzek2.zzg.isSuccessful() ? (String)zzek2.zzg.getResult() : LibraryVersion.getInstance().getVersion("face-detection"));
        if (zzl) {
            zzek2 = this;
            zza3.zze(zzek2.zzh.isSuccessful() ? (String)zzek2.zzh.getResult() : zzek2.zzf.getMlSdkInstanceId());
        }
        zza2.zza(zzbw2).zza(zza3);
        this.zze.zza((zzbl.zzad)((zzgb)zza2.zzg()));
    }

    static final /* synthetic */ zzek zza(ComponentContainer componentContainer) {
        return new zzek((Context)componentContainer.get(Context.class), (SharedPrefManager)componentContainer.get(SharedPrefManager.class), (zzb)componentContainer.get(zzb.class));
    }

    static final /* synthetic */ String zza() throws Exception {
        return LibraryVersion.getInstance().getVersion("face-detection");
    }

    static {
        zzk = true;
        zzl = true;
        zza = Component.builder(zzek.class).add(Dependency.required(Context.class)).add(Dependency.required(SharedPrefManager.class)).add(Dependency.required(zzb.class)).factory(zzen.zza).build();
    }

    public static interface zza<K> {
        public zzbl.zzad.zza zza(K var1, int var2, zzbl.zzab var3);
    }

    public static interface zzc {
        public zzbl.zzad.zza zza();
    }

    public static interface zzb {
        public void zza(zzbl.zzad var1);
    }
}

