/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.face;

import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.internal.mlkit_vision_face.zzbl;
import com.google.android.gms.internal.mlkit_vision_face.zzgb;
import com.google.mlkit.vision.face.zza;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FaceDetectorOptions {
    @LandmarkMode
    private final int zza;
    @ContourMode
    private final int zzb;
    @ClassificationMode
    private final int zzc;
    @PerformanceMode
    private final int zzd;
    private final boolean zze;
    private final float zzf;
    public static final int LANDMARK_MODE_NONE = 1;
    public static final int LANDMARK_MODE_ALL = 2;
    public static final int CONTOUR_MODE_NONE = 1;
    public static final int CONTOUR_MODE_ALL = 2;
    public static final int CLASSIFICATION_MODE_NONE = 1;
    public static final int CLASSIFICATION_MODE_ALL = 2;
    public static final int PERFORMANCE_MODE_FAST = 1;
    public static final int PERFORMANCE_MODE_ACCURATE = 2;

    @LandmarkMode
    public final int zza() {
        return this.zza;
    }

    @ContourMode
    public final int zzb() {
        return this.zzb;
    }

    @ClassificationMode
    public final int zzc() {
        return this.zzc;
    }

    @PerformanceMode
    public final int zzd() {
        return this.zzd;
    }

    public final boolean zze() {
        return this.zze;
    }

    public final float zzf() {
        return this.zzf;
    }

    private FaceDetectorOptions(@LandmarkMode int n, @ContourMode int n2, @ClassificationMode int n3, @PerformanceMode int n4, boolean bl, float f) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
        this.zzd = n4;
        this.zze = bl;
        this.zzf = f;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FaceDetectorOptions)) {
            return false;
        }
        FaceDetectorOptions faceDetectorOptions = (FaceDetectorOptions)object;
        return Float.floatToIntBits(this.zzf) == Float.floatToIntBits(faceDetectorOptions.zzf) && this.zza == faceDetectorOptions.zza && this.zzb == faceDetectorOptions.zzb && this.zzd == faceDetectorOptions.zzd && this.zze == faceDetectorOptions.zze && this.zzc == faceDetectorOptions.zzc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.floatToIntBits(this.zzf), this.zza, this.zzb, this.zzd, this.zze, this.zzc});
    }

    public String toString() {
        return com.google.android.gms.internal.mlkit_vision_face.zza.zza("FaceDetectorOptions").zza("landmarkMode", this.zza).zza("contourMode", this.zzb).zza("classificationMode", this.zzc).zza("performanceMode", this.zzd).zza("trackingEnabled", this.zze).zza("minFaceSize", this.zzf).toString();
    }

    public final zzbl.zzac zzg() {
        zzbl.zzac.zzc zzc2;
        zzbl.zzac.zze zze2;
        zzbl.zzac.zzb zzb2;
        zzbl.zzac.zzd zzd2;
        zzbl.zzac.zza zza2 = zzbl.zzac.zza();
        switch (this.zza) {
            case 1: {
                zzd2 = zzbl.zzac.zzd.zzb;
                break;
            }
            case 2: {
                zzd2 = zzbl.zzac.zzd.zzc;
                break;
            }
            default: {
                zzd2 = zzbl.zzac.zzd.zza;
            }
        }
        zzbl.zzac.zza zza3 = zza2.zza(zzd2);
        switch (this.zzc) {
            case 1: {
                zzb2 = zzbl.zzac.zzb.zzb;
                break;
            }
            case 2: {
                zzb2 = zzbl.zzac.zzb.zzc;
                break;
            }
            default: {
                zzb2 = zzbl.zzac.zzb.zza;
            }
        }
        zzbl.zzac.zza zza4 = zza3.zza(zzb2);
        switch (this.zzd) {
            case 1: {
                zze2 = zzbl.zzac.zze.zzb;
                break;
            }
            case 2: {
                zze2 = zzbl.zzac.zze.zzc;
                break;
            }
            default: {
                zze2 = zzbl.zzac.zze.zza;
            }
        }
        zzbl.zzac.zza zza5 = zza4.zza(zze2);
        switch (this.zzb) {
            case 1: {
                zzc2 = zzbl.zzac.zzc.zzb;
                break;
            }
            case 2: {
                zzc2 = zzbl.zzac.zzc.zzc;
                break;
            }
            default: {
                zzc2 = zzbl.zzac.zzc.zza;
            }
        }
        return (zzbl.zzac)((zzgb)zza5.zza(zzc2).zza(this.zze).zza(this.zzf).zzg());
    }

    /* synthetic */ FaceDetectorOptions(int n, int n2, int n3, int n4, boolean bl, float f, zza zza2) {
        this(n, n2, n3, n4, bl, f);
    }

    public static class Builder {
        @LandmarkMode
        private int zza = 1;
        @ContourMode
        private int zzb = 1;
        @ClassificationMode
        private int zzc = 1;
        @PerformanceMode
        private int zzd = 1;
        private boolean zze = false;
        private float zzf = 0.1f;

        @NonNull
        public Builder setLandmarkMode(@LandmarkMode int n) {
            this.zza = n;
            return this;
        }

        @NonNull
        public Builder setContourMode(@ContourMode int n) {
            this.zzb = n;
            return this;
        }

        @NonNull
        public Builder setClassificationMode(@ClassificationMode int n) {
            this.zzc = n;
            return this;
        }

        @NonNull
        public Builder enableTracking() {
            this.zze = true;
            return this;
        }

        @NonNull
        public Builder setPerformanceMode(@PerformanceMode int n) {
            this.zzd = n;
            return this;
        }

        @NonNull
        public Builder setMinFaceSize(float f) {
            this.zzf = f;
            return this;
        }

        @NonNull
        public FaceDetectorOptions build() {
            return new FaceDetectorOptions(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, null);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PerformanceMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ClassificationMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ContourMode {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface LandmarkMode {
    }
}

