/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.face.internal;

import android.content.Context;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_face.zzbl;
import com.google.android.gms.internal.mlkit_vision_face.zzbv;
import com.google.android.gms.internal.mlkit_vision_face.zzbw;
import com.google.android.gms.internal.mlkit_vision_face.zzek;
import com.google.android.gms.internal.mlkit_vision_face.zzeo;
import com.google.android.gms.internal.mlkit_vision_face.zzgb;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.FaceDetector;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.BitmapInStreamingChecker;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import com.google.mlkit.vision.face.internal.zzc;
import com.google.mlkit.vision.face.internal.zzd;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zza
extends MLTask<List<Face>, InputImage> {
    private final Context zza;
    private final FaceDetectorOptions zzb;
    private final zzek zzc;
    @VisibleForTesting
    private static final AtomicBoolean zzd = new AtomicBoolean(true);
    private static final ImageUtils zze = ImageUtils.getInstance();
    @GuardedBy(value="this")
    private FaceDetector zzf;
    @GuardedBy(value="this")
    private FaceDetector zzg;
    private final BitmapInStreamingChecker zzh = new BitmapInStreamingChecker();

    public zza(@NonNull MlKitContext mlKitContext, @NonNull FaceDetectorOptions faceDetectorOptions) {
        Preconditions.checkNotNull((Object)mlKitContext, (Object)"MlKitContext can not be null");
        Preconditions.checkNotNull((Object)faceDetectorOptions, (Object)"FaceDetectorOptions can not be null");
        this.zza = mlKitContext.getApplicationContext();
        this.zzb = faceDetectorOptions;
        this.zzc = (zzek)mlKitContext.get(zzek.class);
    }

    @WorkerThread
    public final synchronized void load() {
        if (this.zzb.zzb() == 2) {
            if (this.zzg == null) {
                this.zzg = new FaceDetector.Builder(this.zza).setLandmarkType(2).setMode(2).setTrackingEnabled(false).setProminentFaceOnly(true).build();
            }
            if ((this.zzb.zza() == 2 || this.zzb.zzc() == 2 || this.zzb.zzd() == 2) && this.zzf == null) {
                this.zzf = new FaceDetector.Builder(this.zza).setLandmarkType(com.google.mlkit.vision.face.internal.zza.zza(this.zzb.zza())).setClassificationType(com.google.mlkit.vision.face.internal.zza.zzc(this.zzb.zzc())).setMode(com.google.mlkit.vision.face.internal.zza.zzb(this.zzb.zzd())).setMinFaceSize(this.zzb.zzf()).setTrackingEnabled(this.zzb.zze()).build();
                return;
            }
        } else if (this.zzf == null) {
            this.zzf = new FaceDetector.Builder(this.zza).setLandmarkType(com.google.mlkit.vision.face.internal.zza.zza(this.zzb.zza())).setClassificationType(com.google.mlkit.vision.face.internal.zza.zzc(this.zzb.zzc())).setMode(com.google.mlkit.vision.face.internal.zza.zzb(this.zzb.zzd())).setMinFaceSize(this.zzb.zzf()).setTrackingEnabled(this.zzb.zze()).build();
        }
    }

    @WorkerThread
    public final synchronized void release() {
        if (this.zzf != null) {
            this.zzf.release();
            this.zzf = null;
        }
        if (this.zzg != null) {
            this.zzg.release();
            this.zzg = null;
        }
        zzd.set(true);
    }

    @WorkerThread
    @VisibleForTesting
    private final synchronized List<Face> zza(@NonNull FaceDetector faceDetector, @NonNull InputImage inputImage, long l) throws MlKitException {
        Frame frame;
        if (!faceDetector.isOperational()) {
            this.zza(zzbv.zzb, l, inputImage, 0, 0);
            throw new MlKitException("Waiting for the face detection model to be downloaded. Please wait.", 14);
        }
        InputImage inputImage2 = inputImage;
        if (inputImage2.getFormat() == 35) {
            frame = new Frame.Builder().setPlanes(inputImage2.getPlanes(), inputImage2.getWidth(), inputImage2.getHeight(), CommonConvertUtils.convertToAndroidImageFormat((int)inputImage2.getFormat())).setRotation(CommonConvertUtils.convertToMVRotation((int)inputImage2.getRotationDegrees())).setTimestampMillis(SystemClock.elapsedRealtime()).build();
        } else {
            ByteBuffer byteBuffer = inputImage2.getFormat() == 17 ? inputImage2.getByteBuffer() : ImageConvertUtils.getInstance().convertToNv21Buffer(inputImage2, false);
            frame = new Frame.Builder().setImageData(byteBuffer, inputImage2.getWidth(), inputImage2.getHeight(), 17).setRotation(CommonConvertUtils.convertToMVRotation((int)inputImage2.getRotationDegrees())).build();
        }
        Frame frame2 = frame;
        SparseArray sparseArray = faceDetector.detect(frame2);
        ArrayList<Face> arrayList = new ArrayList<Face>();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            arrayList.add(new Face((com.google.android.gms.vision.face.Face)sparseArray.get(n)));
        }
        return arrayList;
    }

    @WorkerThread
    private final synchronized List<Face> zza(@NonNull InputImage inputImage) throws MlKitException {
        ArrayList<Face> arrayList;
        List<Face> list = null;
        ArrayList<Face> arrayList2 = null;
        long l = SystemClock.elapsedRealtime();
        if (this.zzf == null && this.zzg == null) {
            this.zza(zzbv.zzc, l, inputImage, 0, 0);
            throw new MlKitException("Face detector wasn't initialized correctly. This is most likely caused by invalid face detector options.", 13);
        }
        this.zzh.check(inputImage);
        if (this.zzf != null) {
            list = this.zza(this.zzf, inputImage, l);
            if (!this.zzb.zze()) {
                com.google.mlkit.vision.face.internal.zza.zza(list);
            }
        }
        if (this.zzg != null) {
            arrayList2 = this.zza(this.zzg, inputImage, l);
            com.google.mlkit.vision.face.internal.zza.zza(arrayList2);
        }
        ArrayList<Face> arrayList3 = arrayList2;
        List<Face> list2 = list;
        if (list2 == null && arrayList3 == null) {
            throw new MlKitException("No detector is enabled", 13);
        }
        if (list2 == null) {
            arrayList = arrayList3;
        } else if (arrayList3 == null) {
            arrayList = list2;
        } else {
            HashSet<Face> hashSet = new HashSet<Face>();
            for (Face face : arrayList3) {
                boolean bl = false;
                Iterator<Face> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    double d;
                    double d2;
                    double d3;
                    Rect rect;
                    Rect rect2;
                    Face face2;
                    Face face3 = face2 = iterator.next();
                    Face face4 = face;
                    if (face4.getBoundingBox() == null || face3.getBoundingBox() == null ? false : (rect2 = face4.getBoundingBox()).intersect(rect = face3.getBoundingBox()) && (d3 = (double)((Math.min(rect2.right, rect.right) - Math.max(rect2.left, rect.left)) * (Math.min(rect2.bottom, rect.bottom) - Math.max(rect2.top, rect.top)))) / ((d2 = (double)((rect2.right - rect2.left) * (rect2.bottom - rect2.top))) + (d = (double)((rect.right - rect.left) * (rect.bottom - rect.top))) - d3) > 0.6) {
                        bl = true;
                        face2.zza(face.zza());
                    }
                    hashSet.add(face2);
                }
                if (bl) continue;
                hashSet.add(face);
            }
            arrayList = new ArrayList<Face>(hashSet);
        }
        ArrayList<Face> arrayList4 = arrayList;
        this.zza(zzbv.zza, l, inputImage, arrayList2 == null ? 0 : arrayList2.size(), list == null ? 0 : list.size());
        zzd.set(false);
        return arrayList4;
    }

    private static void zza(@NonNull List<Face> list) {
        Iterator<Face> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(-1);
        }
    }

    @WorkerThread
    private final synchronized void zza(zzbv zzbv2, long l, InputImage inputImage, int n, int n2) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zzd zzd2 = new zzd(this, l2, zzbv2, n, n2, inputImage);
        this.zzc.zza(zzd2, zzbw.zza);
        zzbl.zzd.zzb zzb2 = (zzbl.zzd.zzb)((zzgb)zzbl.zzd.zzb.zza().zza(zzbv2).zza(zzd.get()).zza(zzeo.zza(zze.getMobileVisionImageFormat(inputImage), zze.getMobileVisionImageSize(inputImage))).zza(n).zzb(n2).zza(this.zzb.zzg()).zzg());
        zzek.zza zza2 = com.google.mlkit.vision.face.internal.zzc.zza;
        this.zzc.zza(zzb2, l2, zzbw.zzc, zza2);
    }

    @VisibleForTesting
    private static int zza(@FaceDetectorOptions.LandmarkMode int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
    }

    private static int zzb(@FaceDetectorOptions.PerformanceMode int n) {
        switch (n) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Invalid mode type: ").append(n).toString());
    }

    @VisibleForTesting
    private static int zzc(@FaceDetectorOptions.ClassificationMode int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
    }

    @WorkerThread
    public final /* synthetic */ Object run(@NonNull MLTaskInput mLTaskInput) throws MlKitException {
        return this.zza((InputImage)mLTaskInput);
    }

    static final /* synthetic */ zzbl.zzad.zza zza(zzbl.zzd.zzb zzb2, int n, zzbl.zzab zzab2) {
        return zzbl.zzad.zzb().zza(zzbl.zzd.zza().zza(n).zza(zzb2).zza(zzab2));
    }

    final /* synthetic */ zzbl.zzad.zza zza(long l, zzbv zzbv2, int n, int n2, InputImage inputImage) {
        zzbl.zzap zzap2 = (zzbl.zzap)((zzgb)zzbl.zzap.zza().zza(zzbl.zzaf.zza().zza(l).zza(zzbv2).zza(zzd.get()).zzb(true).zzc(true)).zza(this.zzb.zzg()).zza(n).zzb(n2).zza(zzeo.zza(zze.getMobileVisionImageFormat(inputImage), zze.getMobileVisionImageSize(inputImage))).zzg());
        return zzbl.zzad.zzb().zza(zzap2);
    }
}

