/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Text {
    private final List<TextBlock> zza;
    private final String zzb;

    @NonNull
    public List<TextBlock> getTextBlocks() {
        return Collections.unmodifiableList(this.zza);
    }

    @NonNull
    public String getText() {
        return this.zzb;
    }

    public Text(@RecentlyNonNull SparseArray<com.google.android.gms.vision.text.TextBlock> sparseArray) {
        ArrayList<TextBlock> arrayList = new ArrayList<TextBlock>();
        this.zza = arrayList;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sparseArray.size(); ++i) {
            com.google.android.gms.vision.text.TextBlock textBlock = (com.google.android.gms.vision.text.TextBlock)sparseArray.get(sparseArray.keyAt(i));
            if (textBlock == null) continue;
            TextBlock textBlock2 = new TextBlock(textBlock);
            this.zza.add(textBlock2);
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            if (textBlock.getValue() == null) continue;
            stringBuilder.append(textBlock2.getText());
        }
        this.zzb = stringBuilder.toString();
    }

    static class TextBase {
        private final String zza;
        private final Rect zzb;
        private final Point[] zzc;
        private final String zzd;

        TextBase(@NonNull com.google.android.gms.vision.text.Text text) {
            Preconditions.checkNotNull((Object)text, (Object)"Text to construct Text classes can't be null");
            this.zza = text.getValue();
            this.zzb = text.getBoundingBox();
            this.zzc = text.getCornerPoints();
            this.zzd = text.getLanguage();
        }

        @Nullable
        public Rect getBoundingBox() {
            return this.zzb;
        }

        @Nullable
        public Point[] getCornerPoints() {
            return this.zzc;
        }

        @NonNull
        public String getRecognizedLanguage() {
            return this.zzd;
        }

        @NonNull
        protected final String zza() {
            String string = ((TextBase)((Object)string)).zza;
            if (string == null) {
                return "";
            }
            return string;
        }
    }

    public static class Element
    extends TextBase {
        Element(@NonNull com.google.android.gms.vision.text.Element element) {
            super((com.google.android.gms.vision.text.Text)element);
        }

        @NonNull
        public String getText() {
            return this.zza();
        }
    }

    public static class Line
    extends TextBase {
        @GuardedBy(value="this")
        private final List<Element> zza;

        @NonNull
        public String getText() {
            return this.zza();
        }

        Line(@NonNull com.google.android.gms.vision.text.Line object) {
            super((com.google.android.gms.vision.text.Text)object);
            com.google.android.gms.vision.text.Text text2 = new ArrayList();
            this.zza = text2;
            for (com.google.android.gms.vision.text.Text text2 : object.getComponents()) {
                if (text2 instanceof com.google.android.gms.vision.text.Element) {
                    List<Element> list = this.zza;
                    Element element = new Element((com.google.android.gms.vision.text.Element)text2);
                    list.add(element);
                    continue;
                }
                Log.e((String)"Text", (String)"A subcomponent of line is should be an element!");
            }
        }

        @NonNull
        public synchronized List<Element> getElements() {
            return this.zza;
        }
    }

    public static class TextBlock
    extends TextBase {
        @GuardedBy(value="this")
        private final List<Line> zza;

        @NonNull
        public String getText() {
            return this.zza();
        }

        TextBlock(@NonNull com.google.android.gms.vision.text.TextBlock object) {
            super((com.google.android.gms.vision.text.Text)object);
            com.google.android.gms.vision.text.Text text2 = new ArrayList();
            this.zza = text2;
            for (com.google.android.gms.vision.text.Text text2 : object.getComponents()) {
                if (text2 instanceof com.google.android.gms.vision.text.Line) {
                    List<Line> list = this.zza;
                    Line line = new Line((com.google.android.gms.vision.text.Line)text2);
                    list.add(line);
                    continue;
                }
                Log.e((String)"Text", (String)"A subcomponent of textblock is should be a line!");
            }
        }

        @NonNull
        public synchronized List<Line> getLines() {
            return this.zza;
        }
    }
}

