/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_text.zzcc;
import com.google.android.gms.internal.mlkit_vision_text.zzgi;
import com.google.android.gms.internal.mlkit_vision_text.zzgo;
import com.google.android.gms.internal.mlkit_vision_text.zzgp;
import com.google.android.gms.internal.mlkit_vision_text.zzgr;
import com.google.android.gms.internal.mlkit_vision_text.zzhs;
import com.google.android.gms.internal.mlkit_vision_text.zzht;
import com.google.android.gms.internal.mlkit_vision_text.zzid;
import com.google.android.gms.internal.mlkit_vision_text.zzii;
import com.google.android.gms.internal.mlkit_vision_text.zzij;
import com.google.android.gms.internal.mlkit_vision_text.zzir;
import com.google.android.gms.internal.mlkit_vision_text.zzis;
import com.google.android.gms.internal.mlkit_vision_text.zzit;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.TextRecognizer;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.internal.zza;
import com.google.mlkit.vision.text.internal.zzc;
import com.google.mlkit.vision.text.internal.zzd;

public final class zze
extends MLTask<Text, InputImage> {
    @VisibleForTesting
    static boolean zza = true;
    private static final ImageUtils zzb = ImageUtils.getInstance();
    @GuardedBy(value="this")
    @Nullable
    private TextRecognizer zzc;
    private final zza zzd;
    private final Context zze;
    private final zzij zzf;
    private final zzit zzg;

    public zze(@NonNull MlKitContext object) {
        zzij zzij2 = zzir.zza("play-services-mlkit-text-recognition");
        zzit zzit2 = zzit.zza();
        Preconditions.checkNotNull((Object)object, (Object)"MlKitContext can not be null");
        this.zze = object.getApplicationContext();
        this.zzf = zzij2;
        this.zzg = zzit2;
        super(this.zze);
        this.zzd = object;
    }

    @WorkerThread
    public final synchronized void load() throws MlKitException {
        if (this.zzc == null) {
            TextRecognizer.Builder builder = new TextRecognizer.Builder(this.zze);
            this.zzc = builder.build();
            return;
        }
    }

    @WorkerThread
    public final synchronized void release() {
        zza = true;
        TextRecognizer textRecognizer = this.zzc;
        if (textRecognizer != null) {
            textRecognizer.release();
            this.zzc = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final synchronized Text zzc(@NonNull InputImage inputImage) throws MlKitException {
        Frame.Builder builder;
        void var1_4;
        long l = SystemClock.elapsedRealtime();
        TextRecognizer textRecognizer = this.zzc;
        if (textRecognizer == null) {
            this.zze(zzgo.zzB, l, (InputImage)var1_4);
            MlKitException mlKitException = new MlKitException("Model source is unavailable. Please load the model resource first.", 13);
            throw mlKitException;
        }
        if (!textRecognizer.isOperational()) {
            this.zze(zzgo.zzk, l, (InputImage)var1_4);
            MlKitException mlKitException = new MlKitException("Waiting for the text recognition model to be downloaded. Please wait.", 14);
            throw mlKitException;
        }
        if (var1_4.getFormat() == -1) {
            builder = new Frame.Builder();
            builder = builder.setBitmap((Bitmap)Preconditions.checkNotNull((Object)var1_4.getBitmapInternal())).setRotation(CommonConvertUtils.convertToMVRotation((int)var1_4.getRotationDegrees())).build();
        } else {
            builder = new Frame.Builder();
            builder = builder.setBitmap(ImageConvertUtils.getInstance().convertToUpRightBitmap((InputImage)var1_4)).setRotation(0).build();
        }
        builder = textRecognizer.detect((Frame)builder);
        this.zze(zzgo.zza, l, (InputImage)var1_4);
        zza = false;
        return new Text((SparseArray<TextBlock>)builder);
    }

    @WorkerThread
    private final void zze(zzgo object, long l, InputImage object2) {
        l = SystemClock.elapsedRealtime() - l;
        Object object3 = new zzc(l, (zzgo)((Object)object), (InputImage)object2);
        this.zzf.zza((zzii)object3, zzgp.zze);
        object3 = new zzcc();
        ((zzcc)object3).zza((zzgo)((Object)object));
        ((zzcc)object3).zzb(zza);
        ((zzcc)object3).zzc(zzis.zza(zzb.getMobileVisionImageFormat(object2), zzb.getMobileVisionImageSize(object2)));
        object = ((zzcc)object3).zzd();
        object2 = com.google.mlkit.vision.text.internal.zzd.zza;
        this.zzf.zzb(object, l, zzgp.zzbc, object2);
    }

    static final /* synthetic */ zzid zzd(long l, zzgo object, InputImage object2) {
        zzhs zzhs2 = new zzhs();
        zzgi zzgi2 = new zzgi();
        zzgi2.zza(l);
        zzgi2.zzb((zzgo)((Object)object));
        zzgi2.zzc(zza);
        object = true;
        zzgi2.zzd((Boolean)object);
        zzgi2.zze((Boolean)object);
        zzhs2.zza(zzgi2.zzf());
        zzhs2.zzb(zzis.zza(zzb.getMobileVisionImageFormat((InputImage)object2), zzb.getMobileVisionImageSize((InputImage)object2)));
        object = zzhs2.zzc();
        object2 = new zzgr();
        ((zzgr)object2).zzc(false);
        ((zzgr)object2).zzd((zzht)object);
        return zzid.zzc((zzgr)object2);
    }
}

