/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzavj;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzavk
implements Connections {
    public static final Api.zzf<zzavj> zzahc = new Api.zzf();
    public static final Api.zza<zzavj, Api.ApiOptions.NoOptions> zzahd = new Api.zza<zzavj, Api.ApiOptions.NoOptions>(){

        public zzavj zzs(Context context, Looper looper, zzg zzg2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzavj(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzg zzg2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzs(context, looper, zzg2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzavj zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzac.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzavk.zze(googleApiClient, bl);
    }

    public static zzavj zze(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzavj)googleApiClient.zza(zzahc) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zzavk.zzd(googleApiClient, true).zzMT();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zzavk.zzd(googleApiClient, true).zzMU();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, final String string, final AppMetadata appMetadata, final long l, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzaaz zzaaz2 = googleApiClient.zzr((Object)connectionRequestListener);
        return googleApiClient.zzb((zzzv.zza)new zzb(this, googleApiClient){

            protected void zza(zzavj zzavj2) throws RemoteException {
                zzavj2.zza((zzzv.zzb<Connections.StartAdvertisingResult>)this, string, appMetadata, l, (zzaaz<Connections.ConnectionRequestListener>)zzaaz2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzMV();
        }
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        final zzaaz zzaaz2 = googleApiClient.zzr((Object)endpointDiscoveryListener);
        return googleApiClient.zzb((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzavj zzavj2) throws RemoteException {
                zzavj2.zza((zzzv.zzb<Status>)this, string, l, (zzaaz<Connections.EndpointDiscoveryListener>)zzaaz2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzgn(string);
        }
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, final String string, final String string2, final byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzaaz zzaaz2 = googleApiClient.zzr((Object)connectionResponseCallback);
        final zzaaz zzaaz3 = googleApiClient.zzr((Object)messageListener);
        return googleApiClient.zzb((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzavj zzavj2) throws RemoteException {
                zzavj2.zza((zzzv.zzb<Status>)this, string, string2, byArray, (zzaaz<Connections.ConnectionResponseCallback>)zzaaz2, (zzaaz<Connections.MessageListener>)zzaaz3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, final String string, final byte[] byArray, Connections.MessageListener messageListener) {
        final zzaaz zzaaz2 = googleApiClient.zzr((Object)messageListener);
        return googleApiClient.zzb((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzavj zzavj2) throws RemoteException {
                zzavj2.zza((zzzv.zzb<Status>)this, string, byArray, (zzaaz<Connections.MessageListener>)zzaaz2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzb((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzavj zzavj2) throws RemoteException {
                zzavj2.zzt((zzzv.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zza(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zza(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzb(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzb(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, String string) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzgo(string);
        }
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        zzavj zzavj2 = zzavk.zzd(googleApiClient, false);
        if (zzavj2 != null) {
            zzavj2.zzMW();
        }
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzbx(final Status status) {
            return new Connections.StartAdvertisingResult(this){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbx(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzzv.zza<R, zzavj> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }
    }
}

