/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzavp;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final zzavp[] zzbxo = new zzavp[]{zzavp.zzbyf};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzaFs;
    @Deprecated
    final zzavp[] zzbxp;
    private final long zzbxq;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable zzavp[] zzavpArray, long l) {
        this.versionCode = n;
        this.type = (String)zzac.zzw((Object)string2);
        this.zzaFs = string == null ? "" : string;
        this.zzbxq = 0L;
        if (Message.zzac(this.zzaFs, this.type)) {
            zzac.zzb((byArray == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzac.zzw((Object)byArray);
            zzac.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        }
        this.content = byArray;
        if (zzavpArray == null || zzavpArray.length == 0) {
            zzavpArray = zzbxo;
        }
        this.zzbxp = zzavpArray;
        zzac.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public boolean zzMX() {
        return MESSAGE_NAMESPACE_RESERVED.equals(this.getNamespace());
    }

    public boolean zzgp(String string) {
        return this.zzMX() && string.equals(this.getType());
    }

    @Deprecated
    public static boolean zzac(String string, String string2) {
        return string.equals(MESSAGE_NAMESPACE_RESERVED) && string2.equals("__device_presence");
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, zzbxo);
    }

    public Message(byte[] byArray, String string, String string2, zzavp[] zzavpArray) {
        this(byArray, string, string2, zzavpArray, 0L);
    }

    public Message(byte[] byArray, String string, String string2, zzavp[] zzavpArray, long l) {
        this(2, byArray, string, string2, zzavpArray, l);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzaFs;
    }

    public byte[] getContent() {
        return this.content;
    }

    public long zzMY() {
        return 0L;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaFs, this.type, Arrays.hashCode(this.content), 0L});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zzaFs, (CharSequence)message.zzaFs) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content) && 0L == 0L;
    }

    public String toString() {
        String string = this.zzaFs;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes]}").toString();
    }
}

