/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzavn;
import com.google.android.gms.internal.zzavr;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zza {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<zzt> zzbxr;
    private final List<zzavr> zzbxs;
    private final boolean zzbxt;
    private final List<zzavn> zzbxu;

    MessageFilter(int n, List<zzt> list, List<zzavr> list2, boolean bl, List<zzavn> list3) {
        this.mVersionCode = n;
        this.zzbxr = Collections.unmodifiableList((List)zzac.zzw(list));
        this.zzbxt = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzbxs = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzbxu = Collections.unmodifiableList(list3);
    }

    private MessageFilter(List<zzt> list, List<zzavr> list2, boolean bl, List<zzavn> list3) {
        this(2, list, list2, bl, list3);
    }

    List<zzt> zzMZ() {
        return this.zzbxr;
    }

    boolean zzNa() {
        return this.zzbxt;
    }

    List<zzavr> zzNb() {
        return this.zzbxs;
    }

    List<zzavn> zzNc() {
        return this.zzbxu;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.zzbxt;
        String string = String.valueOf(this.zzbxr);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzbxt == messageFilter.zzbxt && zzaa.equal(this.zzbxr, messageFilter.zzbxr) && zzaa.equal(this.zzbxs, messageFilter.zzbxs) && zzaa.equal(this.zzbxu, messageFilter.zzbxu);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzbxr, this.zzbxs, this.zzbxt, this.zzbxu});
    }

    public static final class Builder {
        private final List<zzt> zzbxv = new ArrayList<zzt>();
        private final List<zzavr> zzbxs = new ArrayList<zzavr>();
        private final Set<zzavn> zzbxw = new HashSet<zzavn>();
        private boolean zzbxt;

        public Builder includeAllMyTypes() {
            this.zzbxt = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzac.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzac.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzad(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.zzbxv.addAll(messageFilter.zzMZ());
            this.zzbxs.addAll(messageFilter.zzNb());
            this.zzbxt |= messageFilter.zzNa();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzad("__reserved_namespace", "__eddystone_uid");
            this.zzbxs.add(zzavr.zzae(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzad("__reserved_namespace", "__i_beacon_id");
            this.zzbxs.add(zzavr.zza(uUID, s, s2));
            return this;
        }

        private Builder zzad(String string, String string2) {
            this.zzbxv.add(new zzt(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzac.zza((this.zzbxt || !this.zzbxv.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.zzbxv, this.zzbxs, this.zzbxt, new ArrayList<zzavn>(this.zzbxw));
        }
    }
}

