/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzaa;
import com.google.android.gms.nearby.messages.internal.zzab;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.internal.zzag;
import com.google.android.gms.nearby.messages.internal.zzai;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzm;
import com.google.android.gms.nearby.messages.internal.zzo;
import com.google.android.gms.nearby.messages.internal.zzp;
import com.google.android.gms.nearby.messages.internal.zzq;
import com.google.android.gms.nearby.messages.internal.zzr;
import com.google.android.gms.nearby.messages.internal.zzv;
import com.google.android.gms.nearby.messages.internal.zzy;
import java.util.List;

class zzx
extends zzl<zzo> {
    private final ClientAppContext zzbyD;
    private final int zzbxB;
    private final zzh<StatusCallback, zzf> zzbyE = new zzh<StatusCallback, zzf>(this){

        protected zzf zzh(zzaaz<StatusCallback> zzaaz2) {
            return new zzf(zzaaz2);
        }

        @Override
        protected /* synthetic */ zza zzi(zzaaz zzaaz2) {
            return this.zzh((zzaaz<StatusCallback>)zzaaz2);
        }
    };
    private final zzh<MessageListener, zzc> zzbyF = new zzh<MessageListener, zzc>(this){

        protected zzc zzj(zzaaz<MessageListener> zzaaz2) {
            return new zzc(zzaaz2);
        }

        @Override
        protected /* synthetic */ zza zzi(zzaaz zzaaz2) {
            return this.zzj((zzaaz<MessageListener>)zzaaz2);
        }
    };
    private final zzh<SubscribeCallback, zzg> zzbyG = new zzh<SubscribeCallback, zzg>(this){

        protected zzg zzk(zzaaz<SubscribeCallback> zzaaz2) {
            return new zzg(zzaaz2);
        }

        @Override
        protected /* synthetic */ zza zzi(zzaaz zzaaz2) {
            return this.zzk((zzaaz<SubscribeCallback>)zzaaz2);
        }
    };
    private final zzh<PublishCallback, zze> zzbyH = new zzh<PublishCallback, zze>(this){

        protected zze zzl(zzaaz<PublishCallback> zzaaz2) {
            return new zze(zzaaz2);
        }

        @Override
        protected /* synthetic */ zza zzi(zzaaz zzaaz2) {
            return this.zzl((zzaaz<PublishCallback>)zzaaz2);
        }
    };

    private static int zzbv(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzx(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzg zzg2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzg2, connectionCallbacks, onConnectionFailedListener);
        String string = zzg2.zzxh();
        int n = zzx.zzbv(context);
        if (messagesOptions != null) {
            this.zzbyD = new ClientAppContext(string, messagesOptions.zzbxx, messagesOptions.zzbxy, messagesOptions.zzbxA, n);
            this.zzbxB = messagesOptions.zzbxz;
        } else {
            this.zzbyD = new ClientAppContext(string, null, false, null, n);
            this.zzbxB = -1;
        }
        if (n == 1 && zzs.zzyA()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected Bundle zzql() {
        Bundle bundle = super.zzql();
        bundle.putInt("NearbyPermissions", this.zzbxB);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzbyD);
        return bundle;
    }

    @NonNull
    protected String zzeu() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzev() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected zzo zzeI(IBinder iBinder) {
        return zzo.zza.zzeE(iBinder);
    }

    public void disconnect() {
        try {
            this.zzmd(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zzzv.zzb<Status> zzb2, zzv zzv2, @Nullable zzaaz<PublishCallback> zzaaz2, PublishOptions publishOptions) throws RemoteException {
        zzab zzab2 = new zzab(zzv2, publishOptions.getStrategy(), (IBinder)zzaa.zzu(zzb2), (IBinder)zze.zzm((zzaaz<PublishCallback>)zzaaz2));
        ((zzo)this.zzwW()).zza(zzab2);
    }

    void zza(zzzv.zzb<Status> zzb2, zzv zzv2) throws RemoteException {
        zzag zzag2 = new zzag(zzv2, (IBinder)zzaa.zzu(zzb2), this.zzbyD);
        ((zzo)this.zzwW()).zza(zzag2);
    }

    void zza(zzzv.zzb<Status> zzb2, zzaaz<MessageListener> zzaaz2, MessageListener messageListener, @Nullable zzaaz<SubscribeCallback> zzaaz3, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.zzbyF.zza(zzaaz2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzaa.zzu(zzb2), subscribeOptions.getFilter(), null, 0, byArray, (IBinder)zzg.zzo((zzaaz<SubscribeCallback>)zzaaz3), subscribeOptions.zzbxT);
        ((zzo)this.zzwW()).zza(subscribeRequest);
    }

    void zza(zzzv.zzb<Status> zzb2, PendingIntent pendingIntent, @Nullable zzaaz<SubscribeCallback> zzaaz2, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzaa.zzu(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, (IBinder)zzg.zzo((zzaaz<SubscribeCallback>)zzaaz2), subscribeOptions.zzbxT);
        ((zzo)this.zzwW()).zza(subscribeRequest);
    }

    void zza(zzzv.zzb<Status> zzb2, MessageListener messageListener) throws RemoteException {
        if (this.zzbyF.zzH(messageListener) == null) {
            return;
        }
        zzai zzai2 = new zzai((IBinder)this.zzbyF.zzH(messageListener), (IBinder)zzaa.zzu(zzb2), null, 0);
        ((zzo)this.zzwW()).zza(zzai2);
        this.zzbyF.zzI(messageListener);
    }

    void zza(zzzv.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        zzai zzai2 = new zzai(null, (IBinder)zzaa.zzu(zzb2), pendingIntent, 0);
        ((zzo)this.zzwW()).zza(zzai2);
    }

    void zzt(zzzv.zzb<Status> zzb2) throws RemoteException {
        com.google.android.gms.nearby.messages.internal.zzh zzh2 = new com.google.android.gms.nearby.messages.internal.zzh((IBinder)zzaa.zzu(zzb2));
        ((zzo)this.zzwW()).zza(zzh2);
    }

    void zza(zzzv.zzb<Status> zzb2, zzaaz<StatusCallback> zzaaz2, StatusCallback statusCallback) throws RemoteException {
        zzad zzad2 = new zzad((IBinder)zzaa.zzu(zzb2), (IBinder)this.zzbyE.zza(zzaaz2, statusCallback));
        zzad2.zzbzc = true;
        ((zzo)this.zzwW()).zza(zzad2);
    }

    void zza(zzzv.zzb<Status> zzb2, StatusCallback statusCallback) throws RemoteException {
        if (this.zzbyE.zzH(statusCallback) == null) {
            return;
        }
        zzad zzad2 = new zzad((IBinder)zzaa.zzu(zzb2), (IBinder)this.zzbyE.zzH(statusCallback));
        zzad2.zzbzc = false;
        ((zzo)this.zzwW()).zza(zzad2);
        this.zzbyE.zzI(statusCallback);
    }

    void zzmd(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzo)this.zzwW()).zza(zzj2);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    @Nullable
    zzaaz<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzx.zza(googleApiClient, messageListener, this.zzbyF);
    }

    @Nullable
    zzaaz<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzx.zza(googleApiClient, statusCallback, this.zzbyE);
    }

    @Nullable
    zzaaz<SubscribeCallback> zza(GoogleApiClient googleApiClient, SubscribeCallback subscribeCallback) {
        return zzx.zza(googleApiClient, subscribeCallback, this.zzbyG);
    }

    @Nullable
    zzaaz<PublishCallback> zza(GoogleApiClient googleApiClient, PublishCallback publishCallback) {
        return zzx.zza(googleApiClient, publishCallback, this.zzbyH);
    }

    @Nullable
    private static <C> zzaaz<C> zza(GoogleApiClient googleApiClient, C c, zzh<C, ? extends zza<C>> zzh2) {
        if (c == null) {
            return null;
        }
        zza<C> zza2 = zzh2.zzH(c);
        if (zza2 != null) {
            return zza2.zzNl();
        }
        return googleApiClient.zzr(c);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzeI(iBinder);
    }

    private static abstract class zzh<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> zzaGt = new SimpleArrayMap(1);

        private zzh() {
        }

        @Nullable
        W zzH(C c) {
            return (W)((zza)this.zzaGt.get(c));
        }

        W zza(zzaaz<C> zzaaz2, C c) {
            zza<Object> zza2 = (zza)this.zzaGt.get(c);
            if (zza2 != null) {
                zzaaz2.clear();
                return (W)zza2;
            }
            zza2 = this.zzi(zzaaz2);
            this.zzaGt.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzI(C c) {
            zza zza2 = (zza)this.zzaGt.remove(c);
            if (zza2 != null) {
                zza2.zzNl().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzi(zzaaz<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity zzbyI;
        private final zzx zzbyJ;

        private zzb(Activity activity, zzx zzx2) {
            this.zzbyI = activity;
            this.zzbyJ = zzx2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.zzbyI) {
                try {
                    this.zzbyJ.zzmd(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.zzbyI) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zze
    extends zzp.zza
    implements zza<PublishCallback> {
        private static final zzd<PublishCallback> zzbyL = new zzd<PublishCallback>(){

            public void zza(PublishCallback publishCallback) {
                publishCallback.onExpired();
            }

            public /* synthetic */ void zzs(Object object) {
                this.zza((PublishCallback)object);
            }
        };
        private final zzaaz<PublishCallback> zzbyM;

        private zze(zzaaz<PublishCallback> zzaaz2) {
            this.zzbyM = zzaaz2;
        }

        @Nullable
        private static zze zzm(@Nullable zzaaz<PublishCallback> zzaaz2) {
            return zzaaz2 == null ? null : new zze(zzaaz2);
        }

        @Override
        public void onExpired() {
            this.zzbyM.zza(zzbyL);
        }

        @Override
        public zzaaz<PublishCallback> zzNl() {
            return this.zzbyM;
        }
    }

    private static class zzg
    extends zzr.zza
    implements zza<SubscribeCallback> {
        private static final zzd<SubscribeCallback> zzbyL = new zzd<SubscribeCallback>(){

            public void zza(SubscribeCallback subscribeCallback) {
                subscribeCallback.onExpired();
            }

            public /* synthetic */ void zzs(Object object) {
                this.zza((SubscribeCallback)object);
            }
        };
        private final zzaaz<SubscribeCallback> zzbyM;

        private zzg(zzaaz<SubscribeCallback> zzaaz2) {
            this.zzbyM = zzaaz2;
        }

        @Nullable
        private static zzg zzo(@Nullable zzaaz<SubscribeCallback> zzaaz2) {
            return zzaaz2 == null ? null : new zzg(zzaaz2);
        }

        @Override
        public void onExpired() {
            this.zzbyM.zza(zzbyL);
        }

        @Override
        public zzaaz<SubscribeCallback> zzNl() {
            return this.zzbyM;
        }
    }

    private static class zzf
    extends zzq.zza
    implements zza<StatusCallback> {
        private final zzaaz<StatusCallback> zzbyM;

        private zzf(zzaaz<StatusCallback> zzaaz2) {
            this.zzbyM = zzaaz2;
        }

        @Override
        public void onPermissionChanged(final boolean bl) {
            this.zzbyM.zza((zzaaz.zzc)new zzd<StatusCallback>(this){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(bl);
                }

                public /* synthetic */ void zzs(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzaaz<StatusCallback> zzNl() {
            return this.zzbyM;
        }
    }

    private static class zzc
    extends zzm.zza
    implements zza<MessageListener> {
        private final zzaaz<MessageListener> zzaBG;

        private zzc(zzaaz<MessageListener> zzaaz2) {
            this.zzaBG = zzaaz2;
        }

        @Override
        public void zza(zzv zzv2) {
        }

        @Override
        public void zzb(zzv zzv2) {
        }

        @Override
        public void zzI(final List<Update> list) throws RemoteException {
            this.zzaBG.zza((zzaaz.zzc)new zzd<MessageListener>(this){

                public void zza(MessageListener messageListener) {
                    zzy.zza(list, messageListener);
                }

                public /* synthetic */ void zzs(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzaaz<MessageListener> zzNl() {
            return this.zzaBG;
        }
    }

    private static abstract class zzd<T>
    implements zzaaz.zzc<T> {
        private zzd() {
        }

        public void zzvy() {
        }
    }

    private static interface zza<C> {
        public zzaaz<C> zzNl();
    }
}

