/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzayj;
import com.google.android.gms.internal.zzayl;
import com.google.android.gms.internal.zzayn;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayq;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzaa;
import com.google.android.gms.nearby.messages.internal.zzac;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzah;
import com.google.android.gms.nearby.messages.internal.zzh;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzo;
import com.google.android.gms.nearby.messages.internal.zzv;

class zzx
extends zzl<zzo> {
    private final zzayq zzbAT = new zzayq();
    private final ClientAppContext zzbAU;
    private final int zzbzQ;

    private static int zzbN(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzx(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzg zzg2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzg2, connectionCallbacks, onConnectionFailedListener);
        String string = zzg2.zzxO();
        int n = zzx.zzbN(context);
        if (messagesOptions != null) {
            this.zzbAU = new ClientAppContext(string, messagesOptions.zzbzM, messagesOptions.zzbzN, messagesOptions.zzbzP, n);
            this.zzbzQ = messagesOptions.zzbzO;
        } else {
            this.zzbAU = new ClientAppContext(string, null, false, null, n);
            this.zzbzQ = -1;
        }
        if (n == 1) {
            zzt.zzzg();
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zza(activity, this));
        }
    }

    @NonNull
    protected Bundle zzqL() {
        Bundle bundle = super.zzqL();
        bundle.putInt("NearbyPermissions", this.zzbzQ);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzbAU);
        return bundle;
    }

    @NonNull
    protected String zzez() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzeA() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected zzo zzeP(IBinder iBinder) {
        return zzo.zza.zzeL(iBinder);
    }

    public void disconnect() {
        try {
            this.zzmP(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzbAT.clear();
        super.disconnect();
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, zzv zzv2, @Nullable zzabh<PublishCallback> zzabh3, PublishOptions publishOptions) throws RemoteException {
        zzaa zzaa2 = new zzaa(zzv2, publishOptions.getStrategy(), new zzayl(zzabh2), zzabh3 == null ? null : new zzayn(zzabh3));
        ((zzo)this.zzxD()).zza(zzaa2);
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, zzv zzv2) throws RemoteException {
        zzaf zzaf2 = new zzaf(zzv2, new zzayl(zzabh2), this.zzbAU);
        ((zzo)this.zzxD()).zza(zzaf2);
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, zzabh<MessageListener> zzabh3, @Nullable zzabh<SubscribeCallback> zzabh4, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzbAT.zzi(zzabh3), subscribeOptions.getStrategy(), new zzayl(zzabh2), subscribeOptions.getFilter(), null, 0, byArray, zzabh4 == null ? null : new zzayp(zzabh4), subscribeOptions.zzbAh);
        ((zzo)this.zzxD()).zza(subscribeRequest);
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, PendingIntent pendingIntent, @Nullable zzabh<SubscribeCallback> zzabh3, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), new zzayl(zzabh2), subscribeOptions.getFilter(), pendingIntent, 0, null, zzabh3 == null ? null : new zzayp(zzabh3), subscribeOptions.zzbAh, subscribeOptions.zzbAi);
        ((zzo)this.zzxD()).zza(subscribeRequest);
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, @Nullable zzabh<MessageListener> zzabh3) throws RemoteException {
        if (zzabh3 == null) {
            return;
        }
        zzah zzah2 = new zzah(this.zzbAT.zzi(zzabh3), new zzayl(zzabh2), null, 0);
        ((zzo)this.zzxD()).zza(zzah2);
        this.zzbAT.zzj(zzabh3);
    }

    void zza(zzabh<zzaad.zzb<Status>> zzabh2, PendingIntent pendingIntent) throws RemoteException {
        zzah zzah2 = new zzah(null, new zzayl(zzabh2), pendingIntent, 0);
        ((zzo)this.zzxD()).zza(zzah2);
    }

    void zzh(zzabh<zzaad.zzb<Status>> zzabh2) throws RemoteException {
        zzh zzh2 = new zzh(new zzayl(zzabh2));
        ((zzo)this.zzxD()).zza(zzh2);
    }

    void zzb(zzabh<zzaad.zzb<Status>> zzabh2, zzabh<StatusCallback> zzabh3) throws RemoteException {
        zzac zzac2 = new zzac(new zzayl(zzabh2), this.zzbAT.zzi(zzabh3));
        zzac2.zzbBj = true;
        ((zzo)this.zzxD()).zza(zzac2);
    }

    void zzc(zzabh<zzaad.zzb<Status>> zzabh2, @Nullable zzabh<StatusCallback> zzabh3) throws RemoteException {
        if (zzabh3 == null) {
            return;
        }
        zzac zzac2 = new zzac(new zzayl(zzabh2), this.zzbAT.zzi(zzabh3));
        zzac2.zzbBj = false;
        ((zzo)this.zzxD()).zza(zzac2);
        this.zzbAT.zzj(zzabh3);
    }

    void zzmP(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzo)this.zzxD()).zza(zzj2);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    @Nullable
    zzabh<MessageListener> zza(GoogleApiClient googleApiClient, @Nullable MessageListener messageListener) {
        return this.zzbAT.zzb(googleApiClient, messageListener).zzOO();
    }

    @Nullable
    zzabh<StatusCallback> zza(GoogleApiClient googleApiClient, @Nullable StatusCallback statusCallback) {
        return this.zzbAT.zzb(googleApiClient, statusCallback).zzOO();
    }

    @Nullable
    zzabh<MessageListener> zza(@Nullable MessageListener messageListener) {
        zzayj<MessageListener> zzayj2 = this.zzbAT.zzI(messageListener);
        return zzayj2 == null ? null : zzayj2.zzOO();
    }

    @Nullable
    zzabh<StatusCallback> zza(@Nullable StatusCallback statusCallback) {
        zzayj<StatusCallback> zzayj2 = this.zzbAT.zzI(statusCallback);
        return zzayj2 == null ? null : zzayj2.zzOO();
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzeP(iBinder);
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private final Activity zzbAV;
        private final zzx zzbAW;

        private zza(Activity activity, zzx zzx2) {
            this.zzbAV = activity;
            this.zzbAW = zzx2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.zzbAV) {
                try {
                    this.zzbAW.zzmP(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.zzbAV) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }
}

