/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzayd;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzv;
import com.google.android.gms.nearby.messages.internal.zzx;
import java.util.List;

public class zzy
implements Messages {
    public static final zzy zzbAT = new zzy();
    public static final Api.zzf<zzx> zzaid = new Api.zzf();
    public static final Api.zza<zzx, MessagesOptions> zzaie = new Api.zza<zzx, MessagesOptions>(){

        public zzx zza(Context context, Looper looper, zzg zzg2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzx(context, looper, connectionCallbacks, onConnectionFailedListener, zzg2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    private zzy() {
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, final Message message, final PublishOptions publishOptions) {
        zzac.zzw((Object)((Object)message));
        zzac.zzw((Object)publishOptions);
        final zzabh zzabh2 = publishOptions.getCallback() == null ? null : googleApiClient.zzr((Object)publishOptions.getCallback());
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), zzv.zza(message), (zzabh<PublishCallback>)zzabh2, publishOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient googleApiClient, final Message message) {
        zzac.zzw((Object)((Object)message));
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), zzv.zza(message));
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener, final SubscribeOptions subscribeOptions) {
        zzac.zzw((Object)messageListener);
        zzac.zzw((Object)subscribeOptions);
        zzac.zzb((subscribeOptions.getStrategy().zzOK() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        final zzabh<MessageListener> zzabh2 = zzy.zzm(googleApiClient).zza(googleApiClient, messageListener);
        final zzabh zzabh3 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzr((Object)subscribeOptions.getCallback());
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), (zzabh<MessageListener>)zzabh2, (zzabh<SubscribeCallback>)zzabh3, subscribeOptions, null);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final SubscribeOptions subscribeOptions) {
        zzac.zzw((Object)pendingIntent);
        zzac.zzw((Object)subscribeOptions);
        final zzabh zzabh2 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzr((Object)subscribeOptions.getCallback());
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), pendingIntent, (zzabh<SubscribeCallback>)zzabh2, subscribeOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        zzac.zzw((Object)messageListener);
        final zzabh<MessageListener> zzabh2 = zzy.zzm(googleApiClient).zza(messageListener);
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), (zzabh<MessageListener>)zzabh2);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        zzac.zzw((Object)pendingIntent);
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zza(this.zzOP(), pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        zzy.zza(zzy.zzB(intent), messageListener);
    }

    public static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzmV(1)) {
                messageListener.onFound(update.zzbAO);
            }
            if (update.zzmV(2)) {
                messageListener.onLost(update.zzbAO);
            }
            if (update.zzmV(4)) {
                messageListener.onDistanceChanged(update.zzbAO, update.zzbBm);
            }
            if (update.zzmV(8)) {
                messageListener.onBleSignalChanged(update.zzbAO, update.zzbBn);
            }
            if (!update.zzmV(16)) continue;
            Message cfr_ignored_0 = update.zzbAO;
            zzayd cfr_ignored_1 = update.zzbBo;
        }
    }

    private static List<Update> zzB(Intent intent) {
        return zzs.zzc(intent, "com.google.android.gms.nearby.messages.UPDATES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zzh(this.zzOP());
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzac.zzw((Object)statusCallback);
        final zzabh<StatusCallback> zzabh2 = zzy.zzm(googleApiClient).zza(googleApiClient, statusCallback);
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zzb(this.zzOP(), (zzabh<StatusCallback>)zzabh2);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzac.zzw((Object)statusCallback);
        final zzabh<StatusCallback> zzabh2 = zzy.zzm(googleApiClient).zza(statusCallback);
        return googleApiClient.zzb((zzaad.zza)new zza(this, googleApiClient){

            protected void zza(zzx zzx2) throws RemoteException {
                zzx2.zzc(this.zzOP(), (zzabh<StatusCallback>)zzabh2);
            }
        });
    }

    private static zzx zzm(GoogleApiClient googleApiClient) {
        return (zzx)googleApiClient.zza(zzaid);
    }

    static abstract class zza
    extends zzaad.zza<Status, zzx> {
        private final zzabh<zzaad.zzb<Status>> zzbAZ;

        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.MESSAGES_API, googleApiClient);
            this.zzbAZ = googleApiClient.zzr((Object)this);
        }

        zzabh<zzaad.zzb<Status>> zzOP() {
            return this.zzbAZ;
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ void setResult(Object object) {
            super.zzb((Result)((Status)object));
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

