/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzawb;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import com.google.android.gms.nearby.connection.zze;
import com.google.android.gms.nearby.connection.zzj;
import java.util.List;

public final class zzawc
implements Connections {
    public static final Api.zzf<zzawb> zzaid = new Api.zzf();
    public static final Api.zza<zzawb, Api.ApiOptions.NoOptions> zzaie = new Api.zza<zzawb, Api.ApiOptions.NoOptions>(){

        public zzawb zzs(Context context, Looper looper, zzg zzg2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzawb(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzg zzg2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzs(context, looper, zzg2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    private static zzawb zzk(GoogleApiClient googleApiClient) {
        zzac.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzac.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzac.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (!bl) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return (zzawb)googleApiClient.zza(zzaid);
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zzawc.zzk(googleApiClient).zzOj();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zzawc.zzk(googleApiClient).zzOk();
    }

    public PendingResult<Connections.StartAdvertisingResult> zza(GoogleApiClient googleApiClient, final String string, final String string2, final long l, Connections.ConnectionRequestListener connectionRequestListener, final com.google.android.gms.nearby.connection.zza zza2) {
        final zzabh zzabh2 = googleApiClient.zzr((Object)connectionRequestListener);
        return googleApiClient.zzb((zzaad.zza)new zzb(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Connections.StartAdvertisingResult>)this, string, string2, l, zza2, (zzabh<Connections.ConnectionRequestListener>)zzabh2);
            }
        });
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, String string, AppMetadata appMetadata, long l, Connections.ConnectionRequestListener connectionRequestListener) {
        return this.zza(googleApiClient, string, "__LEGACY_SERVICE_ID__", l, connectionRequestListener, new com.google.android.gms.nearby.connection.zza(zzj.zzbym));
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zzOl();
            }
        });
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener, final zze zze2) {
        final zzabh zzabh2 = googleApiClient.zzr((Object)endpointDiscoveryListener);
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, string, l, zze2, (zzabh<Connections.EndpointDiscoveryListener>)zzabh2);
            }
        });
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, String string, long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        return this.zza(googleApiClient, string, l, endpointDiscoveryListener, new zze(zzj.zzbym));
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        this.zzl(googleApiClient);
    }

    public void zzl(GoogleApiClient googleApiClient) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zzsL();
            }
        });
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, String string, String string2, byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        return this.zza(googleApiClient, string, string2, byArray, connectionResponseCallback, zzawc.zza(messageListener));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final @Nullable String string, final String string2, final @Nullable byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.zza zza2) {
        final zzabh zzabh2 = googleApiClient.zzr((Object)connectionResponseCallback);
        final zzabh zzabh3 = googleApiClient.zzr((Object)zza2);
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, string, string2, byArray, (zzabh<Connections.ConnectionResponseCallback>)zzabh2, (zzabh<Connections.zza>)zzabh3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, String string, byte[] byArray, Connections.MessageListener messageListener) {
        return this.zza(googleApiClient, string, byArray, zzawc.zza(messageListener));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final String string, final @Nullable byte[] byArray, Connections.zza zza2) {
        final zzabh zzabh2 = googleApiClient.zzr((Object)zza2);
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, string, byArray, (zzabh<Connections.zza>)zzabh2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zzt((zzaad.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, final String string, final byte[] byArray) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, new String[]{string}, com.google.android.gms.nearby.connection.zzg.zzB(byArray), true);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, final List<String> list, final byte[] byArray) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, list.toArray(new String[0]), com.google.android.gms.nearby.connection.zzg.zzB(byArray), true);
            }
        });
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        this.zza(googleApiClient, string, com.google.android.gms.nearby.connection.zzg.zzB(byArray));
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        this.zza(googleApiClient, list, com.google.android.gms.nearby.connection.zzg.zzB(byArray));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final String string, final com.google.android.gms.nearby.connection.zzg zzg2) {
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, new String[]{string}, zzg2, false);
            }
        });
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final List<String> list, final com.google.android.gms.nearby.connection.zzg zzg2) {
        return googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zza((zzaad.zzb<Status>)this, list.toArray(new String[0]), zzg2, false);
            }
        });
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, final String string) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zzgl(string);
            }
        });
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        googleApiClient.zzb((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzawb zzawb2) throws RemoteException {
                zzawb2.zzOm();
            }
        });
    }

    private static Connections.zza zza(final Connections.MessageListener messageListener) {
        return new Connections.zza(){

            @Override
            public void zza(String string, com.google.android.gms.nearby.connection.zzg zzg2, boolean bl) {
                if (zzg2.getType() != 1) {
                    return;
                }
                messageListener.onMessageReceived(string, zzg2.zzNX(), bl);
            }

            @Override
            public void onDisconnected(String string) {
                messageListener.onDisconnected(string);
            }
        };
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzby(final Status status) {
            return new Connections.StartAdvertisingResult(this){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzby(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzaad.zza<R, zzawb> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }

        public /* synthetic */ void setResult(Object object) {
            super.zzb((Result)object);
        }
    }
}

