/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzayf;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zza {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int zzaiI;
    private final List<zzt> zzbzE;
    private final List<zzayf> zzbzF;
    private final boolean zzbzG;
    private final List<zzayb> zzbzH;
    private final int zzbzI;

    MessageFilter(int n, List<zzt> list, List<zzayf> list2, boolean bl, List<zzayb> list3, int n2) {
        this.zzaiI = n;
        this.zzbzE = Collections.unmodifiableList((List)zzac.zzw(list));
        this.zzbzG = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzbzF = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzbzH = Collections.unmodifiableList(list3);
        this.zzbzI = n2;
    }

    private MessageFilter(List<zzt> list, List<zzayf> list2, boolean bl, List<zzayb> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public List<zzt> zzOG() {
        return this.zzbzE;
    }

    public boolean zzOH() {
        return this.zzbzG;
    }

    List<zzayf> zzOI() {
        return this.zzbzF;
    }

    public List<zzayb> zzOJ() {
        return this.zzbzH;
    }

    public int zzOK() {
        return this.zzbzI;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.zzbzG;
        String string = String.valueOf(this.zzbzE);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzbzG == messageFilter.zzbzG && zzaa.equal(this.zzbzE, messageFilter.zzbzE) && zzaa.equal(this.zzbzF, messageFilter.zzbzF) && zzaa.equal(this.zzbzH, messageFilter.zzbzH);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzbzE, this.zzbzF, this.zzbzG, this.zzbzH});
    }

    public static final class Builder {
        private final Set<zzt> zzbzJ = new HashSet<zzt>();
        private final List<zzayf> zzbzF = new ArrayList<zzayf>();
        private final Set<zzayb> zzbzK = new HashSet<zzayb>();
        private boolean zzbzG;
        private int zzbzI = 0;

        public Builder includeAllMyTypes() {
            this.zzbzG = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzac.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzac.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzag(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.zzbzJ.addAll(messageFilter.zzOG());
            this.zzbzF.addAll(messageFilter.zzOI());
            this.zzbzK.addAll(messageFilter.zzOJ());
            this.zzbzG |= messageFilter.zzOH();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzag("__reserved_namespace", "__eddystone_uid");
            this.zzbzF.add(zzayf.zzah(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzag("__reserved_namespace", "__i_beacon_id");
            this.zzbzF.add(zzayf.zza(uUID, s, s2));
            return this;
        }

        public Builder includeAudioBytes(int n) {
            zzac.zzb((this.zzbzI == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzac.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzac.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzag("__reserved_namespace", "__audio_bytes");
            this.zzbzI = n;
            return this;
        }

        private Builder zzag(String string, String string2) {
            this.zzbzJ.add(new zzt(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzac.zza((this.zzbzG || !this.zzbzJ.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzt>(this.zzbzJ), this.zzbzF, this.zzbzG, new ArrayList<zzayb>(this.zzbzK), this.zzbzI);
        }
    }
}

