/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.connection;

import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbr;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;

public class Payload {
    private final long id;
    @Type
    private final int type;
    @Nullable
    private final byte[] zzbww;
    @Nullable
    private final File zzbwx;
    @Nullable
    private final Stream zzbwy;

    public static Payload fromBytes(byte[] byArray) {
        zzbr.zzb((Object)byArray, (Object)"Cannot create a Payload from null bytes.");
        return Payload.zza(byArray, UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(byte[] byArray, long l) {
        return new Payload(l, 1, byArray, null, null);
    }

    public static Payload fromFile(java.io.File file) throws FileNotFoundException {
        return Payload.zza(File.zza(file, file.length()), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromFile(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(File.zzb(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(File file, long l) {
        return new Payload(l, 2, null, file, null);
    }

    public static Payload fromStream(InputStream inputStream) {
        return Payload.zza(Stream.zzj(inputStream), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromStream(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(Stream.zzc(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(Stream stream, long l) {
        return new Payload(l, 3, null, null, stream);
    }

    private Payload(long l, int n, @Nullable byte[] byArray, @Nullable File file, @Nullable Stream stream) {
        this.id = l;
        this.type = n;
        this.zzbww = byArray;
        this.zzbwx = file;
        this.zzbwy = stream;
    }

    public long getId() {
        return this.id;
    }

    @Type
    public int getType() {
        return this.type;
    }

    @Nullable
    public byte[] asBytes() {
        return this.zzbww;
    }

    @Nullable
    public File asFile() {
        return this.zzbwx;
    }

    @Nullable
    public Stream asStream() {
        return this.zzbwy;
    }

    public static @interface Type {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int STREAM = 3;
    }

    public static class Stream {
        @Nullable
        private final ParcelFileDescriptor zzbwA;
        @Nullable
        private InputStream zzbwC;

        public static Stream zzj(InputStream inputStream) {
            zzbr.zzb((Object)inputStream, (Object)"Cannot create Payload.Stream from null InputStream.");
            return new Stream(null, inputStream);
        }

        public static Stream zzc(ParcelFileDescriptor parcelFileDescriptor) {
            zzbr.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.Stream from null ParcelFileDescriptor.");
            return new Stream(parcelFileDescriptor, null);
        }

        private Stream(@Nullable ParcelFileDescriptor parcelFileDescriptor, @Nullable InputStream inputStream) {
            this.zzbwA = parcelFileDescriptor;
            this.zzbwC = inputStream;
        }

        @NonNull
        public InputStream asInputStream() {
            if (this.zzbwC == null) {
                this.zzbwC = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbwA);
            }
            return this.zzbwC;
        }

        @Nullable
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzbwA;
        }
    }

    public static class File {
        @Nullable
        private final java.io.File zzbwz;
        private final ParcelFileDescriptor zzbwA;
        private final long zzbwB;

        public static File zza(java.io.File file, long l) throws FileNotFoundException {
            return new File((java.io.File)zzbr.zzb((Object)file, (Object)"Cannot create Payload.File from null java.io.File."), ParcelFileDescriptor.open((java.io.File)file, (int)0x10000000), l);
        }

        public static File zzb(ParcelFileDescriptor parcelFileDescriptor) {
            return new File(null, (ParcelFileDescriptor)zzbr.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.File from null ParcelFileDescriptor."), parcelFileDescriptor.getStatSize());
        }

        private File(@Nullable java.io.File file, ParcelFileDescriptor parcelFileDescriptor, long l) {
            this.zzbwz = file;
            this.zzbwA = parcelFileDescriptor;
            this.zzbwB = l;
        }

        @Nullable
        public java.io.File asJavaFile() {
            return this.zzbwz;
        }

        @NonNull
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzbwA;
        }

        public long getSize() {
            return this.zzbwB;
        }
    }
}

