/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcqt;
import com.google.android.gms.internal.zzcqx;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zza {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzakw;
    private final List<zzad> zzbyb;
    private final List<zzcqx> zzbyc;
    private final boolean zzbyd;
    private final List<zzcqt> zzbye;
    private final int zzbyf;

    MessageFilter(int n, List<zzad> list, List<zzcqx> list2, boolean bl, List<zzcqt> list3, int n2) {
        this.zzakw = n;
        this.zzbyb = Collections.unmodifiableList((List)zzbr.zzu(list));
        this.zzbyd = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzbyc = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzbye = Collections.unmodifiableList(list3);
        this.zzbyf = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcqx> list2, boolean bl, List<zzcqt> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzzO() {
        return this.zzbyb;
    }

    public final boolean zzzP() {
        return this.zzbyd;
    }

    final List<zzcqx> zzzQ() {
        return this.zzbyc;
    }

    public final List<zzcqt> zzzR() {
        return this.zzbye;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, messageFilter.zzbyb, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, messageFilter.zzbyc, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzbyd);
        zzd.zzc((Parcel)parcel2, (int)4, messageFilter.zzbye, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzbyf);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzbyd;
        String string = String.valueOf(this.zzbyb);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzbyd == messageFilter.zzbyd && zzbh.equal(this.zzbyb, messageFilter.zzbyb) && zzbh.equal(this.zzbyc, messageFilter.zzbyc) && zzbh.equal(this.zzbye, messageFilter.zzbye);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbyb, this.zzbyc, this.zzbyd, this.zzbye});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzbyg = new HashSet<zzad>();
        private final List<zzcqx> zzbyc = new ArrayList<zzcqx>();
        private final Set<zzcqt> zzbyh = new HashSet<zzcqt>();
        private boolean zzbyd;
        private int zzbyf = 0;

        public final Builder includeAllMyTypes() {
            this.zzbyd = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbr.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbr.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzS(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzbyg.addAll(messageFilter.zzzO());
            this.zzbyc.addAll(messageFilter.zzzQ());
            this.zzbyh.addAll(messageFilter.zzzR());
            this.zzbyd |= messageFilter.zzzP();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzS("__reserved_namespace", "__eddystone_uid");
            this.zzbyc.add(zzcqx.zzT(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzS("__reserved_namespace", "__i_beacon_id");
            this.zzbyc.add(zzcqx.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbr.zzb((this.zzbyf == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbr.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbr.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzS("__reserved_namespace", "__audio_bytes");
            this.zzbyf = n;
            return this;
        }

        private final Builder zzS(String string, String string2) {
            this.zzbyg.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbr.zza((this.zzbyd || !this.zzbyg.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzbyg), this.zzbyc, this.zzbyd, new ArrayList<zzcqt>(this.zzbyh), this.zzbyf, null);
        }
    }
}

