/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zza {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    private static Strategy zzbyp;
    private int zzakw;
    @Deprecated
    private int zzbyq;
    private int zzbyr;
    private int zzbys;
    @Deprecated
    private boolean zzbyt;
    private int zzbyu;
    private int zzbyv;
    private final int zzbyw;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzakw = n;
        this.zzbyq = n2;
        if (n2 == 0) {
            this.zzbyv = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzbyv = 1;
                    break;
                }
                case 3: {
                    this.zzbyv = 2;
                    break;
                }
                default: {
                    this.zzbyv = 3;
                }
            }
        }
        this.zzbys = n4;
        this.zzbyt = bl;
        if (bl) {
            this.zzbyu = 2;
            this.zzbyr = Integer.MAX_VALUE;
        } else {
            this.zzbyr = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbyu = -1;
                    break;
                }
                default: {
                    this.zzbyu = n5;
                }
            }
        }
        this.zzbyw = n7;
    }

    public final int zzzS() {
        return this.zzbyw;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)strategy.zzbyq);
        zzd.zzc((Parcel)parcel2, (int)2, (int)strategy.zzbyr);
        zzd.zzc((Parcel)parcel2, (int)3, (int)strategy.zzbys);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzbyt);
        zzd.zzc((Parcel)parcel2, (int)5, (int)strategy.zzbyu);
        zzd.zzc((Parcel)parcel2, (int)6, (int)strategy.zzbyv);
        zzd.zzc((Parcel)parcel2, (int)7, (int)strategy.zzbyw);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzakw == strategy.zzakw && this.zzbyv == strategy.zzbyv && this.zzbyr == strategy.zzbyr && this.zzbys == strategy.zzbys && this.zzbyu == strategy.zzbyu;
    }

    public int hashCode() {
        int n = this.zzakw;
        n = n * 31 + this.zzbyv;
        n = n * 31 + this.zzbyr;
        n = n * 31 + this.zzbys;
        return n * 31 + this.zzbyu;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzbyr;
        int n2 = this.zzbys;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = String.valueOf(string4);
        n2 = this.zzbyu;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = String.valueOf(string3);
        n2 = this.zzbyv;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = String.valueOf(string2);
        n2 = this.zzbyw;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = String.valueOf(string);
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append("}").toString();
    }

    static {
        zzbyp = BLE_ONLY = new Builder().zzbq(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbyx = 3;
        private int zzbyy = 300;
        private int zzbyz = 0;
        private int zzbyA = -1;
        private int zzbyB = 0;

        public Builder setDiscoveryMode(int n) {
            this.zzbyx = n;
            return this;
        }

        public final Builder zzbq(int n) {
            this.zzbyA = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbr.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzbyy = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzbyz = n;
            return this;
        }

        public Strategy build() {
            if (this.zzbyA == 2 && this.zzbyz == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbyy, this.zzbyz, false, this.zzbyA, this.zzbyx, 0);
        }
    }
}

