/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzbcl;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzcqz;
import com.google.android.gms.internal.zzcrc;
import com.google.android.gms.internal.zzcrj;
import com.google.android.gms.internal.zzcrl;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzaz;
import com.google.android.gms.nearby.messages.internal.zzbc;
import com.google.android.gms.nearby.messages.internal.zzbe;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;

final class zzah
extends zzaa<zzs> {
    private final zzcrl zzbzi = new zzcrl();
    private final ClientAppContext zzbzj;
    private final int zzbym;

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzq2, connectionCallbacks, onConnectionFailedListener);
        int n;
        String string = zzq2.zzro();
        Context context2 = context;
        int n2 = context2 instanceof Activity ? 1 : (context2 instanceof Application ? 2 : (n = context2 instanceof Service ? 3 : 0));
        if (messagesOptions != null) {
            this.zzbzj = new ClientAppContext(string, null, false, null, n);
            this.zzbym = messagesOptions.zzbyk;
        } else {
            this.zzbzj = new ClientAppContext(string, null, false, null, n);
            this.zzbym = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzmm() {
        Bundle bundle = super.zzmm();
        bundle.putInt("NearbyPermissions", this.zzbym);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzbzj);
        return bundle;
    }

    @NonNull
    protected final String zzda() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzdb() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzbr(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzbzi.clear();
        super.disconnect();
    }

    final void zza(zzbfi<zzbcl<Status>> zzbfi2, zzaf zzaf2) throws RemoteException {
        zzbc zzbc2 = new zzbc(zzaf2, new zzcrc(zzbfi2), this.zzbzj);
        ((zzs)this.zzrd()).zza(zzbc2);
    }

    final void zza(zzbfi<zzbcl<Status>> zzbfi2, zzbfi<MessageListener> zzbfi3, @Nullable zzbfi<SubscribeCallback> zzbfi4, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzbzi.zzh(zzbfi3), subscribeOptions.getStrategy(), new zzcrc(zzbfi2), subscribeOptions.getFilter(), null, null, zzbfi4 == null ? null : new zzcrj(zzbfi4), subscribeOptions.zzbyE);
        ((zzs)this.zzrd()).zza(subscribeRequest);
    }

    final void zza(zzbfi<zzbcl<Status>> zzbfi2, @Nullable zzbfi<MessageListener> zzbfi3) throws RemoteException {
        if (zzbfi3 == null) {
            return;
        }
        zzbe zzbe2 = new zzbe(this.zzbzi.zzh(zzbfi3), new zzcrc(zzbfi2), null);
        ((zzs)this.zzrd()).zza(zzbe2);
        this.zzbzi.zzi(zzbfi3);
    }

    final void zzb(zzbfi<zzbcl<Status>> zzbfi2, zzbfi<StatusCallback> zzbfi3) throws RemoteException {
        zzaz zzaz2 = new zzaz(new zzcrc(zzbfi2), this.zzbzi.zzh(zzbfi3));
        new zzaz(new zzcrc(zzbfi2), this.zzbzi.zzh(zzbfi3)).zzbzy = true;
        ((zzs)this.zzrd()).zza(zzaz2);
    }

    final void zzc(zzbfi<zzbcl<Status>> zzbfi2, @Nullable zzbfi<StatusCallback> zzbfi3) throws RemoteException {
        if (zzbfi3 == null) {
            return;
        }
        zzaz zzaz2 = new zzaz(new zzcrc(zzbfi2), this.zzbzi.zzh(zzbfi3));
        new zzaz(new zzcrc(zzbfi2), this.zzbzi.zzh(zzbfi3)).zzbzy = false;
        ((zzs)this.zzrd()).zza(zzaz2);
        this.zzbzi.zzi(zzbfi3);
    }

    final void zzbr(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzrd()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    @Nullable
    final zzbfi<MessageListener> zza(GoogleApiClient googleApiClient, @Nullable MessageListener messageListener) {
        return this.zzbzi.zzb(googleApiClient, messageListener).zzzV();
    }

    @Nullable
    final zzbfi<StatusCallback> zza(GoogleApiClient googleApiClient, @Nullable StatusCallback statusCallback) {
        return this.zzbzi.zzb(googleApiClient, statusCallback).zzzV();
    }

    @Nullable
    final zzbfi<MessageListener> zza(@Nullable MessageListener messageListener) {
        zzcqz<MessageListener> zzcqz2 = this.zzbzi.zzE(messageListener);
        if (zzcqz2 == null) {
            return null;
        }
        return zzcqz2.zzzV();
    }

    @Nullable
    final zzbfi<StatusCallback> zza(@Nullable StatusCallback statusCallback) {
        zzcqz<StatusCallback> zzcqz2 = this.zzbzi.zzE(statusCallback);
        if (zzcqz2 == null) {
            return null;
        }
        return zzcqz2.zzzV();
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

