/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcph;
import com.google.android.gms.internal.zzcpl;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zza {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzaku;
    private final List<zzad> zzbxX;
    private final List<zzcpl> zzbxY;
    private final boolean zzbxZ;
    private final List<zzcph> zzbya;
    private final int zzbyb;

    MessageFilter(int n, List<zzad> list, List<zzcpl> list2, boolean bl, List<zzcph> list3, int n2) {
        this.zzaku = n;
        this.zzbxX = Collections.unmodifiableList((List)zzbo.zzu(list));
        this.zzbxZ = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzbxY = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzbya = Collections.unmodifiableList(list3);
        this.zzbyb = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcpl> list2, boolean bl, List<zzcph> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzzQ() {
        return this.zzbxX;
    }

    public final boolean zzzR() {
        return this.zzbxZ;
    }

    final List<zzcpl> zzzS() {
        return this.zzbxY;
    }

    public final List<zzcph> zzzT() {
        return this.zzbya;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, messageFilter.zzbxX, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, messageFilter.zzbxY, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzbxZ);
        zzd.zzc((Parcel)parcel2, (int)4, messageFilter.zzbya, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzbyb);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzaku);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzbxZ;
        String string = String.valueOf(this.zzbxX);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzbxZ == messageFilter.zzbxZ && zzbe.equal(this.zzbxX, messageFilter.zzbxX) && zzbe.equal(this.zzbxY, messageFilter.zzbxY) && zzbe.equal(this.zzbya, messageFilter.zzbya);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbxX, this.zzbxY, this.zzbxZ, this.zzbya});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzbyc = new HashSet<zzad>();
        private final List<zzcpl> zzbxY = new ArrayList<zzcpl>();
        private final Set<zzcph> zzbyd = new HashSet<zzcph>();
        private boolean zzbxZ;
        private int zzbyb = 0;

        public final Builder includeAllMyTypes() {
            this.zzbxZ = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbo.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbo.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzS(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzbyc.addAll(messageFilter.zzzQ());
            this.zzbxY.addAll(messageFilter.zzzS());
            this.zzbyd.addAll(messageFilter.zzzT());
            this.zzbxZ |= messageFilter.zzzR();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzS("__reserved_namespace", "__eddystone_uid");
            this.zzbxY.add(zzcpl.zzT(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzS("__reserved_namespace", "__i_beacon_id");
            this.zzbxY.add(zzcpl.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbo.zzb((this.zzbyb == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbo.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbo.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzS("__reserved_namespace", "__audio_bytes");
            this.zzbyb = n;
            return this;
        }

        private final Builder zzS(String string, String string2) {
            this.zzbyc.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbo.zza((this.zzbxZ || !this.zzbyc.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzbyc), this.zzbxY, this.zzbxZ, new ArrayList<zzcph>(this.zzbyd), this.zzbyb, null);
        }
    }
}

