/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.connection;

import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbo;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;

public class Payload {
    private final long id;
    @Type
    private final int type;
    @Nullable
    private final byte[] zzbws;
    @Nullable
    private final File zzbwt;
    @Nullable
    private final Stream zzbwu;

    public static Payload fromBytes(byte[] byArray) {
        zzbo.zzb((Object)byArray, (Object)"Cannot create a Payload from null bytes.");
        return Payload.zza(byArray, UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(byte[] byArray, long l) {
        return new Payload(l, 1, byArray, null, null);
    }

    public static Payload fromFile(java.io.File file) throws FileNotFoundException {
        return Payload.zza(File.zza(file, file.length()), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromFile(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(File.zzb(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(File file, long l) {
        return new Payload(l, 2, null, file, null);
    }

    public static Payload fromStream(InputStream inputStream) {
        return Payload.zza(Stream.zzi(inputStream), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromStream(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(Stream.zzc(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(Stream stream, long l) {
        return new Payload(l, 3, null, null, stream);
    }

    private Payload(long l, int n, @Nullable byte[] byArray, @Nullable File file, @Nullable Stream stream) {
        this.id = l;
        this.type = n;
        this.zzbws = byArray;
        this.zzbwt = file;
        this.zzbwu = stream;
    }

    public long getId() {
        return this.id;
    }

    @Type
    public int getType() {
        return this.type;
    }

    @Nullable
    public byte[] asBytes() {
        return this.zzbws;
    }

    @Nullable
    public File asFile() {
        return this.zzbwt;
    }

    @Nullable
    public Stream asStream() {
        return this.zzbwu;
    }

    public static @interface Type {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int STREAM = 3;
    }

    public static class Stream {
        @Nullable
        private final ParcelFileDescriptor zzbww;
        @Nullable
        private InputStream zzbwy;

        public static Stream zzi(InputStream inputStream) {
            zzbo.zzb((Object)inputStream, (Object)"Cannot create Payload.Stream from null InputStream.");
            return new Stream(null, inputStream);
        }

        public static Stream zzc(ParcelFileDescriptor parcelFileDescriptor) {
            zzbo.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.Stream from null ParcelFileDescriptor.");
            return new Stream(parcelFileDescriptor, null);
        }

        private Stream(@Nullable ParcelFileDescriptor parcelFileDescriptor, @Nullable InputStream inputStream) {
            this.zzbww = parcelFileDescriptor;
            this.zzbwy = inputStream;
        }

        @NonNull
        public InputStream asInputStream() {
            if (this.zzbwy == null) {
                this.zzbwy = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbww);
            }
            return this.zzbwy;
        }

        @Nullable
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzbww;
        }
    }

    public static class File {
        @Nullable
        private final java.io.File zzbwv;
        private final ParcelFileDescriptor zzbww;
        private final long zzbwx;

        public static File zza(java.io.File file, long l) throws FileNotFoundException {
            return new File((java.io.File)zzbo.zzb((Object)file, (Object)"Cannot create Payload.File from null java.io.File."), ParcelFileDescriptor.open((java.io.File)file, (int)0x10000000), l);
        }

        public static File zzb(ParcelFileDescriptor parcelFileDescriptor) {
            return new File(null, (ParcelFileDescriptor)zzbo.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.File from null ParcelFileDescriptor."), parcelFileDescriptor.getStatSize());
        }

        private File(@Nullable java.io.File file, ParcelFileDescriptor parcelFileDescriptor, long l) {
            this.zzbwv = file;
            this.zzbww = parcelFileDescriptor;
            this.zzbwx = l;
        }

        @Nullable
        public java.io.File asJavaFile() {
            return this.zzbwv;
        }

        @NonNull
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzbww;
        }

        public long getSize() {
            return this.zzbwx;
        }
    }
}

