/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.internal.zzc;
import com.google.android.gms.nearby.messages.internal.zzg;
import java.util.Arrays;

public class EddystoneUid {
    public static final int LENGTH = 16;
    public static final int NAMESPACE_LENGTH = 10;
    public static final int INSTANCE_LENGTH = 6;
    private final zzg zzbxR;

    private EddystoneUid(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzbo.zzb((byArray.length == 16 ? 1 : 0) != 0, (Object)"Bytes must be a namespace plus instance (16 bytes).");
        this.zzbxR = new zzg(byArray2);
    }

    public EddystoneUid(String string) {
        this(zzc.zzeE(string));
    }

    public EddystoneUid(String string, String string2) {
        this.zzbxR = new zzg(string, string2);
    }

    public static EddystoneUid from(Message message) {
        String string = String.valueOf(message.getType());
        zzbo.zzb((boolean)message.zzeD("__eddystone_uid"), (Object)new StringBuilder(58 + String.valueOf(string).length()).append("Message type '").append(string).append("' is not Message.MESSAGE_TYPE_EDDYSTONE_UID.").toString());
        return new EddystoneUid(message.getContent());
    }

    public String getNamespace() {
        return zzc.zzo(Arrays.copyOfRange(this.zzbxR.getBytes(), 0, 10));
    }

    public String getInstance() {
        byte[] byArray = this.zzbxR.getBytes();
        if (byArray.length < 16) {
            return null;
        }
        return zzc.zzo(Arrays.copyOfRange(byArray, 10, 16));
    }

    public String getHex() {
        return this.zzbxR.getHex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EddystoneUid)) {
            return false;
        }
        EddystoneUid eddystoneUid = (EddystoneUid)object;
        return zzbe.equal((Object)this.zzbxR, (Object)eddystoneUid.zzbxR);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbxR});
    }

    public String toString() {
        String string = String.valueOf(this.getHex());
        return new StringBuilder(17 + String.valueOf(string).length()).append("EddystoneUid{id=").append(string).append("}").toString();
    }
}

