/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzcpj;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzah;
import com.google.android.gms.nearby.messages.internal.zzal;
import com.google.android.gms.nearby.messages.internal.zzam;
import com.google.android.gms.nearby.messages.internal.zzan;
import com.google.android.gms.nearby.messages.internal.zzao;
import com.google.android.gms.nearby.messages.internal.zzap;
import com.google.android.gms.nearby.messages.internal.zzaq;
import com.google.android.gms.nearby.messages.internal.zzar;
import com.google.android.gms.nearby.messages.internal.zzas;
import com.google.android.gms.nearby.messages.internal.zzat;
import com.google.android.gms.nearby.messages.internal.zzau;
import java.util.Collections;

public final class zzak
implements Messages {
    public static final zzak zzbzi = new zzak();
    public static final Api.zzf<zzah> zzajR = new Api.zzf();
    public static final Api.zza<zzah, MessagesOptions> zzajS = new zzal();

    private zzak() {
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message, PublishOptions publishOptions) {
        zzbo.zzu((Object)((Object)message));
        zzbo.zzu((Object)publishOptions);
        zzbdw zzbdw2 = publishOptions.getCallback() == null ? null : googleApiClient.zzp((Object)publishOptions.getCallback());
        return googleApiClient.zze((zzbay)new zzan(this, googleApiClient, message, zzbdw2, publishOptions));
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unpublish(GoogleApiClient googleApiClient, Message message) {
        zzbo.zzu((Object)((Object)message));
        return googleApiClient.zze((zzbay)new zzao(this, googleApiClient, message));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener, SubscribeOptions subscribeOptions) {
        zzbo.zzu((Object)messageListener);
        zzbo.zzu((Object)subscribeOptions);
        zzbo.zzb((subscribeOptions.getStrategy().zzzU() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        zzbdw<MessageListener> zzbdw2 = zzak.zzh(googleApiClient).zza(googleApiClient, messageListener);
        zzbdw zzbdw3 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzbay)new zzap(this, googleApiClient, zzbdw2, zzbdw3, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) {
        zzbo.zzu((Object)pendingIntent);
        zzbo.zzu((Object)subscribeOptions);
        zzbdw zzbdw2 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzbay)new zzaq(this, googleApiClient, pendingIntent, zzbdw2, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        zzbo.zzu((Object)messageListener);
        zzbdw<MessageListener> zzbdw2 = zzak.zzh(googleApiClient).zza(messageListener);
        return googleApiClient.zze((zzbay)new zzar(this, googleApiClient, zzbdw2));
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        zzbo.zzu((Object)pendingIntent);
        return googleApiClient.zze((zzbay)new zzas(this, googleApiClient, pendingIntent));
    }

    @Override
    public final void handleIntent(Intent intent, MessageListener messageListener) {
        String string = "com.google.android.gms.nearby.messages.UPDATES";
        Bundle bundle = intent.getBundleExtra("com.google.android.gms.nearby.messages.UPDATES");
        zzak.zza(bundle == null ? Collections.emptyList() : bundle.getParcelableArrayList(string), messageListener);
    }

    public static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzbt(1)) {
                messageListener.onFound(update.zzbzd);
            }
            if (update.zzbt(2)) {
                messageListener.onLost(update.zzbzd);
            }
            if (update.zzbt(4)) {
                messageListener.onDistanceChanged(update.zzbzd, update.zzbzB);
            }
            if (update.zzbt(8)) {
                messageListener.onBleSignalChanged(update.zzbzd, update.zzbzC);
            }
            if (!update.zzbt(16)) continue;
            Message cfr_ignored_0 = update.zzbzd;
            zzcpj cfr_ignored_1 = update.zzbzD;
        }
    }

    @Override
    public final PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzbay)new zzat(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbo.zzu((Object)statusCallback);
        zzbdw<StatusCallback> zzbdw2 = zzak.zzh(googleApiClient).zza(googleApiClient, statusCallback);
        return googleApiClient.zze((zzbay)new zzau(this, googleApiClient, zzbdw2));
    }

    @Override
    public final PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbo.zzu((Object)statusCallback);
        zzbdw<StatusCallback> zzbdw2 = zzak.zzh(googleApiClient).zza(statusCallback);
        return googleApiClient.zze((zzbay)new zzam(this, googleApiClient, zzbdw2));
    }

    private static zzah zzh(GoogleApiClient googleApiClient) {
        return (zzah)googleApiClient.zza(zzajR);
    }
}

