/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.internal.zzclt;
import com.google.android.gms.internal.zzcma;
import com.google.android.gms.internal.zzcmc;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzaz;
import com.google.android.gms.nearby.messages.internal.zzbc;
import com.google.android.gms.nearby.messages.internal.zzbe;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;

final class zzah
extends zzaa<zzs> {
    private final zzcmc zzjfz = new zzcmc();
    private final ClientAppContext zzjga;
    private final int zzjed;

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzq2, connectionCallbacks, onConnectionFailedListener);
        int n;
        String string = zzq2.zzaju();
        Context context2 = context;
        int n2 = context2 instanceof Activity ? 1 : (context2 instanceof Application ? 2 : (n = context2 instanceof Service ? 3 : 0));
        if (messagesOptions != null) {
            this.zzjga = new ClientAppContext(string, null, false, null, n);
            this.zzjed = messagesOptions.zzjeb;
        } else {
            this.zzjga = new ClientAppContext(string, null, false, null, n);
            this.zzjed = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzzs() {
        Bundle bundle = super.zzzs();
        bundle.putInt("NearbyPermissions", this.zzjed);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzjga);
        return bundle;
    }

    @NonNull
    protected final String zzhc() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzhd() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzdy(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzjfz.clear();
        super.disconnect();
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzaf zzaf2) throws RemoteException {
        zzbc zzbc2 = new zzbc(zzaf2, new zzclt(zzcj2), this.zzjga);
        ((zzs)this.zzajj()).zza(zzbc2);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzcj<MessageListener> zzcj3, @Nullable zzcj<SubscribeCallback> zzcj4, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzjfz.zzh(zzcj3), subscribeOptions.getStrategy(), new zzclt(zzcj2), subscribeOptions.getFilter(), null, null, zzcj4 == null ? null : new zzcma(zzcj4), subscribeOptions.zzjev);
        ((zzs)this.zzajj()).zza(subscribeRequest);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, @Nullable zzcj<MessageListener> zzcj3) throws RemoteException {
        if (zzcj3 == null) {
            return;
        }
        zzbe zzbe2 = new zzbe(this.zzjfz.zzh(zzcj3), new zzclt(zzcj2), null);
        ((zzs)this.zzajj()).zza(zzbe2);
        this.zzjfz.zzi(zzcj3);
    }

    final void zzb(zzcj<zzn<Status>> zzcj2, zzcj<StatusCallback> zzcj3) throws RemoteException {
        zzaz zzaz2 = new zzaz(new zzclt(zzcj2), this.zzjfz.zzh(zzcj3));
        new zzaz(new zzclt(zzcj2), this.zzjfz.zzh(zzcj3)).zzjgp = true;
        ((zzs)this.zzajj()).zza(zzaz2);
    }

    final void zzc(zzcj<zzn<Status>> zzcj2, @Nullable zzcj<StatusCallback> zzcj3) throws RemoteException {
        if (zzcj3 == null) {
            return;
        }
        zzaz zzaz2 = new zzaz(new zzclt(zzcj2), this.zzjfz.zzh(zzcj3));
        new zzaz(new zzclt(zzcj2), this.zzjfz.zzh(zzcj3)).zzjgp = false;
        ((zzs)this.zzajj()).zza(zzaz2);
        this.zzjfz.zzi(zzcj3);
    }

    final void zzdy(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzajj()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    @Nullable
    final zzcj<MessageListener> zza(GoogleApiClient googleApiClient, @Nullable MessageListener messageListener) {
        return this.zzjfz.zzb(googleApiClient, messageListener).zzbbb();
    }

    @Nullable
    final zzcj<StatusCallback> zza(GoogleApiClient googleApiClient, @Nullable StatusCallback statusCallback) {
        return this.zzjfz.zzb(googleApiClient, statusCallback).zzbbb();
    }

    @Nullable
    final zzcj<MessageListener> zza(@Nullable MessageListener messageListener) {
        zzclq<MessageListener> zzclq2 = this.zzjfz.zzae(messageListener);
        if (zzclq2 == null) {
            return null;
        }
        return zzclq2.zzbbb();
    }

    @Nullable
    final zzcj<StatusCallback> zza(@Nullable StatusCallback statusCallback) {
        zzclq<StatusCallback> zzclq2 = this.zzjfz.zzae(statusCallback);
        if (zzclq2 == null) {
            return null;
        }
        return zzclq2.zzbbb();
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

