/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzclm;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzah;
import com.google.android.gms.nearby.messages.internal.zzal;
import com.google.android.gms.nearby.messages.internal.zzam;
import com.google.android.gms.nearby.messages.internal.zzan;
import com.google.android.gms.nearby.messages.internal.zzao;
import com.google.android.gms.nearby.messages.internal.zzap;
import com.google.android.gms.nearby.messages.internal.zzaq;
import com.google.android.gms.nearby.messages.internal.zzar;
import com.google.android.gms.nearby.messages.internal.zzas;
import com.google.android.gms.nearby.messages.internal.zzat;
import com.google.android.gms.nearby.messages.internal.zzau;
import java.util.Collections;

public final class zzak
implements Messages {
    public static final zzak zzjgd = new zzak();
    public static final Api.zzf<zzah> zzdwq = new Api.zzf();
    public static final Api.zza<zzah, MessagesOptions> zzdwr = new zzal();

    private zzak() {
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message, PublishOptions publishOptions) {
        zzbp.zzu((Object)((Object)message));
        zzbp.zzu((Object)publishOptions);
        zzcj zzcj2 = publishOptions.getCallback() == null ? null : googleApiClient.zzp((Object)publishOptions.getCallback());
        return googleApiClient.zze((zzm)new zzan(this, googleApiClient, message, zzcj2, publishOptions));
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unpublish(GoogleApiClient googleApiClient, Message message) {
        zzbp.zzu((Object)((Object)message));
        return googleApiClient.zze((zzm)new zzao(this, googleApiClient, message));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener, SubscribeOptions subscribeOptions) {
        zzbp.zzu((Object)messageListener);
        zzbp.zzu((Object)subscribeOptions);
        zzbp.zzb((subscribeOptions.getStrategy().zzbay() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        zzcj<MessageListener> zzcj2 = zzak.zzh(googleApiClient).zza(googleApiClient, messageListener);
        zzcj zzcj3 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzm)new zzap(this, googleApiClient, zzcj2, zzcj3, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) {
        zzbp.zzu((Object)pendingIntent);
        zzbp.zzu((Object)subscribeOptions);
        zzcj zzcj2 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        return googleApiClient.zze((zzm)new zzaq(this, googleApiClient, pendingIntent, zzcj2, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        zzbp.zzu((Object)messageListener);
        zzcj<MessageListener> zzcj2 = zzak.zzh(googleApiClient).zza(messageListener);
        return googleApiClient.zze((zzm)new zzar(this, googleApiClient, zzcj2));
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        zzbp.zzu((Object)pendingIntent);
        return googleApiClient.zze((zzm)new zzas(this, googleApiClient, pendingIntent));
    }

    @Override
    public final void handleIntent(Intent intent, MessageListener messageListener) {
        String string = "com.google.android.gms.nearby.messages.UPDATES";
        Bundle bundle = intent.getBundleExtra("com.google.android.gms.nearby.messages.UPDATES");
        zzak.zza(bundle == null ? Collections.emptyList() : bundle.getParcelableArrayList(string), messageListener);
    }

    public static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzdz(1)) {
                messageListener.onFound(update.zzjfy);
            }
            if (update.zzdz(2)) {
                messageListener.onLost(update.zzjfy);
            }
            if (update.zzdz(4)) {
                messageListener.onDistanceChanged(update.zzjfy, update.zzjgw);
            }
            if (update.zzdz(8)) {
                messageListener.onBleSignalChanged(update.zzjfy, update.zzjgx);
            }
            if (!update.zzdz(16)) continue;
            Message cfr_ignored_0 = update.zzjfy;
            zzclm cfr_ignored_1 = update.zzjgy;
        }
    }

    @Override
    public final PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zzat(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbp.zzu((Object)statusCallback);
        zzcj<StatusCallback> zzcj2 = zzak.zzh(googleApiClient).zza(googleApiClient, statusCallback);
        return googleApiClient.zze((zzm)new zzau(this, googleApiClient, zzcj2));
    }

    @Override
    public final PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbp.zzu((Object)statusCallback);
        zzcj<StatusCallback> zzcj2 = zzak.zzh(googleApiClient).zza(statusCallback);
        return googleApiClient.zze((zzm)new zzam(this, googleApiClient, zzcj2));
    }

    private static zzah zzh(GoogleApiClient googleApiClient) {
        return (zzah)googleApiClient.zza(zzdwq);
    }
}

