/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.connection;

import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbp;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;

public class Payload {
    private final long id;
    @Type
    private final int type;
    @Nullable
    private final byte[] zzjao;
    @Nullable
    private final File zzjap;
    @Nullable
    private final Stream zzjaq;

    public static Payload fromBytes(byte[] byArray) {
        zzbp.zzb((Object)byArray, (Object)"Cannot create a Payload from null bytes.");
        return Payload.zza(byArray, UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(byte[] byArray, long l) {
        return new Payload(l, 1, byArray, null, null);
    }

    public static Payload fromFile(java.io.File file) throws FileNotFoundException {
        return Payload.zza(File.zza(file, file.length()), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromFile(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(File.zzb(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(File file, long l) {
        return new Payload(l, 2, null, file, null);
    }

    public static Payload fromStream(InputStream inputStream) {
        return Payload.zza(Stream.zzi(inputStream), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromStream(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(Stream.zzc(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload zza(Stream stream, long l) {
        return new Payload(l, 3, null, null, stream);
    }

    private Payload(long l, int n, @Nullable byte[] byArray, @Nullable File file, @Nullable Stream stream) {
        this.id = l;
        this.type = n;
        this.zzjao = byArray;
        this.zzjap = file;
        this.zzjaq = stream;
    }

    public long getId() {
        return this.id;
    }

    @Type
    public int getType() {
        return this.type;
    }

    @Nullable
    public byte[] asBytes() {
        return this.zzjao;
    }

    @Nullable
    public File asFile() {
        return this.zzjap;
    }

    @Nullable
    public Stream asStream() {
        return this.zzjaq;
    }

    public static @interface Type {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int STREAM = 3;
    }

    public static class Stream {
        @Nullable
        private final ParcelFileDescriptor zzjas;
        @Nullable
        private InputStream zzjat;

        public static Stream zzi(InputStream inputStream) {
            zzbp.zzb((Object)inputStream, (Object)"Cannot create Payload.Stream from null InputStream.");
            return new Stream(null, inputStream);
        }

        public static Stream zzc(ParcelFileDescriptor parcelFileDescriptor) {
            zzbp.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.Stream from null ParcelFileDescriptor.");
            return new Stream(parcelFileDescriptor, null);
        }

        private Stream(@Nullable ParcelFileDescriptor parcelFileDescriptor, @Nullable InputStream inputStream) {
            this.zzjas = parcelFileDescriptor;
            this.zzjat = inputStream;
        }

        @NonNull
        public InputStream asInputStream() {
            if (this.zzjat == null) {
                this.zzjat = new ParcelFileDescriptor.AutoCloseInputStream(this.zzjas);
            }
            return this.zzjat;
        }

        @Nullable
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzjas;
        }
    }

    public static class File {
        @Nullable
        private final java.io.File zzjar;
        private final ParcelFileDescriptor zzjas;
        private final long zzhwh;

        public static File zza(java.io.File file, long l) throws FileNotFoundException {
            return new File((java.io.File)zzbp.zzb((Object)file, (Object)"Cannot create Payload.File from null java.io.File."), ParcelFileDescriptor.open((java.io.File)file, (int)0x10000000), l);
        }

        public static File zzb(ParcelFileDescriptor parcelFileDescriptor) {
            return new File(null, (ParcelFileDescriptor)zzbp.zzb((Object)parcelFileDescriptor, (Object)"Cannot create Payload.File from null ParcelFileDescriptor."), parcelFileDescriptor.getStatSize());
        }

        private File(@Nullable java.io.File file, ParcelFileDescriptor parcelFileDescriptor, long l) {
            this.zzjar = file;
            this.zzjas = parcelFileDescriptor;
            this.zzhwh = l;
        }

        @Nullable
        public java.io.File asJavaFile() {
            return this.zzjar;
        }

        @NonNull
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzjas;
        }

        public long getSize() {
            return this.zzhwh;
        }
    }
}

