/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.internal.zzc;
import com.google.android.gms.nearby.messages.internal.zzg;
import java.util.Arrays;

public class EddystoneUid {
    public static final int LENGTH = 16;
    public static final int NAMESPACE_LENGTH = 10;
    public static final int INSTANCE_LENGTH = 6;
    private final zzg zzjdm;

    private EddystoneUid(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzbp.zzb((byArray.length == 16 ? 1 : 0) != 0, (Object)"Bytes must be a namespace plus instance (16 bytes).");
        this.zzjdm = new zzg(byArray2);
    }

    public EddystoneUid(String string) {
        this(zzc.zzkk(string));
    }

    public EddystoneUid(String string, String string2) {
        this.zzjdm = new zzg(string, string2);
    }

    public static EddystoneUid from(Message message) {
        String string = message.getType();
        zzbp.zzb((boolean)message.zzkj("__eddystone_uid"), (Object)new StringBuilder(58 + String.valueOf(string).length()).append("Message type '").append(string).append("' is not Message.MESSAGE_TYPE_EDDYSTONE_UID.").toString());
        return new EddystoneUid(message.getContent());
    }

    public String getNamespace() {
        return zzc.zzr(Arrays.copyOfRange(this.zzjdm.getBytes(), 0, 10));
    }

    public String getInstance() {
        byte[] byArray = this.zzjdm.getBytes();
        if (byArray.length < 16) {
            return null;
        }
        return zzc.zzr(Arrays.copyOfRange(byArray, 10, 16));
    }

    public String getHex() {
        return this.zzjdm.getHex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EddystoneUid)) {
            return false;
        }
        EddystoneUid eddystoneUid = (EddystoneUid)object;
        return zzbf.equal((Object)this.zzjdm, (Object)eddystoneUid.zzjdm);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjdm});
    }

    public String toString() {
        String string = this.getHex();
        return new StringBuilder(17 + String.valueOf(string).length()).append("EddystoneUid{id=").append(string).append("}").toString();
    }
}

